/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.AuxiliaryFamilyGroup;
import com.intellij.database.view.AuxiliaryObjectsGroup;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseTreeKeys;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewStaticContext;
import com.intellij.database.view.DatabaseViewStructureProvider;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.HostGroup;
import com.intellij.database.view.NodeGroup;
import com.intellij.database.view.ToStringComparator;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DatabaseStructure
extends BaseTreeModel<BasicNode>
implements InvokerSupplier,
Searchable {
    @NotNull
    private final DvTreeStructureService myService;
    @NotNull
    private final DatabaseTreeContext myContext;
    @NotNull
    private final Invoker myInvoker;
    @NotNull
    private final DbRootGroup myRootGroup;
    private static final Logger ourLog = Logger.getInstance(DatabaseStructure.class);

    DatabaseStructure(@NotNull DatabaseTreeContext context, DatabaseViewOptions viewOptions) {
        if (context == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        this.myInvoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
        this.myService = (DvTreeStructureService)context.getProject().getService(DvTreeStructureService.class);
        this.myContext = context;
        this.myRootGroup = DatabaseStructure.getRootGroup(this.myService, viewOptions);
    }

    @Nullable
    public DvTreeStructureService getServiceIfModern() {
        return DatabaseViewStaticContext.isDatabaseViewModern() ? this.myService : null;
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public BasicNode getRoot() {
        if (DatabaseViewStaticContext.isDatabaseViewModern()) {
            return this.myService.getRootNode();
        }
        return this.myRootGroup;
    }

    public boolean isLeaf(Object node) {
        if (DatabaseViewStaticContext.isDatabaseViewModern()) {
            return node instanceof BasicNode ? this.myService.isAlwaysLeaf((BasicNode)node) : true;
        }
        return DatabaseStructure.isAlwaysLeafImpl(node);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        Object[] path = DatabaseViewStaticContext.isDatabaseViewModern() ? (object instanceof BasicNode ? this.myService.getPath((BasicNode)object) : ArrayUtil.EMPTY_OBJECT_ARRAY) : this.getPath(object);
        TreePath treePath = path.length > 0 ? new TreePath(path) : new TreePath(object);
        Promise promise = Promises.resolvedPromise((Object)treePath);
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @NotNull
    private @NotNull Object @NotNull [] getPath(Object object) {
        BasicRoot root2;
        DbDataSource dbDataSource;
        BasicModel model;
        LinkedList<Object> result2 = new LinkedList<Object>();
        Object target = object;
        if (target instanceof BasicDatabase && (model = ((BasicDatabase)target).getModel()) != null && ((Boolean)DatabaseTreeKeys.DATABASE_IS_COLLAPSED.get((UserDataHolder)(dbDataSource = this.myService.findDbDataSource(root2 = model.getRoot())), (Object)false)).booleanValue()) {
            target = dbDataSource;
        }
        if (target instanceof DbDataSource) {
            target = DataSourceNode.node((DbDataSource)target);
        }
        Object cur2 = target;
        while (cur2 != null) {
            result2.addFirst(cur2);
            cur2 = DatabaseStructure.getParentImpl(cur2, this.myRootGroup.viewOptions, this.myService);
        }
        Object[] path = ArrayUtil.toObjectArray(result2);
        if (path == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        return path;
    }

    boolean isNodeCut(@Nullable Object node) {
        return node != null && this.myContext.isNodeCut(node);
    }

    @NotNull
    public List<? extends BasicNode> getChildren(Object parent2) {
        if (parent2 instanceof BasicNode) {
            List<? extends BasicNode> list = this.getChildren((BasicNode)parent2);
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<? extends BasicNode> getChildren(@NotNull BasicNode parent2) {
        if (parent2 == null) {
            DatabaseStructure.$$$reportNull$$$0(6);
        }
        JBIterable<? extends BasicNode> theChildren = DatabaseViewStaticContext.isDatabaseViewModern() ? this.myService.childrenOf(parent2) : this.getChildElements(parent2);
        List<BasicNode> children2 = DatabaseStructure.collectNodesToListSafely(theChildren);
        if (DatabaseViewStaticContext.isDatabaseViewLegacy() && children2.size() >= 2 && !(parent2 instanceof DbGroup) && children2 instanceof ArrayList) {
            children2.sort(this::compareNodes);
        }
        List<BasicNode> list = children2;
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<BasicNode> collectNodesToListSafely(@NotNull JBIterable<? extends BasicNode> nodes2) {
        if (nodes2 == null) {
            DatabaseStructure.$$$reportNull$$$0(8);
        }
        if (nodes2.isEmpty()) {
            List<BasicNode> list = Collections.emptyList();
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<BasicNode> container = new ArrayList<BasicNode>();
        Object exception = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            ArrayList<BasicNode> arrayList;
            try {
                int j = 0;
                for (BasicNode node : nodes2) {
                    container.add(node);
                    if (++j % 10 != 0) continue;
                    ProgressManager.checkCanceled();
                }
                arrayList = container;
            }
            catch (ConcurrentModificationException cme) {
                if (exception == null) {
                    exception = cme;
                }
                container.clear();
                continue;
            }
            if (arrayList == null) {
                DatabaseStructure.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        String exceptionName = exception.getClass().getSimpleName();
        String exceptionMessage = ((Throwable)exception).getMessage();
        ourLog.warn("Unable to collect nodes from 3 attempts; the first exception: " + exceptionName + ": " + exceptionMessage);
        List<BasicNode> list = Collections.emptyList();
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(11);
        }
        return list;
    }

    private int compareNodes(@NotNull BasicNode node1, @NotNull BasicNode node2) {
        int weightDiff;
        if (node1 == null) {
            DatabaseStructure.$$$reportNull$$$0(12);
        }
        if (node2 == null) {
            DatabaseStructure.$$$reportNull$$$0(13);
        }
        return (weightDiff = DbPresentation.getWeight(node1, this.myRootGroup.viewOptions.SORT_POSITIONED) - DbPresentation.getWeight(node2, this.myRootGroup.viewOptions.SORT_POSITIONED)) != 0 ? weightDiff : DbPresentation.NAMES_COMPARATOR.compare(DatabaseStructure.getName(node1), DatabaseStructure.getName(node2));
    }

    private static String getName(@NotNull Object o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(14);
        }
        return o instanceof DasObject ? DbPresentationCore.getPresentableName((DasObject)o, true) : (o instanceof PsiNamedElement ? ((PsiNamedElement)o).getName() : null);
    }

    @NotNull
    private JBIterable<? extends BasicNode> getChildElements(@NotNull BasicNode element2) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(15);
        }
        if (this.isNodeCut(element2)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        if (element2 instanceof PsiElement && !((PsiElement)element2).isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        return DatabaseStructure.getChildrenImpl(element2, this.myRootGroup.viewOptions, this.myRootGroup.structure);
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        if (o instanceof EmptyScopeLeaf) {
            return true;
        }
        BasicElement basic = o instanceof DasObject ? DbImplUtilCore.getMaybeBasicElement((DasObject)o) : null;
        List<ObjectKind> familyKinds = basic == null ? null : DatabaseStructure.getFamilyKinds(basic);
        return familyKinds != null && familyKinds.isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild && (familyKinds == null || familyKinds.isEmpty()) || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    @NotNull
    private static JBIterable<? extends BasicElement> getElementChildren(@NotNull BasicElement element2, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions viewOptions) {
        JBIterable<? extends BasicElement> children2;
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(18);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(19);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(20);
        }
        if ((children2 = DatabaseStructure.getChildrenFromExtensionProvider(element2, kidKind, viewOptions)) == null) {
            children2 = DatabaseStructure.getChildrenFromFamily(element2, kidKind, viewOptions);
        }
        JBIterable<? extends BasicElement> jBIterable = children2;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<? extends DasObject> getObjectChildren(@NotNull DasObject object, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions viewOptions) {
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(22);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(23);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(24);
        }
        if (object instanceof BasicElement) {
            return DatabaseStructure.getElementChildren((BasicElement)object, kidKind, viewOptions);
        }
        JBIterable<? extends DasObject> jBIterable = object.getDasChildren(kidKind);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends BasicElement> getChildrenFromFamily(@NotNull BasicElement host, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions viewOptions) {
        Predicate<BasicElement> filter2;
        JBIterable children2;
        if (host == null) {
            DatabaseStructure.$$$reportNull$$$0(26);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(27);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(28);
        }
        if (kidKind == ObjectKind.NONE) {
            children2 = host.getChildren();
        } else {
            Family<@NotNull ? extends BasicElement> f = host.familyOf(kidKind);
            JBIterable jBIterable = children2 = f != null ? f.jbi() : JBIterable.empty();
        }
        if (children2.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(29);
            }
            return jBIterable;
        }
        DatabaseViewStructureProvider provider = DatabaseStructure.getStructureProvider(host);
        if (provider != null && (filter2 = provider.getFilter(host.getKind(), kidKind, viewOptions)) != null) {
            children2 = children2.filter(e -> filter2.test((BasicElement)e));
        }
        JBIterable jBIterable = children2;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @Nullable
    private static JBIterable<? extends BasicElement> getChildrenFromExtensionProvider(@NotNull BasicElement host, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions viewOptions) {
        DatabaseViewStructureProvider provider;
        if (host == null) {
            DatabaseStructure.$$$reportNull$$$0(31);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(32);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(33);
        }
        if ((provider = DatabaseStructure.getStructureProvider(host)) == null) {
            return null;
        }
        return provider.getChildren(host, kidKind, viewOptions);
    }

    @Nullable
    private static DatabaseViewStructureProvider getStructureProvider(@NotNull BasicElement element2) {
        BasicModel model;
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(34);
        }
        Dbms dbms = (model = element2.getModel()) != null ? model.getDbms() : DbImplUtilCore.getDbms(element2);
        return DatabaseViewStructureProvider.forDbms(dbms);
    }

    @NotNull
    private static @NotNull List<@NotNull ObjectKind> getFamilyKinds(@NotNull BasicElement host) {
        List<ObjectKind> kinds;
        DatabaseViewStructureProvider provider;
        if (host == null) {
            DatabaseStructure.$$$reportNull$$$0(35);
        }
        if ((provider = DatabaseStructure.getStructureProvider(host)) != null && (kinds = provider.getFamilyKinds(host)) != null) {
            List<ObjectKind> list = kinds;
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(36);
            }
            return list;
        }
        List<ObjectKind> list = host.getFamilyKinds();
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Nullable
    private static DasObject getParent(@NotNull DasObject o) {
        BasicElement element2;
        DatabaseViewStructureProvider provider;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(38);
        }
        if (o instanceof BasicElement && (provider = DatabaseStructure.getStructureProvider(element2 = (BasicElement)o)) != null) {
            return provider.getParent(element2);
        }
        return o.getDasParent();
    }

    public static boolean isDatabaseObject(Object element2) {
        return element2 instanceof DasObject || element2 instanceof NodeGroup;
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull ? extends BasicNode> getChildrenImpl(@NotNull BasicNode o, @NotNull DatabaseViewOptions viewOptions, @NotNull DvTreeStructureService structure) {
        ObjectKind nspChild;
        JBIterable children2;
        BasicElement host;
        DbDataSource dataSource2;
        DasObject root2;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(39);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(40);
        }
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(41);
        }
        if (DatabaseViewStaticContext.isDatabaseViewModern()) {
            JBIterable<? extends BasicNode> jBIterable = structure.childrenOf(o);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(42);
            }
            return jBIterable;
        }
        if (o instanceof DbGroup) {
            JBIterable<BasicNode> jBIterable = ((DbGroup)o).iterateChildren();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(43);
            }
            return jBIterable;
        }
        boolean groupNamespaces = viewOptions.GROUP_NAMESPACES;
        boolean showIntermediate = viewOptions.SHOW_INTERMEDIATE;
        Object object = o instanceof FamilyGroup ? ((FamilyGroup)o).dasParent : (o instanceof AuxiliaryObjectsGroup ? ((AuxiliaryObjectsGroup)o).getParent() : (o instanceof DataSourceNode && groupNamespaces && !showIntermediate ? DatabaseStructure.getTopSingleRoot(((DataSourceNode)o).dbDataSource, viewOptions) : (o instanceof DataSourceNode ? DatabaseViewTreeFun.getSimpleDataSourceRoot((DataSourceNode)o) : (o instanceof DbDataSource && !groupNamespaces ? DatabaseViewTreeFun.getSimpleDataSourceRoot((DbDataSource)((Object)o)) : (o instanceof DbDataSource && !showIntermediate ? DatabaseStructure.getTopSingleRoot((DbDataSource)((Object)o), viewOptions) : (o instanceof DasNamespace && !showIntermediate ? DatabaseStructure.getTopSingleRoot(structure.findDbDataSource((DasNamespace)((Object)o)), (DasObject)((Object)o), viewOptions) : (root0 = o instanceof DasObject ? (DasObject)((Object)o) : null)))))));
        if (root0 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(44);
            }
            return jBIterable;
        }
        DasObject dasObject = root2 = root0 instanceof DataSourceNode ? ((DataSourceNode)((Object)root0)).getModelRoot() : root0;
        if (root2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(45);
            }
            return jBIterable;
        }
        DbDataSource dbDataSource = dataSource2 = o instanceof DataSourceNode ? ((DataSourceNode)o).dbDataSource : structure.findDbDataSource(root2);
        if (dataSource2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(46);
            }
            return jBIterable;
        }
        BasicElement basicElement = root2 instanceof BasicElement ? (BasicElement)root2 : (root2 instanceof DbDataSource ? DatabaseViewTreeFun.getDbRoot((DbDataSource)root2) : (host = root2 instanceof HostGroup ? ((HostGroup)((Object)root2)).host : null));
        if (!groupNamespaces) {
            if (o instanceof DataSourceNode && root2 instanceof BasicRoot) {
                JBIterable<? extends BasicNode> jBIterable = DatabaseViewTreeFun.listSimpleRootContent((DataSourceNode)o, viewOptions);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(47);
                }
                return jBIterable;
            }
            if (o instanceof DbDataSource && root2 instanceof BasicRoot) {
                JBIterable<? extends BasicNode> jBIterable = DatabaseViewTreeFun.listSimpleRootContent(dataSource2, viewOptions);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(48);
                }
                return jBIterable;
            }
            if (o instanceof BasicDatabase) {
                JBIterable<? extends BasicNode> jBIterable = DatabaseViewTreeFun.listSimpleDatabaseContent(dataSource2, (BasicDatabase)o, viewOptions);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(49);
                }
                return jBIterable;
            }
            if (o instanceof AuxiliaryObjectsGroup) {
                JBIterable<? extends NodeGroup> jBIterable = ((AuxiliaryObjectsGroup)o).iterateChildren();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(50);
                }
                return jBIterable;
            }
        }
        ObjectKind kidKind = o instanceof FamilyGroup ? ((FamilyGroup)o).kidKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtilCore.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        Dbms dbms = dataSource2.getDbms();
        if (groupOption && kidKind == ObjectKind.NONE) {
            SmartList groups = new SmartList();
            int count = 0;
            DatabaseViewStructureProvider.PresentationToModelConverter converter = DatabaseViewStructureProvider.forDbms(dbms).getConverter();
            for (ObjectKind childKind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DatabaseStructure.getWeight(childKind, dbms, ++count);
                JBIterable<? extends DasObject> kids = DatabaseStructure.getChildObjects(dataSource2, viewOptions, root2, childKind);
                if (viewOptions.HIDDEN_KINDS.contains(childKind.code()) || viewOptions.HIDDEN_KINDS.contains(converter.toModelObjectKind(childKind).code()) || !DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, childKind)) && kids.isEmpty() || host == null) continue;
                RegularFamilyGroup group = DatabaseStructure.getOrCreateRegularFamilyGroup(host, childKind, weight, dbms, dataSource2, viewOptions);
                group.setSize(kids.size());
                groups.add(group);
            }
            if (groups.size() > 1 || viewOptions.SHOW_INTERMEDIATE) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(51);
                }
                return jBIterable;
            }
        }
        JBIterable jBIterable = children2 = host != null ? DatabaseStructure.getElementInnerNodes(dataSource2, viewOptions, host, kidKind) : JBIterable.empty();
        if (!viewOptions.HIDDEN_KINDS.isEmpty()) {
            children2 = children2.filter(oo -> !viewOptions.HIDDEN_KINDS.contains(oo.getKind().code()));
        }
        if (DatabaseStructure.isNamespace(metaModel, kidKind) && children2.isEmpty()) {
            JBIterable jBIterable2 = o instanceof FamilyGroup ? JBIterable.of((Object)((FamilyGroup)o).getEmptyScopeLeaf()) : JBIterable.empty();
            if (jBIterable2 == null) {
                DatabaseStructure.$$$reportNull$$$0(52);
            }
            return jBIterable2;
        }
        if (isNamespace && kidKind == ObjectKind.NONE && children2.find(it2 -> DatabaseStructure.isNamespace(metaModel, it2.getKind())) == null && (nspChild = (ObjectKind)metaModel.getChildKinds(rootKind).find(it2 -> DatabaseStructure.isNamespace(metaModel, it2))) != null && host != null) {
            RegularFamilyGroup extra = DatabaseStructure.getOrCreateRegularFamilyGroup(host, nspChild, DatabaseStructure.getWeight(nspChild, dbms, 0), dbms, dataSource2, viewOptions);
            JBIterable jBIterable3 = JBIterable.of((Object)extra.getEmptyScopeLeaf()).append((Iterable)children2);
            if (jBIterable3 == null) {
                DatabaseStructure.$$$reportNull$$$0(53);
            }
            return jBIterable3;
        }
        JBIterable jBIterable4 = children2;
        if (jBIterable4 == null) {
            DatabaseStructure.$$$reportNull$$$0(54);
        }
        return jBIterable4;
    }

    private static boolean isNamespace(@NotNull MetaModel metaModel, @NotNull ObjectKind rootKind) {
        if (metaModel == null) {
            DatabaseStructure.$$$reportNull$$$0(55);
        }
        if (rootKind == null) {
            DatabaseStructure.$$$reportNull$$$0(56);
        }
        return rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
    }

    private static int getWeight(@NotNull ObjectKind kind, @NotNull Dbms dbms, int groupCount) {
        int weight;
        if (kind == null) {
            DatabaseStructure.$$$reportNull$$$0(57);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(58);
        }
        return (weight = DatabaseViewStructureProvider.forDbms(dbms).getWeight(kind, groupCount)) == -1 ? DbPresentation.getWeight(kind, groupCount) : weight;
    }

    @NotNull
    private static JBIterable<? extends BasicElement> getElementInnerNodes(@NotNull DbDataSource ds, @NotNull DatabaseViewOptions viewOptions, @NotNull BasicElement element2, @NotNull ObjectKind kidKind) {
        if (ds == null) {
            DatabaseStructure.$$$reportNull$$$0(59);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(60);
        }
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(61);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(62);
        }
        Condition<DasObject> condition = null;
        if (element2 instanceof BasicNamespace || element2 instanceof BasicRoot) {
            if (element2 instanceof BasicMateNamespace && ((BasicMateNamespace)element2).isSubstituted() && !DatabaseViewStaticContext.databaseViewShowsMiniCat) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(63);
                }
                return jBIterable;
            }
            condition = DatabaseStructure.getScopeCondition(ds, viewOptions);
        }
        JBIterable result2 = DatabaseStructure.getElementChildren(element2, kidKind, viewOptions);
        JBIterable jBIterable = condition == null ? result2 : result2.filter(condition);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(64);
        }
        return jBIterable;
    }

    private static Condition<DasObject> getScopeCondition(@NotNull DbDataSource ds, @NotNull DatabaseViewOptions viewOptions) {
        LocalDataSource lds;
        if (ds == null) {
            DatabaseStructure.$$$reportNull$$$0(65);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(66);
        }
        TreePattern scope = (lds = DbImplUtil.getMaybeLocalDataSource(ds)) == null || viewOptions.SHOW_ALL_NAMESPACES ? null : lds.getIntrospectionScope();
        Condition<DasObject> condition = DbImplUtilCore.buildFilter(ds);
        Condition displayed = o -> scope == null || !(o instanceof DasNamespace) || DataSourceSchemaMapping.matches(scope, o);
        return condition == null ? displayed : Conditions.and(condition, (Condition)displayed);
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildObjects(DbDataSource ds, DatabaseViewOptions viewOptions, DasObject element2, ObjectKind kidKind) {
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(ds);
        TreePattern scope = lds == null || viewOptions.SHOW_ALL_NAMESPACES ? null : lds.getIntrospectionScope();
        DasModel model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Condition condition = null;
        if (element2 instanceof DasNamespace || element2 instanceof DbDataSource || element2 instanceof BasicRoot) {
            if (element2 instanceof BasicMateNamespace && ((BasicMateNamespace)element2).isSubstituted() && !DatabaseViewStaticContext.databaseViewShowsMiniCat) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(67);
                }
                return jBIterable;
            }
            condition = DbImplUtilCore.buildFilter(ds);
            Condition displayed = o -> scope == null || !(o instanceof DasNamespace) || DataSourceSchemaMapping.matches(scope, o);
            Condition condition2 = condition = condition == null ? displayed : Conditions.and((Condition)condition, (Condition)displayed);
        }
        Object res2 = model instanceof BasicModel ? ((BasicModel)model).getRoot().getDasChildren(kidKind) : (model != null ? model.getModelRoots().filter(DasUtil.byKind(kidKind)) : DatabaseStructure.getObjectChildren(element2, kidKind, viewOptions));
        Object object = condition == null ? res2 : res2.filter(condition);
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(68);
        }
        return object;
    }

    @NotNull
    private static Iterable<ObjectKind> getChildKinds(@NotNull Object element2, @NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        DasModel model;
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(69);
        }
        if (mm == null) {
            DatabaseStructure.$$$reportNull$$$0(70);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(71);
        }
        DasModel dasModel = model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Object delegate = model instanceof BasicModel ? ((BasicModel)model).getRoot() : (element2 instanceof DbElement ? ((DbElement)element2).getDelegate() : element2);
        List<ObjectKind> list = delegate instanceof BasicElement ? DatabaseStructure.getFamilyKinds((BasicElement)delegate) : mm.getChildKinds(parentKind);
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(72);
        }
        return list;
    }

    @Nullable
    public static <T extends DasModel> T getModel(DasDataSource ds, Class<T> clazz) {
        LocalDataSource local = DbImplUtil.getMaybeLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Deprecated
    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        PsiElement delegate;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(73);
        }
        if (!o.isValid()) {
            return null;
        }
        Project project = o.getProject();
        Object object = o instanceof DbDataSource ? o : (o instanceof DbElement ? ((DbElement)o).getDelegate() : (delegate = o instanceof NodeGroup ? o : null));
        if (delegate == null) {
            return null;
        }
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        BasicNode parent2 = DatabaseStructure.getParentImpl(delegate, viewOptions, structure);
        if (parent2 instanceof DasObject && !(parent2 instanceof DbDataSource)) {
            DbDataSource dataSource2 = structure.findDbDataSource((DasObject)((Object)parent2));
            return dataSource2 == null ? null : DbImplUtilCore.findElement(dataSource2, (DasObject)((Object)parent2));
        }
        return parent2 instanceof PsiElement ? (PsiElement)parent2 : null;
    }

    private static boolean shouldShowEmptyGroup(@NotNull DatabaseViewOptions viewOptions, boolean isNamespace) {
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(74);
        }
        return viewOptions.SHOW_EMPTY_GROUPS || isNamespace;
    }

    @Deprecated
    @Nullable
    static BasicNode getParentImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DvTreeStructureService structure) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(75);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(76);
        }
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(77);
        }
        if (o instanceof BasicNode) {
            return DatabaseStructure.getParentImpl((BasicNode)o, viewOptions, structure);
        }
        if (o instanceof DbDataSource) {
            return DatabaseStructure.getParentImpl(DataSourceNode.node((DbDataSource)o), viewOptions, structure);
        }
        if (o instanceof DbElement) {
            return DatabaseStructure.getParentImpl(((DbElement)o).getDelegate(), viewOptions, structure);
        }
        return null;
    }

    @Nullable
    static BasicNode getParentImpl(@NotNull BasicNode node, @NotNull DatabaseViewOptions viewOptions, @NotNull DvTreeStructureService structure) {
        DasObject grandPa;
        FamilyGroup result2;
        BasicNode p2;
        boolean groupOption;
        DasObject theParent;
        if (node == null) {
            DatabaseStructure.$$$reportNull$$$0(78);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(79);
        }
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(80);
        }
        if (DatabaseViewStaticContext.isDatabaseViewModern()) {
            return structure.parentOf(node);
        }
        if (node instanceof DbGroup) {
            return ((DbGroup)node).parent;
        }
        if (node instanceof DataSourceNode) {
            return DatabaseStructure.getDbGroup(structure, ((DataSourceNode)node).getGroupName(), viewOptions);
        }
        if (node instanceof AuxiliaryObjectsGroup) {
            return ((AuxiliaryObjectsGroup)node).getParentNode();
        }
        if (node instanceof AuxiliaryFamilyGroup) {
            return ((AuxiliaryFamilyGroup)node).getParentNode();
        }
        DasObject dasObject = node instanceof HostFamily ? ((HostFamily)node).getHost() : (node instanceof FamilyGroup ? ((FamilyGroup)node).dasParent : (theParent = node instanceof BasicElement ? DatabaseStructure.getParent((DasObject)((Object)node)) : null));
        if (theParent == null) {
            return null;
        }
        DbDataSource dataSource2 = structure.findDbDataSource(theParent);
        if (dataSource2 == null) {
            return null;
        }
        ObjectKind rootKind = theParent.getKind();
        ObjectKind kidKind = node instanceof DasObject ? ((DasObject)((Object)node)).getKind() : ObjectKind.NONE;
        MetaModel metaModel = DbImplUtilCore.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (!viewOptions.GROUP_NAMESPACES && (p2 = DatabaseViewTreeFun.getSimpleParent(node, dataSource2, viewOptions)) != null) {
            return p2;
        }
        if (groupOption && kidKind != ObjectKind.NONE && theParent instanceof BasicElement && (result2 = DatabaseStructure.obtainFamilyGroup(dataSource2, node, kidKind, theParent, viewOptions)) != null) {
            return result2;
        }
        while (theParent instanceof DasNamespace && (grandPa = theParent.getDasParent()) != null && !viewOptions.SHOW_INTERMEDIATE && DatabaseStructure.getTopSingleRoot(dataSource2, grandPa, viewOptions) != grandPa) {
            theParent = grandPa;
        }
        if (theParent instanceof BasicRoot) {
            return DataSourceNode.node(dataSource2);
        }
        if (theParent instanceof DbDataSource) {
            return DataSourceNode.node((DbDataSource)theParent);
        }
        if (theParent instanceof BasicNode) {
            return theParent;
        }
        return null;
    }

    @Nullable
    static FamilyGroup obtainFamilyGroup(@NotNull DbDataSource dbDataSource, @NotNull BasicNode node, @NotNull ObjectKind kidKind, @NotNull BasicElement host, @NotNull DatabaseViewOptions viewOptions) {
        if (dbDataSource == null) {
            DatabaseStructure.$$$reportNull$$$0(81);
        }
        if (node == null) {
            DatabaseStructure.$$$reportNull$$$0(82);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(83);
        }
        if (host == null) {
            DatabaseStructure.$$$reportNull$$$0(84);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(85);
        }
        RegularFamilyGroup result2 = null;
        int visible = 0;
        int count = 0;
        Dbms dbms = dbDataSource.getDbms();
        DatabaseViewStructureProvider.PresentationToModelConverter converter = DatabaseViewStructureProvider.forDbms(dbms).getConverter();
        BasicElement element2 = node instanceof BasicElement ? (BasicElement)node : (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)ObjectUtils.tryCast((Object)node, DasObject.class)), BasicElement.class);
        ObjectKind groupKind = element2 == null ? kidKind : converter.getGroupKind(element2);
        MetaModel metaModel = DbImplUtilCore.getMetaModel(dbDataSource);
        int needVisibles = viewOptions.SHOW_INTERMEDIATE ? 1 : 2;
        for (ObjectKind kind : DatabaseStructure.getChildKinds(host, metaModel, host.getKind())) {
            ++count;
            visible += viewOptions.HIDDEN_KINDS.contains(kind.code()) ? 0 : (DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, kind)) ? 1 : DatabaseStructure.getChildObjects(dbDataSource, viewOptions, host, kind).take(1).size());
            if (kind != groupKind) continue;
            int weight = DatabaseStructure.getWeight(kind, dbms, count);
            result2 = DatabaseStructure.getOrCreateRegularFamilyGroup(host, kind, weight, dbms, dbDataSource, viewOptions);
            if (visible < needVisibles) continue;
            break;
        }
        if (visible >= needVisibles && result2 != null) {
            return result2;
        }
        return null;
    }

    @NotNull
    static DasObject getTopSingleRoot(@NotNull DbDataSource databaseSystem, DatabaseViewOptions options) {
        DasObject single;
        DatabaseSystem delegate;
        DasModel model;
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(86);
        }
        if ((model = (delegate = databaseSystem.getDelegate()).getModel()) instanceof BasicModel) {
            BasicRoot root2 = ((BasicModel)model).getRoot();
            single = DatabaseStructure.getSingleChild(databaseSystem, root2, options);
        } else {
            DasObject singleRoot = (DasObject)model.getModelRoots().single();
            single = singleRoot != null && !options.HIDDEN_KINDS.contains(singleRoot.getKind().code()) ? singleRoot : null;
        }
        DasObject dasObject = single instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(databaseSystem, single, options) : databaseSystem;
        if (dasObject == null) {
            DatabaseStructure.$$$reportNull$$$0(87);
        }
        return dasObject;
    }

    @Nullable
    private static DasObject getSingleChild(@NotNull DbDataSource databaseSystem, DasObject element2, DatabaseViewOptions options) {
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(88);
        }
        if (options.SHOW_INTERMEDIATE) {
            return null;
        }
        JBIterable kinds = element2 instanceof BasicElement ? JBIterable.from(((BasicElement)element2).getFamilyKinds()) : element2.getDasChildren(null).map(DasNamed::getKind).unique();
        ObjectKind singleKind = (ObjectKind)kinds.filter(kind -> !options.HIDDEN_KINDS.contains(kind.code()) && DatabaseStructure.getChildObjects(databaseSystem, options, element2, kind).isNotEmpty()).single();
        return singleKind == null ? null : (DasObject)DatabaseStructure.getChildObjects(databaseSystem, options, element2, singleKind).single();
    }

    static DasObject getTopSingleRoot(@Nullable DbDataSource databaseSystem, @NotNull DasObject element2, @NotNull DatabaseViewOptions options) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(89);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(90);
        }
        if (databaseSystem == null) {
            return null;
        }
        return (DasObject)JBIterable.generate((Object)element2, cur2 -> {
            DasObject single = DatabaseStructure.getSingleChild(databaseSystem, cur2, options);
            return single instanceof DasNamespace ? single : null;
        }).last();
    }

    @NotNull
    static DbRootGroup getRootGroup(@NotNull DvTreeStructureService structure, @NotNull DatabaseViewOptions options) {
        UserDataHolderEx project;
        DbRootGroup root2;
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(91);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(92);
        }
        if ((root2 = (DbRootGroup)(project = (UserDataHolderEx)structure.getContext().project).getUserData(DatabaseTreeKeys.ROOT_GROUP)) == null) {
            root2 = (DbRootGroup)project.putUserDataIfAbsent(DatabaseTreeKeys.ROOT_GROUP, (Object)new DbRootGroup(structure, options));
        }
        DbRootGroup dbRootGroup = root2;
        if (dbRootGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(93);
        }
        return dbRootGroup;
    }

    @NotNull
    static RegularFamilyGroup getOrCreateRegularFamilyGroup(@NotNull BasicElement host, @NotNull ObjectKind childKind, int weight, @NotNull Dbms dbms, @NotNull DbDataSource dataSource2, @NotNull DatabaseViewOptions viewOptions) {
        ConcurrentMap groupMap;
        RegularFamilyGroup result2;
        if (host == null) {
            DatabaseStructure.$$$reportNull$$$0(94);
        }
        if (childKind == null) {
            DatabaseStructure.$$$reportNull$$$0(95);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(96);
        }
        if (dataSource2 == null) {
            DatabaseStructure.$$$reportNull$$$0(97);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(98);
        }
        if ((result2 = (RegularFamilyGroup)(groupMap = (ConcurrentMap)((Map)DatabaseTreeKeys.FAMILY_GROUPS.getRequired((UserDataHolder)dataSource2)).get(host)).get(childKind)) == null || result2.weight != weight) {
            String name = StringUtil.pluralize((String)DbPresentationCore.getPresentableName(childKind, dbms));
            RegularFamilyGroup candidateGroup = new RegularFamilyGroup(host, name, childKind, dataSource2, viewOptions, weight);
            result2 = (RegularFamilyGroup)ConcurrencyUtil.cacheOrGet((ConcurrentMap)groupMap, (Object)childKind, (Object)candidateGroup);
        }
        RegularFamilyGroup regularFamilyGroup = result2;
        if (regularFamilyGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(99);
        }
        return regularFamilyGroup;
    }

    @NotNull
    public static NodeGroup getDbGroup(@NotNull DvTreeStructureService structure, @Nullable String groupName, @NotNull DatabaseViewOptions viewOptions) {
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(100);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(101);
        }
        DbRootGroup root2 = DatabaseStructure.getRootGroup(structure, viewOptions);
        if (!viewOptions.GROUP_DATA_SOURCES) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(102);
            }
            return dbRootGroup;
        }
        Map map2 = (Map)DatabaseTreeKeys.DATABASE_GROUPS.getRequired((UserDataHolder)root2);
        if (StringUtil.isEmpty((String)groupName)) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(103);
            }
            return dbRootGroup;
        }
        NodeGroup nodeGroup = (NodeGroup)JBIterable.from((Iterable)StringUtil.split((String)groupName, (String)"/")).reduce((Object)root2, (p2, s2) -> (DbGroup)((Map)map2.get(p2)).get(s2));
        if (nodeGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(104);
        }
        return nodeGroup;
    }

    public static void renameGroup(@NotNull Project project, DbGroup group, @NotNull String newName) {
        if (project == null) {
            DatabaseStructure.$$$reportNull$$$0(105);
        }
        if (newName == null) {
            DatabaseStructure.$$$reportNull$$$0(106);
        }
        String fullname = group.getQualifiedName();
        String pathname = StringUtil.trimEnd((String)fullname, (String)group.getName());
        String newFullname = pathname + newName;
        DbPsiFacade facade = DbPsiFacade.getInstance(project);
        for (DbDataSource dataSource2 : facade.getDataSources()) {
            AbstractDataSource ds = (AbstractDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), AbstractDataSource.class);
            String cur2 = ds == null ? null : ds.getGroupName();
            if (cur2 == null || !cur2.startsWith(fullname)) continue;
            ds.setGroupName(newFullname + cur2.substring(fullname.length()));
        }
        NodeGroup newGroup = DatabaseStructure.getDbGroup((DvTreeStructureService)project.getService(DvTreeStructureService.class), newFullname, DatabaseViewOptions.getInstance(project));
        DatabaseView.refreshViewAndSelect(project, Collections.singleton(newGroup));
    }

    @Contract(value="!null->!null")
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof DbDataSource) {
            return DataSourceNode.node((DbDataSource)o);
        }
        if (o instanceof DbElement) {
            return ((DbElement)o).getDelegate();
        }
        return o;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 72: 
            case 87: 
            case 93: 
            case 99: 
            case 102: 
            case 103: 
            case 104: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 72: 
            case 87: 
            case 93: 
            case 99: 
            case 102: 
            case 103: 
            case 104: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 72: 
            case 87: 
            case 93: 
            case 99: 
            case 102: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 14: 
            case 38: 
            case 39: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: 
            case 18: 
            case 34: 
            case 61: 
            case 69: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 32: 
            case 62: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kidKind";
                break;
            }
            case 20: 
            case 24: 
            case 28: 
            case 33: 
            case 40: 
            case 60: 
            case 66: 
            case 74: 
            case 76: 
            case 79: 
            case 85: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 26: 
            case 31: 
            case 35: 
            case 84: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 41: 
            case 77: 
            case 80: 
            case 91: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 58: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 59: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childKind";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodesToListSafely";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementChildren";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectChildren";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenFromFamily";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInnerNodes";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildObjects";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSingleRoot";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGroup";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRegularFamilyGroup";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 72: 
            case 87: 
            case 93: 
            case 99: 
            case 102: 
            case 103: 
            case 104: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToListSafely";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElementChildren";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getObjectChildren";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenFromFamily";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenFromExtensionProvider";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getStructureProvider";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isNamespace";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getElementInnerNodes";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getScopeCondition";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowEmptyGroup";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "obtainFamilyGroup";
                break;
            }
            case 86: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTopSingleRoot";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getSingleChild";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getRootGroup";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRegularFamilyGroup";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroup";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "renameGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 72: 
            case 87: 
            case 93: 
            case 99: 
            case 102: 
            case 103: 
            case 104: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyScopeLeaf
    extends UserDataHolderBase
    implements BasicNode,
    NavigationItem,
    ItemPresentation {
        @NotNull
        public final BasicElement host;
        @NotNull
        public final ObjectKind kind;
        @NotNull
        public final Object parentNode;

        public EmptyScopeLeaf(@NotNull BasicElement host, @NotNull ObjectKind kind, @NotNull BasicNode parentNode) {
            if (host == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(1);
            }
            if (parentNode == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(2);
            }
            this.host = host;
            this.kind = kind;
            this.parentNode = parentNode;
        }

        @Override
        @NotNull
        public BasicModel getModel() {
            BasicModel basicModel = this.host.getModel();
            if (basicModel == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(3);
            }
            return basicModel;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.kind;
            if (objectKind == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        public DasObject getDasParent() {
            return this.host;
        }

        private Icon getBaseIcon() {
            return AllIcons.Nodes.NodePlaceholder;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.getBaseIcon();
        }

        public Object getParent() {
            return this.parentNode;
        }

        @NotNull
        public TextRange getTextRangeInParent() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @NotNull
        public @NotNull Iterable<? extends @NotNull PsiSymbolReference> getOwnReferences() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @NotNull
        public String getName() {
            String string = "No " + this.getKind().code();
            if (string == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.getName();
            if (string == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        public ItemPresentation getPresentation() {
            return this;
        }

        @Nullable
        public String getPresentableText() {
            return this.getName();
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$EmptyScopeLeaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$EmptyScopeLeaf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRangeInParent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnReferences";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RegularFamilyGroup
    extends FamilyGroup {
        private int mySize;

        public RegularFamilyGroup(@NotNull BasicElement host, @NotNull String name, @NotNull ObjectKind kidKind, @NotNull DbDataSource dataSource2, @NotNull DatabaseViewOptions viewOptions, int weight) {
            if (host == null) {
                RegularFamilyGroup.$$$reportNull$$$0(0);
            }
            if (name == null) {
                RegularFamilyGroup.$$$reportNull$$$0(1);
            }
            if (kidKind == null) {
                RegularFamilyGroup.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                RegularFamilyGroup.$$$reportNull$$$0(3);
            }
            if (viewOptions == null) {
                RegularFamilyGroup.$$$reportNull$$$0(4);
            }
            super(host, name, kidKind, host, dataSource2, viewOptions, weight);
            this.mySize = 0;
        }

        @Override
        public int getSize() {
            return this.mySize;
        }

        void setSize(int size) {
            this.mySize = size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kidKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewOptions";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/DatabaseStructure$RegularFamilyGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class FamilyGroup
    extends HostGroup
    implements WeighedItem {
        public final DbDataSource dataSource;
        public final DasObject dasParent;
        private WeakReference<EmptyScopeLeaf> myEmptyScopeLeaf;
        final ObjectKind kidKind;
        final int weight;
        final DatabaseViewOptions viewOptions;

        FamilyGroup(@NotNull BasicElement host, @NotNull String name, @NotNull ObjectKind kidKind, @NotNull DasObject dasParent, @NotNull DbDataSource dataSource2, @NotNull DatabaseViewOptions viewOptions, int weight) {
            if (host == null) {
                FamilyGroup.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FamilyGroup.$$$reportNull$$$0(1);
            }
            if (kidKind == null) {
                FamilyGroup.$$$reportNull$$$0(2);
            }
            if (dasParent == null) {
                FamilyGroup.$$$reportNull$$$0(3);
            }
            if (dataSource2 == null) {
                FamilyGroup.$$$reportNull$$$0(4);
            }
            if (viewOptions == null) {
                FamilyGroup.$$$reportNull$$$0(5);
            }
            super(host, name);
            this.myEmptyScopeLeaf = new WeakReference<Object>(null);
            this.dataSource = dataSource2;
            this.kidKind = kidKind;
            this.dasParent = dasParent;
            this.viewOptions = viewOptions;
            this.weight = weight;
        }

        @Override
        public Object getParent() {
            return this.dasParent;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull
        public @NotNull JBIterable<@NotNull ? extends BasicElement> iterateChildren() {
            Predicate<BasicElement> filter2;
            DatabaseViewStructureProvider provider = DatabaseStructure.getStructureProvider(this.host);
            if (provider == null) {
                return FamilyGroup.iterateChildrenOfParent(this.host, this.kidKind);
            }
            DatabaseViewStructureProvider.PresentationToModelConverter converter = provider.getConverter();
            BasicElement modelParent = converter.toModelParent(this.host);
            @NotNull JBIterable children2 = FamilyGroup.iterateChildrenOfParent(modelParent, this.kidKind);
            if (this.dataSource.getDbms().isPostgres() && this.kidKind != ObjectKind.NONE) {
                children2 = converter.pickOnlyGroupChildren(modelParent, children2, this.kidKind);
            }
            if ((filter2 = provider.getFilter(modelParent.getKind(), this.kidKind, this.viewOptions)) != null) {
                children2 = children2.filter(e -> filter2.test((BasicElement)e));
            }
            JBIterable jBIterable = children2;
            if (jBIterable == null) {
                FamilyGroup.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @NotNull
        public static JBIterable<? extends BasicElement> iterateChildrenOfParent(@NotNull BasicElement parent2, @NotNull ObjectKind kind) {
            if (parent2 == null) {
                FamilyGroup.$$$reportNull$$$0(7);
            }
            if (kind == null) {
                FamilyGroup.$$$reportNull$$$0(8);
            }
            if (kind != ObjectKind.NONE) {
                Family<? extends BasicElement> family = parent2.familyOf(kind);
                JBIterable<? extends BasicElement> jBIterable = family != null ? family.jbi() : JBIterable.empty();
                if (jBIterable == null) {
                    FamilyGroup.$$$reportNull$$$0(9);
                }
                return jBIterable;
            }
            JBIterable<? extends BasicElement> jBIterable = parent2.getChildren();
            if (jBIterable == null) {
                FamilyGroup.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getChildrenKind() {
            ObjectKind objectKind = this.converter().toModelObjectKind(this.kidKind);
            if (objectKind == null) {
                FamilyGroup.$$$reportNull$$$0(11);
            }
            return objectKind;
        }

        @NotNull
        private DatabaseViewStructureProvider.PresentationToModelConverter converter() {
            DatabaseViewStructureProvider.PresentationToModelConverter presentationToModelConverter = DatabaseViewStructureProvider.forDbms(this.dataSource.getDbms()).getConverter();
            if (presentationToModelConverter == null) {
                FamilyGroup.$$$reportNull$$$0(12);
            }
            return presentationToModelConverter;
        }

        @NotNull
        public EmptyScopeLeaf getEmptyScopeLeaf() {
            EmptyScopeLeaf leaf = (EmptyScopeLeaf)this.myEmptyScopeLeaf.get();
            if (leaf == null) {
                BasicElement modelParent = DatabaseViewTreeFun.getModelElement(this.dasParent);
                leaf = new EmptyScopeLeaf((BasicElement)ObjectUtils.notNull((Object)modelParent, (Object)this.host), this.kidKind, this);
                this.myEmptyScopeLeaf = new WeakReference<EmptyScopeLeaf>(leaf);
            }
            EmptyScopeLeaf emptyScopeLeaf = leaf;
            if (emptyScopeLeaf == null) {
                FamilyGroup.$$$reportNull$$$0(13);
            }
            return emptyScopeLeaf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kidKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasParent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewOptions";
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildrenOfParent";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenKind";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "converter";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyScopeLeaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "iterateChildrenOfParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DbGroupChildrenComparator
    implements Comparator<BasicNode> {
        static final DbGroupChildrenComparator INSTANCE = new DbGroupChildrenComparator();

        private DbGroupChildrenComparator() {
        }

        @Override
        public int compare(BasicNode o1, BasicNode o2) {
            if (o1 instanceof DbGroup && o2 instanceof DataSourceNode) {
                return -1;
            }
            if (o1 instanceof DataSourceNode && o2 instanceof DbGroup) {
                return 1;
            }
            return ToStringComparator.INSTANCE.compare(o1, o2);
        }

        public String toString() {
            return "DbGroupChildrenComparator";
        }
    }

    public static class DbRootGroup
    extends DbGroup {
        public final DvTreeStructureService structure;
        public final DatabaseViewOptions viewOptions;

        public DbRootGroup(@NotNull DvTreeStructureService structure, @NotNull DatabaseViewOptions options) {
            if (structure == null) {
                DbRootGroup.$$$reportNull$$$0(0);
            }
            if (options == null) {
                DbRootGroup.$$$reportNull$$$0(1);
            }
            super("Database", null);
            this.structure = structure;
            this.viewOptions = options;
        }

        @NotNull
        public Project getProject() {
            Project project = this.structure.getContext().project;
            if (project == null) {
                DbRootGroup.$$$reportNull$$$0(2);
            }
            return project;
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @Override
        @NotNull
        public DbRootGroup getRootGroup() {
            DbRootGroup dbRootGroup = this;
            if (dbRootGroup == null) {
                DbRootGroup.$$$reportNull$$$0(3);
            }
            return dbRootGroup;
        }

        @Override
        @Nullable
        public Void getParent() {
            return null;
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public void navigate(boolean requestFocus) {
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.Dbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbGroup
    extends NodeGroup {
        final DbGroup parent;
        private int mySize = 0;

        public DbGroup(String name, DbGroup parent2) {
            super(name);
            this.parent = parent2;
        }

        @Override
        @Nullable
        public final BasicModel getModel() {
            return null;
        }

        @Override
        public int getSize() {
            return this.mySize;
        }

        void setSize(int size) {
            this.mySize = size;
        }

        void incSize() {
            ++this.mySize;
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.ObjectGroup;
        }

        @Override
        public Object getParent() {
            return this.parent;
        }

        @Nullable
        public DbRootGroup getRootGroup() {
            NodeGroup g = this;
            while (g != null) {
                if (g instanceof DbRootGroup) {
                    return (DbRootGroup)g;
                }
                Object p2 = ((NodeGroup)g).getParent();
                g = p2 instanceof NodeGroup ? (NodeGroup)p2 : null;
            }
            return null;
        }

        @NotNull
        public JBIterable<BasicNode> iterateChildren() {
            DbRootGroup rg = this.getRootGroup();
            if (rg == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DbGroup.$$$reportNull$$$0(0);
                }
                return jBIterable;
            }
            DatabaseViewOptions vo = rg.viewOptions;
            Comparator<Object> comparator2 = vo.SORT_POSITIONED ? ToStringComparator.INSTANCE : DbGroupChildrenComparator.INSTANCE;
            JBIterable children2 = this.collectChildren(vo);
            JBIterable jBIterable = children2 = children2.sort((Comparator)comparator2);
            if (jBIterable == null) {
                DbGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @NotNull
        private JBIterable<BasicNode> collectChildren(@NotNull DatabaseViewOptions viewOptions) {
            if (viewOptions == null) {
                DbGroup.$$$reportNull$$$0(2);
            }
            JBIterable parentGroups = JBIterable.generate((Object)this, o -> o.parent);
            DbRootGroup root2 = Objects.requireNonNull((DbRootGroup)parentGroups.filter(DbRootGroup.class).first());
            JBIterable dataSources = JBIterable.from(DbPsiFacade.getInstance(root2.getProject()).getDataSources());
            if (!viewOptions.GROUP_DATA_SOURCES) {
                JBIterable jBIterable = this instanceof DbRootGroup ? dataSources.map(ds -> DataSourceNode.node(ds)) : JBIterable.empty();
                if (jBIterable == null) {
                    DbGroup.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            String fullName = this.getQualifiedName();
            Map groups = (Map)((Map)DatabaseTreeKeys.DATABASE_GROUPS.getRequired((UserDataHolder)root2)).get(this);
            HashSet<String> subNames = new HashSet<String>();
            ArrayList<BasicNode> result2 = new ArrayList<BasicNode>();
            for (DbDataSource dataSource2 : dataSources) {
                String subName;
                String groupName = StringUtil.notNullize((String)((AbstractDataSource)dataSource2.getDelegate()).getGroupName());
                if (!groupName.startsWith(fullName)) continue;
                if (groupName.equals(fullName)) {
                    DataSourceNode dsNode = DataSourceNode.node(dataSource2);
                    result2.add(dsNode);
                    continue;
                }
                if (fullName.length() != 0 && groupName.charAt(fullName.length()) != '/') continue;
                String substring = StringUtil.trimStart((String)groupName.substring(fullName.length()), (String)"/");
                int idx = substring.indexOf("/");
                String string = subName = idx < 0 ? substring : substring.substring(0, idx);
                if (subName.isEmpty()) continue;
                DbGroup subGroup = (DbGroup)groups.get(subName);
                if (!subNames.add(subName)) {
                    subGroup.incSize();
                    continue;
                }
                result2.add(subGroup);
                subGroup.setSize(1);
            }
            JBIterable jBIterable = JBIterable.from(result2);
            if (jBIterable == null) {
                DbGroup.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        public String getQualifiedName() {
            StringBuilder sb = new StringBuilder(this.getName());
            DbGroup cur2 = this.parent;
            while (cur2 != null && !(cur2 instanceof DbRootGroup)) {
                sb.insert(0, cur2.getName() + "/");
                cur2 = cur2.parent;
            }
            return sb.toString();
        }

        @NotNull
        public ItemPresentation getQualifiedPresentation() {
            PresentationData presentation = (PresentationData)this.getPresentation();
            presentation.getColoredText().set(0, new PresentableNodeDescriptor.ColoredFragment(this.getQualifiedName(), SimpleTextAttributes.REGULAR_ATTRIBUTES));
            PresentationData presentationData = presentation;
            if (presentationData == null) {
                DbGroup.$$$reportNull$$$0(5);
            }
            return presentationData;
        }

        @Override
        public boolean canNavigate() {
            DbRootGroup rg = this.getRootGroup();
            if (rg == null) {
                return false;
            }
            return !rg.structure.getContext().project.isDisposed();
        }

        @Override
        public void navigate(boolean requestFocus) {
            DbRootGroup rg = this.getRootGroup();
            if (rg == null) {
                return;
            }
            DatabaseView.select(rg.structure.getContext().project, Collections.singleton(this), requestFocus, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$DbGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$DbGroup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "collectChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Deprecated
    public static interface Group {
        public ObjectKind getChildrenKind();
    }
}

