/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2
implements TargetElementEvaluatorEx {
    public static boolean isLegacyNavigateToSchema() {
        return Registry.is((String)"database.legacy.navigate.to.schema", (boolean)false);
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element2, @Nullable PsiElement navElement) {
        if (element2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
    }

    @NotNull
    public static NavigationItem getGotoDeclarationTarget(DbElement dbElement) {
        NavigationItem navigationItem = DatabaseTargetElementEvaluator.isLegacyNavigateToSchema() ? DbNavigationUtils.createToDatabaseViewNavigatable(dbElement) : DbNavigationUtils.createToSourceNavigatable(dbElement);
        if (navigationItem == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        return navigationItem;
    }

    public boolean isIdentifierPart(@NotNull PsiFile element2, @NotNull CharSequence text2, int offset) {
        PsiElement e;
        if (element2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        return (e = element2.findElementAt(offset)) != null && e.getParent() instanceof SqlIdentifier;
    }

    @Nullable
    public static OpenFileDescriptor getDescriptor(@NotNull DbElement dbElement) {
        VirtualFile file;
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        if ((file = DbTargetUtil.getContainingFile(dbElement, true)) == null) {
            return null;
        }
        Project project = dbElement.getProject();
        int offset = DbTargetUtil.calcTargetOffset(project, file, dbElement);
        return new OpenFileDescriptor(project, file, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoDeclarationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifierPart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

