/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropQueryGenerator {
    private final Project myProject;
    private final BasicModel myModel;
    private ScriptingOptions myOptions;
    private Set<BasicElement> myItems;
    private BasicNamespace myCurrentNamespace;

    public static boolean canDeleteAnything(@NotNull BasicModel model, @NotNull Iterable<BasicElement> elements) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            DropQueryGenerator.$$$reportNull$$$0(1);
        }
        return !JBIterable.from(elements).filter(e -> DropQueryGenerator.canDelete(model, e)).isEmpty();
    }

    private static boolean canDelete(@NotNull BasicModel model, @NotNull BasicElement element2) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DropQueryGenerator.$$$reportNull$$$0(3);
        }
        return ScriptGenerators.INSTANCE.byModel(model).capabilities(element2).getDrop().get(model.getRoot().getServerVersion());
    }

    public DropQueryGenerator(@NotNull Project project, @NotNull BasicModel model) {
        if (project == null) {
            DropQueryGenerator.$$$reportNull$$$0(4);
        }
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(5);
        }
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.myItems = Collections.emptySet();
        this.myProject = project;
        this.myModel = model;
    }

    public void setItems(@NotNull Iterable<BasicElement> items2) {
        if (items2 == null) {
            DropQueryGenerator.$$$reportNull$$$0(6);
        }
        this.myItems = JBIterable.from(items2).filter(e -> this.myModel.contains((DasObject)e)).toSet();
    }

    @NotNull
    public Set<BasicElement> getItems() {
        Set<BasicElement> set = this.myItems;
        if (set == null) {
            DropQueryGenerator.$$$reportNull$$$0(7);
        }
        return set;
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        this.myCurrentNamespace = currentNamespace;
    }

    public void setOptions(@NotNull ScriptingOptions o) {
        if (o == null) {
            DropQueryGenerator.$$$reportNull$$$0(8);
        }
        this.myOptions = o;
    }

    @NotNull
    public ScriptingResult generate() {
        ScriptingResult scriptingResult = this.generate(this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(9);
        }
        return scriptingResult;
    }

    @NotNull
    public ScriptingResult generate(@Nullable Version version) {
        ScriptingResult scriptingResult = ScriptGenerators.INSTANCE.makeScript(this.myProject, this.createTask(version));
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(10);
        }
        return scriptingResult;
    }

    @NotNull
    public ScriptingSingleModelTask createTask(@Nullable Version version) {
        ScriptingSingleModelTaskBuilder task2 = new ScriptingSingleModelTaskBuilder(this.myModel, ScriptCategory.DROP_COMPLETE);
        task2.getElements().addAll(this.myItems);
        task2.setCurrentNamespace(this.myCurrentNamespace);
        task2.setOptions(this.myOptions);
        if (version != null) {
            task2.setVersion(version);
        }
        ScriptingSingleModelTask scriptingSingleModelTask = task2.build();
        if (scriptingSingleModelTask == null) {
            DropQueryGenerator.$$$reportNull$$$0(11);
        }
        return scriptingSingleModelTask;
    }

    public void fillNamespacesToRemove(List<ObjectPath> toRemove) {
        for (BasicElement namespace : this.myItems) {
            ObjectKind kind = namespace.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            toRemove.add(BasicPaths.of(namespace));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteAnything";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDelete";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

