/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayerKt;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u001c\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00162\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J \u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00162\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0018\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u001c\u0010%\u001a\u00060\nR\u00020\u00002\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010(\u001a\u0004\u0018\u00010\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer;", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "base", "Lcom/intellij/database/view/structure/DvTreeLayer;", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "(Lcom/intellij/database/view/structure/DvTreeLayer;Lcom/intellij/database/view/structure/DvTreeContext;)V", "auxiliaryGroups", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup;", "getBase", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "setBase", "(Lcom/intellij/database/view/structure/DvTreeLayer;)V", "emptyScopeLeaves", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$EmptyScopeLeaf;", "root", "Lcom/intellij/database/model/basic/BasicNode;", "getRoot", "()Lcom/intellij/database/model/basic/BasicNode;", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "node", "childrenOfFamily", "family", "Lcom/intellij/database/model/families/HostFamily;", "childrenOfNamespaceOwner", "host", "parent", "childrenOfRoot", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "clearAll", "", "isAlwaysLeaf", "", "obtainAuxiliaryGroup", "obtainEmptyScopeLeaf", "parentOf", "parentOfFamily", "presentableNameOf", "", "AuxiliaryGroup", "EmptyScopeLeaf", "HostGroup", "intellij.database.impl"})
public final class DvTreeLayoutLayer
extends DvTreeAbstractLayer {
    private final WeakHashMap<BasicNamespaceOwner, AuxiliaryGroup> auxiliaryGroups;
    private final WeakHashMap<BasicNamespaceOwner, EmptyScopeLeaf> emptyScopeLeaves;
    @NotNull
    private DvTreeLayer base;

    @Override
    @NotNull
    public BasicNode getRoot() {
        return this.getBase().getRoot();
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof AuxiliaryGroup) {
            return ((AuxiliaryGroup)node).getParent();
        }
        BasicNode originalParent = this.baseParentOf(node);
        BasicNode basicNode = originalParent;
        if (basicNode instanceof DataSourceNode) {
            if (node instanceof HostFamily && DvTreeLayoutLayerKt.access$isNamespaceFamily(node)) {
                return originalParent;
            }
            BasicRoot root2 = ((DataSourceNode)originalParent).getModelRoot();
            if (root2 != null) {
                return this.obtainAuxiliaryGroup(root2, originalParent);
            }
        } else if (basicNode instanceof BasicDatabase) {
            if (node instanceof HostFamily && DvTreeLayoutLayerKt.access$isNamespaceFamily(node)) {
                return originalParent;
            }
            return this.obtainAuxiliaryGroup((BasicNamespaceOwner)originalParent, originalParent);
        }
        return (basicNode = node) instanceof HostFamily ? this.parentOfFamily((HostFamily)node) : originalParent;
    }

    private final BasicNode parentOfFamily(HostFamily<?> family) {
        return this.baseParentOf(family);
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DataSourceNode ? this.childrenOfRoot((DataSourceNode)node) : (basicNode instanceof BasicDatabase ? this.childrenOfNamespaceOwner((BasicNamespaceOwner)node, node) : (basicNode instanceof AuxiliaryGroup ? ((AuxiliaryGroup)node).getChildren() : (basicNode instanceof HostFamily ? this.childrenOfFamily((HostFamily)node) : this.getBase().childrenOf(node))));
    }

    private final JBIterable<? extends BasicNode> childrenOfRoot(DataSourceNode dsn) {
        BasicRoot basicRoot = dsn.getModelRoot();
        if (basicRoot == null) {
            return this.getBase().childrenOf(dsn);
        }
        BasicRoot root2 = basicRoot;
        return this.childrenOfNamespaceOwner(root2, dsn);
    }

    private final JBIterable<? extends BasicNode> childrenOfNamespaceOwner(BasicNamespaceOwner host, BasicNode parent2) {
        JBIterable<? extends BasicNode> jBIterable = this.getBase().childrenOf(host);
        Object object = childrenOfNamespaceOwner.namespaceFamilies.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Condition(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean value(Object p0) {
                    Object object = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            };
        }
        JBIterable jBIterable2 = jBIterable.filter((Condition)object);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"base.childrenOf(host).fi\u2026cNode::isNamespaceFamily)");
        JBIterable namespaceFamilies2 = jBIterable2;
        AuxiliaryGroup auxiliaryGroup = this.obtainAuxiliaryGroup(host, parent2);
        if (auxiliaryGroup.isNotEmpty()) {
            ArrayList<AuxiliaryGroup> list = new ArrayList<AuxiliaryGroup>();
            CollectionsKt.addAll((Collection)list, (Iterable)((Iterable)namespaceFamilies2));
            list.add(auxiliaryGroup);
            JBIterable jBIterable3 = JBIterable.from((Iterable)list);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.from(list)");
            return jBIterable3;
        }
        return namespaceFamilies2;
    }

    private final JBIterable<? extends BasicNode> childrenOfFamily(HostFamily<?> family) {
        JBIterable children2 = this.getBase().childrenOf(family);
        if (children2.isEmpty()) {
            JBIterable jBIterable;
            BasicElement basicElement = family.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"family.host");
            BasicElement host = basicElement;
            if (host instanceof BasicMultiDatabaseRoot) {
                JBIterable jBIterable2 = JBIterable.of((Object)this.obtainEmptyScopeLeaf((BasicNamespaceOwner)host));
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"JBIterable.of(obtainEmptyScopeLeaf(host))");
            } else if (host instanceof BasicDatabase) {
                JBIterable jBIterable3 = JBIterable.of((Object)this.obtainEmptyScopeLeaf((BasicNamespaceOwner)host));
                jBIterable = jBIterable3;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.of(obtainEmptyScopeLeaf(host))");
            } else {
                jBIterable = children2;
            }
            return jBIterable;
        }
        return children2;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof EmptyScopeLeaf || this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    @Override
    public void clearAll() {
        this.auxiliaryGroups.clear();
        this.emptyScopeLeaves.clear();
    }

    private final AuxiliaryGroup obtainAuxiliaryGroup(BasicNamespaceOwner host, BasicNode parent2) {
        AuxiliaryGroup group = this.auxiliaryGroups.get(host);
        if (group == null) {
            group = new AuxiliaryGroup(host, parent2);
            ((Map)this.auxiliaryGroups).put(host, group);
        }
        return group;
    }

    private final EmptyScopeLeaf obtainEmptyScopeLeaf(BasicNamespaceOwner host) {
        EmptyScopeLeaf leaf = this.emptyScopeLeaves.get(host);
        if (leaf == null) {
            leaf = new EmptyScopeLeaf(host);
            ((Map)this.emptyScopeLeaves).put(host, leaf);
        }
        return leaf;
    }

    @Override
    @NotNull
    public DvTreeLayer getBase() {
        return this.base;
    }

    public void setBase(@NotNull DvTreeLayer dvTreeLayer) {
        Intrinsics.checkNotNullParameter((Object)dvTreeLayer, (String)"<set-?>");
        this.base = dvTreeLayer;
    }

    public DvTreeLayoutLayer(@NotNull DvTreeLayer base, @NotNull DvTreeContext context) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.base = base;
        this.auxiliaryGroups = new WeakHashMap();
        this.emptyScopeLeaves = new WeakHashMap();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H&J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$HostGroup;", "H", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvHostNode;", "host", "(Lcom/intellij/database/model/basic/BasicElement;)V", "getChildren", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "isEmpty", "", "isNotEmpty", "intellij.database.impl"})
    public static abstract class HostGroup<H extends BasicElement>
    extends DvHostNode<H> {
        @NotNull
        public abstract JBIterable<? extends BasicNode> getChildren();

        public final boolean isEmpty() {
            return this.getChildren().isEmpty();
        }

        public final boolean isNotEmpty() {
            return this.getChildren().isNotEmpty();
        }

        public HostGroup(@NotNull H host) {
            Intrinsics.checkNotNullParameter(host, (String)"host");
            super(host);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup;", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$HostGroup;", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "host", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "(Lcom/intellij/database/view/structure/DvTreeLayoutLayer;Lcom/intellij/database/model/basic/BasicNamespaceOwner;Lcom/intellij/database/model/basic/BasicNode;)V", "hostKind", "Lcom/intellij/database/model/ObjectKind;", "getHostKind", "()Lcom/intellij/database/model/ObjectKind;", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "isServer", "", "getParent", "()Lcom/intellij/database/model/basic/BasicNode;", "getChildren", "Lcom/intellij/util/containers/JBIterable;", "getDisplayName", "", "toString", "intellij.database.impl"})
    public final class AuxiliaryGroup
    extends HostGroup<BasicNamespaceOwner> {
        private final boolean isServer;
        @NotNull
        private final BasicNode parent;

        @Override
        @Nullable
        public ObjectKind getHostKind() {
            return ObjectKind.UNKNOWN_OBJECT;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicNode> getChildren() {
            JBIterable<? extends BasicNode> hostChildren = DvTreeLayoutLayer.this.getBase().childrenOf(this.host);
            JBIterable jBIterable = hostChildren.filter((Condition)getChildren.1.INSTANCE).filter((Condition)getChildren.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"hostChildren\n        .fi\u2026amily<*> && it.isEmpty) }");
            return jBIterable;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.isServer ? "Server Objects" : "Database Objects";
        }

        @Override
        @Nullable
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.GRAY_FOLDER_ICON;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append(this.getDisplayName()).append(" (host: ");
            ObjectKind objectKind = ((BasicNamespaceOwner)this.host).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"host.kind");
            StringBuilder stringBuilder2 = stringBuilder.append(objectKind.getPresentableName()).append(' ');
            String string = ((BasicNamespaceOwner)this.host).getRealName();
            if (string == null) {
                string = "<unnamed>";
            }
            return stringBuilder2.append(string).append(')').toString();
        }

        @NotNull
        public final BasicNode getParent() {
            return this.parent;
        }

        public AuxiliaryGroup(@NotNull BasicNamespaceOwner host, BasicNode parent2) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            super((BasicElement)host);
            this.parent = parent2;
            this.isServer = host instanceof BasicRoot;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$EmptyScopeLeaf;", "Lcom/intellij/database/view/structure/DvHostNode;", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "host", "(Lcom/intellij/database/model/basic/BasicNamespaceOwner;)V", "isItselfMeaningful", "", "()Z", "leafKind", "Lcom/intellij/database/model/ObjectKind;", "getLeafKind", "()Lcom/intellij/database/model/ObjectKind;", "getDisplayName", "", "intellij.database.impl"})
    public static final class EmptyScopeLeaf
    extends DvHostNode<BasicNamespaceOwner> {
        @NotNull
        private final ObjectKind leafKind;

        @NotNull
        public final ObjectKind getLeafKind() {
            return this.leafKind;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            ObjectKind objectKind = this.leafKind;
            return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? "No database" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? "No schema" : "No objects here");
        }

        @Override
        public boolean isItselfMeaningful() {
            return true;
        }

        public EmptyScopeLeaf(@NotNull BasicNamespaceOwner host) {
            ObjectKind objectKind;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super((BasicElement)host);
            BasicNamespaceOwner basicNamespaceOwner = host;
            if (basicNamespaceOwner instanceof BasicMultiDatabaseRoot) {
                ObjectKind objectKind2 = ObjectKind.DATABASE;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"DATABASE");
            } else if (basicNamespaceOwner instanceof BasicDatabase) {
                ObjectKind objectKind3 = ObjectKind.SCHEMA;
                objectKind = objectKind3;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"SCHEMA");
            } else {
                ObjectKind objectKind4 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind4;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"UNKNOWN_OBJECT");
            }
            this.leafKind = objectKind;
        }
    }
}

