/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabasePreviewDialog
extends DialogWrapper {
    private final Project myProject;
    private final DbDataSource mySource;
    private final SearchPath mySearchPath;
    private final String myQuery;
    private SqlPreviewComponent myPreviewPanel;
    private final @NlsContexts.Label String myLabelText;
    @NotNull
    private final List<String> myMessages;

    public DatabasePreviewDialog(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Label String labelText, @NotNull String query, @NotNull List<String> messages, final boolean addSkipPreview) {
        if (project == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(2);
        }
        if (labelText == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(3);
        }
        if (query == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(4);
        }
        if (messages == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(5);
        }
        super(project);
        this.setDoNotAskOption(new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return !DatabaseSettings.getSettings().skipRefactoringPreview;
            }

            public void setToBeShown(boolean toBeShown, int exitCode) {
                DatabaseSettings.getSettings().skipRefactoringPreview = !toBeShown;
                DatabaseSettings.fireSettingsChanged();
            }

            public boolean canBeHidden() {
                return addSkipPreview;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = DatabaseBundle.message("checkbox.skip.preview.valid.script", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabasePreviewDialog$1", "getDoNotShowMessage"));
            }
        });
        this.myProject = project;
        this.mySource = dataSource2;
        this.mySearchPath = searchPath;
        this.myQuery = query;
        this.myLabelText = labelText;
        this.myMessages = messages;
        this.setTitle(title);
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPreviewPanel = new SqlPreviewComponent(this.myProject, this.mySource, this.mySearchPath, this.myQuery, false, () -> this.close(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel(this.myLabelText), "Center");
        if (!this.myMessages.isEmpty()) {
            String title = this.myMessages.size() == 1 ? this.myMessages.get(0) : DatabaseBundle.message("label.there.are.errors", new Object[0]);
            ErrorLabel error2 = new ErrorLabel(title, UIUtil.getBalloonErrorIcon());
            error2.setErrorText(StringUtil.join(this.myMessages, (String)"\n"), (Color)JBColor.RED);
            northPanel.add((Component)error2, "East");
        }
        ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message("ObjectEditorWithPreview.label.sql.script", new Object[0]), northPanel, (JComponent)this.myPreviewPanel.getEditor(), this.getDimensionServiceKey());
        splitter.setProportion(0.0f);
        splitter.setResizeEnabled(false);
        splitter.setTrailWidget(this.myPreviewPanel.createToolbar());
        return splitter;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    @NotNull
    public SqlPreviewComponent getPreviewPanel() {
        SqlPreviewComponent sqlPreviewComponent = this.myPreviewPanel;
        if (sqlPreviewComponent == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(7);
        }
        return sqlPreviewComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabasePreviewDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabasePreviewDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

