/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCheckBoxTree<N extends MyNode<N>>
extends CheckboxTree {
    public DbCheckBoxTree(@NotNull CheckedTreeNode root2, @NotNull CheckboxTree.CheckboxTreeCellRenderer renderer) {
        if (root2 == null) {
            DbCheckBoxTree.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            DbCheckBoxTree.$$$reportNull$$$0(1);
        }
        super(renderer, root2, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        this.setRowHeight(renderer.getTreeCellRendererComponent((JTree)((Object)this), (Object)root2, (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height);
        this.setLargeModel(true);
    }

    protected void installSpeedSearch() {
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 32 && e.getModifiers() == 0) {
            TreePath path = this.getLeadSelectionPath();
            CheckedTreeNode node = path == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class);
            boolean state = node != null && node.isChecked();
            CheckedTreeNode[] sel = (CheckedTreeNode[])this.getSelectedNodes(CheckedTreeNode.class, CheckedTreeNode::isEnabled);
            if (sel.length != 0) {
                for (CheckedTreeNode treeNode : sel) {
                    this.setNodeState(treeNode, !state);
                }
                this.updateFromNodes();
                e.consume();
            }
            return;
        }
        if (e.getID() == 400 && e.getKeyChar() == ' ') {
            return;
        }
        super.processKeyEvent(e);
    }

    public void updateFromNodes() {
        DbCheckBoxTree.updateEnabled((Tree)this, null);
    }

    @NotNull
    public FilteringTree.SearchTreeModel<CheckedTreeNode, N> getSearchModel() {
        FilteringTree.SearchTreeModel searchTreeModel = (FilteringTree.SearchTreeModel)this.getModel();
        if (searchTreeModel == null) {
            DbCheckBoxTree.$$$reportNull$$$0(2);
        }
        return searchTreeModel;
    }

    protected void onNodeStateChanged(CheckedTreeNode treeNode) {
        super.onNodeStateChanged(treeNode);
        FilteringTree.SearchTreeModel<CheckedTreeNode, N> model = this.getSearchModel();
        MyNode node = (MyNode)model.getUserObject((DefaultMutableTreeNode)treeNode);
        if (node != null) {
            DbCheckBoxTree.updateEnabled((Tree)this, node.getObject() == "*" ? node.getParent() : node);
        }
    }

    private static <N extends MyNode<N>> void updateEnabled(Tree tree, N root2) {
        FilteringTree.SearchTreeModel searchModel = (FilteringTree.SearchTreeModel)tree.getModel();
        if (root2 == null) {
            root2 = (MyNode)searchModel.getRootObject();
        }
        root2 = (MyNode)ObjectUtils.chooseNotNull((Object)((MyNode)JBIterable.generate(root2, MyNode::getParent).filter(n -> !DbCheckBoxTree.isSubtreeEnabled(n.getParent(), n.getMeta())).last()), root2);
        for (MyNode enabledNode : (JBTreeTraverser)JBTreeTraverser.from(DbCheckBoxTree::enabledChildren).withRoot(root2)) {
            DbCheckBoxTree.setEnabled(searchModel, enabledNode, true);
            HashSet<ObjectKind> disabled = new HashSet<ObjectKind>();
            for (MyNode n2 : JBIterable.from(enabledNode.getAllNodes())) {
                DbCheckBoxTree.setEnabled(searchModel, n2, true);
                if (!n2.isChecked()) continue;
                disabled.add(n2.getKind());
            }
            for (MyNode node : enabledNode.getSimpleChildNodes()) {
                if (!disabled.contains(node.getKind())) continue;
                for (MyNode disabledNode : (JBTreeTraverser)JBTreeTraverser.from(MyNode::getChildNodes).withRoot((Object)node)) {
                    DbCheckBoxTree.setEnabled(searchModel, disabledNode, false);
                }
            }
        }
        tree.repaint();
        tree.revalidate();
    }

    private static <N extends MyNode<N>> Iterable<N> enabledChildren(N n) {
        Set disabled = JBIterable.from(n.getAllNodes()).filter(MyNode::isChecked).map(MyNode::getKind).toSet();
        return n.getChildNodes().filter(c2 -> !disabled.contains(c2.getKind()));
    }

    private static boolean isSubtreeEnabled(@Nullable MyNode<? extends MyNode<?>> n, @Nullable BasicMetaObject<?> metaObject) {
        List<MyNode<?>> allNodes;
        List<MyNode<?>> list = allNodes = n == null ? null : n.getAllNodes();
        if (allNodes == null) {
            return true;
        }
        boolean empty = true;
        for (MyNode<?> node : allNodes) {
            if (metaObject != null && node.getMeta() != metaObject) continue;
            if (!node.isChecked()) {
                return true;
            }
            empty = false;
        }
        return empty;
    }

    private static <N extends MyNode<N>> void setEnabled(@NotNull FilteringTree.SearchTreeModel<CheckedTreeNode, N> m, @Nullable N n, boolean e) {
        CheckedTreeNode node;
        if (m == null) {
            DbCheckBoxTree.$$$reportNull$$$0(3);
        }
        if ((node = (CheckedTreeNode)m.getCachedNode(n)) != null) {
            node.setEnabled(e);
        }
    }

    @Nullable
    public static <T extends DbCheckBoxTree<?>> T getTree(@NotNull DataContext dataContext, @NotNull Class<T> clazz) {
        if (dataContext == null) {
            DbCheckBoxTree.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            DbCheckBoxTree.$$$reportNull$$$0(5);
        }
        return (T)((Object)((DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext), clazz))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbCheckBoxTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbCheckBoxTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class CellWithUnderlinedAllRenderer<N extends MyNode<N>>
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Color SEP_COLOR = UIManager.getColor("Label.disabledForeground");
        private final Border OVERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)1, (int)0, (int)0, (int)0);
        private final Border UNDERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)0, (int)0, (int)1, (int)0);

        public CellWithUnderlinedAllRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree baseTree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DbCheckBoxTree tree = (DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)baseTree, DbCheckBoxTree.class));
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)value2, CheckedTreeNode.class);
            if (tree == null || !(tree.getModel() instanceof FilteringTree.SearchTreeModel) || treeNode == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            MyNode node = (MyNode)tree.getSearchModel().getUserObject((DefaultMutableTreeNode)treeNode);
            if (node != null) {
                this.customizeCheckboxRenderer(node);
                this.setToolTipText(treeNode.isEnabled() ? "" : DatabaseBundle.message("not.editable.because.all.check.box.is.selected", new Object[0]));
                if (UIUtil.isClientPropertyTrue((Object)baseTree, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    this.setBorder(null);
                } else {
                    this.updateBorder((TreeNode)treeNode, node);
                }
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)tree), (SimpleColoredComponent)renderer, (boolean)true, (boolean)selected);
        }

        protected void updateBorder(@NotNull TreeNode treeNode, @NotNull N node) {
            MyNode c1;
            MyNode c0;
            TreeNode parent2;
            if (treeNode == null) {
                CellWithUnderlinedAllRenderer.$$$reportNull$$$0(0);
            }
            if (node == null) {
                CellWithUnderlinedAllRenderer.$$$reportNull$$$0(1);
            }
            int idx = (parent2 = treeNode.getParent()) != null ? parent2.getIndex(treeNode) : -1;
            MyNode myNode = c0 = idx == -1 ? null : (MyNode)node;
            if (((MyNode)node).getObject() == "*") {
                c1 = idx == -1 ? null : (MyNode)this.getChild(parent2, idx + 1);
            } else {
                c1 = c0;
                MyNode myNode2 = c0 = idx > 0 ? (MyNode)this.getChild(parent2, idx - 1) : null;
            }
            if (c0 != null && c1 != null && c0.getObject() == "*" && c1.getObject() != "*") {
                boolean isFirst;
                SimpleColoredText text2 = new SimpleColoredText();
                this.renderText(c0, (ColoredTextContainer)text2);
                String t0 = text2.toString();
                text2.clear();
                this.renderText(c1, (ColoredTextContainer)text2);
                String t1 = text2.toString();
                boolean useFirst = t0.length() > t1.length();
                boolean bl = isFirst = node == c0;
                this.setBorder(useFirst == isFirst ? (isFirst ? this.UNDERLINE : this.OVERLINE) : null);
            } else {
                this.setBorder(null);
            }
        }

        @Nullable
        protected N getChild(@Nullable TreeNode parent2, int idx) {
            if (parent2 == null || idx >= parent2.getChildCount()) {
                return null;
            }
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)parent2.getChildAt(idx), CheckedTreeNode.class);
            return (N)(treeNode == null ? null : (MyNode)treeNode.getUserObject());
        }

        protected abstract void customizeCheckboxRenderer(N var1);

        protected abstract void renderText(N var1, ColoredTextContainer var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "treeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/ui/DbCheckBoxTree$CellWithUnderlinedAllRenderer";
            objectArray[2] = "updateBorder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class MyNode<Self extends MyNode<Self>> {
        private List<Self> myAllNodes;
        private List<Self> myChildren = null;
        private List<Self> myShadowChildren = null;
        private Self myParent = null;
        private boolean myChecked;
        private final String myName;
        @Nullable
        private final BasicMetaObject<?> myMeta;
        private Object myObject;

        public MyNode(String name, @Nullable BasicMetaObject<?> meta, Object object) {
            this.myName = name;
            this.myMeta = meta;
            this.myObject = object;
        }

        @Nullable
        public BasicMetaObject<?> getMeta() {
            return this.myMeta;
        }

        @NotNull
        public List<Self> getChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
            if (list == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<Self> getShadowChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myShadowChildren, Collections.emptyList());
            if (list == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void setChildren(@Nullable Collection<Self> children2) {
            MyNode.reparent(this.myChildren, null);
            this.myChildren = ContainerUtil.isEmpty(children2) ? null : new SmartList(children2);
            this.reparent((Collection<Self>)this.myChildren);
            if (children2 != null && this.myShadowChildren != null) {
                this.myShadowChildren.removeAll(children2);
            }
        }

        public void setShadowChildren(@Nullable Collection<Self> children2) {
            MyNode.reparent(this.myShadowChildren, null);
            this.myShadowChildren = ContainerUtil.isEmpty(children2) ? null : new SmartList(children2);
            this.reparent((Collection<Self>)this.myShadowChildren);
            if (children2 != null && this.myChildren != null) {
                this.myChildren.removeAll(children2);
            }
        }

        public void setHasAll(boolean has) {
            if (has == (this.myAllNodes != null)) {
                return;
            }
            if (has) {
                List allNodes = this.getWildcardMetas().map(m -> this.createAll((BasicMetaObject<?>)m)).toList();
                this.myAllNodes = allNodes.isEmpty() ? null : allNodes;
                this.reparent(allNodes);
            } else {
                this.myAllNodes = null;
            }
        }

        @Nullable
        public List<Self> getAllNodes() {
            return this.myAllNodes;
        }

        @NotNull
        public Iterable<Self> iterAllNodes() {
            Iterable iterable = (Iterable)ObjectUtils.notNull(this.getAllNodes(), Collections.emptyList());
            if (iterable == null) {
                MyNode.$$$reportNull$$$0(2);
            }
            return iterable;
        }

        @NotNull
        public ThreeState getAllNodeState() {
            if (this.myAllNodes == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    MyNode.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            boolean res2 = ((MyNode)this.myAllNodes.get(0)).isChecked();
            for (int i2 = 1; i2 < this.myAllNodes.size(); ++i2) {
                if (res2 == ((MyNode)this.myAllNodes.get(i2)).isChecked()) continue;
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    MyNode.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.fromBoolean((boolean)res2);
            if (threeState == null) {
                MyNode.$$$reportNull$$$0(5);
            }
            return threeState;
        }

        public void setObject(Object object) {
            this.myObject = object;
        }

        @NlsSafe
        public String getName() {
            return this.myName;
        }

        @Nullable
        public ObjectKind getKind() {
            BasicMetaObject<?> meta = this.getMeta();
            return meta == null ? null : meta.kind;
        }

        @Nls
        @NotNull
        public String getKindName() {
            BasicMetaObject<?> meta;
            ObjectKind kind = this.getKind();
            if (kind == null) {
                kind = ObjectKind.NONE;
            }
            String string = DbPresentationCore.getPresentableName(kind, (meta = this.getMeta()) == null ? Dbms.UNKNOWN : meta.getModel().dbms);
            if (string == null) {
                MyNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        public Object getObject() {
            return this.myObject;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void purgeShadow() {
            this.setShadowChildren(null);
            for (MyNode node : this.getChildren()) {
                node.purgeShadow();
            }
        }

        public void makeShadow() {
            this.setShadowChildren(this.myShadowChildren == null ? this.myChildren : ContainerUtil.newArrayList(this.getSimpleChildNodes()));
            this.setChildren(null);
            for (MyNode node : this.getShadowChildren()) {
                node.makeShadow();
            }
        }

        @NotNull
        public JBIterable<BasicMetaObject<?>> getWildcardMetas() {
            BasicMetaObject<?> meta = this.getMeta();
            JBIterable jBIterable = meta == null ? JBIterable.empty() : JBIterable.of((Object[])meta.children).filter(m -> m.kindOf(BasicMateNamespace.class));
            if (jBIterable == null) {
                MyNode.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        @Nullable
        public BasicMetaObject<?> findChild(ObjectKind kind) {
            return kind == null ? null : BasicMetaUtils.findChild(this.getMeta(), kind);
        }

        protected void reparent(@Nullable Collection<Self> children2) {
            MyNode.reparent(children2, this.self());
        }

        protected static <Self extends MyNode<Self>> void reparent(@Nullable Collection<Self> children2, @Nullable Self parent2) {
            if (children2 == null) {
                return;
            }
            for (MyNode child : children2) {
                if (child.myParent != null && child.myParent != parent2 && parent2 != null) {
                    throw new AssertionError((Object)"Already has parent");
                }
                child.myParent = parent2;
            }
        }

        protected Self self() {
            return (Self)this;
        }

        @NotNull
        public JBIterable<Self> getChildNodes() {
            JBIterable jBIterable = this.myAllNodes == null ? JBIterable.from(this.getSimpleChildNodes()) : JBIterable.from(this.myAllNodes).append(this.getSimpleChildNodes());
            if (jBIterable == null) {
                MyNode.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @NotNull
        public Iterable<Self> getSimpleChildNodes() {
            if (this.myChildren == null) {
                List<Self> list = this.getShadowChildren();
                if (list == null) {
                    MyNode.$$$reportNull$$$0(9);
                }
                return list;
            }
            if (this.myShadowChildren == null) {
                List<Self> list = this.getChildren();
                if (list == null) {
                    MyNode.$$$reportNull$$$0(10);
                }
                return list;
            }
            JBIterable jBIterable = JBIterable.from(this.myChildren).append(this.myShadowChildren);
            if (jBIterable == null) {
                MyNode.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }

        @Nullable
        public Self getParent() {
            return this.myParent;
        }

        @NotNull
        protected abstract Self createAll(@NotNull BasicMetaObject<?> var1);

        public boolean isShadow() {
            return this.myParent != null && ((MyNode)this.myParent).getShadowChildren().contains(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/ui/DbCheckBoxTree$MyNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShadowChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterAllNodes";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNodeState";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKindName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWildcardMetas";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildNodes";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleChildNodes";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

