/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNavigationUtils;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentationProvider
implements DocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        DasObject dasObject;
        if (element2 instanceof SqlDefinition) {
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " " + QNameUtil.getQualifiedName((DasObject)definition);
        }
        DasSymbol symbol = DasSymbolUtil.getOrResolveSymbol(element2);
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (dasObject instanceof BuiltinFunction) {
            return dasObject.getName();
        }
        return element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getName() : null;
    }

    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        DasObject dasObject;
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
        if (element2 instanceof SqlDefinition) {
            PsiElement textElement = element2.getParent() instanceof SqlAlterInstruction ? element2.getParent() : element2;
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " <b>" + QNameUtil.getQualifiedName((DasObject)definition) + "</b><br><pre><code>" + DbSqlUtil.sql2Html(element2.getProject(), (Language)dialect, (CharSequence)ObjectUtils.notNull((Object)textElement.getText(), (Object)"")) + "</code></pre>";
        }
        DasSymbol symbol = DasSymbolUtil.getOrResolveSymbol(element2);
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (dasObject instanceof SqlFunctionDefinition && originalElement != null) {
            Class<?> dialectClass = originalElement.getContainingFile().getLanguage().getClass();
            SqlFunctionCallExpression call = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, SqlFunctionCallExpression.class);
            SqlFunctionDefinition.Prototype prototype = call == null ? null : SqlFunctionsUtil.chooseTheBestPrototype(call, false);
            return SqlDocumentationProvider.getDocumentation((SqlFunctionDefinition)((Object)dasObject), prototype, dialectClass);
        }
        if (SqlImplUtil.isAsteriskRef(element2)) {
            return SqlDocumentationProvider.generateAsteriskDocumentation(element2, dialect);
        }
        return null;
    }

    @Nullable
    private static String generateAsteriskDocumentation(PsiElement element2, SqlLanguageDialectEx dialect) {
        ResolveResult result2 = ((SqlReferenceExpression)element2).resolveSingle();
        SqlAsteriskSymbol target = (SqlAsteriskSymbol)((Object)ObjectUtils.tryCast((Object)SqlImplUtil.getImmediateTarget(result2), SqlAsteriskSymbol.class));
        if (target == null) {
            return null;
        }
        SqlTableType type = target.getTableType();
        int columnCount = type.getColumnCount();
        NamingService namingService = NamingServices.getNamingService(dialect.getDbms());
        StringBuilder builder = new StringBuilder();
        builder.append("<pre><code>");
        for (int i2 = 0; i2 < columnCount; ++i2) {
            String columnName = type.getColumnName(i2);
            if (type.isColumnQuoted(i2)) {
                columnName = namingService.enquote(columnName, ObjectKind.COLUMN);
            }
            String columnText = columnName + " " + type.getColumnType(i2).getDataType().getSpecification();
            if (i2 > 0) {
                builder.append(",\n");
            }
            builder.append(DbSqlUtil.sql2Html(element2.getProject(), (Language)dialect, columnText));
        }
        builder.append("</code></pre>");
        return builder.toString();
    }

    @Nullable
    public static String getDocumentation(@NotNull SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype, @NotNull Class<? extends Language> dialectClass) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (dialectClass == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(1);
        }
        int prototypeId = prototype == null ? 0 : prototype.getPrototypeId();
        String name = definition.getAliasedFunction();
        String basePath = "functions/" + name.replace('@', '_');
        if (prototypeId > 0) {
            try {
                return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + "-" + prototypeId + ".html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + ".html");
        }
        catch (IOException e) {
            return null;
        }
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if (object instanceof SqlFunctionDefinition.Prototype) {
            return SqlImplUtil.wrapObjectToPsi((DasObject)((Object)((SqlFunctionDefinition.Prototype)object).getFunction()), psiManager.getProject());
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(3);
        }
        PsiReference ref = TargetElementUtil.findReference((Editor)editor, (int)(contextElement == null ? targetOffset : contextElement.getTextOffset()));
        return (PsiElement)SqlNavigationUtils.findRelatedDbElements(ref, null).filter(DbImplUtil.CAN_CONNECT_TO).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/SqlDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

