/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element2) {
        DasObject dasObject;
        if (element2 == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return (dasObject = SqlImplUtil.unwrapPsiToObject(element2)) instanceof DasTable || dasObject instanceof DasTypedObject || dasObject instanceof BuiltinFunction;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        if (element2 instanceof SqlVariableDefinition) {
            return ((SqlVariableDefinition)element2).getInitializer() != null;
        }
        if (element2 instanceof SqlTableDefinition) {
            return ((SqlTableDefinition)element2).getQueryExpression() != null;
        }
        if (element2 instanceof DasTypedObject) {
            return ((DasTypedObject)element2).getDefault() != null;
        }
        return false;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        if (referencedElement instanceof DasTypedObject || referencedElement instanceof SqlAsExpression) {
            ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(4);
            }
            return access;
        }
        if (referencedElement instanceof SqlDefinition && reference.getElement() == ((SqlDefinition)referencedElement).getNameElement()) {
            ReadWriteAccessDetector.Access access = this.isDeclarationWriteAccess(referencedElement) ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(5);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(6);
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        SqlSetClause setClause;
        if (expression == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(7);
        }
        if (expression instanceof SqlDefinition) {
            ReadWriteAccessDetector.Access access = this.isDeclarationWriteAccess(expression) ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(8);
            }
            return access;
        }
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof SqlBinaryExpression) {
            SqlBinaryExpression binaryExpression = (SqlBinaryExpression)parent2;
            ReadWriteAccessDetector.Access access = binaryExpression.getOpSign() == SqlTokens.SQL_OP_ASSIGN && binaryExpression.getLOperand() == expression ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(9);
            }
            return access;
        }
        SqlTableColumnsList tableColumnList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlTableColumnsList.class);
        if (tableColumnList != null) {
            if (tableColumnList.getParent() instanceof SqlDmlInstruction && tableColumnList.getParent().getParent() instanceof SqlInsertStatement) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(10);
                }
                return access;
            }
            if (SqlImplUtil.getSqlDialectDbms((PsiElement)tableColumnList).isMicrosoft() && tableColumnList.getParent() instanceof SqlReturningClause) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(11);
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(12);
            }
            return access;
        }
        if (expression instanceof SqlReferenceExpression) {
            SqlAsExpression updateTargetExpression = parent2 instanceof SqlAsExpression ? (SqlAsExpression)parent2 : (SqlReferenceExpression)expression;
            SqlDmlInstruction instruction2 = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlDmlInstruction.class);
            if (instruction2 != null && PsiTreeUtil.getChildOfType((PsiElement)instruction2, SqlExpression.class) == updateTargetExpression) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(13);
                }
                return access;
            }
        }
        if ((setClause = (SqlSetClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSetClause.class)) != null) {
            PsiElement first2 = parent2 instanceof SqlReferenceList ? parent2 : expression;
            for (PsiElement child = first2.getNextSibling(); child != null; child = child.getNextSibling()) {
                IElementType elementType = child.getNode().getElementType();
                if (elementType == SqlTokens.SQL_COMMA) {
                    ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
                    if (access == null) {
                        SqlReadWriteAccessDetector.$$$reportNull$$$0(14);
                    }
                    return access;
                }
                if (elementType != SqlTokens.SQL_OP_EQ) continue;
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(15);
                }
                return access;
            }
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(16);
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

