/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileActions;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDialectAction
extends ScratchFileActions.ChangeLanguageAction {
    @NotNull
    @Nls
    protected String getChangeLanguageActionName(@NotNull String languageName) {
        if (languageName == null) {
            ChangeDialectAction.$$$reportNull$$$0(0);
        }
        String string = LangBundle.message((String)"scratch.file.action.change.dialect.action", (Object[])new Object[]{languageName});
        if (string == null) {
            ChangeDialectAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    protected String getChangeLanguageTitle() {
        String string = LangBundle.message((String)"scratch.file.action.change.dialect.title", (Object[])new Object[0]);
        if (string == null) {
            ChangeDialectAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected Condition<VirtualFile> fileFilter(@NotNull Project project) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(3);
        }
        return ChangeDialectAction.FILE_FILTER(project);
    }

    @NotNull
    public static Condition<VirtualFile> FILE_FILTER(@NotNull Project project) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(4);
        }
        Condition condition = file -> {
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            if (console != null) {
                return !DbSqlUtilCore.getDbms(console.getLanguage()).isMongo();
            }
            if (ScratchRootType.getInstance().containsFile(file)) {
                return false;
            }
            if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE)) {
                return true;
            }
            return PsiManager.getInstance((Project)project).findFile(file) instanceof SqlFile && file.isInLocalFileSystem();
        };
        if (condition == null) {
            ChangeDialectAction.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @NotNull
    protected Language fileLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ChangeDialectAction.$$$reportNull$$$0(7);
        }
        SqlLanguageDialect sqlLanguageDialect = SqlLanguageSubstitutor.getSqlLanguageDialect(file, project);
        if (sqlLanguageDialect == null) {
            ChangeDialectAction.$$$reportNull$$$0(8);
        }
        return sqlLanguageDialect;
    }

    protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project, @NlsContexts.PopupTitle @NotNull String title, @NotNull JBIterable<? extends VirtualFile> files2) {
        if (e == null) {
            ChangeDialectAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(10);
        }
        if (title == null) {
            ChangeDialectAction.$$$reportNull$$$0(11);
        }
        if (files2 == null) {
            ChangeDialectAction.$$$reportNull$$$0(12);
        }
        ListPopup popup2 = ChangeDialectAction.buildDialectsPopup(project, files2, StringUtil.notNullize((String)this.getTemplatePresentation().getTextWithMnemonic()));
        DbUIUtil.showPopup((JBPopup)popup2, null, e);
    }

    @NotNull
    public static ListPopup buildDialectsPopup(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files2) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(13);
        }
        if (files2 == null) {
            ChangeDialectAction.$$$reportNull$$$0(14);
        }
        return ChangeDialectAction.buildDialectsPopup(project, files2, DatabaseBundle.message("ChangeDialectAction.popup.title.sql.dialect", new Object[0]));
    }

    @NotNull
    public static ListPopup buildDialectsPopup(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files2, @NlsContexts.PopupTitle @NotNull String title) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(15);
        }
        if (files2 == null) {
            ChangeDialectAction.$$$reportNull$$$0(16);
        }
        if (title == null) {
            ChangeDialectAction.$$$reportNull$$$0(17);
        }
        LRUPopupBuilder builder = LRUPopupBuilder.languagePopupBuilder((Project)project, (String)title, o -> o instanceof SqlLanguageDialect ? ((SqlLanguageDialect)o).getIcon() : null);
        builder.forValues(SqlDialects.getTopLevelSqlDialects());
        builder.onChosen(language -> ChangeDialectAction.setDialectImpl(project, files2, language));
        if (files2.find(ScratchUtil::isScratch) == null) {
            builder.withExtraBottomValue((Object)Language.ANY, DatabaseBundle.message("ChangeDialectAction.sql.dialects", new Object[0]), null);
        }
        ListPopup listPopup = builder.buildPopup();
        if (listPopup == null) {
            ChangeDialectAction.$$$reportNull$$$0(18);
        }
        return listPopup;
    }

    public static void setDialectImpl(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files2, @Nullable Language language) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(19);
        }
        if (files2 == null) {
            ChangeDialectAction.$$$reportNull$$$0(20);
        }
        if (language == null || language == Language.ANY) {
            SqlDialectImplUtilCore.LOG.assertTrue(files2.find(file -> ScratchUtil.isScratch((VirtualFile)file)) == null);
            SqlDialectsConfigurable.openDialectsConfigurable(project, (VirtualFile)files2.first());
            return;
        }
        for (VirtualFile file2 : files2) {
            ChangeDialectAction.setDialectImpl0(project, file2, language, false);
        }
        FileContentUtilCore.reparseFiles((Collection)files2.toList());
    }

    public static void setDialectImpl(@NotNull Project project, @NotNull VirtualFile file, @NotNull Language language, boolean fromInjection) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(21);
        }
        if (file == null) {
            ChangeDialectAction.$$$reportNull$$$0(22);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(23);
        }
        SqlDialectImplUtilCore.LOG.assertTrue(language != Language.ANY);
        ChangeDialectAction.setDialectImpl0(project, file, language, fromInjection);
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
    }

    private static void setDialectImpl0(@NotNull Project project, @NotNull VirtualFile file, @NotNull Language language, boolean fromInjection) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(24);
        }
        if (file == null) {
            ChangeDialectAction.$$$reportNull$$$0(25);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(26);
        }
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        if (!fromInjection && scratchRootType.containsFile(file)) {
            ScratchFileService.getInstance().getScratchesMapping().setMapping(file, (Object)language);
        } else {
            LocalDataSource dataSource2;
            if (file instanceof DatabaseElementVirtualFileImpl) {
                dataSource2 = DbImplUtil.getMaybeLocalDataSource(((DatabaseElementVirtualFileImpl)file).findDataSource(project));
            } else {
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
                LocalDataSource localDataSource = dataSource2 = console == null ? null : (LocalDataSource)console.getTarget();
            }
            if (dataSource2 != null) {
                ChangeDialectAction.askAndSetDriverSqlDialect(project, dataSource2.getDatabaseDriver(), language);
            } else if (file.isInLocalFileSystem()) {
                SqlDialectMappings.getInstance(project).setMapping(file, (SqlLanguageDialect)language);
            } else if (file instanceof LightVirtualFile) {
                ((LightVirtualFile)file).setLanguage(language);
            }
        }
    }

    private static void askAndSetDriverSqlDialect(@NotNull Project project, @Nullable DatabaseDriver driver, @NotNull Language language) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(27);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(28);
        }
        if (driver == null) {
            return;
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)DatabaseBundle.message("change.driver.dialect.warn.message", driver.getName()), (String)DatabaseBundle.message("change.driver.dialect.warn.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        ((DatabaseDriverImpl)driver).setSqlDialect(language.getID());
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        for (LocalDataSource ds : storage.getDataSources()) {
            if (ds.getDatabaseDriver() != driver) continue;
            storage.updateDataSource(ds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLanguageActionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLanguageTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "FILE_FILTER";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDialectsPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangeLanguageActionName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "FILE_FILTER";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileLanguage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildDialectsPopup";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDialectImpl";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDialectImpl0";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "askAndSetDriverSqlDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

