/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectImplUtil
extends SqlDialectImplUtilCore {
    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class<?> dialectClass, @NonNls String name) throws IOException {
        String text2;
        @NonNls String resourceName = null;
        InputStream zipIs = null;
        for (Class<?> c2 = dialectClass; c2 != null; c2 = c2.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c2) + "-help.zip";
            ClassLoader loader = c2.getClassLoader();
            zipIs = loader == null ? null : loader.getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", StringUtil.notNullize(resourceName)));
        }
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlBundle.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text2 == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = StringUtil.toLowerCase((String)className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()));
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

