/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExceptionClause;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SqlCodeBlockProviderUtils {
    public static final TokenSet STARTERS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCommonKeywords.SQL_IF, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_REPEAT, SqlCommonKeywords.SQL_FOR, SqlCommonKeywords.SQL_WHILE, SqlCommonKeywords.SQL_CASE, SqlCommonKeywords.SQL_WHEN});
    public static final Condition<PsiElement> STARTERS_C = e -> STARTERS.contains(PsiUtilCore.getElementType((PsiElement)e));
    public static final TokenSet EXPAND = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_WHEN_CLAUSE, SqlCompositeElementTypes.SQL_CASE_WHEN_THEN_CLAUSE, SqlCompositeElementTypes.SQL_ELSE_CLAUSE, SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE, SqlCompositeElementTypes.SQL_EXCEPTION_CLAUSE});
    public static final TokenSet EXTRA = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCommonKeywords.SQL_ELSE, SqlCommonKeywords.SQL_WHEN, SqlCommonKeywords.SQL_ELSIF, SqlCommonKeywords.SQL_ELSEIF, SqlCommonKeywords.SQL_EXCEPTION, SqlCompositeElementTypes.SQL_EXCEPTION_CLAUSE});
    public static final TokenSet ACTIVATORS = TokenSet.orSet((TokenSet[])new TokenSet[]{STARTERS, EXTRA, TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END})});
    public static final Condition<PsiElement> EXTRA_C = e -> EXTRA.contains(PsiUtilCore.getElementType((PsiElement)e));
    public static final Condition<PsiElement> NOT_END_C = Conditions.or(EXTRA_C, STARTERS_C);

    private SqlCodeBlockProviderUtils() {
    }

    public static JBIterable<PsiElement> processBlock(PsiFile file, int at) {
        PsiElement block;
        PsiElement element2 = file.findElementAt(at);
        IElementType type = PsiUtilCore.getElementType((PsiElement)element2);
        if (type != null && ACTIVATORS.contains(type) && SqlCodeBlockProviderUtils.isGoodBlock(block = SqlCodeBlockProviderUtils.getBlock(element2))) {
            if (type == SqlCommonKeywords.SQL_END && !SqlCodeBlockProviderUtils.isLastEnd(block, element2)) {
                return JBIterable.of((Object)element2);
            }
            return SqlCodeBlockProviderUtils.collectRanges(block);
        }
        return JBIterable.empty();
    }

    private static PsiElement getBlock(PsiElement element2) {
        boolean expanded = false;
        for (PsiElement e : SqlImplUtil.sqlParents(element2)) {
            if (e == element2) continue;
            boolean expand = EXPAND.contains(PsiUtilCore.getElementType((PsiElement)e));
            expanded |= expand;
            if (expand) continue;
            if (expanded && e instanceof SqlBlockStatementImpl) {
                if (PsiUtilCore.getElementType((PsiElement)element2) == SqlCommonKeywords.SQL_EXCEPTION) {
                    return e;
                }
                return null;
            }
            return e;
        }
        return null;
    }

    private static SyntaxTraverser<PsiElement> childrenOfBlock(PsiElement block, boolean rev) {
        return (SyntaxTraverser)(rev ? SqlImplUtil.sqlRevTraverser(block) : SqlImplUtil.sqlTraverser(block)).expandAndSkip(e -> e == block || !(block instanceof SqlBlockStatementImpl) && EXPAND.contains(PsiUtilCore.getElementType((PsiElement)e)));
    }

    public static JBIterable<PsiElement> collectRanges(@NotNull PsiElement block) {
        if (block == null) {
            SqlCodeBlockProviderUtils.$$$reportNull$$$0(0);
        }
        PsiElement end2 = SqlCodeBlockProviderUtils.findEnd((JBIterable<PsiElement>)SqlCodeBlockProviderUtils.childrenOfBlock(block, true).traverse());
        JBIterable allChildren = SqlCodeBlockProviderUtils.childrenOfBlock(block, false).traverse();
        JBIterable fromStarter = allChildren.skipWhile(Conditions.not(STARTERS_C));
        if (end2 == null) {
            return fromStarter.skipWhile(Conditions.not(STARTERS_C)).filter(NOT_END_C);
        }
        JBIterable res2 = fromStarter.takeWhile(e -> e != end2).filter(NOT_END_C);
        PsiElement f = (PsiElement)res2.first();
        if (f != null && f.getTextRange().getStartOffset() > end2.getTextRange().getStartOffset()) {
            res2 = JBIterable.empty();
        }
        return res2.append((Object)end2).append((Iterable)allChildren.skipWhile(e -> e != end2).filter(NOT_END_C));
    }

    @Contract(value="null->false")
    public static boolean isGoodBlock(PsiElement block) {
        return block instanceof SqlBlockStatementImpl || block instanceof SqlIfStatement || PsiUtilCore.getElementType((PsiElement)block) == SqlCompositeElementTypes.SQL_CASE_STATEMENT || block instanceof SqlCaseExpression || block instanceof SqlExceptionWhenClause || block instanceof SqlExceptionClause || block instanceof SqlLoopStatement || SqlImplUtil.isBodyLazyBlock(block) || block instanceof SqlFile;
    }

    private static boolean isLastEnd(PsiElement block, PsiElement element2) {
        TextRange rest = TextRange.create((int)element2.getTextRange().getEndOffset(), (int)block.getTextRange().getEndOffset());
        return SqlCodeBlockProviderUtils.findEnd(SqlCodeBlockProviderUtils.childrenOnRange(block, rest)) == null;
    }

    private static PsiElement findEnd(JBIterable<PsiElement> elements) {
        return (PsiElement)elements.find(e -> PsiUtilCore.getElementType((PsiElement)e) == SqlCommonKeywords.SQL_END);
    }

    @NotNull
    private static JBIterable<PsiElement> childrenOnRange(PsiElement element2, TextRange range) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlCodeBlockProviderUtils.childrenOfBlock(element2, true).onRange(e -> e.getTextRange().intersectsStrict(range))).traverse();
        if (jBIterable == null) {
            SqlCodeBlockProviderUtils.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlCodeBlockProviderUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlCodeBlockProviderUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOnRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectRanges";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

