/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FindPhraseResult;
import com.intellij.sql.formatter.model.SqlAS;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlArrayAccessBlock;
import com.intellij.sql.formatter.model.SqlAssignmentBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockCommentBlock;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlColumnAliasCortegeBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlComplexTextBlock;
import com.intellij.sql.formatter.model.SqlConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlDropRoutineBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlExternalParameterBlock;
import com.intellij.sql.formatter.model.SqlFileBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlHeadLoopBlock;
import com.intellij.sql.formatter.model.SqlIdentifierBlock;
import com.intellij.sql.formatter.model.SqlInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlLiteralBlock;
import com.intellij.sql.formatter.model.SqlLiteralInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlLoopBlock;
import com.intellij.sql.formatter.model.SqlMonolithBlock;
import com.intellij.sql.formatter.model.SqlNamedConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlNullabilityCheckBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedExpressionBlock;
import com.intellij.sql.formatter.model.SqlPgDoStatementBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReferenceBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlockKt;
import com.intellij.sql.formatter.model.SqlSimpleLoopBlock;
import com.intellij.sql.formatter.model.SqlSimpleTypeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.SqlTableTypeBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00d4\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\rH\u0002\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0018\u0010*\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0018\u0010-\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0000\u001a\u0018\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u0006\u00100\u001a\u000201\u001a\u0006\u00102\u001a\u000201\u001a\u0006\u00103\u001a\u000201\u001a\u0006\u00104\u001a\u000201\u001a%\u00105\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00180\u0019H\u0086\b\u001a+\u00105\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u00107\u001a\u00020\u0002\u001a+\u00105\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u00108\u001a\u000209\u001a3\u00105\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u000209\u001a;\u00105\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u000209\u001a<\u00105\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020>\"\u00020\u0002\u00a2\u0006\u0002\u0010?\u001a&\u0010@\u001a\u0004\u0018\u0001H\u0017\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00180\u0019H\u0086\b\u00a2\u0006\u0002\u0010A\u001a\u001a\u0010@\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u00107\u001a\u00020\u0002\u001a\u001a\u0010@\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u00108\u001a\u000209\u001a0\u0010B\u001a\u0004\u0018\u00010\u0012*\b\u0012\u0004\u0012\u00020\u001f0C2\b\b\u0002\u0010D\u001a\u00020\u00112\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020G0F\u001a \u0010H\u001a\u0004\u0018\u0001H\u0017\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0004*\u00020\u0004H\u0080\b\u00a2\u0006\u0002\u0010I\u001a5\u0010J\u001a\u0004\u0018\u00010K*\b\u0012\u0004\u0012\u00020\u001f0C2\u0006\u0010L\u001a\u00020\u00112\u0014\u0010M\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020>0>\u00a2\u0006\u0002\u0010N\u001a\u000e\u0010O\u001a\u0004\u0018\u00010P*\u0004\u0018\u00010Q\u001a\n\u0010R\u001a\u00020G*\u00020\u001f\u001a \u0010S\u001a\u00020G*\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020G0FH\u0002\u001a6\u0010T\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u001f0C2\u0006\u00107\u001a\u00020\u00022\b\b\u0002\u0010D\u001a\u00020\u00112\b\b\u0002\u0010U\u001a\u00020\u00112\b\b\u0002\u0010V\u001a\u00020\u0011\u001a<\u0010T\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u001f0C2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\b\b\u0002\u0010D\u001a\u00020\u00112\b\b\u0002\u0010U\u001a\u00020\u00112\b\b\u0002\u0010V\u001a\u00020\u0011\u001aI\u0010W\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u0004*\u0002H\u00172,\u0010X\u001a(\u0012\u0004\u0012\u0002H\u0017\u0012\u0013\u0012\u0011H\u0017\u00a2\u0006\f\bZ\u0012\b\b[\u0012\u0004\b\b(\\\u0012\u0004\u0012\u00020]0Y\u00a2\u0006\u0002\b^H\u0000\u00a2\u0006\u0002\u0010_\u001a\f\u0010`\u001a\u00020G*\u0004\u0018\u00010Q\u001a\u0012\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001f0C*\u00020\u001fH\u0000\u001a&\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001f0C*\u00020\u001f2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020G0FH\u0000\u001a\u000e\u0010c\u001a\u0004\u0018\u00010\u0002*\u00020\u0004H\u0000\u001a\u000e\u0010d\u001a\u0004\u0018\u00010\u001f*\u00020\u0004H\u0000\u001a+\u0010e\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0016\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010f\u001a\u00020\u0011\"#\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"6\u0010\f\u001a$\u0012\u0004\u0012\u00020\r\u0012\u001a\u0012\u0018\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000e0\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00128\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\",\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\b\b\u0000\u0010\u0017*\u00020\u0018*\b\u0012\u0004\u0012\u0002H\u00170\u00198\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006g"}, d2={"COMMON_SIMPLE_ELEMENT_BLOCKS", "", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/reflect/KFunction0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getCOMMON_SIMPLE_ELEMENT_BLOCKS", "()Ljava/util/Map;", "CONSTRAINT_TYPES", "", "kotlin.jvm.PlatformType", "getCONSTRAINT_TYPES", "()Ljava/util/Set;", "DIALECT_SPECIFIC_BLOCKS", "Lcom/intellij/database/Dbms;", "Lkotlin/reflect/KClass;", "getDIALECT_SPECIFIC_BLOCKS", "finish", "", "Lkotlin/ranges/IntRange;", "getFinish", "(Lkotlin/ranges/IntRange;)I", "jbi", "Lcom/intellij/util/containers/JBIterable;", "B", "Lcom/intellij/formatting/Block;", "", "getJbi", "(Ljava/lang/Iterable;)Lcom/intellij/util/containers/JBIterable;", "createBlockForBinaryExpression", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "node", "Lcom/intellij/lang/ASTNode;", "createBlockForConstraint", "createBlockForIdentifier", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "createBlockForParenthesizedExpression", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "createBlockForStatement", "dbms", "createBlockForUnspecifiedLoop", "Lcom/intellij/sql/formatter/model/SqlLoopBlock;", "createDropBlock", "handleStringLiteral", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "instantiateDefaultBlock", "makeDefaultBlock", "parent", "makeLeftAlignment", "Lcom/intellij/formatting/Alignment;", "makeLeftAlignmentBS", "makeRightAlignment", "makeRightAlignmentBS", "filter", "Lorg/jetbrains/annotations/NotNull;", "type", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "role1", "role2", "role3", "types", "", "(Ljava/lang/Iterable;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/util/containers/JBIterable;", "find", "(Ljava/lang/Iterable;)Lcom/intellij/formatting/Block;", "findConsequence", "", "since", "predicate", "Lkotlin/Function1;", "", "findParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/SqlBlock;", "findPhrase", "Lcom/intellij/sql/formatter/model/FindPhraseResult;", "offset", "patterns", "(Ljava/util/List;I[[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/sql/formatter/model/FindPhraseResult;", "getType", "Lcom/intellij/formatting/WrapImpl$Type;", "Lcom/intellij/formatting/Wrap;", "hasInjection", "hasOnlyOneChild", "indexOf", "till", "notFound", "init", "initializer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "that", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/sql/formatter/model/SqlBlock;Lkotlin/jvm/functions/Function2;)Lcom/intellij/sql/formatter/model/SqlBlock;", "isAlways", "listChildren", "flatten", "primaryElementType", "primaryNode", "skip", "count", "intellij.database.sql.core.impl"})
public final class SqlFormattingModelFunKt {
    @NotNull
    private static final Map<IElementType, KFunction<SqlBlock>> COMMON_SIMPLE_ELEMENT_BLOCKS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_AS, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.1.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.2.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.3.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SELECT_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.4.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.5.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UNION_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.6.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_INSERT_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.7.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_UPDATE_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.8.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DELETE_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.9.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.10.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.11.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_MERGE_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.12.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.13.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.14.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_EXPRESSION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.15.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CASE_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.16.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REFERENCE_LIST, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.17.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FUNCTION_CALL, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.18.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.19.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_SCHEMA_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.20.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_COLUMN_DEFINITION), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.21.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_REFERENCES_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.22.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_CASCADE_OPTION, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.23.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.24.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_TABLE_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.25.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.26.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.27.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.28.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IF_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.29.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_THEN_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.30.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSE_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.31.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.32.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.33.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.34.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.35.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.36.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.37.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.38.INSTANCE)), TuplesKt.to((Object)((Object)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT), (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.39.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.40.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.41.INSTANCE)), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_DECLARE_STATEMENT, (Object)((Object)COMMON_SIMPLE_ELEMENT_BLOCKS.42.INSTANCE))});
    @NotNull
    private static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> DIALECT_SPECIFIC_BLOCKS = MapsKt.mapOf((Pair)TuplesKt.to((Object)Dbms.CLICKHOUSE, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (Object)Reflection.getOrCreateKotlinClass(SqlIdentifierBlock.class)))));
    @NotNull
    private static final Set<IElementType> CONSTRAINT_TYPES = SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCompositeElementTypes.SQL_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION});

    @NotNull
    public static final Map<IElementType, KFunction<SqlBlock>> getCOMMON_SIMPLE_ELEMENT_BLOCKS() {
        return COMMON_SIMPLE_ELEMENT_BLOCKS;
    }

    @NotNull
    public static final Map<Dbms, Map<? extends IElementType, KClass<? extends SqlBlock>>> getDIALECT_SPECIFIC_BLOCKS() {
        return DIALECT_SPECIFIC_BLOCKS;
    }

    @NotNull
    public static final Set<IElementType> getCONSTRAINT_TYPES() {
        return CONSTRAINT_TYPES;
    }

    @NotNull
    public static final SqlBlock makeDefaultBlock(@NotNull SqlBlock parent2, @NotNull ASTNode node) {
        SqlBlock block;
        block1: {
            SqlBlock sqlBlock;
            block3: {
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        IElementType iElementType = node.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
                        IElementType type = iElementType;
                        Map<? extends IElementType, KClass<? extends SqlBlock>> map2 = parent2.getContext().getDialectSpecificBlocks();
                        boolean bl = false;
                        KClass<? extends SqlBlock> specificBlockClass = map2.get(type);
                        sqlBlock = block = specificBlockClass == null ? SqlFormattingModelFunKt.instantiateDefaultBlock(node, parent2.getContext()) : (SqlBlock)KClasses.createInstance(specificBlockClass);
                        if (!(sqlBlock instanceof SqlNodeBlock)) break block0;
                        SqlNodeBlock $this$withSetup$iv = (SqlNodeBlock)block;
                        boolean $i$f$withSetup = false;
                        $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, node);
                        break block1;
                    }
                    if (!(sqlBlock instanceof SqlLeafBlock)) break block2;
                    SqlLeafBlock $this$withSetup$iv = (SqlLeafBlock)block;
                    boolean $i$f$withSetup = false;
                    $this$withSetup$iv.setup(parent2, node);
                    break block1;
                }
                if (!(sqlBlock instanceof SqlRangeBlock)) break block3;
                SqlRangeBlock $this$withSetup$iv = (SqlRangeBlock)block;
                boolean $i$f$withSetup = false;
                TextRange textRange = node.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, textRange, SqlFormattingModelFunKt.listChildren(node));
                break block1;
            }
            if (!(sqlBlock instanceof SqlInjectionHostBlock)) break block1;
            SqlInjectionHostBlock $this$withSetup$iv = (SqlInjectionHostBlock)block;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent2, node);
        }
        return block;
    }

    @NotNull
    public static final SqlBlock instantiateDefaultBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Dbms dbms = context.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"context.dialect.dbms");
        Dbms dbms2 = dbms;
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType type = iElementType;
        KFunction<SqlBlock> simpleBlockConstructor = COMMON_SIMPLE_ELEMENT_BLOCKS.get(type);
        if (simpleBlockConstructor != null) {
            SqlBlock block = (SqlBlock)((Function0)simpleBlockConstructor).invoke();
            return block;
        }
        if (type instanceof SqlKeywordTokenType) {
            IElementType iElementType2 = type;
            sqlBlock = Intrinsics.areEqual((Object)iElementType2, (Object)SqlCommonKeywords.SQL_AS) ? (SqlKeyword)new SqlAS() : new SqlKeyword();
        } else if (SqlUtilFun.isSymbol(node)) {
            IElementType iElementType3 = type;
            sqlBlock = Intrinsics.areEqual((Object)iElementType3, (Object)SqlCommonTokens.SQL_COMMA) ? (SqlSymbol)new SqlComma() : new SqlSymbol();
        } else if (node instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
        } else if (node instanceof PsiErrorElement) {
            sqlBlock = new SqlErrorNodeBlock();
        } else if (node instanceof SqlColumnAliasListImpl) {
            sqlBlock = new SqlColumnAliasCortegeBlock();
        } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.BIGQUERY) && SqlUtilFun.isSymbol(node.getFirstChildNode(), '`') && SqlUtilFun.isSymbol(node.getLastChildNode(), '`')) {
            sqlBlock = new SqlMonolithBlock();
        } else {
            IElementType iElementType4 = type;
            if (iElementType4 instanceof IsExternal) {
                sqlBlock = new SqlLeafBlock();
            } else if (iElementType4 instanceof SqlReferenceElementType) {
                sqlBlock = (SqlBlock)(type == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE ? (Block)new SqlExternalParameterBlock() : (Block)new SqlReferenceBlock());
            } else if (SqlFormattingFunKt.getLITERAL_TYPES().contains(iElementType4)) {
                sqlBlock = new SqlLiteralBlock();
            } else if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)iElementType4)) {
                sqlBlock = new SqlLineCommentBlock();
            } else if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getBLOCK_COMMENT_TYPES(), (Object)iElementType4)) {
                sqlBlock = new SqlBlockCommentBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
                sqlBlock = SqlFormattingModelFunKt.handleStringLiteral(node, context);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForIdentifier(node);
            } else if (SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(iElementType4)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForBinaryExpression(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForParenthesizedExpression(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_PROCEDURE_STATEMENT)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_FUNCTION_STATEMENT)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_METHOD_STATEMENT))) {
                sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms2);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_PROCEDURE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_FUNCTION_DEFINITION))) {
                sqlBlock = SqlRoutineBlockKt.createRoutineBlock(dbms2);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_LOOP_STATEMENT)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForUnspecifiedLoop(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_STATEMENT)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForStatement(node, dbms2);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_GENERIC_DROP_STATEMENT)) {
                sqlBlock = SqlFormattingModelFunKt.createDropBlock(node);
            } else if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(iElementType4)) {
                sqlBlock = SqlUtilFun.firstLeaf(node).getElementType() == SqlCommonKeywords.SQL_TABLE ? (SqlNodeBlock)new SqlTableTypeBlock() : (SqlNodeBlock)new SqlSimpleTypeBlock();
            } else if (CONSTRAINT_TYPES.contains(iElementType4)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForConstraint(node);
            } else if (iElementType4 instanceof SqlFileElementType) {
                sqlBlock = new SqlFileBlock();
            } else {
                SqlBlock sqlBlock2 = context.getHelper().instantiateBlock(type);
                if (sqlBlock2 == null) {
                    sqlBlock2 = (SqlBlock)(node instanceof SqlBlockStatementImpl ? (Block)new SqlBlockStatementBlock() : (node instanceof SqlDdlStatement ? (Block)new SqlDdlStatementBlock() : (SqlUtilFun.isKeyWord(node) ? (Block)new SqlKeyword() : (SqlUtilFun.isComplex(node) ? (Block)new SqlUnsortedBlock() : (Block)new SqlLeafBlock()))));
                }
                sqlBlock = sqlBlock2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlBlock2, (String)"context.helper.instantia\u2026)\n          } as SqlBlock");
            }
        }
        return sqlBlock;
    }

    private static final SqlLoopBlock createBlockForUnspecifiedLoop(ASTNode node) {
        ASTNode c2;
        for (c2 = node.getFirstChildNode(); c2 != null && !CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLOOP_PRIMARY_WORD_TYPES(), (Object)c2.getElementType()); c2 = c2.getTreeNext()) {
        }
        ASTNode aSTNode = c2;
        return (aSTNode != null ? aSTNode.getElementType() : null) == SqlCommonKeywords.SQL_LOOP ? (SqlLoopBlock)new SqlSimpleLoopBlock() : (SqlLoopBlock)new SqlHeadLoopBlock();
    }

    private static final SqlRangeBlock createBlockForParenthesizedExpression(ASTNode node) {
        return SqlUtilFun.getMeaningfulChildType(node, 2) == SqlCommonTokens.SQL_COMMA ? (SqlRangeBlock)new SqlCortegeBlock() : (SqlRangeBlock)new SqlParenthesizedExpressionBlock();
    }

    private static final SqlNodeBlock createBlockForBinaryExpression(ASTNode node) {
        IElementType t2 = SqlUtilFun.getMeaningfulChildType(node, 1);
        if (t2 == SqlCommonTokens.SQL_OP_ASSIGN) {
            return new SqlAssignmentBlock();
        }
        if (t2 == SqlCommonTokens.SQL_LEFT_BRACKET) {
            return new SqlArrayAccessBlock();
        }
        IElementType t3 = SqlUtilFun.getMeaningfulChildType(node, 2);
        if (!(t3 != SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && t3 != SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL || t2 != SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && t2 != SqlCommonKeywords.SQL_IS)) {
            return new SqlNullabilityCheckBlock();
        }
        return new SqlBinaryExpressionBlock();
    }

    private static final SqlBlock createBlockForStatement(ASTNode node, Dbms dbms) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            return new SqlStatementBlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.firstChildNode?.ele\u2026eturn SqlStatementBlock()");
        ASTNode firstChildType = aSTNode;
        return Intrinsics.areEqual((Object)firstChildType, (Object)SqlCompositeElementTypes.SQL_WITH_CLAUSE) ? (SqlBlock)new SqlQueryBlock() : (Intrinsics.areEqual((Object)firstChildType, (Object)SqlCommonKeywords.SQL_DO) && dbms.isPostgres() ? (SqlBlock)new SqlPgDoStatementBlock() : (SqlBlock)new SqlStatementBlock());
    }

    private static final SqlLeafBlock createBlockForIdentifier(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        return aSTNode.getElementType() == SqlCompositeElementTypes.SQL_AS_EXPRESSION ? (SqlLeafBlock)new SqlAliasBlock() : (SqlLeafBlock)new SqlIdentifierBlock();
    }

    private static final SqlBlock createBlockForConstraint(ASTNode node) {
        IElementType iElementType = SqlUtilFun.firstLeaf(node).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.firstLeaf().elementType");
        IElementType firstLeafElementType = iElementType;
        IElementType iElementType2 = SqlUtilFun.lastLeaf(node).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"node.lastLeaf().elementType");
        IElementType lastLeafElementType = iElementType2;
        return firstLeafElementType == SqlCommonKeywords.SQL_CONSTRAINT ? (SqlBlock)new SqlNamedConstraintDefinitionBlock() : (firstLeafElementType == SqlCommonKeywords.SQL_DEFAULT ? (SqlBlock)new SqlColumnDefaultBlock() : (lastLeafElementType == SqlCommonKeywords.SQL_NULL ? (SqlBlock)new SqlColumnNullabilityBlock() : (SqlBlock)new SqlConstraintDefinitionBlock()));
    }

    private static final SqlBlock createDropBlock(ASTNode node) {
        Object targetKind;
        Object object;
        ASTNode aSTNode = node;
        if (!(aSTNode instanceof SqlDropStatementImpl)) {
            aSTNode = null;
        }
        if ((object = (SqlDropStatementImpl)aSTNode) == null || (object = object.getTargetType()) == null) {
            object = ObjectKind.UNKNOWN_OBJECT;
        }
        Object object2 = targetKind = object;
        return Intrinsics.areEqual((Object)object2, (Object)ObjectKind.ROUTINE) ? (SqlBlock)new SqlDropRoutineBlock() : (SqlBlock)new SqlStatementBlock();
    }

    @NotNull
    public static final <B extends SqlBlock> B init(@NotNull B $this$init, @NotNull Function2<? super B, ? super B, Unit> initializer) {
        Intrinsics.checkNotNullParameter($this$init, (String)"$this$init");
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        initializer.invoke($this$init, $this$init);
        return $this$init;
    }

    public static final /* synthetic */ <B extends SqlBlock> B findParent(SqlBlock $this$findParent) {
        int $i$f$findParent = 0;
        Intrinsics.checkNotNullParameter((Object)$this$findParent, (String)"$this$findParent");
        for (SqlBlock p2 = $this$findParent.getParent(); p2 != null; p2 = p2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"B");
            if (!(p2 instanceof SqlBlock)) continue;
            return (B)p2;
        }
        return null;
    }

    @Nullable
    public static final ASTNode primaryNode(@NotNull SqlBlock $this$primaryNode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$primaryNode, (String)"$this$primaryNode");
        SqlBlock sqlBlock = $this$primaryNode;
        if (sqlBlock instanceof SqlLeafBlock) {
            object = ((SqlLeafBlock)$this$primaryNode).getNode();
        } else if (sqlBlock instanceof SqlNodeBlock) {
            object = ((SqlNodeBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRangeBlock) {
            object = ((SqlRangeBlock)$this$primaryNode).getNestedBlocks().size() == 1 ? SqlFormattingModelFunKt.primaryNode(((SqlRangeBlock)$this$primaryNode).getNestedBlocks().get(0)) : null;
        } else if (sqlBlock instanceof SqlInjectionHostBlock) {
            object = ((SqlInjectionHostBlock)$this$primaryNode).getBlockNode();
        } else if (sqlBlock instanceof SqlRootBlock) {
            object = ((SqlRootBlock)$this$primaryNode).getBlockNode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final IElementType primaryElementType(@NotNull SqlBlock $this$primaryElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$primaryElementType, (String)"$this$primaryElementType");
        ASTNode aSTNode = SqlFormattingModelFunKt.primaryNode($this$primaryElementType);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"$this$listChildren");
        return SqlFormattingModelFunKt.listChildren($this$listChildren, (Function1<? super ASTNode, Boolean>)((Function1)listChildren.1.INSTANCE));
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $this$listChildren, @NotNull Function1<? super ASTNode, Boolean> flatten) {
        Intrinsics.checkNotNullParameter((Object)$this$listChildren, (String)"$this$listChildren");
        Intrinsics.checkNotNullParameter(flatten, (String)"flatten");
        boolean bl = false;
        List list = new ArrayList();
        Function1<ASTNode, Unit> $fun$listChildrenRecursively$2 = new Function1<ASTNode, Unit>(flatten, list){
            final /* synthetic */ Function1 $flatten;
            final /* synthetic */ List $list;

            public final void invoke(@NotNull ASTNode parentNode) {
                Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
                for (ASTNode node = parentNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
                    IElementType type;
                    Intrinsics.checkNotNullExpressionValue((Object)node.getElementType(), (String)"node.elementType");
                    if (type == SqlElementTypes.SQL_DUMMY_BLOCK || ((Boolean)this.$flatten.invoke((Object)node)).booleanValue()) {
                        this.invoke(node);
                        continue;
                    }
                    if (SqlUtilFun.isWhitespace(node)) continue;
                    Collection collection = this.$list;
                    boolean bl = false;
                    collection.add(node);
                }
            }
            {
                this.$flatten = function1;
                this.$list = list;
                super(1);
            }
        };
        $fun$listChildrenRecursively$2.invoke($this$listChildren);
        return list;
    }

    private static final SqlBlock handleStringLiteral(ASTNode node, SqlFormattingContext context) {
        return SqlUtilFun.doesntIntersect(node, context.getInterestingRange()) ? (SqlBlock)new SqlLiteralBlock() : (SqlFormattingModelFunKt.hasInjection(node) ? (SqlBlock)new SqlLiteralInjectionHostBlock() : (SqlUtilFun.isLeaf(node) || SqlFormattingModelFunKt.hasOnlyOneChild(node, (Function1<? super IElementType, Boolean>)((Function1)handleStringLiteral.1.INSTANCE)) ? (SqlBlock)new SqlLiteralBlock() : (SqlBlock)new SqlComplexTextBlock()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasOnlyOneChild(ASTNode $this$hasOnlyOneChild, Function1<? super IElementType, Boolean> predicate) {
        ASTNode aSTNode = $this$hasOnlyOneChild.getFirstChildNode();
        if (aSTNode == null) return false;
        ASTNode child1 = aSTNode;
        if (child1.getTreeNext() != null) return false;
        IElementType iElementType = child1.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"child1.elementType");
        if ((Boolean)predicate.invoke((Object)iElementType) == false) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasInjection(@NotNull ASTNode $this$hasInjection) {
        void result2;
        PsiElement element2;
        Intrinsics.checkNotNullParameter((Object)$this$hasInjection, (String)"$this$hasInjection");
        if (!Registry.is((String)"sql.formatter.consider.language.injection")) {
            return false;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        PsiElement psiElement = element2 = $this$hasInjection.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        InjectedLanguageManager.getInstance((Project)psiFile.getProject()).enumerate(element2, new PsiLanguageInjectionHost.InjectedPsiVisitor((Ref.BooleanRef)result2){
            final /* synthetic */ Ref.BooleanRef $result;

            public final void visit(@NotNull PsiFile $noName_0, @NotNull List<PsiLanguageInjectionHost.Shred> $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                this.$result.element = true;
            }
            {
                this.$result = booleanRef;
            }
        });
        return result2.element;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull IElementType type, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"$this$indexOf");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw (Throwable)new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = since;
        int n3 = Math.min(till, n);
        while (n2 < n3) {
            void i2;
            if ($this$indexOf.get((int)i2).getElementType() == type) {
                return (int)i2;
            }
            ++i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, IElementType iElementType, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFunKt.indexOf((List<? extends ASTNode>)list, iElementType, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOf(@NotNull List<? extends ASTNode> $this$indexOf, @NotNull Set<? extends IElementType> types, int since, int till, int notFound) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"$this$indexOf");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        int n = $this$indexOf.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw (Throwable)new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = since;
        int n3 = Math.min(till, n);
        while (n2 < n3) {
            void i2;
            if (types.contains($this$indexOf.get((int)i2).getElementType())) {
                return (int)i2;
            }
            ++i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, Set set, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFunKt.indexOf((List<? extends ASTNode>)list, set, n, n2, n3);
    }

    @Nullable
    public static final IntRange findConsequence(@NotNull List<? extends ASTNode> $this$findConsequence, int since, @NotNull Function1<? super ASTNode, Boolean> predicate) {
        int f;
        int s2;
        Intrinsics.checkNotNullParameter($this$findConsequence, (String)"$this$findConsequence");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int n = $this$findConsequence.size();
        for (s2 = since; s2 < n && !((Boolean)predicate.invoke((Object)$this$findConsequence.get(s2))).booleanValue(); ++s2) {
        }
        if (s2 == n) {
            return null;
        }
        for (f = s2 + 1; f < n && ((Boolean)predicate.invoke((Object)$this$findConsequence.get(f))).booleanValue(); ++f) {
        }
        return RangesKt.until((int)s2, (int)f);
    }

    public static /* synthetic */ IntRange findConsequence$default(List list, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return SqlFormattingModelFunKt.findConsequence(list, n, (Function1<? super ASTNode, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FindPhraseResult findPhrase(@NotNull List<? extends ASTNode> $this$findPhrase, int offset, @NotNull IElementType[][] patterns2) {
        Intrinsics.checkNotNullParameter($this$findPhrase, (String)"$this$findPhrase");
        Intrinsics.checkNotNullParameter((Object)patterns2, (String)"patterns");
        int n = $this$findPhrase.size();
        int k = offset;
        while (k < n) {
            int begin;
            ASTNode node;
            if (SqlUtilFun.isWhitespaceOrComment(node = $this$findPhrase.get(begin = k++))) continue;
            int n2 = 0;
            int n3 = ((Object[])patterns2).length;
            while (n2 < n3) {
                void i2;
                IElementType[] iElementTypeArray = patterns2[i2];
                int m = SqlUtilFun.matchPhrase($this$findPhrase, begin, Arrays.copyOf(iElementTypeArray, iElementTypeArray.length));
                if (m > 0) {
                    return new FindPhraseResult((int)i2, begin, begin + m);
                }
                ++i2;
            }
        }
        return null;
    }

    public static final int getFinish(@NotNull IntRange $this$finish) {
        int $i$f$getFinish = 0;
        Intrinsics.checkNotNullParameter((Object)$this$finish, (String)"$this$finish");
        return $this$finish.getEndInclusive();
    }

    @NotNull
    public static final Alignment makeLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"Alignment.createAlignmen\u2026, Alignment.Anchor.RIGHT)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"Alignment.createAlignmen\u2026, Alignment.Anchor.RIGHT)");
        return alignment;
    }

    @Nullable
    public static final WrapImpl.Type getType(@Nullable Wrap $this$getType) {
        Wrap wrap2 = $this$getType;
        if (!(wrap2 instanceof WrapImpl)) {
            wrap2 = null;
        }
        WrapImpl wrapImpl = (WrapImpl)wrap2;
        return wrapImpl != null ? wrapImpl.getType() : null;
    }

    public static final boolean isAlways(@Nullable Wrap $this$isAlways) {
        return SqlFormattingModelFunKt.getType($this$isAlways) == WrapImpl.Type.WRAP_ALWAYS;
    }

    @NotNull
    public static final JBIterable<SqlBlock> skip(@NotNull Iterable<? extends SqlBlock> $this$skip, int count) {
        Intrinsics.checkNotNullParameter($this$skip, (String)"$this$skip");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$skip;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.skip(count);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.skip(count)");
        return jBIterable2;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull BlockRole role) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"$this$find");
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            Iterable<? extends SqlBlock> iterable = $this$find;
            boolean bl = false;
            Iterable<? extends SqlBlock> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<? extends SqlBlock> iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it2 = sqlBlock2 = iterator.next();
                boolean bl3 = false;
                if (!(it2.getRole() == role)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $this$find, @NotNull IElementType type) {
        SqlBlock sqlBlock;
        block1: {
            Intrinsics.checkNotNullParameter($this$find, (String)"$this$find");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable<? extends SqlBlock> iterable = $this$find;
            boolean bl = false;
            Iterable<? extends SqlBlock> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<? extends SqlBlock> iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it2 = sqlBlock2 = iterator.next();
                boolean bl3 = false;
                if (!(SqlFormattingModelFunKt.primaryElementType(it2) == type)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    public static final /* synthetic */ <B extends Block> B find(Iterable<? extends Block> $this$find) {
        Block block;
        block1: {
            int $i$f$find = 0;
            Intrinsics.checkNotNullParameter($this$find, (String)"$this$find");
            Iterable<? extends Block> iterable = $this$find;
            boolean bl = false;
            Iterable<? extends Block> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<? extends Block> iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                Block block2;
                Block it2 = block2 = iterator.next();
                boolean bl3 = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"B");
                if (!(it2 instanceof Block)) continue;
                block = block2;
                break block1;
            }
            block = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"B");
        return (B)block;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(new Condition(role){
            final /* synthetic */ BlockRole $role;

            public final boolean value(SqlBlock it2) {
                return it2.getRole() == this.$role;
            }
            {
                this.$role = blockRole;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter { it.role == role }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(new Condition(role1, role2){
            final /* synthetic */ BlockRole $role1;
            final /* synthetic */ BlockRole $role2;

            public final boolean value(SqlBlock it2) {
                return it2.getRole() == this.$role1 || it2.getRole() == this.$role2;
            }
            {
                this.$role1 = blockRole;
                this.$role2 = blockRole2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter { it.rol\u2026le1 || it.role == role2 }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull BlockRole role1, @NotNull BlockRole role2, @NotNull BlockRole role3) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)((Object)role1), (String)"role1");
        Intrinsics.checkNotNullParameter((Object)((Object)role2), (String)"role2");
        Intrinsics.checkNotNullParameter((Object)((Object)role3), (String)"role3");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(new Condition(role1, role2, role3){
            final /* synthetic */ BlockRole $role1;
            final /* synthetic */ BlockRole $role2;
            final /* synthetic */ BlockRole $role3;

            public final boolean value(SqlBlock it2) {
                return it2.getRole() == this.$role1 || it2.getRole() == this.$role2 || it2.getRole() == this.$role3;
            }
            {
                this.$role1 = blockRole;
                this.$role2 = blockRole2;
                this.$role3 = blockRole3;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter { it.rol\u2026le2 || it.role == role3 }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(new Condition(type){
            final /* synthetic */ IElementType $type;

            public final boolean value(SqlBlock it2) {
                return it2 instanceof SqlSingleNodeBlock && ((SqlSingleNodeBlock)((Object)it2)).getBlockElementTypes() == this.$type;
            }
            {
                this.$type = iElementType;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter { it is \u2026ckElementTypes === type }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $this$filter, IElementType ... types) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Iterable<? extends SqlBlock> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(new Condition(types){
            final /* synthetic */ IElementType[] $types;

            public final boolean value(SqlBlock it2) {
                return it2 instanceof SqlSingleNodeBlock && ArraysKt.contains((Object[])this.$types, (Object)((SqlSingleNodeBlock)((Object)it2)).getBlockElementTypes());
            }
            {
                this.$types = iElementTypeArray;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter { it is \u2026ckElementTypes in types }");
        return jBIterable2;
    }

    public static final /* synthetic */ <B extends Block> JBIterable<B> filter(Iterable<? extends Block> $this$filter) {
        int $i$f$filter = 0;
        Intrinsics.checkNotNullParameter($this$filter, (String)"$this$filter");
        Iterable<? extends Block> $this$jbi$iv = $this$filter;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from($this$jbi$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        Intrinsics.reifiedOperationMarker((int)4, (String)"B");
        JBIterable jBIterable2 = jBIterable.filter(Block.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
        return jBIterable2;
    }

    @NotNull
    public static final <B extends Block> JBIterable<B> getJbi(@NotNull Iterable<? extends B> $this$jbi) {
        int $i$f$getJbi = 0;
        Intrinsics.checkNotNullParameter($this$jbi, (String)"$this$jbi");
        JBIterable jBIterable = JBIterable.from($this$jbi);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        return jBIterable;
    }
}

