/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.formatter.settings.GeneralSqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlLanguageCodeStyleSettingsProviderBase;
import com.intellij.sql.psi.SqlLanguage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStyleSettingsProvider
extends SqlLanguageCodeStyleSettingsProviderBase {
    public GeneralCodeStyleSettingsProvider() {
        super((Language)SqlLanguage.INSTANCE, SqlCodeStyleSettings.class);
    }

    @Nullable
    public String getLanguageName() {
        return "General";
    }

    @Override
    public SqlCodeStyleSettings createCustomSettings(CodeStyleSettings settingsContainer) {
        return new SqlCodeStyleSettings("Sql", settingsContainer, true);
    }

    public List<Language> getApplicableLanguages() {
        return SqlCodeStyles.getSettingsDialects().filter(d2 -> d2 != SqlLanguage.INSTANCE).filter(Language.class).toList();
    }

    @Override
    @Nullable
    public PsiFile createFileFromText(Project project, String text2) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("preview\u22c8style.sql", (Language)SqlLanguage.INSTANCE, (CharSequence)text2, false, false);
    }

    @Override
    @NotNull
    protected SqlCodeStyleMainPanel createSettingsPanel(CodeStyleSettings theSettings, CodeStyleSettings currentSettings) {
        return new GeneralSqlCodeStyleMainPanel(currentSettings, theSettings);
    }

    public int getWeight() {
        return 2000;
    }
}

