/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlAggregatesInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAnalyticClause;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlPivotColumnsClause;
import com.intellij.sql.psi.SqlQualifyClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlAggregatesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlAggregatesInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        return new SqlInspectionBase.SqlAnnotationVisitor(dbms2, onTheFly, manager, dialect, result2, manager, dialect, result2){
            private final Lazy clausesWithAggregates$delegate;
            private final Lazy groupByPrimaryKeys$delegate;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            private final HashSet<SqlClause> getClausesWithAggregates() {
                Lazy lazy = this.clausesWithAggregates$delegate;
                createAnnotationVisitor.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (HashSet)lazy.getValue();
            }

            private final HashSet<SqlGroupByClause> getGroupByPrimaryKeys() {
                Lazy lazy = this.groupByPrimaryKeys$delegate;
                createAnnotationVisitor.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (HashSet)lazy.getValue();
            }

            private final boolean getHasAnalyticClause(SqlFunctionCallExpression $this$hasAnalyticClause) {
                return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$hasAnalyticClause), SqlAnalyticClause.class) != null;
            }

            private final boolean maybeSameRefs(SqlReferenceExpression ref1, SqlReferenceExpression ref2) {
                PsiElement result1 = ref1.resolve();
                PsiElement result2 = ref2.resolve();
                return result1 == null || result2 == null || Intrinsics.areEqual((Object)result1, (Object)result2);
            }

            private final ObjectKind getEffectiveKind(SqlReferenceExpression $this$getEffectiveKind) {
                ObjectKind objectKind;
                block3: {
                    PsiElement target;
                    while ((target = $this$getEffectiveKind.resolve()) instanceof SqlAsExpression) {
                        SqlExpression sqlExpression = ((SqlAsExpression)target).getExpression();
                        if (!(sqlExpression instanceof SqlReferenceExpression)) {
                            sqlExpression = null;
                        }
                        if ((SqlReferenceExpression)sqlExpression != null) {
                            continue;
                        }
                        objectKind = null;
                        break block3;
                    }
                    objectKind = target instanceof PsiObject ? ((PsiObject)target).getKind() : null;
                }
                return objectKind;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                block6: {
                    SqlExpression[] sqlExpressionArray;
                    block9: {
                        Object object;
                        block8: {
                            block7: {
                                PsiElement targetElement;
                                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                                PsiElement immediateTarget = o.getReference().resolveImmediate();
                                Object object2 = immediateTarget instanceof SqlAsExpression ? (PsiElement)((SqlAsExpression)immediateTarget).getExpression() : (targetElement = immediateTarget instanceof SqlColumnSymbol ? ((SqlColumnSymbol)immediateTarget).getContextElement() : null);
                                if (!(targetElement instanceof SqlFunctionCallExpression) || !SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)targetElement)) break block7;
                                SqlQueryExpression currentQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlQueryExpression.class);
                                SqlQueryExpression targetQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)targetElement, SqlQueryExpression.class);
                                if (!Intrinsics.areEqual((Object)targetQuery, (Object)currentQuery)) break block6;
                                this.processAggregate((SqlExpression)o, (SqlFunctionCallExpression)targetElement);
                                break block6;
                            }
                            if (!Intrinsics.areEqual((Object)this.getEffectiveKind(o), (Object)ObjectKind.COLUMN)) break block6;
                            PsiElement psiElement = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o).takeWhile((Condition)createAnnotationVisitor.visitSqlReferenceExpression.1.INSTANCE).filter((Condition)createAnnotationVisitor.visitSqlReferenceExpression.2.INSTANCE).first();
                            if (psiElement == null) break block6;
                            PsiElement psiElement2 = psiElement;
                            boolean bl = false;
                            boolean bl2 = false;
                            PsiElement clause = psiElement2;
                            boolean bl3 = false;
                            PsiElement psiElement3 = clause;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"clause");
                            PsiElement parent2 = psiElement3.getParent();
                            object = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)parent2, SqlGroupByClause.class);
                            if (object == null) {
                                SqlQueryExpression sqlQueryExpression;
                                PsiElement psiElement4 = parent2;
                                if (!(psiElement4 instanceof SqlQueryExpression)) {
                                    psiElement4 = null;
                                }
                                object = (sqlQueryExpression = (SqlQueryExpression)psiElement4) != null && (sqlQueryExpression = sqlQueryExpression.getTableExpression()) != null ? sqlQueryExpression.getGroupByClause() : null;
                            }
                            if (object != null) break block8;
                            break block6;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PsiTreeUtil.getChildOfTy\u2026            ?: return@let");
                        SqlGroupByClause groupByClause = object;
                        if (this.getGroupByPrimaryKeys().contains(groupByClause)) break block6;
                        sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                        if (sqlExpressionArray != null) break block9;
                        break block6;
                    }
                    SqlExpression[] expressions2 = sqlExpressionArray;
                    boolean hasRef = false;
                    for (SqlExpression expression : expressions2) {
                        if (expression instanceof SqlReferenceExpression) {
                            if (hasRef || !this.maybeSameRefs((SqlReferenceExpression)expression, o)) continue;
                            hasRef = true;
                            continue;
                        }
                        break block6;
                    }
                    if (hasRef) break block6;
                    if (this.$dbms.isSqlite() || this.$dbms.isH2()) {
                        PsiElement psiElement = (PsiElement)o;
                        String string = SqlBundle.message("inspection.message.nondeterministic.value.column.neither.aggregated.nor.mentioned.in.group.by.clause", o.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026group.by.clause\", o.name)");
                        this.reportWarning(psiElement, string);
                    } else {
                        PsiElement psiElement = (PsiElement)o;
                        String string = SqlBundle.message("inspection.message.column.must.be.either.aggregated.or.mentioned.in.group.by.clause", o.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026group.by.clause\", o.name)");
                        this.reportError(psiElement, string);
                    }
                }
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (SqlPsiUtilCoreKt.isAggregateCall(o)) {
                    this.processAggregate((SqlExpression)o, o);
                }
                super.visitSqlElement((SqlElement)o);
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.checkIfGroupedByPrimaryKey(o);
                super.visitSqlQueryExpression(o);
            }

            public void elementFinished(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                if (element2 instanceof SqlHavingClause && !this.getClausesWithAggregates().contains(element2)) {
                    SqlGroupByClause groupBy = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((SqlHavingClause)element2).getParent(), SqlGroupByClause.class);
                    if (groupBy != null && this.hasMultipleGroupingSets(groupBy)) {
                        return;
                    }
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)((SqlHavingClause)element2).getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_HAVING), (boolean)false, null);
                    String string = SqlBundle.message("inspection.message.using.aggregate.free.condition.s.in.having.clause.might.be.inefficient.consider.moving.them.to.where", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026er.moving.them.to.where\")");
                    this.reportWarning(psiElement, string);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasMultipleGroupingSets(SqlGroupByClause $this$hasMultipleGroupingSets) {
                boolean bl;
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)$this$hasMultipleGroupingSets);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(this)");
                Iterable $this$any$iv = (Iterable)jBIterable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    IElementType type = PsiUtilCore.getElementType((PsiElement)it2);
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_CUBE)) return true;
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_ROLLUP)) return true;
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_GROUPING)) {
                        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$this$hasMultipleGroupingSets), SqlExpression.class);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (psiElementArray != null) {
                            PsiElement[] psiElementArray2 = psiElementArray;
                            boolean bl5 = false;
                            if (psiElementArray2.length != 0) return true;
                            boolean bl6 = true;
                            if (!bl6) return true;
                        }
                        boolean bl7 = true;
                        if (!bl7) {
                            return true;
                        }
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            /*
             * WARNING - void declaration
             */
            private final void checkIfGroupedByPrimaryKey(SqlQueryExpression query) {
                Collection destination$iv;
                Object object;
                SqlTableExpression sqlTableExpression = query.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"query.tableExpression?.fromClause ?: return");
                SqlTableExpression fromClause = sqlTableExpression;
                SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)query), SqlGroupByClause.class, (boolean)true, SqlQueryExpression.class);
                if (sqlGroupByClause == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlGroupByClause, (String)"PsiTreeUtil.findChildOfT\u2026                ?: return");
                SqlGroupByClause groupByClause = sqlGroupByClause;
                SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                if (sqlExpressionArray != null) {
                    void $this$mapNotNullTo$iv;
                    object = sqlExpressionArray;
                    destination$iv = new HashSet<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    void var10_12 = $this$forEach$iv$iv;
                    int n = ((void)var10_12).length;
                    for (int j = 0; j < n; ++j) {
                        DasTypedObject dasTypedObject;
                        void element$iv$iv;
                        void element$iv = element$iv$iv = var10_12[j];
                        boolean bl = false;
                        void it2 = element$iv;
                        boolean bl2 = false;
                        Object v3 = it2;
                        if (!(v3 instanceof SqlReferenceExpression)) {
                            v3 = null;
                        }
                        SqlReferenceExpression sqlReferenceExpression = v3;
                        Object object2 = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                        if (!(object2 instanceof DasTypedObject)) {
                            object2 = null;
                        }
                        if ((DasTypedObject)object2 == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        DasTypedObject it$iv = dasTypedObject;
                        boolean bl5 = false;
                        destination$iv.add(it$iv);
                    }
                } else {
                    return;
                }
                HashSet groupByColumns = (HashSet)destination$iv;
                if (groupByColumns.isEmpty()) {
                    return;
                }
                Iterator<E> iterator = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)fromClause), SqlReferenceExpression.class).iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    block15: {
                        Iterable<T> primaryKeyColumns;
                        DasTable table;
                        SqlReferenceExpression ref;
                        SqlReferenceExpression sqlReferenceExpression = ref = (SqlReferenceExpression)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"ref");
                        SqlReferenceElementType sqlReferenceElementType = sqlReferenceExpression.getReferenceElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"ref.referenceElementType");
                        if (Intrinsics.areEqual((Object)sqlReferenceElementType.getTargetKind(), (Object)ObjectKind.TABLE) ^ true) continue;
                        PsiElement psiElement = ref.resolve();
                        if (!(psiElement instanceof DasTable)) {
                            psiElement = null;
                        }
                        if ((DasTable)psiElement == null) {
                            continue;
                        }
                        Object object3 = DasUtil.getPrimaryKey(table);
                        if (object3 == null || (object3 = object3.getColumnsRef()) == null || (object3 = object3.resolveObjects()) == null) {
                            return;
                        }
                        Iterable<T> $this$any$iv = primaryKeyColumns = object3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                DasTypedObject it3 = (DasTypedObject)element$iv;
                                boolean bl6 = false;
                                if (!(!groupByColumns.contains(it3))) continue;
                                bl = true;
                                break block15;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    return;
                }
                object = this.getGroupByPrimaryKeys();
                boolean bl = false;
                object.add(groupByClause);
            }

            /*
             * WARNING - void declaration
             */
            private final void processAggregate(SqlExpression e, SqlFunctionCallExpression aggregateCall) {
                block9: {
                    Object v4;
                    Object object;
                    block8: {
                        void $this$firstOrNull$iv;
                        PsiElement permittedClause2;
                        JBIterable jBIterable = SqlImplUtil.sqlParents(e.getParent()).takeWhile((Condition)createAnnotationVisitor.processAggregate.parents.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlParents(e\u2026 !is SqlQueryExpression }");
                        JBIterable parents2 = jBIterable;
                        object = permittedClause2 = (PsiElement)parents2.filter(new Condition(this){
                            final /* synthetic */ createAnnotationVisitor.1 this$0;

                            public final boolean value(PsiElement it2) {
                                return it2 instanceof SqlSelectClause || it2 instanceof SqlHavingClause || it2 instanceof SqlQualifyClause && this.this$0.$dbms.isSnowflake() || it2 instanceof SqlOrderByClause || it2 instanceof SqlPivotColumnsClause || it2 instanceof SqlStatement;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).first();
                        if (object == null) {
                            PsiElement psiElement = (PsiElement)e;
                            String string = SqlBundle.message("inspection.message.aggregate.calls.are.not.allowed.here", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026ls.are.not.allowed.here\")");
                            this.reportError(psiElement, string);
                        } else if (object instanceof SqlHavingClause || object instanceof SqlSelectClause) {
                            PsiElement psiElement = permittedClause2;
                            if (psiElement == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlClause");
                            }
                            this.getClausesWithAggregates().add((SqlClause)psiElement);
                        }
                        if (this.getHasAnalyticClause(aggregateCall) || this.$dbms.isOracle()) break block9;
                        object = (Iterable)parents2;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(it2 instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)it2))) continue;
                            v4 = element$iv;
                            break block8;
                        }
                        v4 = null;
                    }
                    PsiElement psiElement = v4;
                    if (psiElement != null) {
                        object = psiElement;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it3 = object;
                        boolean bl3 = false;
                        Object object2 = it3;
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlFunctionCallExpression");
                        }
                        if (!this.getHasAnalyticClause((SqlFunctionCallExpression)object2)) {
                            PsiElement psiElement2 = (PsiElement)e;
                            String string = SqlBundle.message("inspection.message.nested.aggregate.calls.are.not.allowed", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026e.calls.are.not.allowed\")");
                            this.reportError(psiElement2, string);
                        }
                    }
                }
            }

            private final void reportError(PsiElement element2, @InspectionMessage String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.GENERIC_ERROR);
            }

            private final void reportWarning(PsiElement element2, @InspectionMessage String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.WARNING);
            }

            private final void reportProblem(PsiElement element2, @InspectionMessage String message2, ProblemHighlightType highlightType) {
                PsiElement psiElement = element2 instanceof SqlFunctionCallExpression ? (PsiElement)((SqlFunctionCallExpression)element2).getNameElement() : element2;
                if (psiElement == null) {
                    return;
                }
                PsiElement anchor2 = psiElement;
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, anchor2, message2, highlightType, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$dbms = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                this.clausesWithAggregates$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.clausesWithAggregates.2.INSTANCE);
                this.groupByPrimaryKeys$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.groupByPrimaryKeys.2.INSTANCE);
            }
        };
    }
}

