/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasTypedObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.DropPsiListItemFix;
import com.intellij.sql.inspections.SqlCaseVsCoalesceInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "Companion", "ReplaceWithFirstArgumentFix", "intellij.database.sql.impl"})
public final class SqlRedundantCodeInCoalesceInspection
extends SqlInspectionBase {
    @NotNull
    private static final DropPsiListItemFix DROP_ARGUMENT_FIX;
    @NotNull
    private static final TokenSet GROUPING_SET_TOKENS;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        String string = SqlCaseVsCoalesceInspection.Companion.getCoalesceName(dialect);
        if (string == null) {
            return null;
        }
        String coalesceName = string;
        return new SqlInspectionBase.SqlAnnotationVisitor(coalesceName, onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ String $coalesceName;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlFunctionCallExpression(o);
                BuiltinFunction builtinFunction = o.getFunctionDefinition();
                if (Intrinsics.areEqual((Object)(builtinFunction != null ? builtinFunction.getName() : null), (Object)this.$coalesceName) ^ true) {
                    return;
                }
                SqlExpressionList sqlExpressionList = o.getParameterList();
                if (sqlExpressionList == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpressionList, (String)"o.parameterList ?: return");
                SqlExpressionList argumentList = sqlExpressionList;
                List list = argumentList.getExpressionList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"argumentList.expressionList");
                List arguments = list;
                if (arguments.size() == 1) {
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    this.reportProblem((PsiElement)o, (TextRange)(sqlReferenceExpression != null ? sqlReferenceExpression.getTextRangeInParent() : null), (LocalQuickFix)ReplaceWithFirstArgumentFix.INSTANCE);
                }
                boolean bl = false;
                for (SqlExpression argument : (Iterable)arguments) {
                    void i2;
                    if (argument instanceof SqlSpecialLiteralExpression && ((SqlSpecialLiteralExpression)argument).isNull()) {
                        this.reportProblem((PsiElement)argument, (PsiElement)argument, (LocalQuickFix)SqlRedundantCodeInCoalesceInspection.Companion.getDROP_ARGUMENT_FIX());
                    } else if (i2 < CollectionsKt.getLastIndex((List)arguments)) {
                        SqlExpression sqlExpression = argument;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"argument");
                        if (this.isNotNull(sqlExpression, o)) {
                            PsiElement psiElement = argument.getNextSibling();
                            if (psiElement == null) {
                                return;
                            }
                            PsiElement psiElement2 = argumentList.getLastChild();
                            if (psiElement2 == null) {
                                return;
                            }
                            this.reportProblem(psiElement, psiElement2, (LocalQuickFix)DropPsiFix.INSTANCE);
                            if (i2 != false) break;
                            SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                            this.reportProblem((PsiElement)o, (TextRange)(sqlReferenceExpression != null ? sqlReferenceExpression.getTextRangeInParent() : null), (LocalQuickFix)ReplaceWithFirstArgumentFix.INSTANCE);
                            break;
                        }
                    }
                    ++i2;
                }
            }

            private final void reportProblem(PsiElement startElement, PsiElement endElement, LocalQuickFix fix) {
                this.addDescriptor(this.myManager.createProblemDescriptor(startElement, endElement, SqlBundle.message("inspection.message.redundant.code.in.coalesce.call", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[]{fix}));
            }

            private final void reportProblem(PsiElement element2, TextRange range, LocalQuickFix fix) {
                this.addDescriptor(this.myManager.createProblemDescriptor(element2, range, SqlBundle.message("inspection.message.redundant.code.in.coalesce.call", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[]{fix}));
            }

            private final boolean isNotNull(SqlExpression expression, SqlFunctionCallExpression call) {
                boolean bl;
                SqlExpression sqlExpression = expression;
                if (sqlExpression instanceof SqlSpecialLiteralExpression) {
                    bl = !((SqlSpecialLiteralExpression)expression).isNull();
                } else if (sqlExpression instanceof SqlLiteralExpression) {
                    bl = true;
                } else if (sqlExpression instanceof SqlReferenceExpression) {
                    PsiElement psiElement = ((SqlReferenceExpression)expression).resolve();
                    if (!(psiElement instanceof DasTypedObject)) {
                        psiElement = null;
                    }
                    DasTypedObject dasTypedObject = (DasTypedObject)psiElement;
                    if (dasTypedObject == null) {
                        return false;
                    }
                    DasTypedObject target = dasTypedObject;
                    if (!target.isNotNull()) {
                        return false;
                    }
                    if (this.isNullableDueToJoin((SqlReferenceExpression)expression, call)) {
                        return false;
                    }
                    if (this.isNullableDueToGrouping(call)) {
                        return false;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean isNullableDueToJoin(SqlReferenceExpression ref, SqlFunctionCallExpression call) {
                boolean bl;
                block6: {
                    void $this$any$iv;
                    PsiElement psiElement = SqlImplUtil.getQualifier(ref.resolveSingle());
                    if (psiElement == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SqlImplUtil.getQualifier\u2026Single()) ?: return false");
                    PsiElement qualifier = psiElement;
                    SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)call), SqlQueryExpression.class, (boolean)true);
                    if (sqlQueryExpression == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)sqlQueryExpression, (String)"PsiTreeUtil.getParentOfT\u2026va, true) ?: return false");
                    SqlQueryExpression queryExpression = sqlQueryExpression;
                    SqlTableExpression sqlTableExpression = queryExpression.getTableExpression();
                    if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"queryExpression.tableExp\u2026romClause ?: return false");
                    SqlTableExpression fromClause = sqlTableExpression;
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)fromClause).filter(SqlJoinExpression.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil\n          .s\u2026inExpression::class.java)");
                    Iterable iterable = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlJoinExpression it2 = (SqlJoinExpression)element$iv;
                            boolean bl2 = false;
                            SqlJoinExpression sqlJoinExpression = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlJoinExpression, (String)"it");
                            if (!(sqlJoinExpression.isLeft() && this.equalsOrRefersTo(it2.getROperand(), qualifier) || it2.isRight() && this.equalsOrRefersTo(it2.getLOperand(), qualifier))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean equalsOrRefersTo(SqlExpression $this$equalsOrRefersTo, PsiElement target) {
                if (Intrinsics.areEqual((Object)$this$equalsOrRefersTo, (Object)target)) return true;
                SqlExpression sqlExpression = $this$equalsOrRefersTo;
                Object object = sqlExpression != null ? UtilsKt.unwrapAlias(sqlExpression) : null;
                if (!(object instanceof SqlReferenceExpression)) {
                    object = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)object;
                if (!Intrinsics.areEqual((Object)(sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null), (Object)target)) return false;
                return true;
            }

            private final boolean isNullableDueToGrouping(SqlFunctionCallExpression call) {
                boolean bl;
                block6: {
                    SqlQueryExpression sqlQueryExpression;
                    SqlSelectClause sqlSelectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)call), SqlSelectClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
                    if (sqlSelectClause == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)sqlSelectClause, (String)"PsiTreeUtil.getParentOfT\u2026          ?: return false");
                    SqlSelectClause selectClause = sqlSelectClause;
                    PsiElement psiElement = selectClause.getParent();
                    if (!(psiElement instanceof SqlQueryExpression)) {
                        psiElement = null;
                    }
                    if ((sqlQueryExpression = (SqlQueryExpression)psiElement) == null || (sqlQueryExpression = sqlQueryExpression.getTableExpression()) == null || (sqlQueryExpression = sqlQueryExpression.getGroupByClause()) == null) {
                        sqlQueryExpression = (SqlGroupByClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)selectClause), SqlGroupByClause.class);
                    }
                    SqlQueryExpression groupByClause = sqlQueryExpression;
                    JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)groupByClause);
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(groupByClause)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!SqlRedundantCodeInCoalesceInspection.Companion.getGROUPING_SET_TOKENS().contains(PsiUtilCore.getElementType((PsiElement)it2))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$coalesceName = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    static {
        Companion = new Companion(null);
        DROP_ARGUMENT_FIX = new DropPsiListItemFix("argument", SqlExpression.class);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlCommonKeywords.SQL_GROUPING, (IElementType)SqlCommonKeywords.SQL_CUBE, (IElementType)SqlCommonKeywords.SQL_ROLLUP});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(SQL_GROU\u2026NG, SQL_CUBE, SQL_ROLLUP)");
        GROUPING_SET_TOKENS = tokenSet;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection$ReplaceWithFirstArgumentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    public static final class ReplaceWithFirstArgumentFix
    implements LocalQuickFix {
        @NotNull
        public static final ReplaceWithFirstArgumentFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.replace.with.first.argument", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ace.with.first.argument\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Object object;
            SqlFunctionCallExpression callExpression;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement = descriptor2.getStartElement();
                    if (!(psiElement instanceof SqlFunctionCallExpression)) {
                        psiElement = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
                    if (sqlFunctionCallExpression == null) {
                        return;
                    }
                    callExpression = sqlFunctionCallExpression;
                    object = callExpression.getParameterList();
                    if (object == null || (object = object.getExpressionList()) == null || (object = (SqlExpression)CollectionsKt.firstOrNull((List)object)) == null) break block5;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it2 = object2;
                    boolean bl3 = false;
                    object = it2 instanceof SqlNamedParameterValueExpression ? ((SqlNamedParameterValueExpression)((Object)it2)).getROperand() : it2;
                    if (object != null) break block6;
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"callExpression.parameter\u2026else it\n      } ?: return");
            Object firstArgument = object;
            callExpression.replace((PsiElement)firstArgument);
        }

        private ReplaceWithFirstArgumentFix() {
        }

        static {
            ReplaceWithFirstArgumentFix replaceWithFirstArgumentFix;
            INSTANCE = replaceWithFirstArgumentFix = new ReplaceWithFirstArgumentFix();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection$Companion;", "", "()V", "DROP_ARGUMENT_FIX", "Lcom/intellij/sql/inspections/DropPsiListItemFix;", "getDROP_ARGUMENT_FIX", "()Lcom/intellij/sql/inspections/DropPsiListItemFix;", "GROUPING_SET_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getGROUPING_SET_TOKENS", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final DropPsiListItemFix getDROP_ARGUMENT_FIX() {
            return DROP_ARGUMENT_FIX;
        }

        @NotNull
        public final TokenSet getGROUPING_SET_TOKENS() {
            return GROUPING_SET_TOKENS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

