/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DataType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlStringLengthExceededInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "IncreaseLengthFix", "intellij.database.sql.impl"})
public final class SqlStringLengthExceededInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression sqlExpression) {
                SqlElement sqlElement;
                Object object;
                PsiElement parent2;
                Intrinsics.checkNotNullParameter((Object)sqlExpression, (String)"sqlExpression");
                PsiElement psiElement = parent2 = sqlExpression.getParent();
                if (psiElement instanceof SqlSetAssignment) {
                    SqlElement sqlElement2 = ((SqlSetAssignment)parent2).getRValue();
                    boolean bl = false;
                    boolean bl2 = false;
                    SqlElement it2 = sqlElement2;
                    boolean bl3 = false;
                    object = Intrinsics.areEqual((Object)((SqlSetAssignment)parent2).getLValue(), (Object)sqlExpression) ? sqlElement2 : null;
                } else if (psiElement instanceof SqlBinaryExpression) {
                    SqlExpression sqlExpression2 = ((SqlBinaryExpression)parent2).getROperand();
                    boolean bl = false;
                    boolean bl4 = false;
                    SqlExpression it3 = sqlExpression2;
                    boolean bl5 = false;
                    object = (SqlElement)(Intrinsics.areEqual((Object)((SqlBinaryExpression)parent2).getOpSign(), (Object)SqlCommonTokens.SQL_OP_ASSIGN) && Intrinsics.areEqual((Object)((SqlBinaryExpression)parent2).getLOperand(), (Object)sqlExpression) ? sqlExpression2 : null);
                } else {
                    object = sqlElement = null;
                }
                if (!(object instanceof SqlStringLiteralExpression)) {
                    sqlElement = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)sqlElement;
                if (sqlStringLiteralExpression == null) {
                    return;
                }
                SqlStringLiteralExpression stringLiteralExpression = sqlStringLiteralExpression;
                PsiElement psiElement2 = sqlExpression.resolve();
                if (!(psiElement2 instanceof SqlVariableDefinition)) {
                    psiElement2 = null;
                }
                SqlVariableDefinition sqlVariableDefinition = (SqlVariableDefinition)psiElement2;
                if (sqlVariableDefinition == null) {
                    return;
                }
                SqlVariableDefinition variableDefinition = sqlVariableDefinition;
                this.reportProblemIfNeeded(variableDefinition, stringLiteralExpression);
                super.visitSqlVariableDefinition(variableDefinition);
            }

            public void visitSqlVariableDefinition(@NotNull SqlVariableDefinition variableDefinition) {
                Intrinsics.checkNotNullParameter((Object)variableDefinition, (String)"variableDefinition");
                SqlExpression sqlExpression = variableDefinition.getInitializer();
                if (!(sqlExpression instanceof SqlStringLiteralExpression)) {
                    sqlExpression = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)sqlExpression;
                if (sqlStringLiteralExpression == null) {
                    return;
                }
                SqlStringLiteralExpression stringLiteralExpression = sqlStringLiteralExpression;
                this.reportProblemIfNeeded(variableDefinition, stringLiteralExpression);
            }

            private final void reportProblemIfNeeded(SqlVariableDefinition variableDefinition, SqlStringLiteralExpression stringLiteral) {
                SqlType sqlType = variableDefinition.getSqlType();
                Intrinsics.checkNotNullExpressionValue((Object)sqlType, (String)"variableDefinition.sqlType");
                if (SqlType.Category.STRING != sqlType.getCategory()) {
                    return;
                }
                SqlType sqlType2 = variableDefinition.getSqlType();
                Intrinsics.checkNotNullExpressionValue((Object)sqlType2, (String)"variableDefinition.sqlType");
                DataType dataType = sqlType2.getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"variableDefinition.sqlType.dataType");
                int maxLen = dataType.getLength();
                String string = stringLiteral.getValue();
                if (string == null) {
                    return;
                }
                int literalLen = string.length();
                if (maxLen < 0 || literalLen <= maxLen) {
                    return;
                }
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor((PsiElement)stringLiteral, SqlBundle.message("inspection.message.string.will.be.truncated", new Object[0]), true, ProblemHighlightType.WARNING, false, new LocalQuickFix[]{(LocalQuickFix)new IncreaseLengthFix(variableDefinition, literalLen)});
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"myManager.createProblemD\u2026on, literalLen)\n        )");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$dialect = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlStringLengthExceededInspection$IncreaseLengthFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "variableDefinition", "Lcom/intellij/sql/psi/SqlVariableDefinition;", "newSize", "", "(Lcom/intellij/sql/psi/SqlVariableDefinition;I)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class IncreaseLengthFix
    extends LocalQuickFixOnPsiElement {
        private final int newSize;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.increase.type.length", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026me.increase.type.length\")");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Object v4;
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                PsiElement psiElement = startElement;
                if (!(psiElement instanceof SqlVariableDefinition)) {
                    psiElement = null;
                }
                SqlVariableDefinition sqlVariableDefinition = (SqlVariableDefinition)psiElement;
                if (sqlVariableDefinition == null) {
                    return;
                }
                SqlVariableDefinition variableDefinition = sqlVariableDefinition;
                SqlLiteralExpression sqlLiteralExpression = (SqlLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)variableDefinition.getTypeElement()), SqlLiteralExpression.class);
                if (sqlLiteralExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlLiteralExpression, (String)"PsiTreeUtil.getChildOfTy\u2026on::class.java) ?: return");
                SqlLiteralExpression literalExpression = sqlLiteralExpression;
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)literalExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(literalExpression)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlTokens.SQL_INTEGER_TOKEN)) continue;
                    v4 = element$iv;
                    break block5;
                }
                v4 = null;
            }
            PsiElement psiElement = v4;
            if (psiElement == null) {
                return;
            }
            PsiElement integerElement = psiElement;
            PsiElement psiElement2 = SqlPsiElementFactory.createLeafFromText(project, SqlImplUtil.getSqlDialectSafe((PsiElement)file), String.valueOf(this.newSize));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"SqlPsiElementFactory.cre\u2026ile), newSize.toString())");
            PsiElement lengthElement = psiElement2;
            integerElement.replace(lengthElement);
        }

        public IncreaseLengthFix(@NotNull SqlVariableDefinition variableDefinition, int newSize) {
            Intrinsics.checkNotNullParameter((Object)variableDefinition, (String)"variableDefinition");
            super((PsiElement)variableDefinition, (PsiElement)variableDefinition);
            this.newSize = newSize;
        }
    }
}

