/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithOrdinalityClause;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlExplicitTableExpressionWithOrdinalityImpl
extends SqlExplicitTableExpressionImpl {
    public SqlExplicitTableExpressionWithOrdinalityImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlExplicitTableExpressionWithOrdinalityImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    protected Dbms getDbms() {
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this);
        if (dbms == null) {
            SqlExplicitTableExpressionWithOrdinalityImpl.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType type = this.getSqlTypeWithoutOrdinality();
        if (!(type instanceof SqlTableType)) {
            SqlType sqlType = type;
            if (sqlType == null) {
                SqlExplicitTableExpressionWithOrdinalityImpl.$$$reportNull$$$0(2);
            }
            return sqlType;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlTypedDefinition ordinality = this.getOrdinalityColumn();
        if (ordinality != null) {
            tableType = tableType.add(new TableBasedSqlTableTypeImpl<SqlTypedDefinition>(Collections.singletonList(ordinality), this.getTable()));
        }
        SqlTableType sqlTableType = tableType;
        if (sqlTableType == null) {
            SqlExplicitTableExpressionWithOrdinalityImpl.$$$reportNull$$$0(3);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlType getSqlTypeWithoutOrdinality() {
        SqlType sqlType = super.getSqlType();
        if (sqlType == null) {
            SqlExplicitTableExpressionWithOrdinalityImpl.$$$reportNull$$$0(4);
        }
        return sqlType;
    }

    @NotNull
    protected abstract PsiTable getTable();

    @Nullable
    private SqlTypedDefinition getOrdinalityColumn() {
        return (SqlTypedDefinition)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcOrdinalityColumn(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlTypedDefinition calcOrdinalityColumn() {
        SqlWithOrdinalityClause ordinality = this.findChildByClass(SqlWithOrdinalityClause.class);
        if (ordinality == null) {
            return null;
        }
        SqlTypedDefinition ordinalityDefinition = ordinality.getOrdinalityDefinition();
        if (ordinalityDefinition != null) {
            return ordinalityDefinition;
        }
        return new OrdinalityColumn(this.getTable(), ordinality);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeWithoutOrdinality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OrdinalityColumn
    extends FakeDefinition
    implements SqlTypedDefinition {
        private final SqlWithOrdinalityClause myClause;

        protected OrdinalityColumn(PsiTable table, SqlWithOrdinalityClause clause) {
            super(table);
            this.myClause = clause;
        }

        @Override
        @NotNull
        public String getName() {
            SqlTypedDefinition ordinalityDefinition = this.myClause.getOrdinalityDefinition();
            if (ordinalityDefinition != null) {
                String string = ordinalityDefinition.getName();
                if (string == null) {
                    OrdinalityColumn.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = this.myClause.getLastChild().getText();
            if (string == null) {
                OrdinalityColumn.$$$reportNull$$$0(1);
            }
            return string;
        }

        public DasObject getDasParent() {
            return (PsiTable)this.getParent();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                OrdinalityColumn.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                OrdinalityColumn.$$$reportNull$$$0(3);
            }
            return dataType;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = SqlImplUtil.getTypeService((PsiElement)this.myClause).getIntType();
            if (dasType == null) {
                OrdinalityColumn.$$$reportNull$$$0(4);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = SqlExplicitTableExpressionWithOrdinalityImpl.this.getSqlTypeForCategory(SqlType.Category.INTEGER);
            if (sqlType == null) {
                OrdinalityColumn.$$$reportNull$$$0(5);
            }
            return sqlType;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlWithOrdinalityClause sqlWithOrdinalityClause = this.myClause;
            if (sqlWithOrdinalityClause == null) {
                OrdinalityColumn.$$$reportNull$$$0(6);
            }
            return sqlWithOrdinalityClause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityImpl$OrdinalityColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent2) {
            super(parent2);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlExplicitTableExpressionWithOrdinalityImpl.this.getDbms();
            if (dbms == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        private SqlExplicitTableExpressionWithOrdinalityImpl getOuter() {
            SqlExplicitTableExpressionWithOrdinalityImpl sqlExplicitTableExpressionWithOrdinalityImpl = SqlExplicitTableExpressionWithOrdinalityImpl.this;
            if (sqlExplicitTableExpressionWithOrdinalityImpl == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            return sqlExplicitTableExpressionWithOrdinalityImpl;
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted(this.getNameElement());
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentationCore.getIcon((DasObject)((Object)this));
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(SqlVisitor visitor2) {
        }

        public void acceptChildren(SqlVisitor visitor2) {
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            SqlNameElement nameElement;
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            if ((nameElement = this.getNameElement()) != null) {
                nameElement.setName(name);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.getOuter();
        }

        public boolean isEquivalentTo(PsiElement another) {
            return another != null && another.getClass().equals(((Object)((Object)this)).getClass()) && this.getOuter().equals((Object)((FakeDefinition)another).getOuter());
        }

        public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                FakeDefinition.$$$reportNull$$$0(5);
            }
            if (state == null) {
                FakeDefinition.$$$reportNull$$$0(6);
            }
            if (place == null) {
                FakeDefinition.$$$reportNull$$$0(7);
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FakeDefinition definition = (FakeDefinition)((Object)o);
            return this.getOuter().equals((Object)definition.getOuter());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getOuter()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityImpl$FakeDefinition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOuter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityImpl$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

