/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlType;
import com.intellij.util.SmartList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSignatureId {
    private final DasSymbol mySymbol;
    private final SmartList<SqlType> myParameterTypes;

    private SqlSignatureId(@NotNull DasSymbol symbol, @NotNull SmartList<SqlType> types) {
        if (symbol == null) {
            SqlSignatureId.$$$reportNull$$$0(0);
        }
        if (types == null) {
            SqlSignatureId.$$$reportNull$$$0(1);
        }
        this.mySymbol = symbol;
        this.myParameterTypes = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlSignatureId id = (SqlSignatureId)o;
        return Objects.equals(this.mySymbol, id.mySymbol) && Objects.equals(this.myParameterTypes, id.myParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.mySymbol, this.myParameterTypes);
    }

    public String toString() {
        return this.mySymbol.getName() + "(" + StringUtil.join(this.myParameterTypes, t -> t.getDisplayName(), (String)", ") + ")";
    }

    @Nullable
    public static SqlSignatureId of(@NotNull DasSymbol routineSymbol) {
        DasObject routine;
        if (routineSymbol == null) {
            SqlSignatureId.$$$reportNull$$$0(2);
        }
        if (!((routine = routineSymbol.getDasObject()) instanceof DasRoutine)) {
            return null;
        }
        DasUtil.getParameters((DasRoutine)routine).map(p2 -> p2.getDataType());
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineSymbol";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/impl/SqlSignatureId";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "of";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

