/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.symbols;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.virtual.DasVirtualParameterSymbol;
import com.intellij.sql.symbols.virtual.DasVirtualVariableSymbol;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasSymbolUtil {
    protected DasSymbolUtil() {
    }

    @Nullable
    public static DasSymbol getSymbolByPsi(@Nullable PsiElement element2) {
        if (element2 instanceof DasSymbol) {
            return (DasSymbol)element2;
        }
        if (element2 instanceof SqlReferenceExpression) {
            return DasSymbolUtil.getInlineSymbol(((SqlReferenceExpression)element2).getReference());
        }
        return null;
    }

    @NotNull
    public static DasSymbol getInlineSymbol(@NotNull SqlReference reference, boolean unresolved) {
        if (reference == null) {
            DasSymbolUtil.$$$reportNull$$$0(0);
        }
        return new DasInlineSymbol(reference, unresolved);
    }

    @NotNull
    public static DasSymbol getInlineSymbol(@NotNull SqlReference reference) {
        if (reference == null) {
            DasSymbolUtil.$$$reportNull$$$0(1);
        }
        return DasSymbolUtil.getInlineSymbol(reference, false);
    }

    public static boolean isUnresolved(@Nullable DasSymbol symbol) {
        return symbol instanceof DasInlineSymbol && ((DasInlineSymbol)symbol).isUnresolved();
    }

    @Nullable
    public static DasSymbol getSymbol(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getTargetSymbol() : null;
    }

    @Nullable
    public static PsiElement getSinglePsiSource(@Nullable DasSymbol symbol) {
        return symbol != null ? (PsiElement)symbol.getPsiDeclarations().single() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static DasSymbol wrapObjectToSymbol(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            DasSymbolUtil.$$$reportNull$$$0(2);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof DasSymbol) {
            return (DasSymbol)((Object)object);
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialect(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(3);
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)ObjectUtils.notNull((Object)((SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(symbol.getDbms())), (Object)SqlDialectImplUtilCore.getDefaultSqlDialect());
        if (sqlLanguageDialectEx == null) {
            DasSymbolUtil.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialectEx;
    }

    public static DasVirtualVariableSymbol createSimpleVariable(@NotNull SqlElement context, @NotNull String name, final @NotNull DataType dataType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(6);
        }
        if (dataType == null) {
            DasSymbolUtil.$$$reportNull$$$0(7);
        }
        return new DasVirtualVariableSymbol(context, name){

            @Override
            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$1", "getDataType"));
            }
        };
    }

    public static DasVirtualParameterSymbol createDelegatingParameter(@NotNull SqlElement context, @NotNull DasRoutine routine, @NotNull String name, @NotNull ArgumentDirection direction, short position, final @NotNull DasTypedObject delegate) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(8);
        }
        if (routine == null) {
            DasSymbolUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(10);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(11);
        }
        if (delegate == null) {
            DasSymbolUtil.$$$reportNull$$$0(12);
        }
        return new DasVirtualParameterSymbol(context, routine, name, direction, position){

            @Override
            @NotNull
            public DataType getDataType() {
                DataType dataType = delegate.getDataType();
                if (dataType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType;
            }

            @Override
            public boolean isNotNull() {
                return delegate.isNotNull();
            }

            @Override
            @Nullable
            public String getDefault() {
                return delegate.getDefault();
            }

            @Override
            public boolean isQuoted() {
                return DbSqlUtilCore.isQuoted(delegate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$2", "getDataType"));
            }
        };
    }

    public static DasVirtualParameterSymbol createSimpleParameter(@NotNull SqlElement context, @NotNull DasRoutine routine, @NotNull String name, @NotNull ArgumentDirection direction, short position, final @NotNull DataType dataType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(13);
        }
        if (routine == null) {
            DasSymbolUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(15);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(16);
        }
        if (dataType == null) {
            DasSymbolUtil.$$$reportNull$$$0(17);
        }
        return new DasVirtualParameterSymbol(context, routine, name, direction, position){

            @Override
            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$3", "getDataType"));
            }
        };
    }

    @Nullable
    public static DasSymbol getOrResolveSymbol(@Nullable PsiElement element2) {
        if (element2 instanceof DasSymbol) {
            return (DasSymbol)element2;
        }
        if (element2 instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)element2).resolveSymbol();
        }
        return null;
    }

    @Nullable
    public static Icon getIcon(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(18);
        }
        if (symbol instanceof PsiPresentableMetaData) {
            return ((PsiPresentableMetaData)symbol).getIcon();
        }
        if (symbol instanceof PsiElement) {
            return ((PsiElement)symbol).getIcon(0);
        }
        DasObject dasObject = symbol.getDasObject();
        return dasObject != null ? DbPresentationCore.getIcon(dasObject) : DbPresentationCore.getIcon(symbol.getKind());
    }

    @Nls
    @NotNull
    public static String getTypeName(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(19);
        }
        String string = DbPresentationCore.getPresentableName(symbol.getKind(), symbol.getDbms());
        if (string == null) {
            DasSymbolUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInlineSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 4: 
            case 20: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleVariable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDelegatingParameter";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

