/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.SofterReference;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrTestScopeSerialization {
    @NotNull
    @Contract(value="_ -> new")
    public static CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> getTestSerializer(Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        return new CidrTestWithScopeElementsSerializer(generator);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForCaching(final @Nullable String testName, final @Nullable String suiteName, final long offsetAsNaturalOrder, final @Nullable String uniqueTestBodyElementId, @NotNull PsiFile pfile, final @Nullable OCSymbolKind kind, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function) {
        void generator;
        if (pfile == null) {
            CidrTestScopeSerialization.$$$reportNull$$$0(0);
        }
        if (function == null) {
            CidrTestScopeSerialization.$$$reportNull$$$0(1);
        }
        final VirtualFile exVFile = pfile.getVirtualFile();
        final Project exProject = pfile.getProject();
        return new CidrTestScopeElementWithSerializerImpl(suiteName, testName, (Function)generator){
            @Nullable
            SofterReference<PsiElement> myPsiElement;

            @Override
            public void write(@NotNull Output output) {
                if (output == null) {
                    1.$$$reportNull$$$0(0);
                }
                output.writeString(testName);
                output.writeString(suiteName);
                output.writeLong(offsetAsNaturalOrder);
                output.writeString(uniqueTestBodyElementId);
                output.writeString(kind == null ? null : kind.toString());
            }

            public long getSortIndex() {
                return offsetAsNaturalOrder;
            }

            @NotNull
            public PsiElement getElement() {
                PsiElement element;
                PsiFile psiFile;
                if (this.myPsiElement != null) {
                    PsiElement element2 = (PsiElement)this.myPsiElement.get();
                    if (element2 != null && element2.isValid()) {
                        PsiElement psiElement = element2;
                        if (psiElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return psiElement;
                    }
                    this.myPsiElement = null;
                }
                CidrTestLog.LOG.assertTrue((psiFile = OCLanguageUtils.tryGetOCFile(PsiManager.getInstance((Project)exProject).findFile(exVFile))) != null);
                if (OCTestExecution.canWaitInThisThread() && (element = this.getElementSlow(psiFile)) != null) {
                    CidrTestListUpdater.log("Moved element was found", new Object[0]);
                    this.myPsiElement = new SofterReference((Object)element);
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiElement;
                }
                element = psiFile.findElementAt(OCSymbolOffsetUtil.getTextOffset(offsetAsNaturalOrder));
                if (element != null) {
                    CidrTestListUpdater.log("Element from position", new Object[0]);
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return psiElement;
                }
                CidrTestListUpdater.log("File as element", new Object[0]);
                PsiFile psiFile2 = psiFile;
                if (psiFile2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiFile2;
            }

            @Nullable
            private PsiElement getElementSlow(@NotNull PsiFile psiFile) {
                OCFile realSource;
                if (psiFile == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!(psiFile instanceof OCFile) || uniqueTestBodyElementId == null) {
                    return null;
                }
                OCSymbolReference.GlobalReference bodyRef = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.parse(uniqueTestBodyElementId));
                OCFile source = (OCFile)psiFile;
                if (OCInclusionContextUtil.isNeedToFindRoot(psiFile) && (realSource = ((OCFile)psiFile).getAssociatedFile()) != null) {
                    source = realSource;
                }
                List<OCSymbol> symbols = bodyRef.resolveToSymbols(OCResolveContext.forPsi(source));
                OCSymbol preDeclaration = null;
                for (OCSymbol symbol : symbols) {
                    PsiElement element = this.extractElement(symbol);
                    if (element != null) {
                        return element;
                    }
                    if (preDeclaration != null || symbol.getKind() != OCSymbolKind.FUNCTION_PREDECLARATION) continue;
                    preDeclaration = symbol;
                }
                if (preDeclaration != null) {
                    return this.extractElement(preDeclaration.getDefinitionSymbol(source.getProject()));
                }
                return null;
            }

            @Nullable
            public String getId() {
                return uniqueTestBodyElementId;
            }

            @Contract(value="null -> null")
            @Nullable
            private PsiElement extractElement(@Nullable OCSymbol symbol) {
                if (symbol != null && symbol.getKind() == kind) {
                    return OCSymbolHolderVirtualPsiElement.create(symbol, exProject);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "write";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementSlow";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "generator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization";
        objectArray[2] = "createTestScopeElementForCaching";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CidrTestWithScopeElementsSerializer
    implements CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator;
        private static final int SKIP_WATERMARK = -1;
        private static final int TEST_WITH_SCOPE_ELEMENTS_SERIALIZER = 0;

        public CidrTestWithScopeElementsSerializer() {
            this.myGenerator = null;
        }

        public CidrTestWithScopeElementsSerializer(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (generator == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(0);
            }
            this.myGenerator = generator;
        }

        public void setGenerator(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (generator == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(1);
            }
            this.myGenerator = generator;
        }

        @Override
        public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestScopeElement testScope) {
            if (kryo == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(2);
            }
            if (output == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(3);
            }
            if (testScope == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(4);
            }
            if (testScope instanceof CidrTestScopeElementWithSerializerImpl) {
                output.writeInt(0);
                ((CidrTestScopeElementWithSerializerImpl)testScope).write(output);
                return;
            }
            output.writeInt(-1);
        }

        @Override
        @Nullable
        public CidrTestScopeElement read(@NotNull Kryo kryo, @NotNull Input input, @NotNull PsiFile psiFileWithTest) {
            int watermark;
            if (kryo == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(5);
            }
            if (input == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(6);
            }
            if (psiFileWithTest == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(7);
            }
            if ((watermark = input.readInt()) == 0) {
                return CidrTestScopeElementWithSerializerImpl.read(input, psiFileWithTest, this.getGenerator());
            }
            return null;
        }

        @NotNull
        @Contract(pure=true)
        public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
            assert (this.myGenerator != null);
            Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function = this.myGenerator;
            if (function == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(8);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kryo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testScope";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFileWithTest";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestWithScopeElementsSerializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestWithScopeElementsSerializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setGenerator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class CidrTestScopeElementWithSerializerImpl
    extends CidrTestScopeElementImpl {
        CidrTestScopeElementWithSerializerImpl(@Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (generator == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(0);
            }
            super(suiteName, testName, generator);
        }

        public abstract void write(@NotNull Output var1);

        @NotNull
        public static CidrTestScopeElement read(@NotNull Input input, @NotNull PsiFile psiFileWithTest, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (input == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(1);
            }
            if (psiFileWithTest == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(2);
            }
            if (generator == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(3);
            }
            String testName = input.readString();
            String suiteName = input.readString();
            long offsetAsNaturalOrder = input.readLong();
            String uniqueTestBodyElementId = input.readString();
            String name = input.readString();
            OCSymbolKind kind = StringUtil.isEmpty((String)name) ? null : OCSymbolKind.valueOf(name);
            CidrTestScopeElement cidrTestScopeElement = CidrTestScopeSerialization.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, uniqueTestBodyElementId, psiFileWithTest, kind, generator);
            if (cidrTestScopeElement == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(4);
            }
            return cidrTestScopeElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFileWithTest";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestScopeElementWithSerializerImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestScopeElementWithSerializerImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

