/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestUtil {
    private static final Pattern TEMPLATE_ARGS = Pattern.compile("<.*>");

    public static boolean processNamespaceRecursively(@NotNull OCSymbol symbol, @NotNull Processor<? super OCSymbol> processor) {
        if (symbol == null) {
            CidrTestUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            CidrTestUtil.$$$reportNull$$$0(1);
        }
        if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
            List<OCSymbol> membersList = ((OCNamespaceSymbol)symbol).getMembersList();
            if (membersList != null) {
                for (OCSymbol nsSymbol : membersList) {
                    if (processor.process((Object)nsSymbol)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getAsPatternForCommandLine(@NotNull Project project, @NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull CidrTestScope testScope, @NotNull ProgressIndicator progress) {
        if (project == null) {
            CidrTestUtil.$$$reportNull$$$0(2);
        }
        if (framework == null) {
            CidrTestUtil.$$$reportNull$$$0(3);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestUtil.$$$reportNull$$$0(4);
        }
        if (testScope == null) {
            CidrTestUtil.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            CidrTestUtil.$$$reportNull$$$0(6);
        }
        String string = CidrTestExecutionUtil.getAsPatternForCommandLine((Project)project, file -> framework.getTestObjects(OCLanguageUtils.tryGetOCFile(file)).values(), emptyTestScopeProducer, () -> FileSymbolTablesCache.areSymbolsLoaded(project), (CidrTestScope)testScope, (ProgressIndicator)progress);
        if (string == null) {
            CidrTestUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getCanonicalNameFromSymbol(@NotNull OCSymbolWithQualifiedName namespaceSymbol, @NotNull OCResolveContext context) {
        OCQualifiedName namespaceQName;
        if (namespaceSymbol == null) {
            CidrTestUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            CidrTestUtil.$$$reportNull$$$0(9);
        }
        return (namespaceQName = namespaceSymbol.getResolvedQualifiedName(context)) == null ? null : CidrTestUtil.replaceTemplateParamTo(namespaceQName.getFullName(context), "");
    }

    public static String replaceTemplateParamTo(@NotNull String name, @NotNull String replacement) {
        if (name == null) {
            CidrTestUtil.$$$reportNull$$$0(10);
        }
        if (replacement == null) {
            CidrTestUtil.$$$reportNull$$$0(11);
        }
        return TEMPLATE_ARGS.matcher(name).replaceAll(replacement);
    }

    @NotNull
    public static String createFilePattern(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull PsiFile file, @NotNull Predicate<CidrTestScopeElement> filter) {
        if (framework == null) {
            CidrTestUtil.$$$reportNull$$$0(12);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestUtil.$$$reportNull$$$0(13);
        }
        if (file == null) {
            CidrTestUtil.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            CidrTestUtil.$$$reportNull$$$0(15);
        }
        String string = CidrTestUtil.filePatternAsRef() ? CidrTestUtil.createFilePatternAsRef(framework, file) : CidrTestExecutionUtil.createFilePatternAsTestList(framework.getTestObjects(file).values(), emptyTestScopeProducer, filter);
        if (string == null) {
            CidrTestUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean filePatternAsRef() {
        return Registry.is((String)"cidr.test.framework.filePatternAsRef") && !PlatformUtils.isAppCode();
    }

    @NotNull
    public static String createFilePatternAsRef(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull PsiFile file) {
        if (framework == null) {
            CidrTestUtil.$$$reportNull$$$0(17);
        }
        if (file == null) {
            CidrTestUtil.$$$reportNull$$$0(18);
        }
        framework.updateTestsListOrScheduleUpdateIfCannotWait(file);
        String string = "all-tests(" + file.getVirtualFile().getUrl() + ")";
        if (string == null) {
            CidrTestUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyTestScopeProducer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsPatternForCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePattern";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePatternAsRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAsPatternForCommandLine";
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNameFromSymbol";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceTemplateParamTo";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFilePattern";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFilePatternAsRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

