/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestWithScopeElementsFramework<TEST_OBJECT extends CidrTestScopeElement>
extends CidrTestFrameworkBase<TEST_OBJECT>
implements CidrTestRunConfigurationLanguageSupport {
    protected final Class<? extends PsiElement>[] myTestHolderClassWithoutMacroCall;
    protected final boolean myCanHaveMacroAsTest;
    protected final boolean myCanHaveNamespaceAsTest;
    protected final boolean myCanHaveClassAsTest;
    protected final boolean myCanHaveFunctionAsTest;
    protected final boolean myCanHaveDeclaratorAsTest;
    protected OCSymbolKind[] myDeclaratorKinds;
    protected final Key<Map<String, TEST_OBJECT>> myObjects;
    protected final Key<Boolean> myIsDirty;
    private final Key<Pair<TEST_OBJECT, Long>> myTestScopeInElementWithVersion;

    @SafeVarargs
    protected CidrTestWithScopeElementsFramework(@NonNls @NotNull String testFrameworkId, Class<? extends PsiElement> ... testHolderClass) {
        if (testFrameworkId == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(0);
        }
        if (testHolderClass == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(1);
        }
        super(testFrameworkId, testHolderClass);
        this.myDeclaratorKinds = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE};
        this.myObjects = Key.create((String)(this.myFrameworkId + " objects"));
        this.myIsDirty = Key.create((String)(this.myFrameworkId + " dirty"));
        this.myTestScopeInElementWithVersion = Key.create((String)(this.myFrameworkId + "Test Scope With Version"));
        this.myTestHolderClassWithoutMacroCall = ContainerUtil.filter((Collection)this.myTestHolderClass, clazz -> !clazz.equals(OCMacroCall.class)).toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        this.myCanHaveMacroAsTest = this.myTestHolderClass.contains(OCMacroCall.class);
        this.myCanHaveNamespaceAsTest = this.myTestHolderClass.contains(OCCppNamespace.class);
        this.myCanHaveClassAsTest = this.myTestHolderClass.contains(OCStruct.class);
        this.myCanHaveFunctionAsTest = this.myTestHolderClass.contains(OCFunctionDefinition.class);
        this.myCanHaveDeclaratorAsTest = this.myTestHolderClass.contains(OCDeclarator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, TEST_OBJECT> getOrCreateObjects(@NotNull PsiFile actualFile, @NotNull CidrTestInfoForFile infoForFile) {
        Map<String, TEST_OBJECT> map;
        boolean isDirty;
        if (actualFile == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(2);
        }
        if (infoForFile == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(3);
        }
        if (infoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(4);
            }
            return map2;
        }
        Map objects = (Map)this.myObjects.get((UserDataHolder)infoForFile);
        boolean bl = isDirty = this.myIsDirty.get((UserDataHolder)infoForFile) == Boolean.TRUE;
        if (objects != null && !isDirty) {
            Map map3 = objects;
            if (map3 == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(5);
            }
            return map3;
        }
        CidrTestListUpdater updater = this.getUpdater(actualFile.getProject());
        if (!OCTestExecution.canWaitInThisThread()) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            Map map4 = objects != null ? objects : Collections.emptyMap();
            if (map4 == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(6);
            }
            return map4;
        }
        try {
            Map<String, TEST_OBJECT> objectsDirectly = this.createTestObjectsDirectly(actualFile);
            CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
            synchronized (cidrTestInfoForFile) {
                this.myIsDirty.set((UserDataHolder)infoForFile, null);
                this.myObjects.set((UserDataHolder)infoForFile, objectsDirectly);
                updater.incTestInfoVersion();
            }
            map = objectsDirectly;
        }
        catch (IndexNotReadyException e) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            Map map5 = objects != null ? objects : Collections.emptyMap();
            if (map5 == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(8);
            }
            return map5;
        }
        if (map == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Override
    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(9);
        }
        if (newTestInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(10);
        }
        this.getOrCreateObjects(file, newTestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
        if (dst == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(11);
        }
        if (src != null) {
            CidrTestInfoForFile cidrTestInfoForFile = dst;
            synchronized (cidrTestInfoForFile) {
                this.myIsDirty.set((UserDataHolder)dst, (Object)Boolean.TRUE);
                this.myObjects.set((UserDataHolder)dst, (Object)((Map)this.myObjects.get((UserDataHolder)src)));
            }
        }
    }

    @NotNull
    public Map<String, TEST_OBJECT> getTestObjects(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(12);
        }
        Map<String, TEST_OBJECT> map = this.getOrCreateObjects(file, this.getTestInfo(file));
        if (map == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(13);
        }
        return map;
    }

    public void updateTestsListOrScheduleUpdateIfCannotWait(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(14);
        }
        this.getTestObjects(file);
    }

    @Override
    @Nullable
    protected TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(15);
        }
        CidrTestScopeElement scope = CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> CidrTestUtil.createFilePattern(this, () -> CidrTestScope.createEmptyTestScope((String)this.getPatternSeparatorInCommandLine()), file, this::shouldAddToFileScope));
        return (TEST_OBJECT)scope;
    }

    protected boolean shouldAddToFileScope(@NotNull CidrTestScopeElement testScopeElement) {
        if (testScopeElement == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(16);
        }
        return testScopeElement.isTest();
    }

    @NotNull
    protected abstract Map<String, TEST_OBJECT> createTestObjectsDirectly(@NotNull PsiFile var1);

    @NonNls
    @NotNull
    public abstract String getProtocolPrefix();

    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suite, @Nullable String test) {
        throw new RuntimeException("Not implemented");
    }

    protected TEST_OBJECT getTestObjectFromTestHolder(@NotNull PsiElement maybeTestHolder, @NotNull Set<String> macroNames) {
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(17);
        }
        if (macroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(18);
        }
        Pair pair = (Pair)this.myTestScopeInElementWithVersion.get((UserDataHolder)maybeTestHolder);
        Project project = maybeTestHolder.getProject();
        long modificationCount = this.getFileVersion(maybeTestHolder.getContainingFile());
        if (pair != null && (Long)pair.second == modificationCount) {
            return (TEST_OBJECT)((CidrTestScopeElement)pair.first);
        }
        TEST_OBJECT ret = null;
        boolean saveResultToCache = false;
        if (this.isTestMacroCandidate(maybeTestHolder, macroNames)) {
            ret = this.findTestObjectFromMacro(maybeTestHolder, macroNames);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveNamespaceAsTest && maybeTestHolder instanceof OCCppNamespace) {
            ret = this.extractTestObject(((OCCppNamespace)maybeTestHolder).getSymbol(), project, OCSymbolKind.NAMESPACE);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveClassAsTest && maybeTestHolder instanceof OCStruct) {
            ret = this.extractTestObject(((OCStruct)maybeTestHolder).getSymbol(), project, OCSymbolKind.STRUCT);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveFunctionAsTest && maybeTestHolder instanceof OCFunctionDefinition) {
            ret = this.extractTestObject(((OCFunctionDefinition)maybeTestHolder).getSymbol(), project, OCSymbolKind.FUNCTION_DECLARATION);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveDeclaratorAsTest && maybeTestHolder instanceof OCDeclarator) {
            ret = this.extractTestObject(((OCDeclarator)maybeTestHolder).getSymbol(), project, this.myDeclaratorKinds);
            saveResultToCache = true;
        }
        if (saveResultToCache) {
            this.cacheResultForTestHolder(maybeTestHolder, ret);
        }
        return ret;
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret) {
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(19);
        }
        this.myTestScopeInElementWithVersion.set((UserDataHolder)maybeTestHolder, (Object)Pair.create(ret, (Object)this.getFileVersion(maybeTestHolder.getContainingFile())));
    }

    @Contract(value="null, _, _ -> null")
    protected TEST_OBJECT extractTestObject(@Nullable OCSymbol symbol, @NotNull Project project, OCSymbolKind ... kinds) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(20);
        }
        if (kinds == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(21);
        }
        if (symbol == null) {
            return null;
        }
        PsiFile file = symbol.getContainingPsiFile(project);
        if (file != null && this.isAvailable(file)) {
            for (OCSymbolKind canBe : kinds) {
                if (symbol.getKind() != canBe) continue;
                OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
                String key = this.getTestObjectKeyForSymbol(symbol, context);
                return (TEST_OBJECT)((CidrTestScopeElement)this.getTestObjects(file).get(key));
            }
        }
        return null;
    }

    @Nullable
    protected String getTestObjectKeyForSymbol(@NotNull OCSymbol symbol, OCResolveContext context) {
        if (symbol == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(22);
        }
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return null;
        }
        return CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
    }

    @Contract(value="null, null, _, _, _ -> false")
    protected boolean standardProbe(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Class<?> clazz, @NotNull Project project, OCSymbolKind ... symbolKind) {
        if (clazz == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(23);
        }
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(24);
        }
        if (symbolKind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(25);
        }
        if (symbol == null && clazz.isInstance(element)) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        return this.extractTestObject(symbol, project, symbolKind) != null;
    }

    protected TEST_OBJECT findTestObjectFromMacro(@NotNull PsiElement maybeMacro, @NotNull Set<String> testMacroNames) {
        if (maybeMacro == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(26);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(27);
        }
        Ref ref = new Ref();
        ((OCMacroCall)maybeMacro).processExpansionLeaves((Processor<? super PsiElement>)((Processor)leaf -> {
            TEST_OBJECT ret;
            OCElement testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])this.myTestHolderClassWithoutMacroCall);
            if (testHolder != null && testHolder.getComplexOffset() > ((OCMacroCall)maybeMacro).getComplexOffset() && (ret = this.getTestObjectFromTestHolder(testHolder, testMacroNames)) != null) {
                ref.set(ret);
                return false;
            }
            return true;
        }));
        return (TEST_OBJECT)((CidrTestScopeElement)ref.get());
    }

    @Contract(pure=true)
    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        if (element == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(28);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(29);
        }
        return element instanceof OCMacroCall;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        if (pathToFind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(30);
        }
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(31);
        }
        Ref result = new Ref();
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind.equals(testInfo.getTestPath())) {
                result.set(testInfo);
                return false;
            }
            return true;
        });
        return (TEST_OBJECT)((CidrTestScopeElement)result.get());
    }

    @NotNull
    public Collection<TEST_OBJECT> collectTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(32);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.consumeTestObjects(pathToFind, project, scope, (Processor<? super TEST_OBJECT>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(33);
        }
        return collection;
    }

    public void consumeTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(34);
        }
        if (processor == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(35);
        }
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind == null) {
                processor.process(testInfo);
                return true;
            }
            int pathToFindLength = pathToFind.length();
            String infoTestPath = testInfo.getTestPath();
            if (infoTestPath.startsWith(pathToFind) && (pathToFindLength == infoTestPath.length() || infoTestPath.charAt(pathToFindLength) == '/')) {
                processor.process(testInfo);
            }
            return true;
        });
    }

    public void consumeTestObjects(@NotNull Project project, @Nullable SearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) throws IndexNotReadyException {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(36);
        }
        if (processor == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(37);
        }
        LinkedList<VirtualFile> testFirstCollection = new LinkedList<VirtualFile>();
        CidrTestListUpdater.fillCollectionWithTestFirst(this.getPotentialTestHolderRoots(project), testFirstCollection);
        this.consumeTestInfo(project, testFirstCollection.iterator(), scope, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileAndFileInfo -> {
            for (CidrTestScopeElement testScope : this.getOrCreateObjects((PsiFile)fileAndFileInfo.first, (CidrTestInfoForFile)((Object)((Object)fileAndFileInfo.second))).values()) {
                if (processor.process((Object)testScope)) continue;
                return false;
            }
            return true;
        }));
    }

    @Override
    @Contract(value="null -> null")
    public OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement testElement) {
        if (testElement == null || CidrTestWithScopeElementsFramework.isMacroInjectedIdOwner(testElement)) {
            return null;
        }
        final CidrTestScopeElement testObject = (CidrTestScopeElement)this.getTestObject(testElement);
        if (testObject != null) {
            return new OCTestLineMarkInfo(){

                @Override
                @NotNull
                public String getUrlInTestTree() {
                    String string = CidrTestWithScopeElementsFramework.this.getTestUrl(testObject);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public boolean isSuite() {
                    return !testObject.isTest();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework$1", "getUrlInTestTree"));
                }
            };
        }
        return null;
    }

    @NotNull
    protected String getTestUrl(@NotNull TEST_OBJECT testObject) {
        if (testObject == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(38);
        }
        String string = this.getProtocolPrefix() + testObject.getTestPath();
        if (string == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(40);
        }
        GlobalSearchScope globalSearchScope = OCSearchScope.getProjectSourcesScope(project);
        if (globalSearchScope == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(41);
        }
        return globalSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestInfoForFile testInfo) {
        CidrTestScopeSerializer serializer;
        if (kryo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(42);
        }
        if (output == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(43);
        }
        if (testInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(44);
        }
        if ((serializer = this.getTestSerializer()) == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = testInfo;
        synchronized (cidrTestInfoForFile) {
            Map map = (Map)this.myObjects.get((UserDataHolder)testInfo);
            if (map == null) {
                output.writeInt(0);
            } else {
                output.writeInt(map.size());
                map.forEach((name, testScopeElement) -> {
                    output.writeString(name);
                    serializer.write(kryo, output, testScopeElement);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
        CidrTestScopeSerializer<TEST_OBJECT> serializer;
        if (kryo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(45);
        }
        if (input == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(46);
        }
        if (initTestInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(47);
        }
        if (fileWithTest == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(48);
        }
        if ((serializer = this.getTestSerializer()) == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = initTestInfo;
        synchronized (cidrTestInfoForFile) {
            HashMap<String, TEST_OBJECT> links = new HashMap<String, TEST_OBJECT>();
            int testCount = input.readInt();
            for (int i2 = 0; i2 < testCount; ++i2) {
                String name = input.readString();
                TEST_OBJECT scopeElement = serializer.read(kryo, input, fileWithTest);
                if (scopeElement == null) continue;
                links.put(name, scopeElement);
            }
            this.myObjects.set((UserDataHolder)initTestInfo, links);
        }
    }

    @Nullable
    protected CidrTestScopeSerializer<TEST_OBJECT> getTestSerializer() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 33: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 33: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolderClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoForFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 33: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScopeElement";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeTestHolder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroNames";
                break;
            }
            case 20: 
            case 24: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeMacro";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMacroNames";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFind";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testObject";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kryo";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInfo";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initTestInfo";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateObjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestObjects";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestObjects";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestUrl";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateObjects";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 33: 
            case 39: 
            case 41: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyDirty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjects";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTestsListOrScheduleUpdateIfCannotWait";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFileTestObjectIfPossible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToFileScope";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjectFromTestHolder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cacheResultForTestHolder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractTestObject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjectKeyForSymbol";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "standardProbe";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findTestObjectFromMacro";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isTestMacroCandidate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectTestObjects";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "consumeTestObjects";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTestUrl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "writeTestInfo";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "readTestInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 33: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CidrTestScopeSerializer<TEST_OBJECT extends CidrTestScopeElement> {
        public void write(@NotNull Kryo var1, @NotNull Output var2, @NotNull TEST_OBJECT var3);

        @Nullable
        public TEST_OBJECT read(@NotNull Kryo var1, @NotNull Input var2, @NotNull PsiFile var3);
    }
}

