/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandler;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewFileLangBackendHandlerImpl
implements OCNewFileLangBackendHandler {
    private static final String DEFAULT_H_EXT = "h";

    @Nullable
    public VirtualFile getVirtualFile(@Nullable PsiFile file) {
        return OCInclusionContextUtil.getVirtualFile(file);
    }

    public void handleCreatedFile(@NotNull PsiFile file) {
        if (file == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(0);
        }
        if (file instanceof OCFile) {
            FileSymbolTable.forFile(file, OCInclusionContextUtil.headerContext(file).derive());
        }
    }

    @Nullable
    public LanguageFileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @Nullable
    public Language getLanguage() {
        return OCLanguageUtils.getConfigLanguage();
    }

    @NotNull
    public List<FileExtensionPair> getExtensions(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(1);
        }
        ImmutableList<FileExtensionPair> immutableList = ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
        if (immutableList == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    public void storeExtensions(@NotNull CodeStyleSettings settings, @NotNull List<FileExtensionPair> extensionPairs) {
        if (settings == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(3);
        }
        if (extensionPairs == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(4);
        }
        ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList(extensionPairs);
    }

    public boolean isCppFileExtension(@NotNull String extension, @NotNull Project project) {
        OCLanguageKind kind;
        if (extension == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(6);
        }
        return (kind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, extension)) != null && kind.isCpp();
    }

    @NotNull
    public Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        if (sampleFile == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(7);
        }
        Project project = sampleFile.getProject();
        if (!(sampleFile instanceof OCFile)) {
            Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
            if (couple == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(8);
            }
            return couple;
        }
        OCFile ocFile = (OCFile)sampleFile;
        if (preferredSourceExt == null && preferredHeaderExt == null) {
            if (ocFile.isHeader()) {
                preferredHeaderExt = FileUtilRt.getExtension((String)ocFile.getName());
                OCFile implFile = ocFile.getAssociatedFile();
                if (implFile != null) {
                    preferredSourceExt = FileUtilRt.getExtension((String)implFile.getName());
                }
            } else {
                preferredSourceExt = FileUtilRt.getExtension((String)ocFile.getName());
            }
        }
        if (preferredSourceExt == null) {
            preferredSourceExt = this.findSourceExt(project, preferredHeaderExt, ocFile.getKind());
        } else if (preferredHeaderExt == null) {
            preferredHeaderExt = this.findHeaderExt(project, preferredSourceExt);
        }
        Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
        if (couple == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @NotNull
    public String getHeaderGuardStylePattern(@NotNull String filePath, @NotNull Project project) {
        if (filePath == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(10);
        }
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(11);
        }
        String string = ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
        if (string == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String findSourceExt(@NotNull Project project, @NotNull String headerExt, @NotNull OCLanguageKind headerKind) {
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(13);
        }
        if (headerExt == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(14);
        }
        if (headerKind == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(15);
        }
        for (FileExtensionPair pair : this.getExtensions(CodeStyle.getSettings((Project)project))) {
            OCLanguageKind sourceKind;
            if (!pair.myHeaderExt.equals(headerExt) || headerKind != (sourceKind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, "." + pair.mySourceExt))) continue;
            String string = pair.mySourceExt;
            if (string == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = headerKind.getDefaultSourceExtension();
        if (string == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String findHeaderExt(@NotNull Project project, @NotNull String sourceExt) {
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(18);
        }
        if (sourceExt == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(19);
        }
        for (FileExtensionPair pair : this.getExtensions(CodeStyle.getSettings((Project)project))) {
            if (!pair.mySourceExt.equals(sourceExt)) continue;
            String string = pair.myHeaderExt;
            if (string == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        return DEFAULT_H_EXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileLangBackendHandlerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPairs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerExt";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerKind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileLangBackendHandlerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "determineExtensions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderGuardStylePattern";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceExt";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findHeaderExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "storeExtensions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCppFileExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineExtensions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderGuardStylePattern";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSourceExt";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findHeaderExt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

