/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAnnotator
extends OCVisitor
implements Annotator,
OCAnnotatorSink {
    public static final Key<Object> ALWAYS_ANNOTATE = Key.create((String)"ALWAYS_ANNOTATE");
    public static final String CIDR_DIAG = "CIDR";
    @Nullable
    private AnnotationHolder myHolder;
    private PsiElement myAnnotatingElement;

    @NotNull
    public static List<OCAnnotatorHelper> getAnnotatorHelpers() {
        List list = OCAnnotatorHelper.EP_NAME.getExtensionList();
        if (list == null) {
            OCAnnotator.$$$reportNull$$$0(0);
        }
        return list;
    }

    @InspectionMessage
    private static String getErrorAfterMacroSubstitution() {
        return OCInspectionsBundle.message("inspection.message.error.after.macro.substitution", new Object[0]);
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            OCAnnotator.$$$reportNull$$$0(2);
        }
        this.annotate(psiElement, holder, holder.getCurrentAnnotationSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @NotNull AnnotationSession session) {
        OCFile ocFile;
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(3);
        }
        if (session == null) {
            OCAnnotator.$$$reportNull$$$0(4);
        }
        if ((ocFile = OCLanguageUtils.asOCFile(session.getFile())) == null || psiElement.getContainingFile() != ocFile) {
            return;
        }
        Project project = ocFile.getProject();
        if (!OCAnnotator.isAnnotated(project, ocFile.getVirtualFile())) {
            return;
        }
        ocFile.pushAnnotationSession(session);
        this.myHolder = holder;
        this.myAnnotatingElement = psiElement;
        try {
            if (this.isEnabled(ocFile)) {
                this.myAnnotatingElement.accept((PsiElementVisitor)this);
            }
        }
        finally {
            this.myHolder = null;
            this.myAnnotatingElement = null;
            ocFile.popAnnotationSession();
        }
    }

    protected boolean isEnabled(@NotNull PsiFile file) {
        if (file == null) {
            OCAnnotator.$$$reportNull$$$0(5);
        }
        return true;
    }

    public static boolean isAnnotated(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(6);
        }
        return OCAnnotator.doIsAnnotated(project, file, true);
    }

    public static boolean isAnnotatedAsUserCode(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(7);
        }
        return OCAnnotator.doIsAnnotated(project, file, false);
    }

    private static boolean doIsAnnotated(@NotNull Project project, @Nullable VirtualFile file, boolean includingLibraries) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(8);
        }
        if (file == null || !OCLanguageUtils.isSupported(file)) {
            return false;
        }
        if (project.getUserData(ALWAYS_ANNOTATE) != null) {
            return true;
        }
        return includingLibraries ? OCSearchScope.isInProjectSourcesOrLibraries(project, file) : OCSearchScope.isInProjectSources(project, file);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull @NlsSafe String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(9);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(10);
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addErrorAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull @NlsSafe String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(11);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(12);
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCElement context = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCallArgument.class, OCDirective.class});
        if (context != null) {
            if (context instanceof OCDirective) {
                PsiElement headerToken = ((OCDirective)context).getHeaderToken();
                IElementType type = headerToken.getNode().getElementType();
                if (type != OCTokenTypes.ERROR_DIRECTIVE && type != OCTokenTypes.WARNING_DIRECTIVE) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (macroRange == null) {
            return this.addErrorAnnotation(range, inspectionClass, clangID, (String)message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addErrorAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, (String)message, highlightType);
            }
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (!((String)message).startsWith(OCAnnotator.getErrorAfterMacroSubstitution())) {
                message = OCAnnotator.getErrorAfterMacroSubstitution() + (String)message;
            }
            return this.addErrorAnnotation(macroCall, macroCall.getTextRange(), inspectionClass, clangID, (String)message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(macroRange.getArgumentRange(), inspectionClass, clangID, (String)message, highlightType);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull @NlsSafe String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(13);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(14);
        }
        if (this.myHolder == null || range == null || range.isEmpty()) {
            return null;
        }
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, clangID, inspectionClass);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case WARNING: {
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull @NlsSafe String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(15);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(16);
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @NonNls @Nullable String clangID, @NlsSafe @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(17);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(18);
        }
        if (element == null) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange == null) {
            return this.doAddWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addWarningAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            if (OCElementUtil.getRangeInMacroCall(this.myAnnotatingElement) == null) {
                return this.doAddWarningAnnotation(macroRange.getMacroCall(), macroRange.getMacroCall().getTextRange(), inspectionClass, clangID, message, highlightType);
            }
            return null;
        }
        return this.doAddWarningAnnotation(element, macroRange.getTextRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation doAddWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(19);
        }
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(20);
        }
        if (range == null || range.isEmpty()) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class) != null) {
            return null;
        }
        if (this.myHolder == null) {
            return null;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspectionClass, (PsiElement)element, (HighlightSeverity)HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return null;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, clangID, inspectionClass);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createAnnotation(highlightSeverity, range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file, @NotNull TextRange range, @Nullable String problemID, @NotNull Class<? extends OCInspection> inspectionClass) {
        OCClangMessageDescriptor descriptor;
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(21);
        }
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(22);
        }
        if (problemID == null) {
            return null;
        }
        String inspectionId = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionId == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionId, suppressionGroup, file, range);
    }

    private void setupAnnotation(@Nullable Annotation annotation, @Nullable ProblemHighlightType highlightType, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable OCProblemGroup problemGroup) {
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(23);
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, (IntentionAction)new EmptyIntentionAction(CidrLangUtil.getPrettyNameFromClassName(inspectionClass)));
            if (problemGroup != null) {
                annotation.setProblemGroup((ProblemGroup)problemGroup);
            }
            annotation.setHighlightType(highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @NotNull
    public static ProblemHighlightType getProblemHighlightType(@NotNull HighlightSeverity highlightSeverity, @NotNull ProblemHighlightType defaultHighlightType) {
        if (highlightSeverity == null) {
            OCAnnotator.$$$reportNull$$$0(24);
        }
        if (defaultHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(25);
        }
        ProblemHighlightType highlightType = defaultHighlightType;
        if (!highlightSeverity.equals((Object)HighlightSeverity.WARNING)) {
            if (highlightSeverity.equals((Object)HighlightSeverity.ERROR)) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.INFORMATION)) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.WEAK_WARNING)) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
        }
        ProblemHighlightType problemHighlightType = highlightType;
        if (problemHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(26);
        }
        return problemHighlightType;
    }

    @Override
    public void registerQuickFix(@Nullable Annotation annotation, @NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            OCAnnotator.$$$reportNull$$$0(27);
        }
        if (annotation != null) {
            if (intentionAction instanceof SuppressIntentionAction) {
                OCProblemGroup problemGroup = (OCProblemGroup)annotation.getProblemGroup();
                if (problemGroup != null) {
                    problemGroup.addSuppressAction((SuppressIntentionAction)intentionAction);
                }
            } else {
                Annotation.QuickFixInfo emptyFix;
                List quickFixes = annotation.getQuickFixes();
                Annotation.QuickFixInfo quickFixInfo = emptyFix = quickFixes != null ? (Annotation.QuickFixInfo)ContainerUtil.find((Iterable)quickFixes, info -> info.quickFix instanceof EmptyIntentionAction) : null;
                if (emptyFix != null) {
                    quickFixes.remove(emptyFix);
                }
                annotation.registerFix(intentionAction);
                if (intentionAction instanceof OCQuickFix && ((OCQuickFix)intentionAction).isSupportedInBatchMode() && ((OCQuickFix)intentionAction).isAvailable()) {
                    annotation.registerBatchFix((IntentionAction)((OCQuickFix)intentionAction), null, null);
                }
            }
        }
    }

    @Override
    public boolean highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
            return true;
        }
        return false;
    }

    @Override
    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(28);
        }
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(key).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHighlightType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatorHelpers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedAsUserCode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doIsAnnotated";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addErrorAnnotation";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addWarningAnnotation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doAddWarningAnnotation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProblemGroup";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setupAnnotation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getProblemHighlightType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFix";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

