/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.editor.OCTypingActionsExtension;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.HashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCLineIndentProvider
extends JavaLikeLangLineIndentProvider
implements JoinedLinesSpacingCalculator {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();
    private static final SemanticEditorPosition.Rule LINE_STARTER;
    private static boolean ourCanUseFormatterForIndent;
    private static final SemanticEditorPosition.SyntaxElement[] LEFTS;
    private static final SemanticEditorPosition.SyntaxElement[] RIGHTS;
    private static final IndentCalculator.BaseLineOffsetCalculator STRONG_LINE_BEFORE;

    public static void skipWhiteSpacesInLine(@NotNull HighlighterIterator it, @NotNull CharSequence sequence, boolean forward) {
        if (it == null) {
            OCLineIndentProvider.$$$reportNull$$$0(0);
        }
        if (sequence == null) {
            OCLineIndentProvider.$$$reportNull$$$0(1);
        }
        while (!it.atEnd() && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType()) && !OCLineIndentProvider.hasNewLine(sequence, it)) {
            if (forward) {
                it.advance();
                continue;
            }
            it.retreat();
        }
    }

    static boolean hasNewLine(@NotNull CharSequence sequence, @NotNull HighlighterIterator it) {
        if (sequence == null) {
            OCLineIndentProvider.$$$reportNull$$$0(2);
        }
        if (it == null) {
            OCLineIndentProvider.$$$reportNull$$$0(3);
        }
        return OCLineIndentProvider.containsNewLine(sequence, it.getStart(), it.getEnd());
    }

    @Contract(pure=true)
    static boolean containsNewLine(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            OCLineIndentProvider.$$$reportNull$$$0(4);
        }
        return start < end && StringUtil.contains((CharSequence)text, (int)start, (int)end, (char)'\n');
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            OCLineIndentProvider.$$$reportNull$$$0(5);
        }
        return OCLineIndentProvider.getSyntaxElement(tokenType);
    }

    @Nullable
    public static SemanticEditorPosition.SyntaxElement getSyntaxElement(@Nullable IElementType tokenType) {
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        if (language == null) {
            OCLineIndentProvider.$$$reportNull$$$0(6);
        }
        return OCLanguageUtils.isSupported(language);
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        CommonCodeStyleSettings commonCodeStyleSettings;
        SemanticEditorPosition beforeStart;
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(7);
        }
        if (blockStartPosition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(8);
        }
        if ((beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace)).isAtEnd()) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.NORMAL);
        }
        Editor editor = blockStartPosition.getEditor();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        boolean validSource = file != null && OCLanguageUtils.isSupported(language);
        OCCodeStyleSettings codeStyleSettings = validSource ? (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class) : null;
        CommonCodeStyleSettings commonCodeStyleSettings2 = commonCodeStyleSettings = validSource ? CodeStyle.getLanguageSettings((PsiFile)file) : null;
        if (validSource && (beforeStart.isAt((IElementType)OCTokenTypes.RBRACKET) || beforeStart.isAt((IElementType)OCTokenTypes.LPAR) || beforeStart.isAt((IElementType)OCTokenTypes.XOR))) {
            return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_INSIDE_CODE_BLOCK);
        }
        if (beforeStart.isAt((IElementType)OCTokenTypes.EQ) || beforeStart.isAt((IElementType)OCTokenTypes.AT)) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (validSource) {
            OCTypedHandlerDelegate.ContextType blockType = OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(beforeStart));
            switch (blockType) {
                case Namespace: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_NAMESPACE_MEMBERS);
                }
                case ClassCPP: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_CLASS_MEMBERS);
                }
                case StructLike: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_C_STRUCT_MEMBERS);
                }
                case SwitchStatement: {
                    return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonCodeStyleSettings.INDENT_CASE_FROM_SWITCH ? Indent.Type.NORMAL : Indent.Type.NONE));
                }
            }
        }
        return super.getIndentInBlock(project, language, blockStartPosition);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        if (statementBeforeSemicolon == null) {
            OCLineIndentProvider.$$$reportNull$$$0(9);
        }
        return statementBeforeSemicolon.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.ReturnLike);
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            OCLineIndentProvider.$$$reportNull$$$0(10);
        }
        return OCLineIndentProvider.isSwitchContext(OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position));
    }

    @Contract(pure=true)
    private static boolean isSwitchContext(@NotNull Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context) {
        SemanticEditorPosition editorPosition;
        if (context == null) {
            OCLineIndentProvider.$$$reportNull$$$0(11);
        }
        if ((editorPosition = (SemanticEditorPosition)context.first) == null) {
            return false;
        }
        SemanticEditorPosition.SyntaxElement element = editorPosition.getCurrElement();
        return element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCSElement.Identifier && context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement;
    }

    @NotNull
    public static Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> getColonAfterLabelCaseDefaultPublicContext(@NotNull SemanticEditorPosition finPos) {
        if (finPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(12);
        }
        if (!finPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                OCLineIndentProvider.$$$reportNull$$$0(13);
            }
            return pair;
        }
        SemanticEditorPosition maybeCaseDefaultPublic = finPos.copy();
        SemanticEditorPosition.SyntaxElement element = maybeCaseDefaultPublic.elementAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault, OCSElement.PublicLike});
        if (element != null) {
            Pair pair = Pair.create((Object)maybeCaseDefaultPublic, null);
            if (pair == null) {
                OCLineIndentProvider.$$$reportNull$$$0(14);
            }
            return pair;
        }
        SemanticEditorPosition maybeLabelId = finPos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
        if (maybeLabelId.getCurrElement() == OCSElement.Identifier && maybeLabelId.before().isAtMultiline(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            SemanticEditorPosition pos = maybeLabelId.copy();
            pos.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            if (!pos.isAtEnd()) {
                Pair pair = Pair.create((Object)maybeLabelId, (Object)((Object)OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(pos))));
                if (pair == null) {
                    OCLineIndentProvider.$$$reportNull$$$0(15);
                }
                return pair;
            }
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            OCLineIndentProvider.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    private static HighlighterIterator createEditorIteratorAtPosition(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(17);
        }
        HighlighterIterator highlighterIterator = pos.getEditor().getHighlighter().createIterator(pos.getStartOffset());
        if (highlighterIterator == null) {
            OCLineIndentProvider.$$$reportNull$$$0(18);
        }
        return highlighterIterator;
    }

    @Nullable
    private static OCLanguageKind getLanguageKind(@NotNull SemanticEditorPosition pos) {
        PsiFile file;
        Editor editor;
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(19);
        }
        if ((editor = pos.getEditor()).getProject() != null && editor instanceof EditorEx && ((EditorEx)editor).getVirtualFile() != null && OCLanguageUtils.isSupported(file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument()))) {
            return OCLanguageKindCalculator.calculateLanguageKindFast(((EditorEx)editor).getVirtualFile(), editor.getProject());
        }
        return null;
    }

    protected boolean isInsideForLikeConstruction(@NotNull SemanticEditorPosition finPos) {
        if (finPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(20);
        }
        return finPos.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    @NotNull
    protected SkipDirectivesHighlighterIterator getIteratorAtPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(21);
        }
        return new SkipDirectivesHighlighterIterator(editor, offset);
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        if (position == null) {
            OCLineIndentProvider.$$$reportNull$$$0(22);
        }
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !(!ignoreLabels ? position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.PublicLike, OCSElement.Identifier}) : position.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike));
    }

    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(24);
        }
        if (offset > 0) {
            String indent;
            Document document = editor.getDocument();
            int lineStart = DocumentUtil.getLineStartOffset((int)offset, (Document)document);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile source = psiDocumentManager.getPsiFile(document);
            if (source != null && ExternalFormatProcessor.useExternalFormatter((PsiFile)source) && OCTypingActionsExtension.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) != Boolean.TRUE && (indent = ExternalFormatProcessor.indentLine((PsiFile)source, (int)lineStart)) != null) {
                return indent;
            }
            CharSequence docText = document.getImmutableCharSequence();
            int endIndent = CharArrayUtil.shiftForward((CharSequence)docText, (int)lineStart, (String)" \t");
            if (endIndent < docText.length() && docText.charAt(endIndent) == '#') {
                return null;
            }
            return super.getLineIndent(project, editor, language, offset);
        }
        return "";
    }

    private static boolean isAlignFuncParamsOrArgs(@NotNull OCCodeStyleSettings customSettings, @NotNull SemanticEditorPosition maybeLeft) {
        SemanticEditorPosition beforeLP;
        if (customSettings == null) {
            OCLineIndentProvider.$$$reportNull$$$0(25);
        }
        if (maybeLeft == null) {
            OCLineIndentProvider.$$$reportNull$$$0(26);
        }
        if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) && (beforeLP = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})).isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Identifier, OCSElement.Gt})) {
            SemanticEditorPosition maybeRight = maybeLeft.copy().after();
            OCLineIndentProvider.moveToRightInBlockParenthesisForwardsSkippingNestedWithPredicate(maybeRight, self -> self.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis));
            if (maybeRight.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                SemanticEditorPosition afterRight = maybeRight.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
                if (afterRight.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    return customSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
                }
                OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(beforeLP, self -> self.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}));
                if (beforeLP.isAtEnd() || beforeLP.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon})) {
                    int offset;
                    OCCodeFragment fragment;
                    PsiElement elemBeforeLPar;
                    CharSequence docText = beforeLP.getEditor().getDocument().getCharsSequence();
                    int offsetBase = beforeLP.isAtEnd() ? 0 : beforeLP.getStartOffset() + 1;
                    String maybeFuncDeclText = docText.subSequence(offsetBase, maybeRight.getStartOffset() + 1).toString();
                    if (beforeLP.getEditor().getProject() != null && (elemBeforeLPar = (fragment = OCElementFactory.codeFragment(maybeFuncDeclText, beforeLP.getEditor().getProject(), null, false, false)).findElementAt(offset = maybeLeft.getStartOffset() - offsetBase)) != null && PsiTreeUtil.getParentOfType((PsiElement)elemBeforeLPar, OCFunctionDeclaration.class) != null) {
                        return customSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
                    }
                }
            }
            return customSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
        }
        return false;
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        SemanticEditorPosition maybeLineStarter;
        IndentCalculator indent;
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(28);
        }
        SemanticEditorPosition pos = this.getPosition(editor, offset);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)editor);
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        Document document = editor.getDocument();
        boolean inNewLineSpace = pos.matchesRule(LINE_STARTER);
        SemanticEditorPosition firstTokenAtNewLine = pos.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (inNewLineSpace) {
            SemanticEditorPosition secondToken = firstTokenAtNewLine.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if ((firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) && document.getLineNumber(offset + 1) == document.getLineNumber(firstTokenAtNewLine.getStartOffset())) {
                return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
        }
        if ((indent = super.getIndent(project, editor, language, offset)) != null) {
            return indent;
        }
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory myFactory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project, editor);
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions options = commonSettings.getIndentOptions();
        if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment) && offset == pos.findStartOf((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
            return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment));
        }
        if (inNewLineSpace) {
            SemanticEditorPosition lastTokenInLine = OCLineIndentProvider.getLastAnchorTokenInPrevLine(pos.before());
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, position -> lastTokenInLine.getStartOffset());
            }
            if (lastTokenInLine.isAtEnd() || lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment)) {
                if (lastTokenInLine.isAtEnd() && this.getIteratorAtPosition(editor, offset).isInDirective()) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_AFTER);
                }
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace})) {
                return this.getIndent(project, editor, language, this.getBlockStatementStartOffset(lastTokenInLine));
            }
            if (lastTokenInLine.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && pos.after().afterOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At).isAt((IElementType)OCTokenTypes.STRING_LITERAL)) {
                return this.getAlignWithPrevLiteralIndent(project, editor, document, lastTokenInLine);
            }
            Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(lastTokenInLine);
            if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                    return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_CLASS_MEMBERS);
                }
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.Identifier && options != null) {
                    SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore((SemanticEditorPosition)context.first);
                    if (element != null) {
                        return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                    }
                    return this.createInBlockSpaceIndentCalculator(project, editor, options.INDENT_SIZE + (context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement && commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0));
                }
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                return myFactory.createIndentCalculator(this.getIndentInBlock(project, language, lastTokenInLine.before()), arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0));
            }
            if (lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.StructLike}) && !lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Typedef})) {
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition testEqAnchor = lastTokenInLine;
            SemanticEditorPosition maybeLeft = lastTokenInLine.copy();
            maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, self -> self.isAtMultiline());
            if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket)) {
                testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
            } else {
                maybeLeft = lastTokenInLine.copy();
                maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, self -> self.isAtMultiline());
                if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
                }
            }
            if (OCLineIndentProvider.isEqLikeOnLineBefore(testEqAnchor)) {
                IndentCalculator it;
                if (OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) && (it = this.getAlignIndentCalculator(project, editor, document, maybeLeft)) != null) {
                    return it;
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (OCLineIndentProvider.isTemplateLikeOnLineBefore(lastTokenInLine)) {
                SemanticEditorPosition after2 = lastTokenInLine.after().afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
                if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                if (lastTokenInLine.isAt((IElementType)OCTokenTypes.GT) || lastTokenInLine.isAt((IElementType)OCTokenTypes.GTGT)) {
                    if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    if (OCLineIndentProvider.isLikeFunctionDecl(after2)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                maybeLeft = OCLineIndentProvider.findLeftBracketInLine(lastTokenInLine);
                if (maybeLeft.isAtAnyOf(LEFTS)) {
                    IndentCalculator it;
                    if ((OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) || OCLineIndentProvider.isAlignFuncParamsOrArgs(customSettings, maybeLeft)) && (it = this.getAlignIndentCalculator(project, editor, document, maybeLeft)) != null) {
                        return it;
                    }
                    return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
        }
        if ((maybeLineStarter = OCLineIndentProvider.getLineStarterBeforeFirstStringOnLine(pos)) != null) {
            return this.getAlignWithPrevLiteralIndent(project, editor, document, maybeLineStarter.before());
        }
        Pair<Boolean, Boolean> needSpecialIndentAndInsideVAR = OCLineIndentProvider.getNeedSpecialIndentAndInsideIVAR(pos);
        if (((Boolean)needSpecialIndentAndInsideVAR.first).booleanValue()) {
            int indentSize = (Boolean)needSpecialIndentAndInsideVAR.second != false && customSettings.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK ? customSettings.INDENT_VISIBILITY_KEYWORDS : customSettings.INDENT_VISIBILITY_KEYWORDS + customSettings.INDENT_INTERFACE_MEMBERS;
            return this.createInBlockSpaceIndentCalculator(project, editor, indentSize);
        }
        Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(pos.copy());
        if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
            if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
            if (options != null) {
                SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore(((SemanticEditorPosition)context.first).before());
                if (element != null) {
                    return new IndentCalculator(project, editor, STRONG_LINE_BEFORE, OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonSettings.INDENT_CASE_FROM_SWITCH && element == OCSElement.Switch ? Indent.Type.NORMAL : Indent.Type.NONE)));
                }
                if (OCLineIndentProvider.isSwitchContext(context)) {
                    return this.createInBlockSpaceIndentCalculator(project, editor, commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0);
                }
                return options.LABEL_INDENT_ABSOLUTE ? this.createAbsoluteSpaceIndentCalculator(project, editor, options.LABEL_INDENT_SIZE) : this.createInBlockSpaceIndentCalculator(project, editor, options.INDENT_SIZE + options.LABEL_INDENT_SIZE);
            }
        }
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(pos)) ? null : myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    @NotNull
    public static Pair<Boolean, Boolean> getNeedSpecialIndentAndInsideIVAR(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(29);
        }
        if (pos.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) && pos.before().matchesRule(LINE_STARTER)) {
            SemanticEditorPosition after2 = pos.after();
            SemanticEditorPosition afterWhitespace = after2.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            boolean isInsideIVAR = pos.beforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace).isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Interface});
            if (afterWhitespace.getCurrElement() == OCSElement.PublicLike || isInsideIVAR && (afterWhitespace.isAtEnd() || after2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && after2.isAtMultiline())) {
                Pair pair = Pair.create((Object)true, (Object)isInsideIVAR);
                if (pair == null) {
                    OCLineIndentProvider.$$$reportNull$$$0(30);
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)false, (Object)false);
        if (pair == null) {
            OCLineIndentProvider.$$$reportNull$$$0(31);
        }
        return pair;
    }

    private static boolean isAlignCollectionStarter(@NotNull CommonCodeStyleSettings commonSettings, @NotNull SemanticEditorPosition maybeLeft) {
        if (commonSettings == null) {
            OCLineIndentProvider.$$$reportNull$$$0(32);
        }
        if (maybeLeft == null) {
            OCLineIndentProvider.$$$reportNull$$$0(33);
        }
        return maybeLeft.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket}) && commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION;
    }

    @Nullable
    private IndentCalculator getAlignIndentCalculator(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull SemanticEditorPosition anyLeftBracket) {
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(34);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(35);
        }
        if (document == null) {
            OCLineIndentProvider.$$$reportNull$$$0(36);
        }
        if (anyLeftBracket == null) {
            OCLineIndentProvider.$$$reportNull$$$0(37);
        }
        HighlighterIterator it = OCLineIndentProvider.createEditorIteratorAtPosition(anyLeftBracket.after());
        OCLineIndentProvider.skipWhiteSpacesInLine(it, anyLeftBracket.getChars(), true);
        if (!it.atEnd() && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType())) {
            return this.createAbsoluteSpaceIndentCalculator(project, editor, OCLineIndentProvider.getOffsetInLine(project, document, it.getStart()));
        }
        return null;
    }

    @NotNull
    private static SemanticEditorPosition findLeftBracketInLine(@NotNull SemanticEditorPosition inSeqPos) {
        if (inSeqPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(38);
        }
        SemanticEditorPosition copy2 = inSeqPos.copy();
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(copy2, self -> self.isAtAnyOf(LEFTS) || self.isAtMultiline());
        SemanticEditorPosition semanticEditorPosition = copy2;
        if (semanticEditorPosition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(39);
        }
        return semanticEditorPosition;
    }

    @NotNull
    private static SemanticEditorPosition getLastAnchorTokenInPrevLine(@NotNull SemanticEditorPosition positionBeforeNewLine) {
        if (positionBeforeNewLine == null) {
            OCLineIndentProvider.$$$reportNull$$$0(40);
        }
        while (!positionBeforeNewLine.isAtEnd() && !positionBeforeNewLine.isAtMultiline() && positionBeforeNewLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            positionBeforeNewLine.moveBefore();
        }
        SemanticEditorPosition semanticEditorPosition = positionBeforeNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) ? positionBeforeNewLine.after() : positionBeforeNewLine;
        if (semanticEditorPosition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(41);
        }
        return semanticEditorPosition;
    }

    protected int getBlockStatementStartOffset(@NotNull SemanticEditorPosition originalPos) {
        if (originalPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(42);
        }
        if (originalPos.isAtEnd()) {
            return 0;
        }
        SemanticEditorPosition position = originalPos.copy();
        if (originalPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
            position.moveAfter();
        }
        int originalStatementOffset = super.getBlockStatementStartOffset(position);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)position.getEditor());
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        SemanticEditorPosition originalBlockAnchor = this.getPosition(position.getEditor(), originalStatementOffset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (originalBlockAnchor.isAtEnd() || originalBlockAnchor.before().isAtEnd() || originalPos.getStartOffset() == originalBlockAnchor.getStartOffset()) {
            return originalStatementOffset;
        }
        if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
            SemanticEditorPosition ipos = originalPos.copy();
            ipos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset());
            SemanticEditorPosition kpos = ipos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) ? ipos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}) : originalPos.copy();
            SemanticEditorPosition spos = kpos.copy();
            kpos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset() || pos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis));
            if (kpos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                while (!kpos.isAtEnd() && kpos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (kpos.before().matchesRule(LINE_STARTER)) {
                        return kpos.getStartOffset();
                    }
                    kpos.moveBefore();
                }
            } else {
                boolean beforeStruct = false;
                while (!spos.isAtEnd() && spos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (spos.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        beforeStruct = true;
                    }
                    if (spos.before().matchesRule(LINE_STARTER) && beforeStruct) {
                        return spos.getStartOffset();
                    }
                    spos.moveBefore();
                }
            }
        } else if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
            SemanticEditorPosition before = originalBlockAnchor.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (before.isAtEnd() || before.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace}) || before.getStartOffset() >= position.getStartOffset()) {
                return originalStatementOffset;
            }
            SemanticEditorPosition move = before.copy();
            if (move.after().isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
                move.moveAfter();
            }
            int offset = this.getBlockStatementStartOffset(move);
            SemanticEditorPosition blockAnchor = this.getPosition(position.getEditor(), offset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            int nextLineStyleAfterBrace = blockAnchor.isAtEnd() ? 4 : (blockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike) ? commonSettings.CLASS_BRACE_STYLE : (blockAnchor.isAt((IElementType)OCTokenTypes.NAMESPACE_CPP_KEYWORD) ? customSettings.NAMESPACE_BRACE_PLACEMENT : (blockAnchor.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword}) ? commonSettings.BRACE_STYLE : customSettings.FUNCTION_BRACE_PLACEMENT)));
            return nextLineStyleAfterBrace == 4 ? originalStatementOffset : offset;
        }
        return originalStatementOffset;
    }

    @NotNull
    private IndentCalculator getAlignWithPrevLiteralIndent(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull SemanticEditorPosition lastTokenInLine) {
        SemanticEditorPosition maybeAt;
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(43);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(44);
        }
        if (document == null) {
            OCLineIndentProvider.$$$reportNull$$$0(45);
        }
        if (lastTokenInLine == null) {
            OCLineIndentProvider.$$$reportNull$$$0(46);
        }
        SemanticEditorPosition anchor = (maybeAt = lastTokenInLine.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})).isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) ? maybeAt : lastTokenInLine;
        Lexer lexer = OCLineIndentProvider.getLexerAtOffset(anchor.getStartOffset() + 1, document.getCharsSequence());
        return this.createAbsoluteSpaceIndentCalculator(project, editor, OCLineIndentProvider.getOffsetInLine(project, document, lexer.getTokenStart()));
    }

    @TestOnly
    public static boolean setCanUseFormatterForIndent(boolean suggest) {
        boolean oldValue = ourCanUseFormatterForIndent;
        ourCanUseFormatterForIndent = suggest;
        return oldValue;
    }

    private static boolean canUseFormatterForIndentProcessing(@Nullable OCLanguageKind kind) {
        if (kind == null || kind.isObjC()) {
            return !Registry.is((String)"cidr.indent.lexer.only.objc");
        }
        return ourCanUseFormatterForIndent && !Registry.is((String)"cidr.indent.lexer.only.cpp");
    }

    private static int getOffsetInLine(@NotNull Project project, @NotNull Document document, int start) {
        CharSequence indent;
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(47);
        }
        if (document == null) {
            OCLineIndentProvider.$$$reportNull$$$0(48);
        }
        if (!StringUtil.contains((CharSequence)(indent = document.getCharsSequence().subSequence(document.getLineStartOffset(document.getLineNumber(start)), start)), (CharSequence)"\t")) {
            return start - document.getLineStartOffset(document.getLineNumber(start));
        }
        int tabSize = 4;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null) {
            tabSize = CodeStyle.getIndentOptions((PsiFile)file).TAB_SIZE;
        }
        int size = 0;
        for (int i2 = 0; i2 < indent.length(); ++i2) {
            size += indent.charAt(i2) == '\t' ? tabSize : 1;
        }
        return size;
    }

    private static boolean isLikeFunctionDecl(@NotNull SemanticEditorPosition maybeFuncStart) {
        if (maybeFuncStart == null) {
            OCLineIndentProvider.$$$reportNull$$$0(49);
        }
        if (maybeFuncStart.isAtEnd()) {
            return false;
        }
        CharSequence chars = maybeFuncStart.getChars();
        HighlighterIterator position = OCLineIndentProvider.createEditorIteratorAtPosition(maybeFuncStart);
        while (!position.atEnd() && !OCLineIndentProvider.containsNewLine(chars, position.getStart(), position.getEnd())) {
            IElementType type = position.getTokenType();
            if (type == OCTokenTypes.SEMICOLON || type == OCTokenTypes.RPAR) {
                return false;
            }
            if (type == OCTokenTypes.LPAR) {
                return true;
            }
            position.advance();
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getColonOrSwitchInNonBlockSwitchOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(50);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Colon, OCSElement.Switch});
    }

    private static boolean isEqLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(51);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.EqualLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma}) == OCSElement.EqualLike;
    }

    private static boolean isTemplateLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(52);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.TemplateLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}) == OCSElement.TemplateLike;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getElementsOnLineBefore(@NotNull SemanticEditorPosition pos, SemanticEditorPosition.SyntaxElement ... syntaxElements) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(53);
        }
        if (syntaxElements == null) {
            OCLineIndentProvider.$$$reportNull$$$0(54);
        }
        SemanticEditorPosition position = pos.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(position, self -> self.isAtAnyOf(syntaxElements) || self.isAtMultiline());
        return position.isAtAnyOf(syntaxElements) ? position.getCurrElement() : null;
    }

    private static void moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SemanticEditorPosition pos, @NotNull Predicate<SemanticEditorPosition> terminationCondition) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(55);
        }
        if (terminationCondition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(56);
        }
        block0: while (!pos.isAtEnd() && !terminationCondition.test(pos)) {
            for (int i2 = 0; i2 < LEFTS.length; ++i2) {
                if (!pos.isAt(RIGHTS[i2])) continue;
                pos.moveBeforeParentheses(LEFTS[i2], RIGHTS[i2]);
                continue block0;
            }
            if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) break;
            pos.moveBefore();
        }
    }

    private static void moveToRightInBlockParenthesisForwardsSkippingNestedWithPredicate(@NotNull SemanticEditorPosition pos, @NotNull Predicate<SemanticEditorPosition> terminationCondition) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(57);
        }
        if (terminationCondition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(58);
        }
        block0: while (!pos.isAtEnd() && !terminationCondition.test(pos)) {
            for (int i2 = 0; i2 < RIGHTS.length; ++i2) {
                if (!pos.isAt(LEFTS[i2])) continue;
                pos.moveAfterParentheses(LEFTS[i2], RIGHTS[i2]);
                continue block0;
            }
            if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) break;
            pos.moveAfter();
        }
    }

    @NotNull
    private IndentCalculator createInBlockSpaceIndentCalculator(@NotNull Project project, @NotNull Editor editor, int spaces) {
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(59);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(60);
        }
        return new IndentCalculator(project, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false));
    }

    @NotNull
    private IndentCalculator createAbsoluteSpaceIndentCalculator(@NotNull Project project, @NotNull Editor editor, int spaces) {
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(61);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(62);
        }
        return new IndentCalculator(project, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false)){

            @NotNull
            protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
                if (currPosition == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$1", "getBaseIndent"));
            }
        };
    }

    @NotNull
    public static Lexer getLexerAtOffset(int offset, CharSequence text) {
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault();
        lexer.start(text);
        while (lexer.getTokenEnd() < offset) {
            lexer.advance();
        }
        OCLexerWithDirectives oCLexerWithDirectives = lexer;
        if (oCLexerWithDirectives == null) {
            OCLineIndentProvider.$$$reportNull$$$0(63);
        }
        return oCLexerWithDirectives;
    }

    @Nullable
    public static SemanticEditorPosition getLineStarterBeforeFirstStringOnLine(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(64);
        }
        SemanticEditorPosition maybeLineStarter = pos.before().beforeOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At);
        return pos.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && maybeLineStarter.matchesRule(LINE_STARTER) && maybeLineStarter.before().isAt((IElementType)OCTokenTypes.STRING_LITERAL) ? maybeLineStarter : null;
    }

    public int getJoinedLinesSpacing(@NotNull Project project, @NotNull Editor editor, Language language, int offset) {
        if (project == null) {
            OCLineIndentProvider.$$$reportNull$$$0(65);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(66);
        }
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(this.getPosition(editor, offset))) ? -1 : 0;
    }

    static {
        SYNTAX_MAP.put(TokenType.WHITE_SPACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put(OCTokenTypes.SEMICOLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put(OCTokenTypes.LBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put(OCTokenTypes.RBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put(OCTokenTypes.LBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put(OCTokenTypes.RBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put(OCTokenTypes.RPAR, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put(OCTokenTypes.LPAR, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put(OCTokenTypes.COLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put(OCTokenTypes.CASE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put(OCTokenTypes.DEFAULT_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put(OCTokenTypes.IF_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put(OCTokenTypes.WHILE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put(OCTokenTypes.CATCH_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put(OCTokenTypes.ELSE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put(OCTokenTypes.FOR_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put(OCTokenTypes.DO_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put(OCTokenTypes.BLOCK_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put(OCTokenTypes.COMMA, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put(OCTokenTypes.GT, OCSElement.Gt);
        SYNTAX_MAP.put(OCTokenTypes.LT, OCSElement.Lt);
        SYNTAX_MAP.put(OCTokenTypes.EOL_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put(OCTokenTypes.TRY_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
        SYNTAX_MAP.put(OCTokenTypes.STRUCT_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put(OCTokenTypes.CLASS_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put(OCTokenTypes.ENUM_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put(OCTokenTypes.UNION_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put(OCTokenTypes.INTERFACE_KEYWORD, OCSElement.Interface);
        SYNTAX_MAP.put(OCTokenTypes.IDENTIFIER, OCSElement.Identifier);
        SYNTAX_MAP.put(OCTokenTypes.RETURN_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put(OCTokenTypes.BREAK_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put(OCTokenTypes.CONTINUE_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put(OCTokenTypes.PUBLIC_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.PROTECTED_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.PRIVATE_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.PACKAGE_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.OPTIONAL_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.REQUIRED_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put(OCTokenTypes.EOL_ESCAPE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put(OCTokenTypes.TYPEDEF_KEYWORD, OCSElement.Typedef);
        SYNTAX_MAP.put(OCTokenTypes.SWITCH_KEYWORD, OCSElement.Switch);
        for (IElementType type : OCTokenTypes.ASSIGNMENT_OPERATIONS.getTypes()) {
            SYNTAX_MAP.put(type, OCSElement.EqualLike);
        }
        for (IElementType type : OCFormatterUtil.FORMAT_DIRECTIVES.getTypes()) {
            SYNTAX_MAP.put(type, OCSElement.DirectiveLike);
        }
        SYNTAX_MAP.put(OCTokenTypes.TEMPLATE_CPP_KEYWORD, OCSElement.TemplateLike);
        SYNTAX_MAP.put(OCTokenTypes.AT, OCSElement.At);
        LINE_STARTER = position -> position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && position.isAtMultiline();
        ourCanUseFormatterForIndent = !ApplicationManager.getApplication().isUnitTestMode();
        LEFTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis};
        RIGHTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis};
        STRONG_LINE_BEFORE = new IndentCalculator.BaseLineOffsetCalculator(){

            public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
                if (currPosition == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document document = currPosition.getEditor().getDocument();
                int lineNo = document.getLineNumber(currPosition.getStartOffset());
                return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)document.getLineEndOffset(lineNo == 0 ? 0 : lineNo - 1), (String)" \t\n\r");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$2", "getOffsetInBaseIndentLine"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 39: 
            case 41: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 39: 
            case 41: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: 
            case 23: 
            case 27: 
            case 34: 
            case 43: 
            case 47: 
            case 59: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStartPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementBeforeSemicolon";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finPos";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 39: 
            case 41: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider";
                break;
            }
            case 17: 
            case 19: 
            case 29: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 21: 
            case 24: 
            case 28: 
            case 35: 
            case 44: 
            case 60: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettings";
                break;
            }
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeLeft";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 36: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyLeftBracket";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSeqPos";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionBeforeNewLine";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPos";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastTokenInLine";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeFuncStart";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColonAfterLabelCaseDefaultPublicContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorIteratorAtPosition";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNeedSpecialIndentAndInsideIVAR";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findLeftBracketInLine";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAnchorTokenInPrevLine";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexerAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "skipWhiteSpacesInLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasNewLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsNewLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForLanguage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dropIndentAfterReturnLike";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isColonAfterLabelOrCase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSwitchContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColonAfterLabelCaseDefaultPublicContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 39: 
            case 41: 
            case 63: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditorIteratorAtPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageKind";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInsideForLikeConstruction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorAtPosition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isIndentProvider";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAlignFuncParamsOrArgs";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNeedSpecialIndentAndInsideIVAR";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAlignCollectionStarter";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAlignIndentCalculator";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findLeftBracketInLine";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLastAnchorTokenInPrevLine";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBlockStatementStartOffset";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAlignWithPrevLiteralIndent";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInLine";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isLikeFunctionDecl";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getColonOrSwitchInNonBlockSwitchOnLineBefore";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isEqLikeOnLineBefore";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateLikeOnLineBefore";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOnLineBefore";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "moveToRightInBlockParenthesisForwardsSkippingNestedWithPredicate";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createInBlockSpaceIndentCalculator";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createAbsoluteSpaceIndentCalculator";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getLineStarterBeforeFirstStringOnLine";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getJoinedLinesSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 39: 
            case 41: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class SkipDirectivesHighlighterIterator
    extends HighlighterIteratorWrapper {
        final Editor myEditor;

        SkipDirectivesHighlighterIterator(@NotNull Editor editor, int offset) {
            if (editor == null) {
                SkipDirectivesHighlighterIterator.$$$reportNull$$$0(0);
            }
            super(editor.getHighlighter().createIterator(offset));
            this.myEditor = editor;
        }

        public void advance() {
            super.advance();
            CharSequence sequence = this.getDocument().getCharsSequence();
            while (this.isInDirective()) {
                while (this.atTheSameLine(sequence)) {
                    super.advance();
                }
                super.advance();
            }
        }

        public void retreat() {
            super.retreat();
            CharSequence sequence = this.getDocument().getCharsSequence();
            while (this.isInDirective()) {
                while (this.atTheSameLine(sequence)) {
                    super.retreat();
                }
                super.retreat();
            }
        }

        boolean atTheSameLine(CharSequence sequence) {
            return !this.atEnd() && !StringUtil.contains((CharSequence)sequence, (int)this.getStart(), (int)this.getEnd(), (char)'\n');
        }

        boolean isInDirective() {
            HighlighterIterator maybePrevEOL;
            if (this.atEnd()) {
                return false;
            }
            if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(this.getTokenType())) {
                return true;
            }
            Document document = this.getDocument();
            int offset = document.getLineStartOffset(document.getLineNumber(this.getStart()));
            if (offset < 0) {
                return false;
            }
            if (offset - 2 > 0 && !(maybePrevEOL = this.myEditor.getHighlighter().createIterator(offset - 2)).atEnd() && maybePrevEOL.getTokenType() == OCTokenTypes.EOL_ESCAPE) {
                return true;
            }
            HighlighterIterator maybeNextDirective = this.myEditor.getHighlighter().createIterator(offset);
            while (!maybeNextDirective.atEnd() && OCTokenTypes.WHITESPACES.contains(maybeNextDirective.getTokenType())) {
                maybeNextDirective.advance();
            }
            return !maybeNextDirective.atEnd() && OCFormatterUtil.FORMAT_DIRECTIVES.contains(maybeNextDirective.getTokenType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$SkipDirectivesHighlighterIterator", "<init>"));
        }
    }

    public static enum OCSElement implements SemanticEditorPosition.SyntaxElement
    {
        StructLike,
        Interface,
        ReturnLike,
        DirectiveLike,
        Identifier,
        PublicLike,
        EqualLike,
        At,
        Lt,
        Gt,
        TemplateLike,
        Switch,
        Typedef;

    }
}

