/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockOwner;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class MissingClassNamespaceBodyFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        boolean isStruct;
        if (editor == null) {
            MissingClassNamespaceBodyFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            MissingClassNamespaceBodyFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            MissingClassNamespaceBodyFixer.$$$reportNull$$$0(2);
        }
        if (OCElementUtil.isMissingSemicolonError(psiElement) && OCElementUtil.getElementType(psiElement.getParent()) == OCElementTypes.DECLARATION && psiElement.getParent().getFirstChild().getFirstChild() != null) {
            psiElement = psiElement.getParent().getFirstChild().getFirstChild();
        }
        if ((isStruct = psiElement instanceof OCStructLike) || psiElement instanceof OCCppNamespace) {
            OCBlockOwner block = (OCBlockOwner)psiElement;
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)psiElement).getNameIdentifier();
            if (nameIdentifier != null) {
                PsiErrorElement error;
                PsiElement lBrace = block.getOpeningBrace();
                PsiElement rBrace = block.getClosingBrace();
                if (lBrace == null && rBrace == null && isStruct && (MissingClassNamespaceBodyFixer.getSemicolonInsertionOffset(editor, block) == -1 || MissingClassNamespaceBodyFixer.isLikeStructVarDeclaration(block) || OCElementUtil.getElementType(MissingClassNamespaceBodyFixer.getPrevEssentialLeaf(block.getNode())) == OCTokenTypes.TYPEDEF_KEYWORD || block.getParent().getParent() instanceof OCParameterDeclaration)) {
                    return;
                }
                final int[] blockInsertionPos = new int[]{OCChangeUtil.getRangeWithMacros(block).getEndOffset()};
                if (isStruct && (error = (PsiErrorElement)PsiTreeUtil.findChildOfType((PsiElement)psiElement, PsiErrorElement.class)) != null) {
                    boolean noBaseClauseElement = OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "Base clause element expected");
                    if (noBaseClauseElement) {
                        ASTNode essentialLeaf = MissingClassNamespaceBodyFixer.getPrevEssentialLeaf(error.getNode());
                        if (essentialLeaf != null) {
                            blockInsertionPos[0] = MissingClassNamespaceBodyFixer.getRangeWithMacros(essentialLeaf).getEndOffset();
                            processor.registerUnresolvedError(blockInsertionPos[0]);
                        }
                    } else if (!(OCElementUtil.isMissingSemicolonError((PsiElement)error) || OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "Unexpected end of file") || OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "Syntax error") || OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "Expecting '{'") || OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "} expected"))) {
                        return;
                    }
                }
                Document doc = editor.getDocument();
                if (lBrace == null) {
                    if (isStruct && !MissingClassNamespaceBodyFixer.endsTheLine(block.getNode())) {
                        block.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitElement(@NotNull PsiElement element) {
                                if (element == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (OCFixer.endsTheLine(element.getNode())) {
                                    blockInsertionPos[0] = OCChangeUtil.getRangeWithMacros(element).getEndOffset();
                                    this.stopWalking();
                                }
                                super.visitElement(element);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/editor/smartEnter/MissingClassNamespaceBodyFixer$1", "visitElement"));
                            }
                        });
                    }
                    editor.getCaretModel().moveToOffset(blockInsertionPos[0]);
                    doc.insertString(blockInsertionPos[0], (CharSequence)(isStruct ? "{};" : "{}"));
                } else {
                    MissingClassNamespaceBodyFixer.fixBlockIfNeed(editor, block, false);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/smartEnter/MissingClassNamespaceBodyFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

