/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.OCTokenSeparatorGenerator;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCFormatProcessor;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMacroBlock;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCSpacingProcessor
extends OCFormatProcessor {
    private static final TokenSet KEYWORD_WITH_LIST = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.OBJC_KEYWORD, OCTokenTypes.NOEXCEPT_KEYWORD, OCTokenTypes.THROW_KEYWORD, OCTokenTypes.TYPEOF_KEYWORD, OCTokenTypes.DECLTYPE_CPP_KEYWORD, OCTokenTypes.TYPEID_CPP_KEYWORD, OCTokenTypes.SIZEOF_KEYWORD, OCTokenTypes.STATIC_ASSERT_KEYWORD, OCTokenTypes.STATIC_ASSERT_C_KEYWORD, OCTokenTypes.ALIGNOF_KEYWORD, OCTokenTypes.ALIGNAS_KEYWORD, OCTokenTypes.ALIGNAS_CPP_KEYWORD, OCTokenTypes.ALIGNOF_CPP_KEYWORD, OCTokenTypes.__UUIDOF_CPP_KEYWORD});
    private final ASTNode nodeLeft;
    private final ASTNode nodeRight;
    private final IElementType typeLeft;
    private final IElementType typeRight;
    private final IElementType lastLeafTypeLeft;
    private final IElementType firstLeafTypeRight;
    private boolean isDependent;
    private TextRange dependentRange;
    private Boolean hasSpace;
    private int minLineFeeds;
    private Integer keepBlankLines;
    private boolean keepLineBreaks;
    private static final ArrayList[] MANDATORY_SPACE_PAIR = new ArrayList[]{ContainerUtil.newArrayList((Object[])new OCPunctuatorElementType[]{OCTokenTypes.PLUS, OCTokenTypes.MINUS, OCTokenTypes.PLUSPLUS, OCTokenTypes.MINUSMINUS}), ContainerUtil.newArrayList((Object[])new OCPunctuatorElementType[]{OCTokenTypes.AND, OCTokenTypes.ANDAND, OCTokenTypes.OR, OCTokenTypes.OROR}), ContainerUtil.newArrayList((Object[])new OCPunctuatorElementType[]{OCTokenTypes.COLON, OCTokenTypes.COLON2X})};

    OCSpacingProcessor(@NotNull CommonCodeStyleSettings settings, @NotNull OCCodeStyleSettings ocSettings, @NotNull ASTNode node, @NotNull ASTNode childLeft, @NotNull ASTNode childRight) {
        if (settings == null) {
            OCSpacingProcessor.$$$reportNull$$$0(0);
        }
        if (ocSettings == null) {
            OCSpacingProcessor.$$$reportNull$$$0(1);
        }
        if (node == null) {
            OCSpacingProcessor.$$$reportNull$$$0(2);
        }
        if (childLeft == null) {
            OCSpacingProcessor.$$$reportNull$$$0(3);
        }
        if (childRight == null) {
            OCSpacingProcessor.$$$reportNull$$$0(4);
        }
        super(settings, ocSettings, node);
        this.nodeLeft = childLeft;
        this.nodeRight = childRight;
        this.typeLeft = this.nodeLeft.getElementType();
        this.typeRight = this.nodeRight.getElementType();
        ASTNode lastLeafNodeLeft = TreeUtil.findLastLeaf((ASTNode)this.nodeLeft);
        LeafElement firstLeafNodeRight = TreeUtil.findFirstLeaf((ASTNode)this.nodeRight);
        this.lastLeafTypeLeft = OCElementUtil.getElementType(lastLeafNodeLeft);
        this.firstLeafTypeRight = OCElementUtil.getElementType((ASTNode)firstLeafNodeRight);
        this.keepLineBreaks = settings.KEEP_LINE_BREAKS;
    }

    @Nullable
    public Spacing getResult(boolean needSpace, boolean forbiddenNewLine) {
        int keepLines;
        int minSpaces;
        boolean formatted;
        if (OCFormatterUtil.isSynthetic(this.nodeLeft) || OCFormatterUtil.isSynthetic(this.nodeRight)) {
            return null;
        }
        if (this.thisType == OCElementTypes.OBJC_ERROR_KEYWORD) {
            return null;
        }
        if (OCTokenTypes.COMMENTS.contains(this.typeLeft) || OCTokenTypes.COMMENTS.contains(this.typeRight)) {
            return null;
        }
        if (this.thisType != OCElementTypes.MACRO_PARAMETER_LIST && TreeUtil.findParent((ASTNode)this.nodeLeft, (IElementType)OCElementTypes.MACRO_DEFINITION) != null) {
            return null;
        }
        if (OCSpacingProcessor.isInsideDirective(this.nodeRight.getFirstChildNode()) ^ OCSpacingProcessor.isInsideDirective(this.nodeLeft.getLastChildNode())) {
            this.minLineFeeds = 1;
        }
        if (!(formatted = this.calcWrapping() | this.calcBlankLines() | this.calcSpaces())) {
            return null;
        }
        this.calcKeepLines();
        int n = needSpace ? 1 : (this.hasSpace == null ? 0 : (minSpaces = this.hasSpace != false ? 1 : 0));
        int maxSpaces = this.hasSpace == null ? 1 : (this.hasSpace != false ? 1 : 0);
        int n2 = keepLines = this.keepBlankLines == null ? -1 : this.keepBlankLines;
        if (forbiddenNewLine || OCFormatterUtil.FORMAT_CONTENTS.contains(this.typeRight)) {
            this.isDependent = false;
            this.keepLineBreaks = true;
            this.minLineFeeds = 0;
        }
        if (this.ocSettings.DO_NOT_ADD_BREAKS) {
            this.isDependent = false;
            this.minLineFeeds = 0;
        }
        if (this.isDependent) {
            if (this.dependentRange == null) {
                this.dependentRange = this.thisNode.getTextRange();
            }
            assert (this.minLineFeeds >= 1);
            return Spacing.createDependentLFSpacing((int)minSpaces, (int)maxSpaces, (TextRange)this.dependentRange, (boolean)this.keepLineBreaks, (int)keepLines, (DependentSpacingRule)(this.minLineFeeds == 1 ? DependentSpacingRule.DEFAULT : new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, this.minLineFeeds)));
        }
        return Spacing.createSpacing((int)minSpaces, (int)maxSpaces, (int)this.minLineFeeds, (boolean)this.keepLineBreaks, (int)keepLines);
    }

    private boolean doWrappingCommaAction(boolean inContext, boolean commaOnNextLine) {
        return inContext && (this.typeLeft == OCTokenTypes.COMMA && commaOnNextLine || this.typeRight == OCTokenTypes.COMMA && !commaOnNextLine);
    }

    private boolean doWrappingCommaAction() {
        return this.doWrappingCommaAction(this.thisType == OCElementTypes.PARAMETER_LIST, this.ocSettings.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.ARGUMENT_LIST || this.thisType == OCElementTypes.MACRO_CALL, this.ocSettings.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.ENUM, this.ocSettings.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST, this.ocSettings.TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST, this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST, this.ocSettings.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(this.thisType == OCElementTypes.CPP_LAMBDA_INTRODUCER, this.ocSettings.LAMBDA_CAPTURE_LIST_COMMA_ON_NEXT_LINE) || this.doWrappingCommaAction(OCFormatterUtil.isCollectionOrStructureInitializer(this.thisType), this.ocSettings.ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE);
    }

    private boolean calcWrapping() {
        if (this.needNewLineBeforeAndAfter()) {
            return this.wrap();
        }
        if (this.typeRight == OCTokenTypes.SEMICOLON || this.typeRight == OCElementTypes.EMPTY_STATEMENT) {
            return this.spaces(false) && this.noWrap(false);
        }
        if (this.thisType == OCElementTypes.LABELED_STATEMENT && this.typeLeft == OCTokenTypes.COLON) {
            return this.wrapAlways();
        }
        if (this.doWrappingCommaAction() || this.thisType == OCElementTypes.CPP_BASE_CLAUSE || OCSpacingProcessor.isNestedBlockOwner(this.ocSettings, this.thisNode)) {
            return this.noWrap(false);
        }
        Boolean result = OCSpacingProcessor.processBraced(this.thisNode, this.typeRight, true, new OCFormatterUtil.LeftBracesProcessor<Boolean>(){

            @Override
            public Boolean processNamespace() {
                return this.doProcess(OCSpacingProcessor.this.ocSettings.NAMESPACE_BRACE_PLACEMENT, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.thisNode.getLastChildNode());
            }

            @Override
            public Boolean processInterfaceOrStructure() {
                return this.doProcess(OCSpacingProcessor.this.settings.CLASS_BRACE_STYLE, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.typeRight == OCElementTypes.INSTANCE_VARIABLES_LIST ? OCSpacingProcessor.this.nodeRight : OCSpacingProcessor.this.thisNode.getLastChildNode());
            }

            @Override
            public Boolean processMethod() {
                return this.doProcess(OCSpacingProcessor.this.ocSettings.METHOD_BRACE_PLACEMENT, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.nodeRight);
            }

            @Override
            public Boolean processFunction() {
                return this.doProcess(OCSpacingProcessor.this.ocSettings.FUNCTION_BRACE_PLACEMENT, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.nodeRight);
            }

            @Override
            public Boolean processBlock() {
                return this.doProcess(OCSpacingProcessor.this.ocSettings.BLOCK_BRACE_PLACEMENT, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.nodeRight);
            }

            @Override
            public Boolean processGeneral() {
                return this.doProcess(OCSpacingProcessor.this.settings.BRACE_STYLE, OCSpacingProcessor.this.nodeRight, OCSpacingProcessor.this.nodeRight);
            }

            private boolean doProcess(int bracesPlacement, ASTNode fromAnchor, ASTNode toAnchor) {
                return OCSpacingProcessor.this.wrapBrace(bracesPlacement, fromAnchor, toAnchor);
            }
        });
        if (result != null) {
            return result;
        }
        if (this.isWithinCodeBraces() || OCSpacingProcessor.isObjCKeywordWithDog(this.typeRight, this.nodeRight, OCTokenTypes.END_KEYWORD)) {
            return this.wrap();
        }
        if (OCFormatterUtil.isOCVisibilityKeywordOrCPPVisibilityColon(this.nodeLeft) || OCElementUtil.isVisibilityKeyword(this.nodeRight) && this.typeLeft != OCTokenTypes.AT) {
            return this.wrap();
        }
        if (this.typeLeft == OCElementTypes.PROPERTY || this.typeRight == OCElementTypes.PROPERTY || this.typeLeft == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST || this.typeRight == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return this.wrap();
        }
        if (this.thisType == OCElementTypes.PROPERTY || this.thisType == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return this.noWrap(this.typeRight != OCTokenTypes.SEMICOLON);
        }
        if (!OCSpacingProcessor.isControlStatement(this.thisType)) {
            if ((OCElementTypes.STATEMENTS.contains(this.typeLeft) || OCSpacingProcessor.isDeclarationOrDefinition(this.typeLeft)) && (OCElementTypes.STATEMENTS.contains(this.typeRight) || OCSpacingProcessor.isDeclarationOrDefinition(this.typeRight))) {
                return this.wrap();
            }
        } else {
            OCStatement psi;
            if (this.thisType == OCElementTypes.IF_STATEMENT && (psi = (OCIfStatement)this.thisNode.getPsi(OCIfStatement.class)) != null) {
                OCStatement then = psi.getThenBranch();
                OCStatement elses = psi.getElseBranch();
                if (OCElementUtil.isOneOf(this.nodeRight, elses) && this.typeRight == OCElementTypes.IF_STATEMENT && this.settings.SPECIAL_ELSE_IF_TREATMENT) {
                    return this.noWrapEatBlankLines();
                }
                if (this.typeRight == OCTokenTypes.ELSE_KEYWORD) {
                    return this.keywordWrap(then, this.settings.ELSE_ON_NEW_LINE);
                }
                if (OCElementUtil.isOneOf(this.nodeLeft, then, elses)) {
                    return this.wrapStatement(this.nodeLeft);
                }
                if (OCSpacingProcessor.isNotEmptyAndOneOf(this.nodeRight, then, elses)) {
                    return this.wrapStatement(this.nodeRight);
                }
            }
            if (OCSpacingProcessor.isLoopStatement(this.thisType) && (psi = (OCLoopStatement)this.thisNode.getPsi(OCLoopStatement.class)) != null) {
                OCStatement body = psi.getBody();
                if (this.thisType == OCElementTypes.DO_WHILE_STATEMENT && this.typeRight == OCTokenTypes.WHILE_KEYWORD) {
                    return this.keywordWrap(body, this.settings.WHILE_ON_NEW_LINE);
                }
                if (OCElementUtil.isOneOf(this.nodeLeft, body)) {
                    return this.wrapStatement(this.nodeLeft);
                }
                if (OCSpacingProcessor.isNotEmptyAndOneOf(this.nodeRight, body)) {
                    return this.wrapStatement(this.nodeRight);
                }
            }
            if (this.thisType == OCElementTypes.TRY_STATEMENT) {
                if (this.typeRight == OCElementTypes.CATCH_SECTION && this.settings.CATCH_ON_NEW_LINE) {
                    return this.wrap();
                }
                if (this.typeRight == OCElementTypes.FINALLY_SECTION && this.settings.FINALLY_ON_NEW_LINE) {
                    return this.wrap();
                }
            }
            if (this.typeRight == OCElementTypes.CASE_STATEMENT) {
                return this.wrapAlways();
            }
            if (this.thisType == OCElementTypes.CASE_STATEMENT && this.typeLeft == OCTokenTypes.COLON) {
                ASTNode switchParent = TreeUtil.findParent((ASTNode)this.thisNode, (IElementType)OCElementTypes.SWITCH_STATEMENT);
                ASTNode dependentTo = this.nodeRight;
                ASTNode each = FormatterUtil.getNext((ASTNode)this.nodeRight, (IElementType[])new IElementType[0]);
                while (each != null && OCElementTypes.STATEMENTS.contains(each.getElementType()) && each.getElementType() != OCElementTypes.CASE_STATEMENT && TreeUtil.findParent((ASTNode)each, (IElementType)OCElementTypes.SWITCH_STATEMENT) == switchParent) {
                    dependentTo = each;
                    each = FormatterUtil.getNext((ASTNode)each, (IElementType[])new IElementType[0]);
                }
                return this.wrapStatement(this.nodeRight, this.nodeRight, dependentTo, this.ocSettings.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE);
            }
        }
        return false;
    }

    private boolean keywordWrap(@Nullable OCStatement leaderStatement, boolean onNewLineAfterBlock) {
        return !onNewLineAfterBlock && leaderStatement instanceof OCBlockStatement && (leaderStatement.textContains('\n') || !OCFormatterUtil.isInBlockEnclosed(null, leaderStatement.getNode()) || !this.settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE) ? this.noWrapEatBlankLines() : this.wrap();
    }

    private boolean needNewLineBeforeAndAfter() {
        return (FORMAT_DIRECTIVES.contains(this.typeLeft) || FORMAT_DIRECTIVES.contains(this.typeRight)) && !OCSpacingProcessor.isInsideDirective(this.thisNode);
    }

    private boolean calcBlankLines() {
        int lines;
        boolean isRightImport;
        if (this.typeRight == OCTokenTypes.SEMICOLON) {
            return false;
        }
        if (this.thisType == OCElementTypes.CPP_LINKAGE_SPECIFICATION) {
            return false;
        }
        if (this.typeLeft == OCTokenTypes.LBRACE || this.typeRight == OCTokenTypes.RBRACE) {
            if (this.isWithinMethodOrFunctionBraces() && this.typeRight != OCTokenTypes.RBRACE) {
                return this.blankLines(this.settings.BLANK_LINES_BEFORE_METHOD_BODY);
            }
            return false;
        }
        if (OCFormatterUtil.isObjCKeywordWithDog(this.typeRight, this.nodeRight, OCTokenTypes.END_KEYWORD)) {
            return false;
        }
        if (OCSpacingProcessor.isClassHeader(this.nodeLeft) && !OCSpacingProcessor.isClassHeader(this.nodeRight)) {
            return this.blankLines(this.settings.BLANK_LINES_AFTER_CLASS_HEADER);
        }
        if (OCFormatterUtil.isOCVisibilityKeywordOrCPPVisibilityColon(this.nodeLeft)) {
            return false;
        }
        boolean result = false;
        boolean isLeftImport = this.typeLeft == OCElementTypes.IMPORT_DIRECTIVE || this.typeLeft == OCElementTypes.IMPORT_MODULE_STATEMENT;
        boolean bl = isRightImport = this.typeRight == OCElementTypes.IMPORT_DIRECTIVE || this.typeRight == OCElementTypes.IMPORT_MODULE_STATEMENT;
        if (isLeftImport != isRightImport) {
            lines = isLeftImport ? this.settings.BLANK_LINES_AFTER_IMPORTS : this.settings.BLANK_LINES_BEFORE_IMPORTS;
            result |= this.blankLines(lines);
        }
        if (OCElementTypes.CLASSES.contains(this.typeLeft) || OCSpacingProcessor.isCPPClassDeclaration(this.nodeLeft) || OCFormatterUtil.isNamespaceWithKeyword(this.nodeLeft) || OCElementTypes.CLASSES.contains(this.typeRight) || OCSpacingProcessor.isCPPClassDeclaration(this.nodeRight) || OCFormatterUtil.isNamespaceWithKeyword(this.nodeRight)) {
            result |= this.blankLines(this.typeLeft == OCElementTypes.CPP_NAMESPACE || this.typeRight == OCElementTypes.CPP_NAMESPACE ? this.ocSettings.BLANK_LINES_AROUND_NAMESPACE : this.settings.BLANK_LINES_AROUND_CLASS);
        }
        if (this.typeLeft == OCElementTypes.PROPERTY || this.typeRight == OCElementTypes.PROPERTY) {
            result |= this.blankLines(this.ocSettings.BLANK_LINES_AROUND_PROPERTIES_IN_INTERFACE);
        }
        if (this.typeLeft == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST || this.typeRight == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            result |= this.blankLines(this.ocSettings.BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION);
        }
        if (this.thisType != OCElementTypes.PROPERTY && (OCElementUtil.isFunctionPredeclaration(this.nodeLeft) || OCElementUtil.isFunctionPredeclaration(this.nodeRight))) {
            result |= this.blankLines(this.settings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE);
        }
        if (this.typeLeft == OCElementTypes.FUNCTION_DEFINITION || this.typeRight == OCElementTypes.FUNCTION_DEFINITION) {
            result |= this.blankLines(this.settings.BLANK_LINES_AROUND_METHOD);
        }
        if (this.typeLeft == OCElementTypes.METHOD || this.typeRight == OCElementTypes.METHOD) {
            lines = this.thisType == OCElementTypes.IMPLEMENTATION ? this.settings.BLANK_LINES_AROUND_METHOD : this.settings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
            result |= this.blankLines(lines);
        }
        if (OCElementUtil.isVariableDeclaration(this.nodeLeft) || OCElementUtil.isVariableDeclaration(this.nodeRight) && this.typeLeft != OCElementTypes.MACRO_CALL) {
            if (this.thisType == OCElementTypes.INSTANCE_VARIABLES_LIST || OCSpacingProcessor.isCPPClass(this.thisNode)) {
                result |= this.blankLines(this.settings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE);
            }
            if (OCSpacingProcessor.isGlobalDeclarationScope(this.thisType) || OCElementTypes.CLASSES.contains(this.thisType)) {
                result |= this.blankLines(this.settings.BLANK_LINES_AROUND_FIELD);
            }
        }
        return result;
    }

    Boolean needSpaceAroundBinaryOperator(ASTNode node, IElementType nodeType) {
        if (OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.BINARY_EXPRESSION) {
            if (OCTokenTypes.LOGIC_OPERATIONS.contains(nodeType)) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_LOGICAL_OPERATORS);
            }
            if (nodeType == OCTokenTypes.EQEQ || nodeType == OCTokenTypes.EXCLEQ) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_EQUALITY_OPERATORS);
            }
            if (OCTokenTypes.COMPARISON_OPERATIONS.contains(nodeType) || nodeType == OCTokenTypes.SPACESHIP) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_RELATIONAL_OPERATORS);
            }
            if (OCTokenTypes.SHIFT_OPERATIONS.contains(nodeType)) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_SHIFT_OPERATORS);
            }
            if (OCTokenTypes.BITLOGIC_OPERATIONS.contains(nodeType)) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_BITWISE_OPERATORS);
            }
            if (nodeType == OCTokenTypes.PLUS || nodeType == OCTokenTypes.MINUS) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_ADDITIVE_OPERATORS);
            }
            if (OCTokenTypes.ARITHMETIC_OPERATIONS.contains(nodeType)) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
            }
            if (nodeType == OCTokenTypes.DEREF_MUL || nodeType == OCTokenTypes.DOT_MUL) {
                return this.spacesAroundPunctuation(this.ocSettings.SPACE_AROUND_PM_OPERATORS);
            }
        }
        return null;
    }

    private boolean calcSpaces() {
        boolean onNewLine;
        boolean isRightRef;
        boolean isLeftRef;
        if (this.typeLeft == OCTokenTypes.XOR && OCElementUtil.getElementType(this.nodeLeft.getTreeParent()) != OCElementTypes.BINARY_EXPRESSION && (this.thisType == OCElementTypes.BLOCK_EXPRESSION || this.thisType == OCElementTypes.DECLARATOR)) {
            return this.spaces(this.ocSettings.SPACE_AFTER_CUP_IN_BLOCKS);
        }
        if (!this.ocSettings.SPACE_BETWEEN_ADJACENT_BRACKETS && this.lastLeafTypeLeft == this.firstLeafTypeRight && (OCFormatterUtil.isAnyLBrace(this.lastLeafTypeLeft) || OCFormatterUtil.isAnyRBrace(this.lastLeafTypeLeft))) {
            return this.spaces(false);
        }
        if (this.typeLeft == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
            return this.spaces(!(this.typeRight instanceof OCPunctuatorElementType) || this.ocSettings.SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR);
        }
        if (this.typeRight == OCElementTypes.ARGUMENT_LIST) {
            return this.spaces(this.settings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
        if (this.typeRight == OCElementTypes.PARAMETER_LIST) {
            if (this.thisType == OCElementTypes.CATCH_SECTION) {
                if (this.typeLeft == OCTokenTypes.CATCH_KEYWORD || this.typeLeft == OCElementTypes.OBJC_KEYWORD) {
                    return this.spaces(this.settings.SPACE_BEFORE_CATCH_PARENTHESES);
                }
            } else {
                return this.spaces(this.settings.SPACE_BEFORE_METHOD_PARENTHESES);
            }
        }
        if (this.typeRight == OCTokenTypes.LPAR) {
            if (this.typeLeft == OCTokenTypes.IF_KEYWORD) {
                return this.spaces(this.settings.SPACE_BEFORE_IF_PARENTHESES);
            }
            if (this.typeLeft == OCTokenTypes.FOR_KEYWORD) {
                return this.spaces(this.settings.SPACE_BEFORE_FOR_PARENTHESES);
            }
            if (this.typeLeft == OCTokenTypes.WHILE_KEYWORD) {
                return this.spaces(this.settings.SPACE_BEFORE_WHILE_PARENTHESES);
            }
            if (this.typeLeft == OCTokenTypes.SWITCH_KEYWORD) {
                return this.spaces(this.settings.SPACE_BEFORE_SWITCH_PARENTHESES);
            }
            if (OCFormatterUtil.isObjCKeywordWithDog(this.typeLeft, this.nodeLeft, OCTokenTypes.SYNCHRONIZED_KEYWORD)) {
                return this.spaces(this.settings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
            }
            if (KEYWORD_WITH_LIST.contains(this.typeLeft)) {
                return this.spaces(this.settings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
        }
        if (this.typeLeft == OCElementTypes.PROPERTY_ATTRIBUTES_LIST || this.typeRight == OCElementTypes.PROPERTY_ATTRIBUTES_LIST) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES || this.typeLeft == OCElementTypes.PROPERTY_ATTRIBUTES_LIST);
        }
        if ((this.thisType == OCElementTypes.DECLARATOR || this.thisType == OCElementTypes.FUNCTION_DEFINITION || this.thisType == OCElementTypes.FUNCTION_DECLARATION) && OCSpacingProcessor.afterParamList(this.nodeRight) && OCTokenSeparatorGenerator.needSpaceInTheEndOfFunctionSig(this.typeRight, this.typeLeft)) {
            return this.spaces(true);
        }
        if ((this.thisType == OCElementTypes.DECLARATOR || this.thisType == OCElementTypes.ASSIGNMENT_EXPRESSION || this.thisType == OCElementTypes.CPP_USING_STATEMENT || this.thisType == OCElementTypes.CPP_NAMESPACE_ALIAS) && (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.typeLeft) || OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.typeRight))) {
            return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (this.thisType == OCElementTypes.SYNTHESIZED_PROPERTY && (this.typeLeft == OCTokenTypes.EQ || this.typeRight == OCTokenTypes.EQ)) {
            return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (this.typeLeft == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR || this.typeRight == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR) {
            return this.spacesAroundPunctuation(this.ocSettings.SPACE_AROUND_PM_OPERATORS);
        }
        if (OCSpacingProcessor.checkContext(this.nodeLeft, OCTokenTypes.DEREF, OCElementTypes.CPP_LAMBDA_EXPRESSION, OCElementTypes.DECLARATOR) || OCSpacingProcessor.checkContext(this.nodeRight, OCTokenTypes.DEREF, OCElementTypes.CPP_LAMBDA_EXPRESSION, OCElementTypes.DECLARATOR)) {
            return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_LAMBDA_ARROW);
        }
        if (this.typeLeft == OCTokenTypes.COLON2X || this.typeRight == OCTokenTypes.COLON2X) {
            return this.spacesAroundPunctuation(false);
        }
        Boolean hasLeftSpaceInBinary = this.needSpaceAroundBinaryOperator(this.nodeRight, this.typeRight);
        if (hasLeftSpaceInBinary != null) {
            return hasLeftSpaceInBinary;
        }
        Boolean hasRightSpaceInBinary = this.needSpaceAroundBinaryOperator(this.nodeLeft, this.typeLeft);
        if (hasRightSpaceInBinary != null) {
            return hasRightSpaceInBinary;
        }
        if ((this.thisType == OCElementTypes.DECLARATOR || this.thisType == OCElementTypes.TYPE_ELEMENT || this.thisType == OCElementTypes.FUNCTION_DEFINITION || this.thisType == OCElementTypes.FUNCTION_DECLARATION) && this.typeRight != OCTokenTypes.RPAR && this.typeLeft != OCTokenTypes.LPAR && (isLeftRef = OCElementUtil.isRefToken(this.typeLeft)) | (isRightRef = OCElementUtil.isRefToken(this.typeRight))) {
            if (isLeftRef && isRightRef) {
                return this.spaces(false);
            }
            if (isLeftRef) {
                return this.spaces(this.typeRight != OCTokenTypes.SEMICOLON && (this.typeLeft == OCTokenTypes.MUL ? this.ocSettings.SPACE_AFTER_POINTER_IN_DECLARATION : this.ocSettings.SPACE_AFTER_REFERENCE_IN_DECLARATION));
            }
            return this.spaces(this.typeRight == OCTokenTypes.MUL ? this.ocSettings.SPACE_BEFORE_POINTER_IN_DECLARATION : this.ocSettings.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
        }
        if (this.thisType == OCElementTypes.UNARY_EXPRESSION && (isLeftRef = OCElementUtil.isRefToken(this.typeLeft)) | (isRightRef = this.typeRight == OCElementTypes.UNARY_EXPRESSION && OCElementUtil.isRefToken(OCElementUtil.getElementType(this.nodeRight.getFirstChildNode())))) {
            if (isLeftRef && isRightRef) {
                return this.spaces(false);
            }
            if (isLeftRef) {
                return this.spaces(this.ocSettings.SPACE_AFTER_REFERENCE_IN_RVALUE);
            }
        }
        if (this.thisType == OCElementTypes.UNARY_EXPRESSION || this.thisType == OCElementTypes.PREFIX_EXPRESSION || this.thisType == OCElementTypes.POSTFIX_EXPRESSION) {
            IElementType t;
            IElementType iElementType = t = this.thisType == OCElementTypes.POSTFIX_EXPRESSION ? this.typeRight : this.typeLeft;
            if (OCTokenTypes.UNARY_OPERATIONS.contains(t) || t == OCTokenTypes.PLUSPLUS || t == OCTokenTypes.MINUSMINUS) {
                return this.spacesAroundPunctuation(this.settings.SPACE_AROUND_UNARY_OPERATOR);
            }
        }
        if ((this.thisType == OCElementTypes.FUNCTION_DEFINITION || this.thisType == OCElementTypes.FUNCTION_DECLARATION) && this.nodeLeft != null && OCElementUtil.getElementType(this.nodeLeft.getTreeParent()) != OCElementTypes.DECLARATOR && OCElementUtil.getElementType(this.nodeRight.getTreeParent()) == OCElementTypes.DECLARATOR) {
            return this.spaces(true);
        }
        Boolean result = OCSpacingProcessor.processBraced(this.thisNode, this.typeRight, true, new OCFormatterUtil.LeftBracesProcessor<Boolean>(){

            @Override
            public Boolean processNamespace() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.ocSettings.SPACE_BEFORE_NAMESPACE_LBRACE);
            }

            @Override
            public Boolean processInterfaceOrStructure() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_CLASS_LBRACE);
            }

            @Override
            public Boolean processMethod() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_METHOD_LBRACE);
            }

            @Override
            public Boolean processFunction() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_METHOD_LBRACE);
            }

            @Override
            public Boolean processBlock() {
                return this.processFunction();
            }

            @Override
            public Boolean processIfStatement() {
                return OCSpacingProcessor.this.spaces(OCFormatterUtil.isPrecededBy(OCSpacingProcessor.this.nodeRight, OCTokenTypes.ELSE_KEYWORD) ? OCSpacingProcessor.this.settings.SPACE_BEFORE_ELSE_LBRACE : OCSpacingProcessor.this.settings.SPACE_BEFORE_IF_LBRACE);
            }

            @Override
            public Boolean processForOrForEachStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_FOR_LBRACE);
            }

            @Override
            public Boolean processWhileStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_WHILE_LBRACE);
            }

            @Override
            public Boolean processDoWhileStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_DO_LBRACE);
            }

            @Override
            public Boolean processSwitchStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_SWITCH_LBRACE);
            }

            @Override
            public Boolean processTryStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_TRY_LBRACE);
            }

            @Override
            public Boolean processCatchStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_CATCH_LBRACE);
            }

            @Override
            public Boolean processFinallyStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_FINALLY_LBRACE);
            }

            @Override
            public Boolean processSynchronizedStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.settings.SPACE_BEFORE_SYNCHRONIZED_LBRACE);
            }

            @Override
            public Boolean processAutoreleasePoolStatement() {
                return OCSpacingProcessor.this.spaces(OCSpacingProcessor.this.ocSettings.SPACE_BEFORE_AUTORELEASE_POOL_LBRACE);
            }
        });
        if (result != null) {
            return result;
        }
        if (this.thisType == OCElementTypes.IF_STATEMENT && this.typeRight == OCTokenTypes.ELSE_KEYWORD) {
            return this.spaces(this.settings.SPACE_BEFORE_ELSE_KEYWORD);
        }
        if (this.thisType == OCElementTypes.DO_WHILE_STATEMENT && this.typeRight == OCTokenTypes.WHILE_KEYWORD) {
            return this.spaces(this.settings.SPACE_BEFORE_WHILE_KEYWORD);
        }
        if (this.typeRight == OCElementTypes.CATCH_SECTION) {
            return this.spaces(this.settings.SPACE_BEFORE_CATCH_KEYWORD);
        }
        if (this.typeRight == OCElementTypes.FINALLY_SECTION) {
            return this.spaces(this.settings.SPACE_BEFORE_FINALLY_KEYWORD);
        }
        if (this.typeLeft == OCTokenTypes.AT && OCTokenTypes.KEYWORDS_WITH_AT.contains(this.typeRight)) {
            return this.spaces(false);
        }
        if (OCFormatterUtil.isCollectionOrStructureInitializer(this.thisType) && (this.isWithinBraces() || this.isWithinBrackets())) {
            boolean isLeft = OCTokenTypes.LBRACE == this.typeLeft || OCTokenTypes.LBRACKET == this.typeLeft;
            boolean onNewLine2 = isLeft ? this.settings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE : this.settings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE;
            return this.spaces(this.typeLeft == OCTokenTypes.LBRACE && this.typeRight == OCTokenTypes.RBRACE || this.typeLeft == OCTokenTypes.LBRACKET && this.typeRight == OCTokenTypes.RBRACKET ? this.settings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES : this.settings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, onNewLine2);
        }
        if (this.isWithinBrackets()) {
            if (this.thisType == OCElementTypes.MESSAGE_EXPRESSION) {
                return this.spaces(this.ocSettings.SPACE_WITHIN_SEND_MESSAGE_BRACKETS);
            }
            if (this.thisType == OCElementTypes.ARRAY_INDEX_EXPRESSION) {
                return this.spaces(this.settings.SPACE_WITHIN_BRACKETS);
            }
            if (this.thisType == OCElementTypes.CPP_LAMBDA_INTRODUCER) {
                onNewLine = this.typeLeft == OCTokenTypes.LBRACKET ? this.ocSettings.LAMBDA_CAPTURE_LIST_NEW_LINE_AFTER_LBRACKET : this.ocSettings.LAMBDA_CAPTURE_LIST_NEW_LINE_BEFORE_RBRACKET;
                boolean space = this.typeLeft == OCTokenTypes.LBRACKET && this.typeRight == OCTokenTypes.RBRACKET ? this.ocSettings.SPACE_WITHIN_EMPTY_LAMBDA_CAPTURE_LIST_BRACKET : this.ocSettings.SPACE_WITHIN_LAMBDA_CAPTURE_LIST_BRACKET;
                return this.spaces(space, onNewLine);
            }
            return this.spaces(false);
        }
        if (this.typeRight == OCTokenTypes.LBRACKET) {
            return this.spaces(false);
        }
        if (this.isWithinBraces()) {
            return this.spaces(this.typeLeft == OCTokenTypes.LBRACE && this.typeRight == OCTokenTypes.RBRACE ? this.ocSettings.SPACE_WITHIN_EMPTY_BRACES : this.settings.SPACE_WITHIN_BRACES);
        }
        if (this.thisType == OCElementTypes.CATEGORY_NAME && (this.typeLeft == OCTokenTypes.LPAR || this.typeRight == OCTokenTypes.RPAR)) {
            return this.spaces(this.ocSettings.SPACE_WITHIN_CATEGORY_PARENTHESES);
        }
        if (this.typeLeft == OCTokenTypes.LPAR || this.typeRight == OCTokenTypes.RPAR) {
            if (OCElementTypes.LIST_OWNER_SET.contains(this.thisType)) {
                return this.spaces(this.typeLeft == OCTokenTypes.LPAR && this.typeRight == OCTokenTypes.RPAR ? this.ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES : this.ocSettings.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.PAREN_EXPRESSION) {
                onNewLine = this.typeLeft == OCTokenTypes.LPAR ? this.settings.PARENTHESES_EXPRESSION_LPAREN_WRAP : this.settings.PARENTHESES_EXPRESSION_RPAREN_WRAP;
                return this.spaces(this.settings.SPACE_WITHIN_PARENTHESES, onNewLine);
            }
            if (this.thisType == OCElementTypes.ARGUMENT_LIST || this.thisType == OCElementTypes.MACRO_CALL) {
                onNewLine = this.thisType != OCElementTypes.MACRO_CALL && (this.typeLeft == OCTokenTypes.LPAR ? this.ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR : this.ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR);
                boolean space = this.typeLeft == OCTokenTypes.LPAR && this.typeRight == OCTokenTypes.RPAR ? this.ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES : this.ocSettings.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES;
                return this.spaces(space, onNewLine);
            }
            if (this.thisType == OCElementTypes.PARAMETER_LIST || this.thisType == OCElementTypes.MACRO_PARAMETER_LIST) {
                if (this.parentType == OCElementTypes.CATCH_SECTION) {
                    return this.spaces(this.settings.SPACE_WITHIN_CATCH_PARENTHESES);
                }
                onNewLine = this.thisType != OCElementTypes.MACRO_PARAMETER_LIST && (this.typeLeft == OCTokenTypes.LPAR ? this.ocSettings.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR : this.ocSettings.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR);
                boolean space = this.typeLeft == OCTokenTypes.LPAR && this.typeRight == OCTokenTypes.RPAR ? this.ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES : this.ocSettings.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES;
                return this.spaces(space, onNewLine);
            }
            if (this.thisType == OCElementTypes.IF_STATEMENT) {
                return this.spaces(this.settings.SPACE_WITHIN_IF_PARENTHESES);
            }
            if (OCSpacingProcessor.isForOrForEachStatement(this.thisType)) {
                onNewLine = this.typeLeft == OCTokenTypes.LPAR ? this.settings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE : this.settings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE;
                return this.spaces(this.settings.SPACE_WITHIN_FOR_PARENTHESES, onNewLine);
            }
            if (this.thisType == OCElementTypes.WHILE_STATEMENT || this.thisType == OCElementTypes.DO_WHILE_STATEMENT) {
                return this.spaces(this.settings.SPACE_WITHIN_WHILE_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.SWITCH_STATEMENT) {
                return this.spaces(this.settings.SPACE_WITHIN_SWITCH_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.SYNCHRONIZED_STATEMENT) {
                return this.spaces(this.settings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.PROPERTY_ATTRIBUTES_LIST) {
                return this.spaces(this.ocSettings.SPACE_WITHIN_PROPERTY_ATTRIBUTES_PARENTHESES);
            }
        }
        if (this.typeLeft == OCTokenTypes.LPAR && this.typeRight == OCElementTypes.TYPE_ELEMENT || this.typeLeft == OCElementTypes.TYPE_ELEMENT && this.typeRight == OCTokenTypes.RPAR) {
            if (this.thisType == OCElementTypes.CAST_EXPRESSION) {
                return this.spaces(this.settings.SPACE_WITHIN_CAST_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.METHOD) {
                return this.spaces(this.ocSettings.SPACE_WITHIN_METHOD_RETURN_TYPE_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.METHOD_SELECTOR_PART) {
                return this.spaces(this.ocSettings.SPACE_WITHIN_METHOD_PARAMETER_TYPE_PARENTHESES);
            }
        }
        if (this.typeRight == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_TEMPLATE_DECLARATION_LT);
        }
        if (this.typeLeft == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            return this.spaces(true);
        }
        if (this.typeRight == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_TEMPLATE_CALL_LT);
        }
        if (this.typeRight == OCElementTypes.PROTOCOL_LIST || OCSpacingProcessor.isProtocolListOrReference(this.thisType) && this.typeRight == OCTokenTypes.LT) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS);
        }
        if (this.typeLeft == OCTokenTypes.LT || this.typeRight == OCTokenTypes.GT) {
            if (OCSpacingProcessor.isProtocolListOrReference(this.thisType)) {
                return this.spaces(this.ocSettings.SPACE_WITHIN_PROTOCOLS_BRACKETS);
            }
            if (this.thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                boolean bl = onNewLine = this.typeLeft == OCTokenTypes.LT ? this.ocSettings.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_AFTER_LT : this.ocSettings.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_BEFORE_GT;
                boolean space = this.typeLeft == OCTokenTypes.LT && this.typeRight == OCTokenTypes.GT ? this.ocSettings.SPACE_WITHIN_EMPTY_TEMPLATE_CALL_LTGT : (this.typeLeft == OCTokenTypes.LT ? this.ocSettings.SPACE_WITHIN_TEMPLATE_CALL_LTGT : (OCElementUtil.getElementType(OCFormatterUtil.lastLeaf(this.nodeLeft)) == OCTokenTypes.GT ? this.ocSettings.SPACE_WITHIN_TEMPLATE_CALL_LTGT || this.ocSettings.SPACE_WITHIN_TEMPLATE_DOUBLE_GT : this.ocSettings.SPACE_WITHIN_TEMPLATE_CALL_LTGT));
                return this.spaces(space, onNewLine);
            }
            if (this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                boolean bl = onNewLine = this.typeLeft == OCTokenTypes.LT ? this.ocSettings.TEMPLATE_PARAMETERS_NEW_LINE_AFTER_LT : this.ocSettings.TEMPLATE_PARAMETERS_NEW_LINE_BEFORE_GT;
                boolean space = this.typeLeft == OCTokenTypes.LT && this.typeRight == OCTokenTypes.GT ? this.ocSettings.SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT : (this.typeLeft == OCTokenTypes.LT ? this.ocSettings.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT : (OCElementUtil.getElementType(OCFormatterUtil.lastLeaf(this.nodeLeft)) == OCTokenTypes.GT ? this.ocSettings.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT || this.ocSettings.SPACE_WITHIN_TEMPLATE_DOUBLE_GT : this.ocSettings.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT));
                return this.spaces(space, onNewLine);
            }
        }
        if (this.thisType == OCElementTypes.CONDITIONAL_EXPRESSION) {
            if (this.typeLeft == OCTokenTypes.QUEST && this.typeRight == OCTokenTypes.COLON) {
                return this.spaces(this.ocSettings.DISCHARGED_SHORT_TERNARY_OPERATOR);
            }
            if (this.typeLeft == OCTokenTypes.QUEST) {
                return this.spaces(this.settings.SPACE_AFTER_QUEST);
            }
            if (this.typeRight == OCTokenTypes.QUEST) {
                return this.spaces(this.settings.SPACE_BEFORE_QUEST);
            }
            if (this.typeLeft == OCTokenTypes.COLON) {
                return this.spaces(this.settings.SPACE_AFTER_COLON);
            }
            if (this.typeRight == OCTokenTypes.COLON) {
                return this.spaces(this.settings.SPACE_BEFORE_COLON);
            }
        }
        if (this.typeRight == OCElementTypes.SUPER_CLASS_REF || this.typeRight == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_SUPERCLASS_COLON);
        }
        if ((this.thisType == OCElementTypes.SUPER_CLASS_REF || this.thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST) && this.typeLeft == OCTokenTypes.COLON) {
            return this.spaces(this.ocSettings.SPACE_AFTER_SUPERCLASS_COLON);
        }
        if (this.thisType == OCElementTypes.DECLARATOR) {
            if (this.typeLeft == OCTokenTypes.COLON) {
                if (this.typeRight == OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST) {
                    return this.spaces(this.ocSettings.SPACE_AFTER_INIT_LIST_COLON);
                }
                return this.spaces(this.ocSettings.SPACE_AFTER_DICTIONARY_LITERAL_COLON);
            }
            if (this.typeRight == OCTokenTypes.COLON) {
                if (this.typeLeft == OCElementTypes.PARAMETER_LIST) {
                    return this.spaces(this.ocSettings.SPACE_BEFORE_INIT_LIST_COLON);
                }
                return this.spaces(this.ocSettings.SPACE_BEFORE_DICTIONARY_LITERAL_COLON);
            }
        }
        if ((this.typeLeft == OCTokenTypes.IDENTIFIER || this.typeLeft == OCElementTypes.TYPE_ELEMENT || this.typeLeft == OCElementTypes.REFERENCE_ELEMENT || this.typeLeft == OCTokenTypes.RBRACKET) && this.typeRight == OCElementTypes.COMPOUND_INITIALIZER) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_INIT_LIST);
        }
        if (this.typeLeft == OCTokenTypes.COMMA) {
            return this.spaces(this.settings.SPACE_AFTER_COMMA);
        }
        if (this.typeRight == OCTokenTypes.COMMA) {
            return this.spaces(this.settings.SPACE_BEFORE_COMMA);
        }
        if (this.thisType == OCElementTypes.FOR_STATEMENT && (this.typeLeft == OCTokenTypes.SEMICOLON || this.typeRight == OCTokenTypes.SEMICOLON)) {
            if (this.typeLeft == this.typeRight) {
                return this.spaces(false);
            }
            return this.spaces(this.typeLeft == OCTokenTypes.SEMICOLON ? this.settings.SPACE_AFTER_SEMICOLON : this.settings.SPACE_BEFORE_SEMICOLON);
        }
        if (OCElementTypes.CLASSES.contains(this.thisType) && this.typeRight == OCElementTypes.CATEGORY_NAME) {
            return this.spaces(this.ocSettings.SPACE_BEFORE_CATEGORY_PARENTHESES);
        }
        if (this.thisType == OCElementTypes.MESSAGE_EXPRESSION && this.typeRight == OCElementTypes.MESSAGE_ARGUMENT) {
            return this.spaces(this.typeLeft != OCElementTypes.MESSAGE_EXPRESSION || this.ocSettings.SPACE_BEFORE_CHAINED_SEND_MESSAGE);
        }
        if (this.thisType == OCElementTypes.METHOD_SELECTOR_PART && this.typeLeft == OCTokenTypes.COLON || this.typeLeft == OCElementTypes.ARGUMENT_SELECTOR) {
            return this.spaces(this.ocSettings.SPACE_AFTER_COLON_IN_SELECTOR);
        }
        if ((this.thisType == OCElementTypes.ARGUMENT_SELECTOR || this.thisType == OCElementTypes.METHOD_SELECTOR_PART) && this.typeRight == OCTokenTypes.COLON) {
            return this.spaces(false);
        }
        if (this.typeLeft == OCElementTypes.METHOD_SELECTOR_PART && this.typeRight == OCElementTypes.METHOD_SELECTOR_PART) {
            return this.spaces(true);
        }
        if (this.typeRight instanceof OCKeywordElementType && (this.typeLeft == OCTokenTypes.IDENTIFIER || OCElementTypes.EXPRESSIONS.contains(this.typeLeft) || this.typeLeft == OCElementTypes.REFERENCE_ELEMENT) || this.typeLeft instanceof OCKeywordElementType && (this.typeRight == OCTokenTypes.IDENTIFIER || OCElementTypes.EXPRESSIONS.contains(this.typeRight) || this.typeRight == OCElementTypes.REFERENCE_ELEMENT) || this.typeLeft instanceof OCKeywordElementType && this.typeRight instanceof OCKeywordElementType) {
            return this.spaces(true);
        }
        if (this.thisType == OCElementTypes.METHOD && (this.typeLeft == OCTokenTypes.PLUS || this.typeLeft == OCTokenTypes.MINUS)) {
            return this.spaces(this.ocSettings.SPACE_AFTER_VISIBILITY_SIGN_IN_METHOD_DECLARATION);
        }
        if (this.typeLeft == OCTokenTypes.RPAR && OCFormatterUtil.isPrecededBy(this.nodeLeft, OCElementTypes.TYPE_ELEMENT)) {
            if (this.thisType == OCElementTypes.CAST_EXPRESSION) {
                return this.spaces(this.settings.SPACE_AFTER_TYPE_CAST);
            }
            if (this.thisType == OCElementTypes.METHOD) {
                return this.spaces(this.ocSettings.SPACE_AFTER_METHOD_RETURN_TYPE_PARENTHESES);
            }
            if (this.thisType == OCElementTypes.METHOD_SELECTOR_PART) {
                return this.spaces(this.ocSettings.SPACE_AFTER_METHOD_PARAMETER_TYPE_PARENTHESES);
            }
        }
        if (this.typeLeft == OCElementTypes.TYPE_ELEMENT && this.typeRight == OCElementTypes.DECLARATOR && OCElementUtil.isStructTypeDeclaration(this.nodeLeft.getLastChildNode())) {
            return this.spaces(this.ocSettings.SPACE_AFTER_STRUCTURES_RBRACE);
        }
        if (this.typeRight == OCElementTypes.DECLARATOR && this.typeLeft != OCTokenTypes.COMMA) {
            IElementType refSign2 = OCElementUtil.getRefInDeclarator(this.nodeRight);
            if (refSign2 != null) {
                return this.spaces(refSign2 == OCTokenTypes.MUL ? this.ocSettings.SPACE_BEFORE_POINTER_IN_DECLARATION : this.ocSettings.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
            }
            if (OCElementUtil.getElementType(this.nodeRight.getFirstChildNode()) == OCTokenTypes.IDENTIFIER) {
                return this.spaces(true);
            }
        }
        if (this.thisType == OCElementTypes.NS_DICTIONARY_LITERAL) {
            if (this.typeRight == OCTokenTypes.COLON) {
                return this.spaces(this.ocSettings.SPACE_BEFORE_DICTIONARY_LITERAL_COLON);
            }
            if (this.typeLeft == OCTokenTypes.COLON) {
                return this.spaces(this.ocSettings.SPACE_AFTER_DICTIONARY_LITERAL_COLON);
            }
        }
        if (this.thisType == OCElementTypes.DECLARATOR && (this.typeLeft == OCTokenTypes.COLON2X || this.typeRight == OCTokenTypes.COLON2X)) {
            return this.spaces(false);
        }
        if (this.nodeLeft != null && this.nodeLeft.getTreeParent() == this.nodeRight.getTreeParent() && (OCSpacingProcessor.checkContext(this.nodeLeft, OCTokenTypes.KEYWORDS, OCElementTypes.TYPE_ELEMENT, OCElementTypes.DECLARATOR) || OCSpacingProcessor.checkContext(this.nodeRight, OCTokenTypes.KEYWORDS, OCElementTypes.TYPE_ELEMENT, OCElementTypes.DECLARATOR))) {
            return this.spaces(true);
        }
        if (OCFormatterUtil.isKeyword(this.nodeLeft) && this.typeRight == OCElementTypes.TYPE_ELEMENT) {
            return this.spaces(true);
        }
        if (this.thisType == OCElementTypes.CPP_LINKAGE_SPECIFICATION) {
            return this.spaces(true);
        }
        if (this.thisType == OCElementTypes.CLASS_PREDEF_LIST && this.nodeLeft == this.thisNode.getFirstChildNode()) {
            return this.spaces(true);
        }
        if ((OCFormatterUtil.isStructure(this.thisType) || OCElementTypes.CLASSES.contains(this.thisType)) && this.nodeLeft == this.thisNode.getFirstChildNode()) {
            return this.spaces(true);
        }
        if (this.thisType == OCElementTypes.CPP_BASE_CLAUSE) {
            return this.spaces(true);
        }
        if (this.thisType == OCElementTypes.RETURN_STATEMENT && this.nodeLeft == this.thisNode.getFirstChildNode() && this.typeRight != OCTokenTypes.SEMICOLON) {
            return this.spaces(true);
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean afterParamList(@Nullable ASTNode node) {
        ASTNode treeParent;
        if (node == null || OCElementUtil.getElementType(treeParent = node.getTreeParent()) != OCElementTypes.DECLARATOR) {
            return false;
        }
        ASTNode pl = treeParent.findChildByType((IElementType)OCElementTypes.PARAMETER_LIST);
        return pl != null && pl.getStartOffset() < node.getStartOffset();
    }

    @Contract(value="null, _, _ -> false")
    private static boolean checkContext(@Nullable ASTNode child, @NotNull IElementType childType, IElementType ... parentTypes) {
        if (childType == null) {
            OCSpacingProcessor.$$$reportNull$$$0(5);
        }
        if (child == null || child.getElementType() != childType) {
            return false;
        }
        IElementType parentType = OCElementUtil.getElementType(child.getTreeParent());
        for (IElementType pt : parentTypes) {
            if (pt != parentType) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    private static boolean checkContext(@Nullable ASTNode child, @NotNull TokenSet childTypes, IElementType ... parentTypes) {
        if (childTypes == null) {
            OCSpacingProcessor.$$$reportNull$$$0(6);
        }
        if (child == null || !childTypes.contains(child.getElementType())) {
            return false;
        }
        IElementType parentType = OCElementUtil.getElementType(child.getTreeParent());
        for (IElementType pt : parentTypes) {
            if (pt != parentType) continue;
            return true;
        }
        return false;
    }

    private boolean wrap() {
        return this.blankLines(0);
    }

    private boolean wrapAlways() {
        return this.blankLinesAlways(0);
    }

    private boolean noWrap(boolean keepSpace) {
        if (keepSpace) {
            this.hasSpace = true;
        }
        this.minLineFeeds = 0;
        this.keepLineBreaks = false;
        return true;
    }

    private boolean noWrapEatBlankLines() {
        this.noWrap(true);
        this.keepBlankLines = -1;
        return true;
    }

    private boolean wrapBrace(int option, ASTNode anchorNodeFrom, ASTNode anchorNodeTo) {
        this.keepBlankLines = -1;
        this.keepLineBreaks = false;
        switch (option) {
            case 1: {
                this.minLineFeeds = 0;
                return true;
            }
            case 5: {
                this.dependentRange = new TextRange(anchorNodeFrom.getStartOffset(), anchorNodeTo.getTextRange().getEndOffset());
                this.isDependent = true;
            }
            case 2: 
            case 3: 
            case 4: {
                this.minLineFeeds = 1;
                return true;
            }
        }
        return false;
    }

    private boolean wrapStatement(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            OCSpacingProcessor.$$$reportNull$$$0(7);
        }
        ASTNode from = OCElementUtil.getElementType(prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)node)) == OCTokenTypes.ELSE_KEYWORD ? prev : this.thisNode;
        return this.wrapStatement(node, from, node, this.settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE);
    }

    private boolean wrapStatement(@NotNull ASTNode node, @Nullable ASTNode dependentFrom, @Nullable ASTNode dependentTo, boolean keepOption) {
        boolean isBlock;
        if (node == null) {
            OCSpacingProcessor.$$$reportNull$$$0(8);
        }
        if (!(isBlock = OCSpacingProcessor.isBlock(node.getElementType())) && keepOption) {
            this.isDependent = true;
            if (dependentFrom == null) {
                dependentFrom = node;
            }
            if (dependentTo == null) {
                dependentTo = node;
            }
            this.dependentRange = new TextRange(dependentFrom.getStartOffset(), dependentTo.getTextRange().getEndOffset());
        }
        this.keepLineBreaks = false;
        this.minLineFeeds = isBlock ? 0 : 1;
        return true;
    }

    private boolean blankLines(int blankLines) {
        if (this.isWithinMethodOrFunctionBraces()) {
            this.isDependent |= this.settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE;
        } else if (OCSpacingProcessor.isControlStatementOrSection(this.thisType) || this.isWithinCodeBlockBraces() && OCSpacingProcessor.isControlStatementOrSection(this.parentType)) {
            this.isDependent |= this.parentType == OCElementTypes.CASE_STATEMENT ? this.ocSettings.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE : this.settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE;
        } else if (OCSpacingProcessor.isStructure(this.thisType)) {
            this.isDependent |= this.ocSettings.KEEP_STRUCTURES_IN_ONE_LINE;
        } else if (this.isWithinCodeBlockBraces()) {
            this.isDependent |= this.settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
        }
        this.isDependent &= !this.needNewLineBeforeAndAfter();
        if (OCElementUtil.getElementType(this.nodeLeft) == OCTokenTypes.LBRACE && OCSpacingProcessor.isNestedInlineBlock(this.getOCSettings(), this.nodeRight)) {
            ASTNode lbrace = this.nodeRight.findChildByType((IElementType)OCTokenTypes.LBRACE);
            if (lbrace != null) {
                this.isDependent = true;
                this.dependentRange = new TextRange(this.nodeLeft.getTextRange().getStartOffset(), lbrace.getTextRange().getEndOffset());
            }
        } else if (OCElementUtil.getElementType(this.nodeRight) == OCTokenTypes.RBRACE && OCSpacingProcessor.isNestedInlineBlock(this.getOCSettings(), this.nodeLeft)) {
            ASTNode rbrace = TreeUtil.findChildBackward((ASTNode)this.nodeLeft, (IElementType)OCTokenTypes.RBRACE);
            ASTNode lbraceRight = this.nodeLeft.findChildByType((IElementType)OCTokenTypes.LBRACE);
            ASTNode lbraceLeft = this.nodeLeft.getTreeParent().findChildByType((IElementType)OCTokenTypes.LBRACE);
            if (rbrace != null && lbraceRight != null && lbraceLeft != null) {
                this.hasSpace = false;
                this.isDependent = true;
                this.keepLineBreaks = false;
                this.keepBlankLines = 0;
                this.dependentRange = new TextRange(lbraceLeft.getTextRange().getStartOffset(), lbraceRight.getTextRange().getEndOffset());
            }
        }
        return this.blankLinesAlways(blankLines);
    }

    private boolean blankLinesAlways(int blankLines) {
        this.minLineFeeds = Math.max(this.minLineFeeds, blankLines + 1);
        return true;
    }

    private void calcKeepLines() {
        if (this.keepBlankLines != null) {
            return;
        }
        this.keepBlankLines = this.settings.KEEP_BLANK_LINES_IN_CODE;
        if ((OCSpacingProcessor.isDeclarationOrDefinition(this.typeLeft) || OCSpacingProcessor.isNamespace(this.typeLeft)) && (OCSpacingProcessor.isDeclarationOrDefinition(this.typeRight) || OCSpacingProcessor.isNamespace(this.typeRight))) {
            this.keepBlankLines = this.settings.KEEP_BLANK_LINES_IN_DECLARATIONS;
        } else if (this.typeRight == OCTokenTypes.RBRACE) {
            this.keepBlankLines = this.settings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        } else if (OCFormatterUtil.isObjCKeywordWithDog(this.typeRight, this.nodeRight, OCTokenTypes.END_KEYWORD)) {
            this.keepBlankLines = this.ocSettings.KEEP_BLANK_LINES_BEFORE_END;
        } else if (this.doWrappingCommaAction() || this.typeRight == OCTokenTypes.SEMICOLON) {
            this.keepBlankLines = 0;
        }
    }

    private boolean spaces(boolean hasSpace) {
        this.hasSpace = hasSpace;
        return true;
    }

    private boolean spacesAroundPunctuation(boolean hasSpace) {
        if (!hasSpace) {
            hasSpace = this.needSpaceBetween();
        }
        this.hasSpace = hasSpace;
        return true;
    }

    private boolean needSpaceBetween() {
        ASTNode lastLeaf = TreeUtil.findLastLeaf((ASTNode)this.nodeLeft);
        LeafElement firstLeaf = TreeUtil.findFirstLeaf((ASTNode)this.nodeRight);
        if (lastLeaf == null || firstLeaf == null) {
            return false;
        }
        String lastLeafText = lastLeaf.getText();
        String firstLeafText = firstLeaf.getText();
        if ((lastLeafText.length() == 0 || Character.isJavaIdentifierPart(lastLeafText.charAt(lastLeafText.length() - 1))) && (firstLeafText.length() == 0 || Character.isJavaIdentifierPart(firstLeafText.charAt(0)))) {
            return true;
        }
        IElementType lastLeafType = lastLeaf.getElementType();
        IElementType firstLeafType = firstLeaf.getElementType();
        for (ArrayList seq : MANDATORY_SPACE_PAIR) {
            if (!seq.contains(lastLeafType) || !seq.contains(firstLeafType)) continue;
            return true;
        }
        return false;
    }

    private boolean spaces(boolean hasSpace, boolean onNewLineIfWrapped) {
        this.hasSpace = hasSpace;
        if (onNewLineIfWrapped) {
            this.isDependent = true;
            this.minLineFeeds = 1;
        }
        return true;
    }

    @Contract(pure=true)
    private boolean isWithinBraces() {
        return this.typeLeft == OCTokenTypes.LBRACE || this.typeRight == OCTokenTypes.RBRACE;
    }

    @Contract(pure=true)
    private boolean isWithinBrackets() {
        return this.typeLeft == OCTokenTypes.LBRACKET || this.typeRight == OCTokenTypes.RBRACKET;
    }

    private boolean isWithinCodeBraces() {
        return this.isWithinBraces() && !OCFormatterUtil.isCollectionOrStructureInitializer(this.thisType);
    }

    private boolean isWithinCodeBlockBraces() {
        return this.isWithinCodeBraces() && !OCElementUtil.isMethodOrFunctionBody(this.thisNode);
    }

    private boolean isWithinMethodOrFunctionBraces() {
        return this.isWithinCodeBraces() && OCElementUtil.isMethodOrFunctionBody(this.thisNode);
    }

    @Nullable
    @Contract(value="_, null, _ -> !null")
    public static Spacing getSpacing(@NotNull OCCodeBlock ownerBlock, @Nullable Block childLeft, @NotNull Block childRight) {
        ASTNode nodeRight;
        ASTNode nodeLeft;
        if (ownerBlock == null) {
            OCSpacingProcessor.$$$reportNull$$$0(9);
        }
        if (childRight == null) {
            OCSpacingProcessor.$$$reportNull$$$0(10);
        }
        if (childLeft == null) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)ownerBlock.getSettings().KEEP_LINE_BREAKS, (int)ownerBlock.getSettings().KEEP_BLANK_LINES_IN_CODE);
        }
        ASTNode owner = null;
        boolean needSpace = false;
        boolean forbiddenNewLine = ownerBlock.isInDirective();
        if (!(childLeft instanceof OCMacroBlock) && !(childRight instanceof OCMacroBlock)) {
            nodeLeft = OCSimpleBlock.extractLastNode(childLeft);
            nodeRight = OCSimpleBlock.extractFirstNode(childRight);
        } else {
            ASTNode right;
            ASTNode left;
            if (childLeft instanceof OCMacroBlock && childRight instanceof OCMacroBlock) {
                left = ((OCMacroBlock)childLeft).getLastInjection();
                right = ((OCMacroBlock)childRight).getFirstInjection();
                owner = OCFormatterUtil.getBestCommonOwner(ownerBlock.getNode(), left, right);
                nodeLeft = OCSpacingProcessor.findParentInOwnerIfExist(owner, left);
                nodeRight = OCSpacingProcessor.findParentInOwnerIfExist(owner, right);
            } else if (childRight instanceof OCMacroBlock) {
                Pair<ASTNode, ASTNode> pair = OCSpacingProcessor.getLeftSiblings(((OCMacroBlock)childRight).getFirstInjection());
                nodeLeft = (ASTNode)pair.first;
                nodeRight = (ASTNode)pair.second;
                if (nodeLeft != null) {
                    owner = nodeLeft.getTreeParent();
                }
            } else {
                left = ((OCMacroBlock)childLeft).getLastInjection();
                right = OCSpacingProcessor.getLeftmostRealLeaf(OCSimpleBlock.extractFirstNode(childRight));
                owner = OCFormatterUtil.getBestCommonOwner(ownerBlock.getNode(), left, right);
                nodeLeft = OCSpacingProcessor.findParentInOwnerIfExist(owner, left);
                nodeRight = OCSpacingProcessor.findParentInOwnerIfExist(owner, right);
            }
            if (childLeft instanceof OCMacroBlock && OCElementUtil.getElementType(((OCMacroBlock)childLeft).getMacroCall().getLastChildNode()) != OCTokenTypes.RPAR) {
                ASTNode leafAfterMacroInjection = TreeUtil.nextLeaf((ASTNode)((OCMacroBlock)childLeft).getLastInjection());
                while (leafAfterMacroInjection instanceof PsiWhiteSpace || leafAfterMacroInjection instanceof OCMacroForeignLeafElement) {
                    leafAfterMacroInjection = TreeUtil.nextLeaf((ASTNode)leafAfterMacroInjection);
                }
                needSpace = leafAfterMacroInjection != null && !(leafAfterMacroInjection.getElementType() instanceof OCPunctuatorElementType);
                boolean bl = forbiddenNewLine = ((OCMacroBlock)childLeft).getMacroCall() == ((OCMacroBlock)childLeft).getFirstInjection();
            }
            if (!needSpace && childRight instanceof OCMacroBlock) {
                ASTNode leafBeforeMacro = TreeUtil.prevLeaf((ASTNode)((OCMacroBlock)childRight).getMacroCall());
                while (leafBeforeMacro instanceof PsiWhiteSpace || leafBeforeMacro instanceof OCMacroForeignLeafElement) {
                    leafBeforeMacro = TreeUtil.prevLeaf((ASTNode)leafBeforeMacro);
                }
                boolean bl = needSpace = leafBeforeMacro != null && !(leafBeforeMacro.getElementType() instanceof OCPunctuatorElementType);
            }
        }
        if (nodeLeft == null || nodeRight == null) {
            return null;
        }
        if (owner == null) {
            owner = ownerBlock.getNode();
        }
        if (OCElementUtil.getElementType(owner) == OCElementTypes.MACRO_ARGUMENT) {
            forbiddenNewLine = true;
        }
        return new OCSpacingProcessor(ownerBlock.getSettings(), ownerBlock.getOCSettings(), owner, nodeLeft, nodeRight).getResult(needSpace, forbiddenNewLine);
    }

    private static Pair<ASTNode, ASTNode> getLeftSiblings(ASTNode right) {
        while (right != null) {
            ASTNode left;
            for (left = right.getTreePrev(); left != null && (left instanceof PsiWhiteSpace || left.getElementType() == OCElementTypes.MACRO_CALL); left = left.getTreePrev()) {
            }
            if (left != null) {
                return Pair.create((Object)left, (Object)right);
            }
            right = right.getTreeParent();
        }
        return Pair.create(null, null);
    }

    @NotNull
    private static ASTNode getLeftmostRealLeaf(@NotNull ASTNode node) {
        if (node == null) {
            OCSpacingProcessor.$$$reportNull$$$0(11);
        }
        LeafElement leaf = TreeUtil.findFirstLeaf((ASTNode)node);
        while (leaf instanceof PsiWhiteSpace || leaf instanceof OCMacroForeignLeafElement) {
            leaf = TreeUtil.nextLeaf((ASTNode)leaf);
        }
        Object object = leaf == null ? node : leaf;
        if (object == null) {
            OCSpacingProcessor.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    private static ASTNode findParentInOwnerIfExist(@Nullable ASTNode owner, @NotNull ASTNode child) {
        if (child == null) {
            OCSpacingProcessor.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                OCSpacingProcessor.$$$reportNull$$$0(14);
            }
            return aSTNode;
        }
        for (ASTNode node = child; node != null; node = node.getTreeParent()) {
            if (node.getTreeParent() != owner) continue;
            ASTNode aSTNode = node;
            if (aSTNode == null) {
                OCSpacingProcessor.$$$reportNull$$$0(15);
            }
            return aSTNode;
        }
        ASTNode aSTNode = child;
        if (aSTNode == null) {
            OCSpacingProcessor.$$$reportNull$$$0(16);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childLeft";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childRight";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerBlock";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCSpacingProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCSpacingProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftmostRealLeaf";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentInOwnerIfExist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapStatement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLeftmostRealLeaf";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findParentInOwnerIfExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

