/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.formatting.alignment.AlignmentInColumnsHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.formatting.OCFormatProcessor;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCLocalFormatterData;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCWrappingProcessor
extends OCFormatProcessor {
    protected static final Key<Boolean> IS_TABLE = new Key("IS_TABLE");
    private static final AlignmentInColumnsConfig VARS_ALIGNMENT_CONFIG = new AlignmentInColumnsConfig(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.COMMA, OCElementTypes.MACRO_CALL})}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCTokenTypes.TYPE_MODIFIERS}), TokenSet.EMPTY, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.ASSIGNMENT_EXPRESSION, OCElementTypes.DECLARATOR}));
    public static final OCElementType CHAINED_CALL_PSEUDOTYPE = new OCElementType("CHAINED_CALL_PSEUDOTYPE");
    public static final OCElementType BINARY_EXPRESSION_PSEUDOTYPE = new OCElementType("BINARY_EXPRESSION_PSEUDOTYPE");
    public static final OCElementType LITERAL_EXPRESSION_PSEUDOTYPE = new OCElementType("LITERAL_EXPRESSION_PSEUDOTYPE");
    @NonNls
    private static final String KEY_METHOD_ARGUMENTS = "method arguments";
    @NonNls
    private static final String KEY_METHOD_FIRST_ARGUMENT = "first method argument";
    @NonNls
    private static final String KEY_METHOD_ARGUMENT_VALUES = "method argument values";
    @NonNls
    private static final String KEY_METHOD_CHAIN = "method argument alignment";
    @NonNls
    private static final String KEY_CALL_ARGUMENT_COLUMNS = "call argument columns";
    @NonNls
    private static final String KEY_PARAMETER_COLUMNS = "parameter columns";
    @NonNls
    private static final String KEY_ASSIGNMENT_WRAP = "assignment wrap";
    @NonNls
    private static final String KEY_ASSIGNMENT_ALIGNMENT = "assignment alignment";
    @NonNls
    private static final String KEY_GROUP_ASSIGNMENT = "group assignment";
    @NonNls
    private static final String KEY_GROUP_VARIABLE_NAME = "group variable name";
    @NonNls
    private static final String KEY_GROUP_INIT_LIST = "group initialization list";
    @NonNls
    private static final String KEY_GROUP_DICTIONARY_PAIRS = "group dictionary pairs";
    @NonNls
    private static final String KEY_TERNARY_ALIGNMENT = "ternary alignment";
    @NonNls
    private static final String KEY_TERNARY_OPERATOR_ALIGNMENT = "ternary operator alignment";
    @NonNls
    private static final String KEY_TERNARY_WRAP = "ternary wrap";
    @NonNls
    private static final String KEY_TERNARY_OPERATOR_WRAP = "ternary operator wrap";
    @NonNls
    private static final String KEY_TEMPLATE_DECLARATION_WRAP = "template declaration wrap";
    @NonNls
    private static final String KEY_NEVER_WRAP = "Never wrap";
    @NonNls
    private static final String KEY_ALWAYS_WRAP = "Always wrap";
    @NonNls
    private static final String KEY_IF_LONG_WRAP = "If long wrap";
    @NonNls
    private static final String KEY_SHIFT_OPERATION = "Shift operations";
    private static final TokenSet COMMENTS_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCElementTypes.EXPRESSIONS});
    private static final TokenSet TYPE_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.TYPE_ELEMENT}), OCElementTypes.EXPRESSIONS});
    private static final TokenSet LAMBDA_LIST_CAPTURE = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.TYPE_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.EQ, OCTokenTypes.THIS_CPP_KEYWORD, OCTokenTypes.ELLIPSIS, OCElementTypes.REFERENCE_ELEMENT})});
    private static final TokenSet MACRO_ARG_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_ARGUMENT}), OCElementTypes.EXPRESSIONS});
    private final OCLocalFormatterData myData;
    private ASTNode childNode;
    private IElementType childType;

    OCWrappingProcessor(CommonCodeStyleSettings settings, OCCodeStyleSettings ocSettings, ASTNode node, OCLocalFormatterData data) {
        super(settings, ocSettings, node);
        this.myData = data;
    }

    public Wrap getTemplateWrap(IElementType ancestorType) {
        OCFormatterInfo formatInfo;
        OCLocalFormatterData upData;
        OCLocalFormatterData oCLocalFormatterData = upData = ancestorType == null ? this.myData : this.myData.getAncestor(ancestorType);
        if (upData != null && (formatInfo = upData.get(KEY_TEMPLATE_DECLARATION_WRAP)) != null) {
            return formatInfo.wrap;
        }
        return null;
    }

    public OCFormatterInfo calculate(ASTNode child, IElementType childType) {
        this.childNode = child;
        this.childType = childType;
        return this.doCalculate();
    }

    private boolean shouldAlignAsElementOrComma(@NotNull IElementType elementType, boolean commaOnNextLine) {
        if (elementType == null) {
            OCWrappingProcessor.$$$reportNull$$$0(0);
        }
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementType);
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && this.childType != elementType || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COMMA));
    }

    private boolean shouldAlignAsElementOrComma(@NotNull TokenSet elementTypes, boolean commaOnNextLine) {
        if (elementTypes == null) {
            OCWrappingProcessor.$$$reportNull$$$0(1);
        }
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementTypes);
        }
        if (elementTypes.contains(this.childType) && OCFormatterUtil.isPrecededBy(this.childNode, elementTypes)) {
            return false;
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && !elementTypes.contains(this.childType) || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COMMA));
    }

    @NotNull
    @Contract(value="_ -> new")
    private static Pair<Object, ASTNode> getAssignGroupKey(@NotNull ASTNode node) {
        IElementType pType;
        if (node == null) {
            OCWrappingProcessor.$$$reportNull$$$0(2);
        }
        int nestLevel = -1;
        ASTNode topContainer = node;
        for (ASTNode p = node; p != null && !OCWrappingProcessor.isVariableScope(pType = OCElementUtil.getElementType(p)); p = p.getTreeParent()) {
            if (pType != OCElementTypes.ASSIGNMENT_EXPRESSION && pType != OCElementTypes.DECLARATOR) continue;
            topContainer = p;
            ++nestLevel;
        }
        if (nestLevel < 0) {
            nestLevel = 0;
        }
        return new Pair((Object)new Pair((Object)KEY_GROUP_ASSIGNMENT, (Object)nestLevel), (Object)topContainer);
    }

    @NotNull
    private static String getInitListGroupKey(@NotNull ASTNode node) {
        if (node == null) {
            OCWrappingProcessor.$$$reportNull$$$0(3);
        }
        StringBuilder path = new StringBuilder();
        int oldSiblingOrder = 0;
        for (ASTNode p = node; p != null && OCElementUtil.getElementType(p.getTreeParent()) == OCElementTypes.COMPOUND_INITIALIZER; p = p.getTreeParent()) {
            int siblingOrder = 0;
            ASTNode s = p;
            while (s != null) {
                ++siblingOrder;
                s = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(s);
            }
            if (oldSiblingOrder > 0) {
                path.insert(0, "/" + oldSiblingOrder);
            }
            oldSiblingOrder = siblingOrder;
        }
        String string = KEY_GROUP_INIT_LIST + path;
        if (string == null) {
            OCWrappingProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private OCFormatterInfo doCalculate() {
        Alignment alignment;
        OCFormatterInfo result;
        PsiElement psi;
        if (this.ocSettings.DO_NOT_ADD_BREAKS) {
            OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(5);
            }
            return oCFormatterInfo;
        }
        if (this.childType == OCElementTypes.METHOD_SELECTOR_PART) {
            OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.METHOD_SELECTOR_PART, this.ocSettings.METHOD_PARAMETERS_WRAP, this.ocSettings.METHOD_PARAMETERS_ALIGN_MULTILINE);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(6);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.PARAMETER_LIST) {
            if (this.shouldAlignAsElementOrComma(OCElementTypes.PARAMETER_DECLARATION, this.ocSettings.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE)) {
                OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.PARAMETER_LIST, this.ocSettings.FUNCTION_PARAMETERS_WRAP, this.ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(7);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.PARAMETER_DECLARATION) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(8);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.ARGUMENT_LIST || this.thisType == OCElementTypes.MACRO_CALL) {
            if (this.shouldAlignAsElementOrComma(MACRO_ARG_OR_EXPRESSION, this.ocSettings.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE)) {
                OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.ARGUMENT_LIST, this.ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP, this.ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(9);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || MACRO_ARG_OR_EXPRESSION.contains(this.childType)) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(10);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION, this.ocSettings.TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE)) {
                OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST, this.ocSettings.TEMPLATE_PARAMETERS_WRAP, this.ocSettings.TEMPLATE_PARAMETERS_ALIGN_MULTILINE);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(11);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(12);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
            if (this.shouldAlignAsElementOrComma(TYPE_OR_EXPRESSION, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE)) {
                OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.TEMPLATE_ARGUMENT_LIST, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_WRAP, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(13);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || TYPE_OR_EXPRESSION.contains(this.childType)) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(14);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.CPP_LAMBDA_INTRODUCER) {
            if (this.shouldAlignAsElementOrComma(LAMBDA_LIST_CAPTURE, this.ocSettings.LAMBDA_CAPTURE_LIST_COMMA_ON_NEXT_LINE)) {
                OCFormatterInfo oCFormatterInfo = this.wrapAndAlign((Object)OCElementTypes.CPP_LAMBDA_INTRODUCER, this.ocSettings.LAMBDA_CAPTURE_LIST_WRAP, this.ocSettings.LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(15);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || LAMBDA_LIST_CAPTURE.contains(this.childType)) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(16);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST || this.parentType == OCElementTypes.FUNCTION_DEFINITION && this.thisType == OCElementTypes.DECLARATOR && this.childType == OCTokenTypes.COLON) {
            OCLocalFormatterData dataStorage = this.thisType == OCElementTypes.DECLARATOR ? this.myData : this.myData.getParent();
            OCFormatterInfo ret = dataStorage.get((Object)OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)dataStorage).wrap, (WrapType)WrapType.byLegacyRepresentation((int)this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP), (boolean)true), (Alignment)(this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null))));
            if (this.childType == OCTokenTypes.COLON) {
                switch (this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON) {
                    case 0: {
                        return OCWrappingProcessor.getJoinFormatting(dataStorage);
                    }
                    case 1: {
                        return OCWrappingProcessor.getNewLineFormatting(dataStorage);
                    }
                }
                return OCWrappingProcessor.getIfLongFormatting(dataStorage);
            }
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_CONSTRUCTOR_FIELD_INITIALIZER, this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE)) {
                if (OCFormatterUtil.isFirstEssentialChild(this.childNode)) {
                    switch (this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON) {
                        case 0: {
                            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(OCWrappingProcessor.getJoinFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                            if (oCFormatterInfo == null) {
                                OCWrappingProcessor.$$$reportNull$$$0(17);
                            }
                            return oCFormatterInfo;
                        }
                        case 1: {
                            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(OCWrappingProcessor.getNewLineFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                            if (oCFormatterInfo == null) {
                                OCWrappingProcessor.$$$reportNull$$$0(18);
                            }
                            return oCFormatterInfo;
                        }
                    }
                    OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                    if (oCFormatterInfo == null) {
                        OCWrappingProcessor.$$$reportNull$$$0(19);
                    }
                    return oCFormatterInfo;
                }
                OCFormatterInfo oCFormatterInfo = ret;
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(20);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_CONSTRUCTOR_FIELD_INITIALIZER) {
                return OCWrappingProcessor.getJoinFormatting(dataStorage);
            }
        }
        if (this.thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
            OCFormatterInfo ret = this.myData.get((Object)OCElementTypes.CPP_BASE_CLAUSE_LIST, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)this.myData).wrap, (WrapType)WrapType.byLegacyRepresentation((int)this.ocSettings.SUPERCLASS_LIST_WRAP), (boolean)true), (Alignment)(this.ocSettings.SUPERCLASS_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null))));
            if (this.childType == OCTokenTypes.COLON) {
                switch (this.ocSettings.SUPERCLASS_LIST_BEFORE_COLON) {
                    case 0: {
                        OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                        if (oCFormatterInfo == null) {
                            OCWrappingProcessor.$$$reportNull$$$0(21);
                        }
                        return oCFormatterInfo;
                    }
                    case 1: {
                        return OCWrappingProcessor.getNewLineFormatting(this.myData);
                    }
                }
                return OCWrappingProcessor.getIfLongFormatting(this.myData);
            }
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_BASE_CLAUSE, this.ocSettings.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE)) {
                if (OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COLON)) {
                    switch (this.ocSettings.SUPERCLASS_LIST_AFTER_COLON) {
                        case 0: {
                            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(this.getJoinFormatting().wrap, ret.alignment);
                            if (oCFormatterInfo == null) {
                                OCWrappingProcessor.$$$reportNull$$$0(22);
                            }
                            return oCFormatterInfo;
                        }
                        case 1: {
                            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(OCWrappingProcessor.getNewLineFormatting((OCLocalFormatterData)this.myData).wrap, ret.alignment);
                            if (oCFormatterInfo == null) {
                                OCWrappingProcessor.$$$reportNull$$$0(23);
                            }
                            return oCFormatterInfo;
                        }
                    }
                    OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)this.myData).wrap, ret.alignment);
                    if (oCFormatterInfo == null) {
                        OCWrappingProcessor.$$$reportNull$$$0(24);
                    }
                    return oCFormatterInfo;
                }
                OCFormatterInfo oCFormatterInfo = ret;
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(25);
                }
                return oCFormatterInfo;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_BASE_CLAUSE) {
                OCFormatterInfo oCFormatterInfo = this.getJoinFormatting();
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(26);
                }
                return oCFormatterInfo;
            }
        }
        if (this.thisType == OCElementTypes.METHOD_SELECTOR_PART && FormatterUtil.isFollowedBy((ASTNode)this.childNode, (IElementType)OCTokenTypes.COLON)) {
            OCFormatterInfo oCFormatterInfo = this.myData.getParent().get(KEY_PARAMETER_COLUMNS, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(this.ocSettings.METHOD_PARAMETERS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null)));
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(27);
            }
            return oCFormatterInfo;
        }
        if (this.childType == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            this.wrapOnly(KEY_TEMPLATE_DECLARATION_WRAP, this.thisType == OCElementTypes.DECLARATION ? this.ocSettings.TEMPLATE_DECLARATION_STRUCT_WRAP : this.ocSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP, false);
            OCFormatterInfo oCFormatterInfo = this.alignOnly(KEY_TEMPLATE_DECLARATION_WRAP, true);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(28);
            }
            return oCFormatterInfo;
        }
        if (this.childType == OCElementTypes.MESSAGE_ARGUMENT) {
            boolean isFirstArgument;
            OCFormatterInfo argBasePosition = this.myData.get(KEY_METHOD_FIRST_ARGUMENT);
            if (argBasePosition == null) {
                OCLocalFormatterData topData = this.myData;
                while (topData.getParent().getType() == OCElementTypes.MESSAGE_EXPRESSION) {
                    topData = topData.getParent();
                }
                OCFormatterInfo chainPosition = topData.get(KEY_METHOD_CHAIN, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.settings.METHOD_CALL_CHAIN_WRAP), (boolean)true), Alignment.createAlignment())));
                argBasePosition = this.myData.put(KEY_METHOD_FIRST_ARGUMENT, OCFormatterInfo.createInfo(chainPosition.wrap, (Alignment)(this.settings.ALIGN_MULTILINE_CHAINED_METHODS ? chainPosition.alignment : (this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE ? Alignment.createAlignment() : null))));
            }
            boolean bl = isFirstArgument = !OCFormatterUtil.isPrecededBy(this.childNode, OCElementTypes.MESSAGE_ARGUMENT);
            if (isFirstArgument) {
                boolean inChain = OCFormatterUtil.isPrecededBy(this.childNode, OCElementTypes.MESSAGE_EXPRESSION);
                OCFormatterInfo oCFormatterInfo = inChain ? argBasePosition : OCFormatterInfo.createInfo(null, argBasePosition.alignment);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(29);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo argBasePositionF = argBasePosition;
            OCFormatterInfo oCFormatterInfo = this.myData.get(KEY_METHOD_ARGUMENTS, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)argBasePositionF.wrap, (WrapType)WrappingUtil.getWrapType((int)this.ocSettings.METHOD_CALL_ARGUMENTS_WRAP), (boolean)true), this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE ? Alignment.createChildAlignment((Alignment)argBasePositionF.alignment) : null)));
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(30);
            }
            return oCFormatterInfo;
        }
        if (this.childType == CHAINED_CALL_PSEUDOTYPE) {
            OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(this.childType, this.settings.METHOD_CALL_CHAIN_WRAP, this.settings.ALIGN_MULTILINE_CHAINED_METHODS);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(31);
            }
            return oCFormatterInfo;
        }
        if (this.childType == BINARY_EXPRESSION_PSEUDOTYPE) {
            if (OCTokenTypes.SHIFT_OPERATIONS.contains((IElementType)((OCBinaryExpression)this.childNode.getPsi()).getOperationSign())) {
                OCFormatterInfo oCFormatterInfo = this.wrapOnly(KEY_SHIFT_OPERATION, this.ocSettings.SHIFT_OPERATION_WRAP);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(32);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = this.wrapOnly(this.childType, this.settings.BINARY_OPERATION_WRAP);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(33);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.BINARY_EXPRESSION) {
            OCElementType operationSign;
            psi = this.childNode.getTreeParent().getPsi();
            OCElementType oCElementType = operationSign = psi instanceof OCBinaryExpression ? ((OCBinaryExpression)psi).getOperationSign() : null;
            if (OCTokenTypes.SHIFT_OPERATIONS.contains((IElementType)operationSign)) {
                if (operationSign == this.childType || this.myData.get(KEY_SHIFT_OPERATION) != null) {
                    OCFormatterInfo oCFormatterInfo = this.alignOnly(KEY_SHIFT_OPERATION, this.ocSettings.SHIFT_OPERATION_ALIGN_MULTILINE);
                    if (oCFormatterInfo == null) {
                        OCWrappingProcessor.$$$reportNull$$$0(34);
                    }
                    return oCFormatterInfo;
                }
                OCFormatterInfo oCFormatterInfo = OCFormatterInfo.EMPTY;
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(35);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = this.alignOnly(this.thisType, this.settings.ALIGN_MULTILINE_BINARY_OPERATION);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(36);
            }
            return oCFormatterInfo;
        }
        if (OCFormatterUtil.isMessageArgumentValue(this.childNode)) {
            int varArgIndex = -1;
            boolean isDictionaryPairs = false;
            for (ASTNode each = this.thisNode; each != null; each = each.getTreePrev()) {
                if (each.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) continue;
                if (OCFormatterUtil.isVarArgArgument(each)) {
                    ++varArgIndex;
                    continue;
                }
                ASTNode selector = each.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
                if (selector == null || !StringUtil.containsIgnoreCase((String)StringUtil.notNullize((String)selector.getText()), (String)"ObjectsAndKeys")) break;
                isDictionaryPairs = true;
                break;
            }
            OCLocalFormatterData containerData = this.myData.getAncestor(OCElementTypes.MESSAGE_EXPRESSION);
            if (varArgIndex != -1) {
                OCFormatterInfo result2 = containerData.get(KEY_METHOD_ARGUMENT_VALUES);
                if (result2 != null) {
                    if (this.ocSettings.METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT && isDictionaryPairs && varArgIndex % 2 == 0) {
                        OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(this.ocSettings.ALIGN_DICTIONARY_PAIR_VALUES ? this.pairsGroupAlignment(KEY_GROUP_DICTIONARY_PAIRS, containerData, this.thisNode) : result2.alignment);
                        if (oCFormatterInfo == null) {
                            OCWrappingProcessor.$$$reportNull$$$0(37);
                        }
                        return oCFormatterInfo;
                    }
                    OCFormatterInfo oCFormatterInfo = result2;
                    if (oCFormatterInfo == null) {
                        OCWrappingProcessor.$$$reportNull$$$0(38);
                    }
                    return oCFormatterInfo;
                }
            } else if (OCFormatterUtil.isFollowedByVarArg(this.thisNode)) {
                OCFormatterInfo arguments = containerData.get(KEY_METHOD_ARGUMENTS);
                OCFormatterInfo formatInfo = OCFormatterInfo.createInfo(arguments != null ? arguments.wrap : Wrap.createWrap((int)this.ocSettings.METHOD_CALL_ARGUMENTS_WRAP, (boolean)true), Alignment.createAlignment());
                OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(containerData.put((Object)KEY_METHOD_ARGUMENT_VALUES, (OCFormatterInfo)formatInfo).alignment);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(39);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.EMPTY;
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(40);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.LITERAL_EXPRESSION && !OCElementTypes.NS_COLLECTION_LITERALS.contains(this.childType) && this.thisNode.getLastChildNode() != this.thisNode.getFirstChildNode()) {
            OCFormatterInfo oCFormatterInfo = this.alignOnly((Object)LITERAL_EXPRESSION_PSEUDOTYPE, true);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(41);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.ARGUMENT_SELECTOR && FormatterUtil.isFollowedBy((ASTNode)this.childNode, (IElementType)OCTokenTypes.COLON)) {
            OCFormatterInfo oCFormatterInfo = this.myData.getAncestor(OCElementTypes.MESSAGE_EXPRESSION).get(KEY_CALL_ARGUMENT_COLUMNS, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null)));
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(42);
            }
            return oCFormatterInfo;
        }
        if (!(this.thisType != OCElementTypes.PARAMETER_LIST && this.thisType != OCElementTypes.ARGUMENT_LIST && this.thisType != OCElementTypes.MACRO_CALL || this.childType != OCTokenTypes.LPAR && this.childType != OCTokenTypes.RPAR)) {
            OCFormatterInfo oCFormatterInfo = this.alignOnly((Object)OCTokenTypes.LPAR, this.thisType == OCElementTypes.PARAMETER_LIST ? this.ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS : this.ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(43);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.CPP_LAMBDA_INTRODUCER && (this.childType == OCTokenTypes.LBRACKET || this.childType == OCTokenTypes.RBRACKET)) {
            OCFormatterInfo oCFormatterInfo = this.alignOnly((Object)OCTokenTypes.LBRACKET, this.ocSettings.LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE_BRACKET);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(44);
            }
            return oCFormatterInfo;
        }
        if (!(this.thisType != OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST && this.thisType != OCElementTypes.TEMPLATE_ARGUMENT_LIST || this.childType != OCTokenTypes.LT && this.childType != OCTokenTypes.GT)) {
            OCFormatterInfo oCFormatterInfo = this.alignOnly((Object)OCTokenTypes.LPAR, this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST ? this.ocSettings.TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS : this.ocSettings.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(45);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.FOR_STATEMENT && (psi = (OCForStatement)this.thisNode.getPsi(OCForStatement.class)) != null && OCElementUtil.isOneOf(this.childNode, psi.getInitializer(), psi.getCondition(), psi.getIncrement())) {
            OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(this.thisType, this.settings.FOR_STATEMENT_WRAP, this.settings.ALIGN_MULTILINE_FOR);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(46);
            }
            return oCFormatterInfo;
        }
        if (this.childType == OCElementTypes.ASSIGNMENT_EXPRESSION) {
            result = this.myData.put(KEY_ASSIGNMENT_ALIGNMENT, this.myData.getParent().get(KEY_ASSIGNMENT_ALIGNMENT));
            if (result == null) {
                result = this.alignOnly(KEY_ASSIGNMENT_ALIGNMENT, this.settings.ALIGN_MULTILINE_ASSIGNMENT);
            }
            OCFormatterInfo oCFormatterInfo = result;
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(47);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.ASSIGNMENT_EXPRESSION) {
            boolean isEq = this.childType == OCTokenTypes.EQ;
            alignment = null;
            if (isEq) {
                Pair<Object, ASTNode> groupKeyPair = OCWrappingProcessor.getAssignGroupKey(this.thisNode);
                alignment = this.varsGroupAlignment(groupKeyPair.first, (ASTNode)groupKeyPair.second);
            }
            if (this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE == isEq) {
                OCFormatterInfo wrap = this.myData.getParent().get(KEY_ASSIGNMENT_WRAP);
                wrap = wrap == null ? this.wrapOnly(KEY_ASSIGNMENT_WRAP, this.settings.ASSIGNMENT_WRAP, this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) : this.myData.put(KEY_ASSIGNMENT_WRAP, wrap);
                OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(wrap.wrap, alignment);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(48);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(alignment);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(49);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.DECLARATION && this.childType == OCElementTypes.DECLARATOR) {
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(this.wrapOnly((Object)this.childType, (int)this.settings.ASSIGNMENT_WRAP, (boolean)true).wrap, this.varsGroupAlignment(KEY_GROUP_VARIABLE_NAME, this.childNode));
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(50);
            }
            return oCFormatterInfo;
        }
        if (this.parentType == OCElementTypes.DECLARATION && (this.thisType == OCElementTypes.DECLARATOR || this.thisType == OCElementTypes.ASSIGNMENT_EXPRESSION) && OCWrappingProcessor.isOrFollows(this.childNode, OCTokenTypes.IDENTIFIER)) {
            boolean isEq = this.childType == OCTokenTypes.EQ;
            alignment = null;
            if (isEq) {
                Pair<Object, ASTNode> groupKeyPair = OCWrappingProcessor.getAssignGroupKey(this.thisNode);
                alignment = this.varsGroupAlignment(groupKeyPair.first, (ASTNode)groupKeyPair.second);
            }
            if (this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE == isEq) {
                OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(this.wrapOnly((Object)KEY_ASSIGNMENT_WRAP, (int)this.settings.ASSIGNMENT_WRAP, (boolean)this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE).wrap, alignment);
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(51);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(alignment);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(52);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.CONDITIONAL_EXPRESSION) {
            boolean needWrap;
            boolean shortTernaryOperator = this.ocSettings.IN_LINE_SHORT_TERNARY_OPERATOR && OCElementUtil.getElementType(FormatterUtil.getNextNonWhitespaceSibling((ASTNode)this.thisNode.findChildByType((IElementType)OCTokenTypes.QUEST))) == OCTokenTypes.COLON;
            boolean isOperator = this.childType == OCTokenTypes.QUEST || this.childType == OCTokenTypes.COLON && !shortTernaryOperator;
            boolean bl = needWrap = isOperator == this.settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && (!shortTernaryOperator || this.childType != OCTokenTypes.COLON);
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(needWrap ? this.wrapOnly((Object)(isOperator ? KEY_TERNARY_OPERATOR_WRAP : KEY_TERNARY_WRAP), (int)this.settings.TERNARY_OPERATION_WRAP, (boolean)isOperator).wrap : null, this.alignOnly((Object)(isOperator ? KEY_TERNARY_OPERATOR_ALIGNMENT : KEY_TERNARY_ALIGNMENT), (boolean)this.settings.ALIGN_MULTILINE_TERNARY_OPERATION, (Object)(isOperator ? KEY_TERNARY_ALIGNMENT : null)).alignment);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(53);
            }
            return oCFormatterInfo;
        }
        if (OCFormatterUtil.isCollectionOrStructureInitializer(this.thisType) && this.shouldAlignAsElementOrComma(OCElementTypes.EXPRESSIONS, this.ocSettings.ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE)) {
            if (this.ocSettings.ALIGN_INIT_LIST_IN_COLUMNS && this.isInTableLikeInitList()) {
                OCFormatterInfo oCFormatterInfo = this.findTopInitListData().get(OCWrappingProcessor.getInitListGroupKey(this.childNode), (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)(this.parentType != OCElementTypes.COMPOUND_INITIALIZER ? 2 : 0), (boolean)false), Alignment.createAlignment((boolean)true))));
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(54);
                }
                return oCFormatterInfo;
            }
            result = this.wrapAndAlign(this.thisType, this.settings.ARRAY_INITIALIZER_WRAP, this.settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
            if (this.thisType != OCElementTypes.NS_DICTIONARY_LITERAL || FormatterUtil.isFollowedBy((ASTNode)this.childNode, (IElementType)OCTokenTypes.COLON, (TokenSet)(this.childType == OCTokenTypes.COMMA ? COMMENTS_OR_EXPRESSION : OCTokenTypes.COMMENTS))) {
                OCFormatterInfo oCFormatterInfo = result;
                if (oCFormatterInfo == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(55);
                }
                return oCFormatterInfo;
            }
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(result.alignment);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(56);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.NS_DICTIONARY_LITERAL && this.childType == OCTokenTypes.COLON) {
            OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(this.pairsGroupAlignment(KEY_GROUP_DICTIONARY_PAIRS, this.myData, this.childNode));
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(57);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.ENUM && this.shouldAlignAsElementOrComma(OCElementTypes.DECLARATION, this.ocSettings.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE)) {
            int wrap = this.settings.ENUM_CONSTANTS_WRAP;
            if (this.ocSettings.KEEP_STRUCTURES_IN_ONE_LINE && wrap == 2) {
                wrap = 4;
            }
            OCFormatterInfo oCFormatterInfo = this.wrapOnly((Object)OCElementTypes.ENUM, wrap);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(58);
            }
            return oCFormatterInfo;
        }
        if (this.thisType == OCElementTypes.PROPERTY && (this.childType == OCElementTypes.DECLARATION || this.childType == OCElementTypes.FUNCTION_DECLARATION)) {
            OCFormatterInfo oCFormatterInfo = this.wrapOnly(this.thisType, this.ocSettings.WRAP_PROPERTY_DECLARATION, true);
            if (oCFormatterInfo == null) {
                OCWrappingProcessor.$$$reportNull$$$0(59);
            }
            return oCFormatterInfo;
        }
        OCFormatterInfo oCFormatterInfo = OCFormatterInfo.createInfo(null, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(60);
        }
        return oCFormatterInfo;
    }

    @NotNull
    public static OCFormatterInfo getJoinFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(61);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_NEVER_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)0, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(62);
        }
        return oCFormatterInfo;
    }

    public OCFormatterInfo getJoinFormatting() {
        return OCWrappingProcessor.getJoinFormatting(this.myData);
    }

    @NotNull
    public static OCFormatterInfo getNewLineFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(63);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_ALWAYS_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)2, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(64);
        }
        return oCFormatterInfo;
    }

    @NotNull
    public static OCFormatterInfo getIfLongFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(65);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_IF_LONG_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)5, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(66);
        }
        return oCFormatterInfo;
    }

    private boolean isInTableLikeInitList() {
        ASTNode topList = null;
        ASTNode nextList = this.thisNode;
        while (OCElementUtil.getElementType(nextList) == OCElementTypes.COMPOUND_INITIALIZER) {
            topList = nextList;
            nextList = nextList.getTreeParent();
        }
        if (topList == null) {
            return false;
        }
        Boolean isTable = (Boolean)topList.getUserData(IS_TABLE);
        if (isTable == null) {
            isTable = OCWrappingProcessor.isInTableLikeInitListReal(topList);
            topList.putUserData(IS_TABLE, (Object)isTable);
        }
        return isTable;
    }

    private static boolean isInTableLikeInitListReal(@NotNull ASTNode topList) {
        if (topList == null) {
            OCWrappingProcessor.$$$reportNull$$$0(67);
        }
        for (ASTNode child = topList.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType cType = child.getElementType();
            if (OCWrappingProcessor.isInessential(child) || cType instanceof OCPunctuatorElementType || cType == OCElementTypes.COMPOUND_INITIALIZER) continue;
            return false;
        }
        return true;
    }

    @NotNull
    OCFormatterInfo wrapOnly(Object key, int wrap) {
        OCFormatterInfo oCFormatterInfo = this.wrapOnly(key, wrap, false);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(68);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapOnly(Object key, int wrapType, boolean wrapFirstElement) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, false, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(69);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo alignOnly(Object key, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.alignOnly(key, align, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(70);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo alignOnly(Object key, boolean align, Object keyParent) {
        OCFormatterInfo formatInfo;
        Alignment parentAlignment = null;
        if (keyParent != null && (formatInfo = this.myData.get(keyParent)) != null) {
            parentAlignment = formatInfo.alignment;
        }
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, false, -1, false, null, align, parentAlignment);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(71);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, wrapType, false, align);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(72);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean wrapFirstElement, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, align, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(73);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, boolean wrap, int wrapType, boolean wrapFirstElement, @Nullable Wrap parentWrap, boolean align, @Nullable Alignment parentAlignment) {
        OCFormatterInfo oCFormatterInfo = this.myData.get(key, (Computable<OCFormatterInfo>)((Computable)() -> {
            Wrap wrapping = wrap ? Wrap.createChildWrap((Wrap)parentWrap, (WrapType)WrappingUtil.getWrapType((int)wrapType), (boolean)wrapFirstElement) : null;
            Alignment alignment = null;
            if (align) {
                alignment = parentAlignment != null ? Alignment.createChildAlignment((Alignment)parentAlignment) : Alignment.createAlignment();
            }
            return OCFormatterInfo.createInfo(wrapping, alignment);
        }));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(74);
        }
        return oCFormatterInfo;
    }

    private static boolean isVariableScope(@Nullable IElementType type) {
        return OCWrappingProcessor.isBlock(type) || OCWrappingProcessor.isVariablesListOrStructure(type) || OCWrappingProcessor.isGlobalDeclarationScope(type);
    }

    @Nullable
    private Alignment varsGroupAlignment(@NotNull Object key, @Nullable ASTNode node) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(75);
        }
        if (!this.settings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            return null;
        }
        return this.groupAlignment(this.findVarGroupParentData(), key, node, VARS_ALIGNMENT_CONFIG);
    }

    @Nullable
    private Alignment pairsGroupAlignment(@NotNull Object key, @Nullable OCLocalFormatterData parentData, @Nullable ASTNode node) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(76);
        }
        if (!this.ocSettings.ALIGN_DICTIONARY_PAIR_VALUES) {
            return null;
        }
        return this.groupAlignment(parentData, key, node, null);
    }

    @Contract(value="null, _, _, _ -> null")
    private Alignment groupAlignment(@Nullable OCLocalFormatterData parentData, @NotNull Object key, @Nullable ASTNode node, @Nullable AlignmentInColumnsConfig config) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(77);
        }
        if (parentData == null) {
            return null;
        }
        Computable factory = () -> OCFormatterInfo.createInfo(Alignment.createAlignment((boolean)true));
        if (config != null && AlignmentInColumnsHelper.INSTANCE.useDifferentVarDeclarationAlignment(node, config, this.settings.KEEP_BLANK_LINES_IN_DECLARATIONS)) {
            parentData.put(key, (OCFormatterInfo)factory.compute());
        }
        return parentData.get((Object)key, (Computable<OCFormatterInfo>)factory).alignment;
    }

    @NotNull
    private OCLocalFormatterData findVarGroupParentData() {
        OCLocalFormatterData data = this.myData;
        while (!OCWrappingProcessor.isVariableScope(data.getType()) && !data.isNull()) {
            data = data.getParent();
        }
        OCLocalFormatterData oCLocalFormatterData = data;
        if (oCLocalFormatterData == null) {
            OCWrappingProcessor.$$$reportNull$$$0(78);
        }
        return oCLocalFormatterData;
    }

    @NotNull
    private OCLocalFormatterData findTopInitListData() {
        OCLocalFormatterData data = this.myData;
        while (true) {
            if (data.getParent().getType() != OCElementTypes.COMPOUND_INITIALIZER) {
                OCLocalFormatterData oCLocalFormatterData = data;
                if (oCLocalFormatterData == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(79);
                }
                return oCLocalFormatterData;
            }
            data = data.getParent();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCWrappingProcessor";
                break;
            }
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topList";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCWrappingProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitListGroupKey";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "doCalculate";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinFormatting";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewLineFormatting";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfLongFormatting";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapOnly";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "alignOnly";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAndAlign";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "findVarGroupParentData";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopInitListData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldAlignAsElementOrComma";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAssignGroupKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitListGroupKey";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: {
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getJoinFormatting";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getNewLineFormatting";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getIfLongFormatting";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isInTableLikeInitListReal";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "varsGroupAlignment";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "pairsGroupAlignment";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "groupAlignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

