/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCCppGenerateHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithParent, C extends OCCppActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    private static final OCBooleanOption INLINE_OPTION = new OCBooleanOption(OCGenerateBundle.message("generate.cpp.handler.inplace.option", new Object[0]));

    @Override
    protected void loadOptions(PsiFile file, @Nullable Editor editor, @NotNull C actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(0);
        }
        if (options == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(1);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)INLINE_OPTION, (Object)this.defaultInlineOption(file, editor, actionContext)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<M> candidates, OCOption option, C actionContext) {
        super.optionValueChanged(chooser, candidates, option, actionContext);
        if (INLINE_OPTION.equals(option)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("cidr.generate.inline.changed");
        }
    }

    protected boolean defaultInlineOption(PsiFile file, @Nullable Editor editor, @NotNull C actionContext) {
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(2);
        }
        return OCCppDefinitionsUtil.shouldInlineNewDefinitions(((OCActionContext)actionContext).getParent(), OCCaretLocation.byEditor(file, editor));
    }

    protected OCCppDefinitionsUtil.InlinePolicy getInlinePolicy(@NotNull C actionContext) {
        Boolean option;
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(3);
        }
        if ((option = this.getOption(actionContext, INLINE_OPTION)) != null) {
            return OCCppDefinitionsUtil.InlinePolicy.get(option);
        }
        return OCCppDefinitionsUtil.InlinePolicy.PREFERRED;
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file) {
        return OCCodeInsightUtil.isValid((PsiElement)file);
    }

    @NotNull
    protected abstract List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation var1, @NotNull C var2, @NotNull List<M> var3);

    @NotNull
    protected List<? extends P> getParents(@NotNull PsiElement at) {
        if (at == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(4);
        }
        OCStructLike struct = (OCStructLike)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class, OCUnion.class});
        if (!this.allowUnions() && struct instanceof OCUnion) {
            List list = Collections.emptyList();
            if (list == null) {
                OCCCppGenerateHandlerBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<OCNamespaceLikeSymbol> parents = new ArrayList<OCNamespaceLikeSymbol>();
        if (struct != null) {
            OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
            if (symbol != null && !symbol.isPredeclaration()) {
                parents.add(symbol);
            }
        } else {
            OCCppNamespace namespace;
            CommonProcessors.CollectProcessor<OCNamespaceSymbol> collector = new CommonProcessors.CollectProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    OCSymbolKind kind = symbol.getKind();
                    return (kind == OCSymbolKind.STRUCT || OCCCppGenerateHandlerBase.this.allowUnions() && kind == OCSymbolKind.UNION || OCCCppGenerateHandlerBase.this.allowNamespacesAndTopLevel() && kind == OCSymbolKind.NAMESPACE) && !symbol.isPredeclaration();
                }
            };
            OCCommonProcessors.TypeFilteredProcessor processor = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)collector, OCNamespaceSymbol.class);
            OCFile file = (OCFile)at.getContainingFile();
            file.processSymbolsRecursively(processor);
            OCFile header = null;
            if (!file.isHeader() && (header = file.getAssociatedFile()) != null) {
                header.processSymbolsRecursively(processor);
            }
            OCNamespaceSymbol namespaceSymbol = (namespace = (OCCppNamespace)PsiTreeUtil.getParentOfType((PsiElement)at, OCCppNamespace.class)) != null ? (OCNamespaceSymbol)namespace.getSymbol() : null;
            block0: for (OCNamespaceSymbol parent : collector.getResults()) {
                if (namespaceSymbol == null) {
                    parents.add(parent);
                    continue;
                }
                OCNamespaceSymbol ancestor = parent;
                while (true) {
                    if (namespaceSymbol.isSameSymbol((OCSymbol)ancestor, at.getProject())) {
                        parents.add(parent);
                        continue block0;
                    }
                    OCSymbolWithQualifiedName ancestorParent = ancestor.getParent();
                    if (!(ancestorParent instanceof OCNamespaceSymbol)) continue block0;
                    ancestor = (OCNamespaceSymbol)ancestorParent;
                }
            }
            if (namespaceSymbol == null && this.allowNamespacesAndTopLevel()) {
                if (header != null) {
                    parents.add(header.getMembersContainer(false));
                }
                parents.add(file.getMembersContainer(false));
            }
        }
        ArrayList<OCNamespaceLikeSymbol> arrayList = parents;
        if (arrayList == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean allowNamespacesAndTopLevel() {
        return false;
    }

    protected boolean allowUnions() {
        return false;
    }

    protected boolean continueTillNoParentsLeft() {
        return false;
    }

    @NotNull
    @NlsContexts.DialogMessage
    protected String getNoParentsMessage() {
        String actionTitle = StringUtil.toLowerCase((String)this.getActionTitle());
        String string = OCGenerateBundle.message("generate.cpp.handler.no.parents.message", actionTitle);
        if (string == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected String getParentChooserTitle() {
        String string = OCGenerateBundle.message("generate.cpp.handler.parent.chooser.title", new Object[0]);
        if (string == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected String getFeatureId() {
        return "codeassists.altInsert";
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(10);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        List<C> contexts = this.getContexts(editor, file);
        if (contexts.size() > 1 && editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            JBList list = new JBList(contexts);
            list.setCellRenderer((ListCellRenderer)new NavigationItemListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object val = value instanceof OCActionContext ? ((OCActionContext)value).getParentNavigationItem() : value;
                    return super.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
                }
            });
            list.setSelectionMode(0);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(this.getParentChooserTitle()).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                OCCppActionContext context = (OCCppActionContext)list.getSelectedValue();
                if (this.checkContext(project, editor, context)) {
                    this.invoke(project, editor, file, context);
                }
            }).setNamerForFiltering(OCActionContext::getParentPresentableName).createPopup().showInBestPositionFor(editor);
        } else if (!contexts.isEmpty()) {
            OCCppActionContext context = (OCCppActionContext)contexts.get(contexts.size() - 1);
            if (this.checkContext(project, editor, context)) {
                this.invoke(project, editor, file, context);
                if (contexts.size() > 1 && this.continueTillNoParentsLeft()) {
                    this.invoke(project, editor, file);
                }
            }
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)this.getNoParentsMessage(), (String)this.getActionTitle(), null);
        }
    }

    @NotNull
    private List<? extends C> getContexts(@Nullable Editor editor, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(11);
        }
        PsiElement at = OCGenerateUtil.getElementAt(editor, psiFile);
        List list = ContainerUtil.mapNotNull(this.getParents(at), p -> {
            OCCppActionContext c = (OCCppActionContext)this.evaluateActionContext(p, at);
            return c != null && c.isValid() && (this.allowEmptySelection(c) || !c.getMemberCandidates().isEmpty()) ? c : null;
        });
        if (list == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    protected boolean generateMissingInTests() {
        return true;
    }

    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull C context) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(13);
        }
        if (location == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(14);
        }
        if (context == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(15);
        }
        List<OCFunctionSymbol> list = Collections.emptyList();
        if (list == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(16);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(17);
        }
        if (file == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(18);
        }
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(19);
        }
        if (chosenCandidates == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(20);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureId());
        ((OCCppActionContext)actionContext).storeEditor(editor, file);
        OCCaretLocation location = OCCaretLocation.byEditor(file, editor);
        Collection<OCFunctionSymbol> existing = this.checkExistingFunctions(project, location, actionContext);
        Runnable generateMissing = () -> {
            actionContext.setReplaceExisting(false);
            this.doPerformAction(project, location, actionContext, chosenCandidates);
        };
        Runnable replaceAll = () -> {
            actionContext.setReplaceExisting(true);
            actionContext.setExisting(existing);
            this.doPerformAction(project, location, actionContext, chosenCandidates);
        };
        if (!existing.isEmpty()) {
            int result;
            int showIdx;
            int missingIdx;
            int replaceIdx;
            String[] options;
            String showExisting = OCGenerateBundle.message("generate.cpp.handler.show.existing.button", new Object[0]);
            String replaceExisting = OCGenerateBundle.message("generate.cpp.handler.replace.button", new Object[0]);
            String addMissing = OCGenerateBundle.message("generate.cpp.handler.add.missing.button", new Object[0]);
            String dialogMessage = ((OCCppActionContext)actionContext).allFunctionsExist() ? this.getAllDefinedText() : this.getSomeDefinedText();
            int INVALID = -100;
            if (SystemInfo.isMac) {
                String[] stringArray;
                if (((OCCppActionContext)actionContext).allFunctionsExist()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = replaceExisting;
                    stringArray2[1] = Messages.getCancelButton();
                    stringArray = stringArray2;
                    stringArray2[2] = showExisting;
                } else {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = replaceExisting;
                    stringArray3[1] = Messages.getCancelButton();
                    stringArray3[2] = addMissing;
                    stringArray = stringArray3;
                    stringArray3[3] = showExisting;
                }
                options = stringArray;
                replaceIdx = 0;
                missingIdx = ((OCCppActionContext)actionContext).allFunctionsExist() ? -100 : 2;
                showIdx = ((OCCppActionContext)actionContext).allFunctionsExist() ? 2 : 3;
            } else {
                String[] stringArray;
                if (((OCCppActionContext)actionContext).allFunctionsExist()) {
                    String[] stringArray4 = new String[3];
                    stringArray4[0] = replaceExisting;
                    stringArray4[1] = showExisting;
                    stringArray = stringArray4;
                    stringArray4[2] = Messages.getCancelButton();
                } else {
                    String[] stringArray5 = new String[4];
                    stringArray5[0] = replaceExisting;
                    stringArray5[1] = addMissing;
                    stringArray5[2] = showExisting;
                    stringArray = stringArray5;
                    stringArray5[3] = Messages.getCancelButton();
                }
                options = stringArray;
                replaceIdx = 0;
                missingIdx = ((OCCppActionContext)actionContext).allFunctionsExist() ? -100 : 1;
                int n = showIdx = ((OCCppActionContext)actionContext).allFunctionsExist() ? 1 : 2;
            }
            int n = ApplicationManager.getApplication().isUnitTestMode() ? (this.generateMissingInTests() && !((OCCppActionContext)actionContext).allFunctionsExist() ? missingIdx : replaceIdx) : (result = Messages.showDialog((Project)project, (String)dialogMessage, (String)this.getActionTitle(), (String[])options, (int)replaceIdx, null));
            if (result == showIdx) {
                UsageViewPresentation presentation = new UsageViewPresentation();
                String codeUsagesString = OCGenerateBundle.message("generate.cpp.handler.usages.string", new Object[0]);
                presentation.setCodeUsagesString(codeUsagesString);
                presentation.setTabName(this.getExistingTabName());
                presentation.setTabText(this.getExistingTabName());
                presentation.setOpenInNewTab(false);
                presentation.setShowCancelButton(true);
                presentation.setUsageTypeFilteringAvailable(false);
                presentation.setMergeDupLinesAvailable(false);
                presentation.setExcludeAvailable(false);
                Usage[] usages = (Usage[])existing.stream().map(s -> {
                    OCFunctionDeclaration psi = s.locateFunctionDefinition(project);
                    if (psi == null) {
                        return null;
                    }
                    return new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psi));
                }).filter(u -> u != null).toArray(Usage[]::new);
                UsageView view = UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, usages, presentation);
                String cannotMakeString = OCGenerateBundle.message("generate.cpp.handler.usages.cannot.make", new Object[0]);
                view.addPerformOperationAction(replaceAll, replaceExisting, cannotMakeString, replaceExisting);
                if (((OCCppActionContext)actionContext).allFunctionsExist()) return;
                view.addPerformOperationAction(generateMissing, addMissing, cannotMakeString, addMissing);
                return;
            } else if (result == replaceIdx) {
                replaceAll.run();
                return;
            } else {
                if (result != missingIdx) return;
                generateMissing.run();
            }
            return;
        } else {
            generateMissing.run();
        }
    }

    @NotNull
    @NlsContexts.DialogMessage
    protected String getSomeDefinedText() {
        OCLog.LOG.error("No text for action " + this.getActionTitle());
        String string = OCBundle.message("dialog.message.some.members.are.defined", new Object[0]);
        if (string == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    @NlsContexts.DialogMessage
    protected String getAllDefinedText() {
        OCLog.LOG.error("No text for action " + this.getActionTitle());
        String string = OCBundle.message("dialog.message.all.members.are.defined", new Object[0]);
        if (string == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getExistingTabName() {
        OCLog.LOG.error("No text for action " + this.getActionTitle());
        String string = OCBundle.message("tab.title.existing", new Object[0]);
        if (string == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected void doPerformAction(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(24);
        }
        if (location == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(25);
        }
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(26);
        }
        if (chosenCandidates == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(27);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> this.doPerformActionInCommand(project, location, actionContext, chosenCandidates), this.getActionTitle(), null);
    }

    protected void doPerformActionInCommand(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(28);
        }
        if (location == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(29);
        }
        if (actionContext == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(30);
        }
        if (chosenCandidates == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(31);
        }
        OCCaretLocation newLoc = (OCCaretLocation)WriteAction.compute(() -> actionContext.isReplaceExisting() ? OCChangeUtil.removeFunctions(actionContext.getExisting(), location) : location);
        List<OCGenerateUtil.Replacement> replacements = this.getReplacements(newLoc, actionContext, chosenCandidates);
        if (FileModificationService.getInstance().preparePsiElementsForWrite(OCGenerateUtil.getAffectedFiles(replacements))) {
            WriteAction.run(() -> OCGenerateUtil.applyReplacements(project, replacements, this.shouldAutoFixImports()));
        }
    }

    protected boolean shouldAutoFixImports() {
        return true;
    }

    @Override
    @Contract(value="_, _, _ -> fail")
    @Nullable
    protected final P getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(32);
        }
        if (file == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(33);
        }
        throw new UnsupportedOperationException("CPP generate handler: Use getParents() instead");
    }

    @Override
    @Contract(value="_, _, _ -> fail")
    @Nullable
    protected final C evaluateActionContext(Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCCCppGenerateHandlerBase.$$$reportNull$$$0(34);
        }
        throw new UnsupportedOperationException("CPP generate handler: return single parent from getParents() instead");
    }

    @Override
    @Contract(value=" -> fail")
    protected final Class<? extends OCSymbolDeclarator> getParentClass() {
        throw new UnsupportedOperationException("CPP generate handler: Can't have single parent, don't use getParentClass");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCCCppGenerateHandlerBase";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 18: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCCCppGenerateHandlerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoParentsMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentChooserTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExistingFunctions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSomeDefinedText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDefinedText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingTabName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "defaultInlineOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInlinePolicy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingFunctions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doPerformActionInCommand";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

