/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.daemon.OCCheckImplementedMethodsProcessor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.daemon.OCDeclaratorChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCOperatorsChecker;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCClearElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCopyElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateInterfaceIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementAllMethodsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementInterfaceIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementMissingAccessorQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OCImplementationChecker
extends OCAnnotatorSinkWrapper {
    public static final int NON_IMPLEMENTED_METHODS_STRING_MAX_LENGTH = 70;
    public static final int DECLARED_IN_CLASSES_STRING_MAX_LENGTH = 30;
    @NotNull
    private final OCDeclaratorChecker myDeclaratorChecker;
    @NotNull
    private final OCOperatorsChecker myOperatorsChecker;

    public OCImplementationChecker(@NotNull OCAnnotatorSink impl, @NotNull OCDeclaratorChecker checker, @NotNull OCOperatorsChecker operatorsChecker) {
        if (impl == null) {
            OCImplementationChecker.$$$reportNull$$$0(0);
        }
        if (checker == null) {
            OCImplementationChecker.$$$reportNull$$$0(1);
        }
        if (operatorsChecker == null) {
            OCImplementationChecker.$$$reportNull$$$0(2);
        }
        super(impl);
        this.myDeclaratorChecker = checker;
        this.myOperatorsChecker = operatorsChecker;
    }

    private void checkImplementationMatchesInterface(OCImplementation implementation, OCInterface anInterface) {
        if (anInterface == null) {
            return;
        }
        OCSuperClassRef implSuperClassRef = implementation.getSuperClassRef();
        OCSuperClassRef intfSuperClassRef = anInterface.getSuperClassRef();
        if (implSuperClassRef.getFirstChild() != null && !OCElementUtil.areElementsEquivalent(implSuperClassRef, intfSuperClassRef, true)) {
            Annotation annotation = this.addErrorAnnotation(implSuperClassRef, "err_conflicting_super_class", "Implementation superclass is inconsistent with interface superclass");
            this.registerQuickFix(annotation, new OCCopyElementIntentionAction(intfSuperClassRef, implSuperClassRef, OCInspectionsBundle.message("quick.fix.copy.superclass.from.interface", new Object[0])));
            this.registerQuickFix(annotation, new OCCopyElementIntentionAction(implSuperClassRef, intfSuperClassRef, OCInspectionsBundle.message("quick.fix.copy.superclass.to.interface", new Object[0])));
            this.registerQuickFix(annotation, new OCClearElementIntentionAction(implSuperClassRef, OCInspectionsBundle.message("quick.fix.remove.superclass", new Object[0])));
        }
    }

    public void checkMethod(OCMethod method) {
        List<PsiElement> selectors = method.getSelectors();
        this.myDeclaratorChecker.checkDuplicates(method.getSelector(), method, selectors);
        OCType returnType = method.getReturnType().resolve(method);
        OCMethodSymbol symbol = (OCMethodSymbol)method.getSymbol();
        if (!returnType.isVoid()) {
            this.myDeclaratorChecker.checkInstanceable(returnType, method.getReturnTypeElement(), symbol, true);
        }
        if (symbol == null) {
            return;
        }
        if (!(symbol.getParent() instanceof OCImplementationSymbol)) {
            this.myOperatorsChecker.checkReadonlyAccess(selectors, symbol, "Declaring", method.getProject());
        }
        if (symbol.isDefinition() && OCCompilerFeaturesHelper.supportsAutosynthesis(method.getContainingOCFile())) {
            OCPropertySymbol property;
            Project project = method.getProject();
            OCMethodSymbol associatedSymbol = symbol.getAssociatedSymbol(project);
            OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            if (property != null && !property.isReadonly() && property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ATOMIC, property.getType(), method) != OCPropertySymbol.PropertyAttribute.NONATOMIC && property.processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){
                int cnt;

                public boolean process(OCMethodSymbol symbol) {
                    return ++this.cnt < 2;
                }
            }, false, project)) {
                OCResolveContext context = OCResolveContext.forPsi(method);
                String message = "Writable atomic " + property.getNameWithKindLowercase(context) + " can't have a" + (symbol.isGetter(context) ? " defined getter and a synthesized setter" : " synthesized getter and a defined setter");
                List<Annotation> annotations = this.addWarningAnnotations(selectors, OCInspections.AccessorsWereOverridden.class, "warn_atomic_property_rule", message);
                this.registerQuickFixes(annotations, new OCImplementMissingAccessorQuickFix(property, symbol.isGetter(context), project));
                this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction(property, OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.NONATOMIC, null, project));
                this.registerQuickFixes(annotations, new OCRemoveElementsIntentionAction((PsiElement)method, symbol.isGetter(context) ? OCInspectionsBundle.message("quick.fix.remove.user.defined.getter.method", new Object[0]) : OCInspectionsBundle.message("quick.fix.remove.user.defined.setter.method", new Object[0])));
            }
        }
    }

    private void checkClassContents(OCClassDeclaration<? extends OCClassSymbol> clazz) {
        Annotation annotation;
        OCInstanceVariablesList implVariables = clazz.getInstanceVariablesList();
        String categoryName = clazz.getCategory();
        if (categoryName != null) {
            if (!clazz.getSuperClassRef().isEmpty()) {
                annotation = this.addErrorAnnotation(clazz.getSuperClassRef(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Category can't have superclass");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getSuperClassRef(), OCInspectionsBundle.message("quick.fix.remove.superclass.reference", new Object[0])));
            }
            if (!(implVariables.isEmpty() || OCCompilerFeaturesHelper.supportsIvarsInCategories() && categoryName.isEmpty())) {
                annotation = this.addErrorAnnotation(implVariables, OCInspections.ConstructionIsNotAllowed.class, "err_misplaced_ivar", "Category can't have instance variables");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(implVariables, OCInspectionsBundle.message("quick.fix.remove.instance.variable.list", new Object[0])));
            }
        }
        if (clazz instanceof OCProtocol) {
            if (!clazz.getSuperClassRef().isEmpty()) {
                annotation = this.addErrorAnnotation(clazz.getSuperClassRef(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Protocol can't have superclass");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getSuperClassRef(), OCInspectionsBundle.message("quick.fix.remove.superclass.reference", new Object[0])));
            }
            if (!implVariables.isEmpty() && implVariables.getDeclarations().size() > 0) {
                annotation = this.addErrorAnnotation(implVariables.getDeclarations().get(0), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Protocol can't have instance variables");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(implVariables, OCInspectionsBundle.message("quick.fix.remove.instance.variable.list", new Object[0])));
            }
            if (categoryName != null) {
                this.addErrorAnnotation(clazz.getNameIdentifier(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Protocol can't have category");
            }
        }
        if (clazz instanceof OCImplementation && !clazz.getProtocolList().isEmpty()) {
            annotation = this.addErrorAnnotation(clazz.getProtocolList(), OCInspections.ConstructionIsNotAllowed.class, "err_objc_unexpected_attr", "Implementation can't have protocols");
            this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getProtocolList(), OCInspectionsBundle.message("quick.fix.remove.protocols.list", new Object[0])));
        }
        for (OCMethod method : clazz.getMethods()) {
            if (method.getBody() != null) {
                Annotation annotation2 = null;
                if (clazz instanceof OCInterface) {
                    annotation2 = this.addErrorAnnotation(method.getBody(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Interface can't have method implementations");
                }
                if (clazz instanceof OCProtocol) {
                    annotation2 = this.addErrorAnnotation(method.getBody(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Protocol can't have method implementations");
                }
                if (annotation2 == null) continue;
                this.registerQuickFix(annotation2, new OCRemoveElementsIntentionAction((PsiElement)method.getBody(), OCInspectionsBundle.message("quick.fix.remove.method.body", new Object[0])));
                continue;
            }
            if (!(clazz instanceof OCImplementation)) continue;
            this.addErrorAnnotation(method.getNavigationElement(), OCInspections.Methods.class, "err_expected_method_body", "Implementation of this method is expected");
        }
    }

    public void checkSynthesize(OCSynthesizeProperty property) {
        OCReferenceElement ivarRef;
        OCImplementation implementation = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCImplementation.class});
        if (implementation == null) {
            Annotation annotation = this.addErrorAnnotation(property.getParent(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "'@synthesize'/'@dynamic' is outside of a class implementation");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(property.getParent(), OCInspectionsBundle.message("quick.fix.remove.synthesize.dynamic.statement", new Object[0])));
            return;
        }
        if (implementation.getCategory() != null && property.isSynthesize()) {
            Annotation annotation = this.addErrorAnnotation(property.getParent(), OCInspections.ConstructionIsNotAllowed.class, OCClangMessageFinder.getInstance().getSynthesizeCategoryDecl(), "'@synthesize' is not allowed in category's implementation");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(property.getParent(), OCInspectionsBundle.message("quick.fix.remove.synthesize.statement", new Object[0])));
            return;
        }
        OCReferenceElement propertyRef = property.getPropertyRef();
        if (propertyRef == null) {
            return;
        }
        OCClassSymbol classSymbol = implementation.getSymbol();
        OCPropertySymbol propertySymbol = (OCPropertySymbol)propertyRef.resolveToSymbol();
        OCReferenceElement oCReferenceElement = ivarRef = property.getInstanceVariableRef() != null ? property.getInstanceVariableRef() : propertyRef;
        if (classSymbol == null || ivarRef == null || propertySymbol == null) {
            return;
        }
        classSymbol = classSymbol.getInterface(property.getProject());
        OCFileSymbols.markImportNeeded(property.getContainingOCFile(), propertySymbol.getParent());
        OCInstanceVariableSymbol ivarSymbol = (OCInstanceVariableSymbol)ivarRef.resolveToSymbol(new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.INSTANCE_VARIABLE, classSymbol)));
        if (ivarSymbol == null) {
            return;
        }
        if (ivarSymbol.getGeneratedFromProperty() != null && property.isSynthesize()) {
            this.handleDynamicIvar(property, propertySymbol, ivarRef);
        }
        if (ivarSymbol.getGeneratedFromProperty() == null) {
            OCFileSymbols.markSymbolAsUsed(property.getContainingOCFile(), ivarSymbol, property);
        }
        this.checkDuplicateSynthesize(property, propertySymbol, propertyRef);
        this.checkDuplicateSynthesize(property, ivarSymbol, ivarRef);
        String propertyCategory = propertySymbol.getParent().getCategoryName();
        if (propertyCategory != null && !propertyCategory.isEmpty()) {
            Annotation annotation = this.addErrorAnnotation(propertyRef, OCInspections.ConstructionIsNotAllowed.class, OCClangMessageFinder.getInstance().getCategoryProperty(), "Can't synthesize property declared in category");
            if (classSymbol != null) {
                this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.PROPERTY, property, classSymbol, propertySymbol));
            }
        }
        if (classSymbol != null && !ivarSymbol.getParent().getName().equals(classSymbol.getName())) {
            String message = ivarSymbol.getNameWithKindUppercase(OCCompilationContext.create(property)) + " must be declared in class '" + implementation.getCanonicalName() + "'";
            Annotation annotation = this.addErrorAnnotation(ivarRef, OCClangMessageFinder.getInstance().getIvarInSuperclassUse(), message);
            this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.INSTANCE_VARIABLE, property, classSymbol, ivarSymbol));
        }
    }

    private void handleDynamicIvar(OCSynthesizeProperty property, OCPropertySymbol propertySymbol, OCReferenceElement ivarRef) {
        for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
            each.checkDynamicIVar(this, property, propertySymbol, ivarRef);
        }
    }

    private void checkDuplicateSynthesize(OCSynthesizeProperty stmt, OCMemberSymbol symbol, PsiElement reference) {
        int stmtOffset = stmt.getTextOffset();
        Project project = stmt.getProject();
        Processor processor = synthesizeSymbol -> {
            PsiElement definition = synthesizeSymbol.locateDefinition(project);
            if (definition != null && definition.getTextOffset() < stmtOffset) {
                String message = null;
                OCPropertySymbol propertySymbol = synthesizeSymbol.getAssociatedProperty(project);
                OCInstanceVariableSymbol ivarSymbol = synthesizeSymbol.getIvarSymbol(project);
                String clangID = null;
                OCCompilationContext context = OCCompilationContext.create(stmt);
                if (symbol instanceof OCInstanceVariableSymbol && propertySymbol != null) {
                    message = symbol.getNameWithKindUppercase(context) + " was already used for synthesizing of " + propertySymbol.getNameWithKindLowercase(context);
                    clangID = OCClangMessageFinder.getInstance().getDuplicateIvarUse();
                } else if (symbol instanceof OCPropertySymbol && ivarSymbol != null) {
                    message = "Accessors of " + symbol.getNameWithKindLowercase(context) + " were already synthesized with " + ivarSymbol.getNameWithKindLowercase(context);
                    clangID = OCClangMessageFinder.getInstance().getPropertyImplemented();
                }
                if (message != null) {
                    this.addErrorAnnotation(reference, OCInspections.DuplicateDeclarations.class, clangID, message);
                }
                return false;
            }
            return true;
        };
        if (symbol instanceof OCPropertySymbol) {
            ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)processor, project);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            ((OCInstanceVariableSymbol)symbol).processSynthesizes((Processor<OCSynthesizeSymbol>)processor, project);
        }
    }

    public void checkInterfaceDeclaration(OCInterface anInterface) {
        OCInterfaceSymbol mainInterface;
        this.checkClassContents(anInterface);
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        if (interfaceSymbol == null || interfaceSymbol.isPredeclaration()) {
            return;
        }
        if (this.checkCyclicInheritance(anInterface)) {
            return;
        }
        Project project = anInterface.getProject();
        this.checkCategoryImport(anInterface, interfaceSymbol, interfaceSymbol.getResolvedType(OCResolveContext.forPsi(anInterface)));
        OCImplementationSymbol implementationSymbol = interfaceSymbol.getImplementation(project);
        if (implementationSymbol != null) {
            if (!"CoreDataGeneratedAccessors".equals(interfaceSymbol.getCategoryName())) {
                OCCheckImplementedMethodsProcessor methodsProcessor = new OCCheckImplementedMethodsProcessor(this, implementationSymbol, null, false, project);
                interfaceSymbol.processMembers(OCMethodSymbol.class, methodsProcessor);
            }
        } else if (OCCodeInsightUtil.isValid(anInterface) && anInterface.getCategory() == null) {
            Annotation annotation = this.addWarningAnnotation(anInterface.getNameIdentifier(), OCInspections.InterfaceHasNoImplementation.class, "CIDR", "Interface '" + anInterface.getCanonicalName() + "' doesn't have an implementation");
            this.registerQuickFix(annotation, new OCImplementInterfaceIntentionAction(interfaceSymbol, project));
        }
        if ("".equals(anInterface.getCategory()) && (mainInterface = interfaceSymbol.getMainInterface(project)) != null && Comparing.equal((Object)interfaceSymbol.getContainingFile(), (Object)mainInterface.getContainingFile())) {
            this.addWarningAnnotation(anInterface.getNameIdentifier(), OCInspections.PrivateCategoryShouldBeNearImplementation.class, "CIDR", "Private category should not be declared in the same file with the public interface");
        }
    }

    private boolean checkCyclicInheritance(OCInterface anInterface) {
        OCInterfaceSymbol aClass = anInterface.getSymbol();
        HashSet<OCInterfaceSymbol> processed = new HashSet<OCInterfaceSymbol>();
        while (aClass != null) {
            if (!processed.add(aClass)) {
                this.addErrorAnnotation(anInterface.getNameIdentifier(), "err_recursive_superclass", "There's a loop in inheritance hierarchy");
                return true;
            }
            OCReferenceType superType = aClass.getSuperType();
            OCType type = superType.resolve(anInterface);
            aClass = type instanceof OCObjectType ? ((OCObjectType)type).getInterface() : null;
        }
        return false;
    }

    public void checkInterfaceImplementation(OCImplementation implementation) {
        OCImplementationSymbol implementationSymbol = implementation.getSymbol();
        if (implementationSymbol == null) {
            return;
        }
        Project project = implementation.getProject();
        OCInterfaceSymbol interfaceSymbol = implementationSymbol.getInterface(project);
        this.checkClassContents(implementation);
        OCType type = implementationSymbol.getType().resolve(implementation);
        this.checkCategoryImport(implementation, implementationSymbol, type);
        if (interfaceSymbol == null) {
            if (implementation.getCategory() == null) {
                String message = "Implementation of '" + implementation.getCanonicalName() + "' doesn't have an interface declaration";
                Annotation annotation = this.addWarningAnnotation(implementation.getNameIdentifier(), OCInspections.ImplementationHasNoInterface.class, "err_undef_interface", message);
                interfaceSymbol = implementationSymbol.getInterface(true, implementationSymbol.getCategoryName(), project);
                if (interfaceSymbol != null) {
                    this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(implementation.getNameIdentifier(), interfaceSymbol));
                } else {
                    PsiElement nameIdentifier = implementation.getNameIdentifier();
                    if (nameIdentifier != null) {
                        this.registerQuickFix(annotation, new OCCreateInterfaceIntentionAction(implementationSymbol, nameIdentifier));
                    }
                }
            }
            return;
        }
        if ("".equals(implementation.getCategory())) {
            this.addErrorAnnotation(implementation.getNameIdentifier(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Private category can't have an implementation");
        }
        OCInterface anInterface = (OCInterface)interfaceSymbol.locateDefinition(project);
        OCFileSymbols.markImportNeeded(implementation.getContainingOCFile(), interfaceSymbol);
        if (anInterface != null) {
            this.checkImplementationMatchesInterface(implementation, anInterface);
        }
        if (type instanceof OCObjectType && Objects.equals(interfaceSymbol.getCategoryName(), implementationSymbol.getCategoryName())) {
            OCObjectType objectType = (OCObjectType)type;
            OCCheckImplementedMethodsProcessor methodsProcessor = new OCCheckImplementedMethodsProcessor(this, implementationSymbol, ((OCObjectType)type).getSuperType(), true, project);
            objectType.processInterfaceMethods(interfaceSymbol, null, methodsProcessor, implementation, false);
            if (!methodsProcessor.wasUnimplementedProperty() && methodsProcessor.getUnimplementedMethods().length() > 0) {
                String message = "Class doesn't implement method(s) " + methodsProcessor.getUnimplementedMethods() + " declared in the " + methodsProcessor.getDeclaredInClasses();
                String clangID = OCClangMessageFinder.getInstance().getMethodNotImplemented();
                Annotation annotation = this.addWarningAnnotation(implementation.getNameIdentifier(), OCInspections.NotImplementedMethods.class, clangID, message);
                this.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction(implementationSymbol));
            }
        }
    }

    private void checkCategoryImport(OCClassDeclaration clazz, OCClassSymbol symbol, OCType type) {
        if (symbol.getCategoryName() != null) {
            if (type instanceof OCObjectType) {
                OCFileSymbols.markImportNeeded(clazz.getContainingOCFile(), ((OCObjectType)type).getInterface());
            } else {
                Annotation annotation = this.addErrorAnnotation(clazz.getNameIdentifier(), OCInspections.CannotResolve.class, "CIDR", "Can't resolve interface '" + symbol.getName() + "'");
                OCInterfaceSymbol interfaceDef = (OCInterfaceSymbol)OCSymbolBase.findSymbolDefinition(symbol.getName(), OCSymbolKind.INTERFACE, clazz.getProject(), symbol.getContainingFile(), interfaceSymbol -> interfaceSymbol.getCategoryName() == null);
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(clazz.getNameIdentifier(), interfaceDef, true, false));
            }
        }
    }

    public void checkProtocolDeclaration(OCProtocol protocol) {
        this.checkClassContents(protocol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "impl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "checker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "operatorsChecker";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/legacy/daemon/OCImplementationChecker";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

