/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCMultiSymbolAlgorithm;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCEscapedValuesChecker
extends OCMultiSymbolAlgorithm {
    OCEscapedValuesChecker(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    protected boolean processClosureSymbols() {
        return false;
    }

    @NotNull
    public Collection<PsiElement> getEscapedVariables() {
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        for (Pair<OCSymbol, PsiElement> pair : this.getReachableElements()) {
            result.add((PsiElement)pair.getSecond());
        }
        HashSet<PsiElement> hashSet = result;
        if (hashSet == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Override
    protected boolean isGoodWrite(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpr = (OCUnaryExpression)element;
            return unaryExpr.isGetAddress() && !OCCodeInsightUtil.isOverloadedOperatorUsage(unaryExpr) && OCEscapedValuesChecker.isLocalVar(unaryExpr.getOperand()) && !(unaryExpr.getOperand().getResolvedType() instanceof OCMagicType);
        }
        if (element instanceof OCReferenceExpression) {
            if (!OCEscapedValuesChecker.isLocalVar((OCExpression)element)) {
                return false;
            }
            OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class);
            if (declarator != null) {
                return declarator.getResolvedType() instanceof OCCppReferenceType && !(((OCReferenceExpression)element).getResolvedType() instanceof OCMagicType);
            }
            return false;
        }
        if (element instanceof OCBlockExpression) {
            return !OCCompilerFeaturesHelper.isArcEnabled(element.getContainingFile());
        }
        return false;
    }

    @Override
    protected boolean isGoodRead(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(1);
        }
        OCSymbol symbol = instruction.getSymbol();
        PsiElement rValue = instruction.getRValue();
        if (rValue != null && symbol.getType().resolve((PsiElement)rValue.getContainingFile()) instanceof OCCppReferenceType) {
            return this.isGoodWrite(rValue);
        }
        return super.isGoodRead(instruction);
    }

    private static boolean isLocalVar(OCExpression operand) {
        if (operand != null) {
            while (operand instanceof OCQualifiedExpression && ((OCQualifiedExpression)operand).getQualifyingTokenKind() == OCTokenTypes.DOT) {
                operand = ((OCQualifiedExpression)operand).getQualifier();
            }
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(OCResolveContext.forPsi(operand));
            operand.accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (!(symbol == null || visitor.getNumOfDereferences() != 0 || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic())) {
                if (symbol.getType().resolve((PsiElement)operand.getContainingFile()) instanceof OCCppReferenceType) {
                    PsiElement declarator = symbol.locateDefinition(operand.getProject());
                    return OCEscapedValuesChecker.isLocalVar(declarator instanceof OCDeclarator ? ((OCDeclarator)declarator).getInitializer() : null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean treatReferencesAsStartInstructions() {
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(2);
        }
        PsiElement rValue = instruction.getRValue();
        return super.isEndInstruction(instruction) && rValue != null && OCEscapedValuesChecker.isEscaped(rValue, null);
    }

    @NotNull
    public List<PsiElement> getEscapedObjects() {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final PsiElement codeFragment = this.myCfg.getCodeFragment();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                PsiElement blockScope;
                if (blockExpression != codeFragment && OCEscapedValuesChecker.this.isGoodWrite(blockExpression) && (blockScope = OCScopeInfo.createScopeInfo(blockExpression).getParentScope()) != null && OCEscapedValuesChecker.isEscaped(blockExpression, OCSymbolOffsetUtil.getComplexRange(blockScope))) {
                    result.add(blockExpression);
                }
            }

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                if (!OCEscapedValuesChecker.isLocalVar(expression)) {
                    return;
                }
                OCType type = expression.getResolvedType();
                if (OCEscapedValuesChecker.isEscaped(expression, null) && (type instanceof OCArrayType || !(type instanceof OCCppReferenceType) && !(type instanceof OCPointerType) && !(type instanceof OCMagicType))) {
                    result.add(expression);
                }
            }

            @Override
            public void visitUnaryExpression(OCUnaryExpression expression) {
                super.visitUnaryExpression(expression);
                if (OCEscapedValuesChecker.this.isGoodWrite(expression) && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }
        });
        result.removeAll(this.getEscapedVariables());
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static boolean canBubble(@NotNull PsiElement element, @NotNull PsiElement parent) {
        if (element == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(5);
        }
        if (parent instanceof OCExpression) {
            if (parent instanceof OCConditionalExpression) {
                OCConditionalExpression conditionalExpression = (OCConditionalExpression)parent;
                return PsiTreeUtil.isAncestor((PsiElement)conditionalExpression.getPositiveExpression(true), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)conditionalExpression.getNegativeExpression(), (PsiElement)element, (boolean)false);
            }
            if (parent instanceof OCParenthesizedExpression) {
                return true;
            }
            if (parent instanceof OCCommaExpression) {
                return PsiTreeUtil.isAncestor((PsiElement)((OCCommaExpression)parent).getTailExpression(), (PsiElement)element, (boolean)false);
            }
            if (parent instanceof OCPrefixExpression) {
                OCPrefixExpression prefixExpression = (OCPrefixExpression)parent;
                return !OCCodeInsightUtil.isOverloadedOperatorUsage(prefixExpression) && (prefixExpression.getOperationSign() == OCTokenTypes.MINUSMINUS || prefixExpression.getOperationSign() == OCTokenTypes.PLUSPLUS);
            }
        }
        return false;
    }

    private static boolean isEscaped(@NotNull PsiElement element, @Nullable ComplexTextRange scope) {
        if (element == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (OCEscapedValuesChecker.isAssignmentExpression(parent)) {
                OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(OCResolveContext.forPsi(element));
                OCExpression receiverExpression = ((OCAssignmentExpression)parent).getReceiverExpression();
                receiverExpression.accept(visitor);
                OCSymbol symbol = visitor.getSymbol();
                if (symbol != null) {
                    OCType type = OCTypeUtils.getCppReferencedType(receiverExpression.getResolvedType());
                    if (symbol instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                        return false;
                    }
                    if (!(type instanceof OCPointerType)) {
                        return false;
                    }
                    if (scope != null && !scope.equals(symbol.getScope())) {
                        return true;
                    }
                    if (scope == null && !symbol.getKind().isLocal()) {
                        return true;
                    }
                }
                return false;
            }
            if (parent instanceof OCReturnStatement) {
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)parent, OCCallable.class);
                if (callable == null) continue;
                OCType returnType = callable.getReturnType().resolve((PsiElement)parent.getContainingFile());
                return returnType instanceof OCCppReferenceType || returnType instanceof OCPointerType;
            }
            if (!OCEscapedValuesChecker.canBubble(element, parent)) break;
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean isAssignmentExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(7);
        }
        return expression instanceof OCAssignmentExpression && ((OCAssignmentExpression)expression).getOperationSign() == OCTokenTypes.EQ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/dfa/OCEscapedValuesChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/dfa/OCEscapedValuesChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isGoodRead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBubble";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEscaped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

