/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.light.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLightFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider {
    private static final Set<Language> ourLanguages = ContainerUtil.immutableSet((Object[])new Language[]{OCLanguageUtils.getLightLanguage(), OCLanguageUtils.getSlowLanguage()});

    public OCLightFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = ourLanguages;
        if (set == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = OCLanguageUtils.getLightLanguage();
        if (language == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language language) {
        if (language == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(4);
        }
        FileType type = this.getFileType();
        return (PsiFileImpl)this.createFile(this.getVirtualFile(), type, language);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(5);
        }
        if (!this.hasLanguage(lang)) {
            return null;
        }
        if (this.getManager().getProject().getUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED) == Boolean.TRUE) {
            return new PsiPlainTextFileImpl((FileViewProvider)this);
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parser == null) {
            return null;
        }
        return parser.createFile((FileViewProvider)this);
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return OCLightFileViewProvider.findElementAt((PsiElement)this.getPsi(OCLanguageUtils.getLightLanguage()), (int)offset);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            OCLightFileViewProvider.$$$reportNull$$$0(6);
        }
        return new OCLightFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/light/psi/OCLightFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/light/psi/OCLightFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFileImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

