/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.AllowedModuleHandler;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.CacheBase;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.CacheImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.EmptyCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.GlobalCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapHeaderCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapLocationCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J$\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_globalCache", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "descriptorsForInitialBuilding", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/ModuleMapDescriptor;", "getDescriptorsForInitialBuilding", "()Ljava/util/List;", "globalCache", "getGlobalCache", "()Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildDependencies", "", "item", "impatientRescheduling", "Ljava/lang/Runnable;", "session", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "buildModule", "cacheFor", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "clearCache", "findModule", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "header", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasModuleMap", "", "root", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "newCache", "obtainModules", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMap;", "processDependencies", "modules", "setupInclusionContext", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "Companion", "intellij.c"})
public class ModuleMapManagerImpl
implements ModuleMapManager {
    private volatile ModuleMapManager.Cache _globalCache;
    @NotNull
    private final Project project;
    private static final Key<ModuleMapManager.Cache> CACHE_KEY;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ModuleMapManager.Cache cacheFor(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return this.getGlobalCache();
        }
        ModuleMapManager.Cache cache = (ModuleMapManager.Cache)configuration.getUserData(CACHE_KEY);
        if (cache != null) {
            return cache;
        }
        Object object = configuration.putUserDataIfAbsent(CACHE_KEY, (Object)this.newCache(configuration));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.putUserDat\u2026 newCache(configuration))");
        return (ModuleMapManager.Cache)object;
    }

    @Override
    @NotNull
    public ModuleMapManager.Cache getGlobalCache() {
        ModuleMapManager.Cache cache = this._globalCache;
        if (cache == null) {
            ModuleMapManager.Cache cache2 = this.newCache(null);
            boolean bl = false;
            boolean bl2 = false;
            ModuleMapManager.Cache it = cache2;
            boolean bl3 = false;
            this._globalCache = it;
            cache = cache2;
        }
        return cache;
    }

    private final ModuleMapManager.Cache newCache(OCResolveConfiguration configuration) {
        return !AllowedModuleHandler.INSTANCE.isEnabled(this.project) ? (ModuleMapManager.Cache)EmptyCache.INSTANCE : (ModuleMapManager.Cache)(configuration != null ? (CacheBase)new CacheImpl(configuration) : (CacheBase)new GlobalCache(this.project));
    }

    @Override
    public boolean hasModuleMap(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return ModuleMapCache.Companion.getInstance(this.project).getPack(root).getHasModuleMaps();
    }

    @Override
    @Nullable
    public ModuleMapSymbol findModule(@NotNull VirtualFile header, @NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return ModuleMapHeaderCache.Companion.getInstance(this.project).findModule(header, configuration);
    }

    @Override
    public void buildModule(@NotNull ModuleMapDescriptor item, @Nullable Runnable impatientRescheduling, @NotNull SerializationSession session) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.obtainModules(item, session, impatientRescheduling);
    }

    private final ModuleMap obtainModules(ModuleMapDescriptor item, SerializationSession session, Runnable impatientRescheduling) {
        HeadersSearchRoot root = item.getHeadersSearchRoot();
        if (!this.hasModuleMap(root)) {
            return null;
        }
        OCResolveConfiguration configuration = item.isForGlobal() ? null : item.getConfiguration();
        ModuleMapManager.Cache cache = this.cacheFor(configuration);
        if (!(cache instanceof CacheBase)) {
            cache = null;
        }
        CacheBase cacheBase = (CacheBase)cache;
        if (cacheBase == null) {
            return null;
        }
        CacheBase cache2 = cacheBase;
        OCInclusionContext context = this.setupInclusionContext(configuration, impatientRescheduling);
        return cache2.getModuleMap(item.getHeadersSearchRoot(), session, context);
    }

    @Override
    public void buildDependencies(@NotNull ModuleMapDescriptor item, @Nullable Runnable impatientRescheduling, @NotNull SerializationSession session) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ModuleMap moduleMap = this.obtainModules(item, session, impatientRescheduling);
        if (moduleMap == null) {
            return;
        }
        ModuleMap modules2 = moduleMap;
        this.processDependencies(modules2, item.getConfiguration());
    }

    private final OCInclusionContext setupInclusionContext(OCResolveConfiguration configuration, Runnable impatientRescheduling) {
        if (configuration == null) {
            return null;
        }
        OCInclusionContext oCInclusionContext = ModuleMapUtil.createSignatureContext(configuration).derive();
        Intrinsics.checkNotNullExpressionValue((Object)oCInclusionContext, (String)"configuration.createSignatureContext().derive()");
        OCInclusionContext inclusionContext = oCInclusionContext;
        inclusionContext.setImpatientRescheduling(impatientRescheduling);
        return inclusionContext;
    }

    private final void processDependencies(ModuleMap modules2, OCResolveConfiguration configuration) {
        for (ModuleMapSymbol module : ModuleMapUtil.allModules(modules2)) {
            module.getDependencies(configuration);
        }
    }

    @Override
    @NotNull
    public List<ModuleMapDescriptor> getDescriptorsForInitialBuilding() {
        boolean bl = false;
        List descriptors = new ArrayList();
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"OCWorkspace.getInstance(project)");
        List list = oCWorkspace.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"OCWorkspace.getInstance(project).configurations");
        List configurations = list;
        boolean bl2 = false;
        Set usedRoots = new LinkedHashSet();
        for (OCResolveConfiguration configuration : configurations) {
            ModuleMapManager.Cache cache = this.cacheFor(configuration);
            CollectionsKt.addAll((Collection)descriptors, (Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)cache.getHeaderSearchRoots()), (Function1)((Function1)new Function1<HeadersSearchRoot, ModuleMapDescriptor>(configuration){
                final /* synthetic */ OCResolveConfiguration $configuration;

                @NotNull
                public final ModuleMapDescriptor invoke(@NotNull HeadersSearchRoot it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    OCResolveConfiguration oCResolveConfiguration = this.$configuration;
                    Intrinsics.checkNotNull((Object)oCResolveConfiguration);
                    return new ModuleMapDescriptor(oCResolveConfiguration, it, false);
                }
                {
                    this.$configuration = oCResolveConfiguration;
                    super(1);
                }
            })));
            List<HeadersSearchRoot> roots2 = cache.getHeaderSearchRoots();
            for (HeadersSearchRoot root : roots2) {
                if (!usedRoots.add(root)) continue;
                OCResolveConfiguration oCResolveConfiguration = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)oCResolveConfiguration, (String)"configuration");
                descriptors.add(new ModuleMapDescriptor(oCResolveConfiguration, root, true));
            }
        }
        return descriptors;
    }

    @Override
    public void clearCache() {
        ModuleMapHeaderCache.Companion.getInstance(this.project).clear();
        ModuleMapLocationCache.Companion.getInstance(this.project).clear();
        this._globalCache = null;
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"OCWorkspace.getInstance(project)");
        for (OCResolveConfiguration config : oCWorkspace.getConfigurations()) {
            config.putUserData(CACHE_KEY, null);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ModuleMapManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.project.getMessageBus().connect().subscribe(AllowedModules.INVALIDATION_TOPIC, (Object)new Runnable(){

            @Override
            public final void run() {
                this.clearCache();
            }
        });
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"CACHE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"CACHE_KEY\")");
        CACHE_KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl$Companion;", "", "()V", "CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

