/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCInterner;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationServiceImpl;
import com.jetbrains.cidr.lang.modulemap.serialization.ModulePosition;
import com.jetbrains.cidr.lang.modulemap.serialization.ModulePositionHolder;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.serialization.RootReferenceHolder;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializationSessionKt;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0002J(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010)\u001a\u00020**\u00020&2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializationSessionImpl;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializationSession;", "moduleMapPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl;", "(Ljava/util/Collection;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl;)V", "modulePositions", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModulePositionHolder;", "packs", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializationPack;", "rootReferenceHolder", "Lcom/jetbrains/cidr/lang/modulemap/serialization/RootReferenceHolder;", "serializationPacks", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack;", "getSerializationPacks", "()Ljava/util/List;", "assembleSerializationPack", "pack", "buildModuleInfo", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleInfo;", "module", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "referenceInterner", "Lcom/jetbrains/cidr/lang/OCInterner;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleReference;", "rootBaseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectHeaders", "", "collectModuleDependencies", "symbol", "collectModuleInfos", "headersSearchRoot", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "moduleMap", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMap;", "getHeaderPath", "header", "toSerializedMap", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;", "intellij.c"})
public final class SerializationSessionImpl
implements SerializationSession {
    private final List<SerializationPack> packs;
    private final RootReferenceHolder rootReferenceHolder;
    private final ModulePositionHolder modulePositions;
    @NotNull
    private final List<ModuleMapSerializationPack> serializationPacks;
    private final ModuleMapSerializationServiceImpl serializationService;

    @Override
    @NotNull
    public List<ModuleMapSerializationPack> getSerializationPacks() {
        return this.serializationPacks;
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleMapSerializationPack assembleSerializationPack(SerializationPack pack) {
        Collection<SerializedModuleMap> collection;
        void $this$mapTo$iv$iv;
        ModuleMapPack moduleMapPack = pack.getModuleMapPack();
        if (!moduleMapPack.getHasModuleMaps() || moduleMapPack.isEmpty()) {
            return new ModuleMapSerializationPack(ModuleMapSerializationPack.State.Empty.INSTANCE, pack.getHeadersSearchRoot(), pack.getHash());
        }
        boolean hasPrebuiltModuleMaps = this.serializationService.getPrebuiltCacheInputStream(pack.getHeadersSearchRoot()) != null;
        Iterable $this$map$iv = pack.getModuleMapPack().getPlainModuleMapsUnsafe();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleMap moduleMap = (ModuleMap)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SerializedModuleMap serializedModuleMap = this.toSerializedMap((ModuleMap)it, pack.getHeadersSearchRoot());
            collection.add(serializedModuleMap);
        }
        collection = (List)destination$iv$iv;
        ModuleMap moduleMap = pack.getModuleMapPack().getGlobalMap();
        boolean bl = false;
        boolean bl2 = false;
        destination$iv$iv = moduleMap;
        boolean bl3 = false;
        boolean bl4 = hasPrebuiltModuleMaps;
        ModuleMap moduleMap2 = !bl4 ? moduleMap : null;
        SerializedModuleMap serializedModuleMap = moduleMap2 != null ? this.toSerializedMap(moduleMap2, pack.getHeadersSearchRoot()) : null;
        Collection<SerializedModuleMap> collection2 = collection;
        long l = pack.getHash();
        HeadersSearchRoot headersSearchRoot = pack.getHeadersSearchRoot();
        ModuleMapSerializationPack.State state = new ModuleMapSerializationPack.State.Value((List<SerializedModuleMap>)collection2, serializedModuleMap);
        return new ModuleMapSerializationPack(state, headersSearchRoot, l);
    }

    private final SerializedModuleMap toSerializedMap(ModuleMap $this$toSerializedMap, HeadersSearchRoot headersSearchRoot) {
        return new SerializedModuleMap($this$toSerializedMap, this.collectModuleInfos(headersSearchRoot, $this$toSerializedMap));
    }

    private final List<ModuleInfo> collectModuleInfos(HeadersSearchRoot headersSearchRoot, ModuleMap moduleMap) {
        OCInterner referenceInterner = new OCInterner();
        VirtualFile rootBaseDirectory = this.serializationService.getRootBaseDirectory(headersSearchRoot);
        if (rootBaseDirectory == null) {
            ModuleMapLog.LOG.error("Non-serializable root " + ModuleMapUtil.getRootText(headersSearchRoot));
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull(ModuleMapUtil.allModules(moduleMap), (Function1)((Function1)new Function1<ModuleMapSymbol, ModuleInfo>(this, referenceInterner, rootBaseDirectory){
            final /* synthetic */ SerializationSessionImpl this$0;
            final /* synthetic */ OCInterner $referenceInterner;
            final /* synthetic */ VirtualFile $rootBaseDirectory;

            @Nullable
            public final ModuleInfo invoke(@NotNull ModuleMapSymbol module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return SerializationSessionImpl.access$buildModuleInfo(this.this$0, module, this.$referenceInterner, this.$rootBaseDirectory);
            }
            {
                this.this$0 = serializationSessionImpl;
                this.$referenceInterner = oCInterner;
                this.$rootBaseDirectory = virtualFile;
                super(1);
            }
        })));
    }

    private final ModuleInfo buildModuleInfo(ModuleMapSymbol module, OCInterner<ModuleReference> referenceInterner, VirtualFile rootBaseDirectory) {
        List<ModuleReference> list = this.collectModuleDependencies(module, referenceInterner);
        if (list == null) {
            return null;
        }
        List<ModuleReference> dependencies2 = list;
        List<String> headers = this.collectHeaders(module, rootBaseDirectory);
        return new ModuleInfo(module, headers, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectHeaders(ModuleMapSymbol module, VirtualFile rootBaseDirectory) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = module.getIncludeHeaders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.getHeaderPath((VirtualFile)file, rootBaseDirectory);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final String getHeaderPath(VirtualFile header, VirtualFile rootBaseDirectory) {
        String string;
        if (header instanceof LightVirtualFile) {
            boolean $i$f$runReadAction = false;
            String customPath = (String)ApplicationManager.getApplication().runReadAction(new Computable(header){
                final /* synthetic */ VirtualFile $header$inlined;
                {
                    this.$header$inlined = virtualFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)CustomHeaderProvider.provideSerializationPathForFile(this.$header$inlined);
                }
            });
            if (customPath != null) {
                return customPath;
            }
        }
        if ((string = VfsUtil.getRelativePath((VirtualFile)header, (VirtualFile)rootBaseDirectory)) == null) {
            String string2 = header.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"header.path");
        }
        return string;
    }

    private final List<ModuleReference> collectModuleDependencies(ModuleMapSymbol symbol, OCInterner<ModuleReference> referenceInterner) {
        List<ModuleMapSymbol> list = symbol.getCachedDependencies();
        if (list == null) {
            return null;
        }
        List<ModuleMapSymbol> modules2 = list;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)modules2), (Function1)((Function1)new Function1<ModuleMapSymbol, ModuleReference>(this){
            final /* synthetic */ SerializationSessionImpl this$0;

            @Nullable
            public final ModuleReference invoke(@NotNull ModuleMapSymbol module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Object object = SerializationSessionImpl.access$getModulePositions$p(this.this$0).get(module);
                if (object == null || (object = ((ModulePosition)object).getModuleMapReference()) == null) {
                    return null;
                }
                Object moduleMapReference = object;
                return new ModuleReference(module.getModuleName(), (ModuleMapReference)moduleMapReference);
            }
            {
                this.this$0 = serializationSessionImpl;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ModuleReference, ModuleReference>(referenceInterner){

            @NotNull
            public final ModuleReference invoke(@NotNull ModuleReference p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return (ModuleReference)((OCInterner)this.receiver).intern((Object)p1);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    public SerializationSessionImpl(@NotNull Collection<ModuleMapPackWithRoot> moduleMapPacks, @NotNull ModuleMapSerializationServiceImpl serializationService) {
        Collection<ModuleMapSerializationPack> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(moduleMapPacks, (String)"moduleMapPacks");
        Intrinsics.checkNotNullParameter((Object)serializationService, (String)"serializationService");
        this.serializationService = serializationService;
        this.packs = SerializationSessionKt.access$setupSerializationPacks(this.serializationService, moduleMapPacks);
        this.rootReferenceHolder = new RootReferenceHolder(this.packs);
        this.modulePositions = new ModulePositionHolder(this.packs, this.rootReferenceHolder);
        Iterable iterable = this.packs;
        SerializationSessionImpl serializationSessionImpl = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pack;
            SerializationPack serializationPack = (SerializationPack)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ModuleMapSerializationPack moduleMapSerializationPack = this.assembleSerializationPack((SerializationPack)pack);
            collection.add(moduleMapSerializationPack);
        }
        collection = (List)destination$iv$iv;
        serializationSessionImpl.serializationPacks = collection;
    }

    public static final /* synthetic */ ModuleInfo access$buildModuleInfo(SerializationSessionImpl $this, ModuleMapSymbol module, OCInterner referenceInterner, VirtualFile rootBaseDirectory) {
        return $this.buildModuleInfo(module, (OCInterner<ModuleReference>)referenceInterner, rootBaseDirectory);
    }

    public static final /* synthetic */ ModulePositionHolder access$getModulePositions$p(SerializationSessionImpl $this) {
        return $this.modulePositions;
    }
}

