/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.qualifiedName;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedNameComparator;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedNameInternerKt;
import com.jetbrains.cidr.lang.symbols.symtable.OCNameInternerKt;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0011\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\u001f\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\t\u0010\"\u001a\u00020\u0019H\u00d6\u0001J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020\u0004H\u0017R\u0011\u0010\u0006\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "", "qualifier", "name", "", "(Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;Ljava/lang/String;)V", "leftmostModuleName", "getLeftmostModuleName", "()Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "getName", "()Ljava/lang/String;", "parts", "", "getParts", "()Ljava/util/List;", "qualifiedNameBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getQualifiedNameBuilder", "()Ljava/lang/StringBuilder;", "getQualifier", "checkQualified", "", "string", "length", "", "compareTo", "other", "component1", "component2", "copy", "equals", "", "equalsToString", "hashCode", "sequenceOfQualifiers", "Lkotlin/sequences/Sequence;", "startsWith", "prefix", "toString", "Companion", "intellij.c"})
public final class QualifiedName
implements Comparable<QualifiedName> {
    @Nullable
    private final QualifiedName qualifier;
    @NotNull
    private final String name;
    @NotNull
    private static final QualifiedName[] EMPTY_ARRAY;
    @NotNull
    public static final Companion Companion;

    @NlsSafe
    @NotNull
    public String toString() {
        String string;
        if (this.qualifier == null) {
            string = this.name;
        } else {
            String string2 = this.getQualifiedNameBuilder().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"qualifiedNameBuilder.toString()");
        }
        return string;
    }

    private final StringBuilder getQualifiedNameBuilder() {
        Comparable<QualifiedName> comparable = this.qualifier;
        if (comparable == null || (comparable = ((QualifiedName)comparable).getQualifiedNameBuilder()) == null || (comparable = ((StringBuilder)comparable).append('.')) == null || (comparable = ((StringBuilder)comparable).append(this.name)) == null) {
            comparable = new StringBuilder(this.name);
        }
        return comparable;
    }

    public final boolean equalsToString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.qualifier == null) {
            return Intrinsics.areEqual((Object)this.name, (Object)string);
        }
        return this.checkQualified(string, string.length());
    }

    private final boolean checkQualified(String string, int length) {
        if (this.qualifier == null) {
            return length == this.name.length() && StringsKt.startsWith$default((String)string, (String)this.name, (boolean)false, (int)2, null);
        }
        if (length < this.name.length() + 1) {
            return false;
        }
        int dotIndex = length - this.name.length() - 1;
        if (string.charAt(dotIndex) != '.') {
            return false;
        }
        if (!StringsKt.startsWith$default((String)string, (String)this.name, (int)(dotIndex + 1), (boolean)false, (int)4, null)) {
            return false;
        }
        return this.qualifier.checkQualified(string, dotIndex);
    }

    @NotNull
    public final QualifiedName getLeftmostModuleName() {
        QualifiedName qualifiedName = this.qualifier;
        if (qualifiedName == null || (qualifiedName = qualifiedName.getLeftmostModuleName()) == null) {
            qualifiedName = this;
        }
        return qualifiedName;
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return QualifiedNameComparator.INSTANCE.compareQualifiedNames(this, other);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(@NotNull QualifiedName prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List<String> parts2 = this.getParts();
        List<String> prefixParts = prefix.getParts();
        if (prefixParts.size() > parts2.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = prefixParts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void prefixPart;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl2 = false;
            String part = parts2.get(index);
            if (!(Intrinsics.areEqual((Object)prefixPart, (Object)part) ^ true)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<String> getParts() {
        return CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.map(this.sequenceOfQualifiers(), (Function1)parts.1.INSTANCE)));
    }

    @NotNull
    public final Sequence<QualifiedName> sequenceOfQualifiers() {
        return SequencesKt.generateSequence((Object)this, (Function1)sequenceOfQualifiers.1.INSTANCE);
    }

    @Nullable
    public final QualifiedName getQualifier() {
        return this.qualifier;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public QualifiedName(@Nullable QualifiedName qualifier, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.qualifier = qualifier;
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        EMPTY_ARRAY = new QualifiedName[0];
    }

    @Nullable
    public final QualifiedName component1() {
        return this.qualifier;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final QualifiedName copy(@Nullable QualifiedName qualifier, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new QualifiedName(qualifier, name);
    }

    public static /* synthetic */ QualifiedName copy$default(QualifiedName qualifiedName, QualifiedName qualifiedName2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            qualifiedName2 = qualifiedName.qualifier;
        }
        if ((n & 2) != 0) {
            string = qualifiedName.name;
        }
        return qualifiedName.copy(qualifiedName2, string);
    }

    public int hashCode() {
        QualifiedName qualifiedName = this.qualifier;
        String string = this.name;
        return (qualifiedName != null ? ((Object)qualifiedName).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof QualifiedName)) break block3;
                QualifiedName qualifiedName = (QualifiedName)object;
                if (!Intrinsics.areEqual((Object)this.qualifier, (Object)qualifiedName.qualifier) || !Intrinsics.areEqual((Object)this.name, (Object)qualifiedName.name)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull String name) {
        return Companion.of(name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull String qualifier, @NotNull String name) {
        return Companion.of(qualifier, name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(String ... names) {
        return Companion.of(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull List<String> names) {
        return Companion.of(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull String name) {
        return Companion.interned(name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull String qualifier, @NotNull String name) {
        return Companion.interned(qualifier, name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(String ... names) {
        return Companion.interned(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull List<String> names) {
        return Companion.interned(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName byQualifiedName(@NotNull String qualifiedName) {
        return Companion.byQualifiedName(qualifiedName);
    }

    @NotNull
    public static final QualifiedName[] getEMPTY_ARRAY() {
        Companion companion = Companion;
        return EMPTY_ARRAY;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J!\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0004\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0007J!\u0010\u0013\u001a\u00020\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0004\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0016\u0010\u0013\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0007J\n\u0010\u0014\u001a\u00020\u0005*\u00020\fR$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\t\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName$Companion;", "", "()V", "EMPTY_ARRAY", "", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "getEMPTY_ARRAY$annotations", "getEMPTY_ARRAY", "()[Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "[Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "byQualifiedName", "qualifiedName", "", "interned", "names", "([Ljava/lang/String;)Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "name", "qualifier", "", "of", "asQualifiedName", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QualifiedName(null, name);
        }

        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull String qualifier, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QualifiedName(new QualifiedName(null, qualifier), name);
        }

        @JvmStatic
        @NotNull
        public final QualifiedName of(String ... names) {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            return this.of(CollectionsKt.listOf((Object[])Arrays.copyOf(names, names.length)));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull List<String> names) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            if (names.isEmpty()) {
                throw (Throwable)new IllegalArgumentException();
            }
            Iterable iterable = names;
            QualifiedName initial$iv = null;
            boolean $i$f$fold = false;
            QualifiedName accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                String string = (String)element$iv;
                QualifiedName prev = accumulator$iv;
                boolean bl = false;
                accumulator$iv = new QualifiedName(prev, (String)part);
            }
            QualifiedName qualifiedName = accumulator$iv;
            Intrinsics.checkNotNull((Object)qualifiedName);
            return qualifiedName;
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = OCNamesInterner.intern((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OCNamesInterner.intern(name)");
            return QualifiedNameInternerKt.intern(new QualifiedName(null, string));
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull String qualifier, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            QualifiedName q = QualifiedNameInternerKt.intern(new QualifiedName(null, OCNameInternerKt.interAsOCName((String)qualifier)));
            return QualifiedNameInternerKt.intern(new QualifiedName(q, OCNameInternerKt.interAsOCName((String)name)));
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(String ... names) {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            return this.interned(CollectionsKt.listOf((Object[])Arrays.copyOf(names, names.length)));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull List<String> names) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            if (names.isEmpty()) {
                throw (Throwable)new IllegalArgumentException();
            }
            Iterable iterable = names;
            QualifiedName initial$iv = null;
            boolean $i$f$fold = false;
            QualifiedName accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                String string = (String)element$iv;
                QualifiedName prev = accumulator$iv;
                boolean bl = false;
                accumulator$iv = QualifiedNameInternerKt.intern(new QualifiedName(prev, OCNameInternerKt.interAsOCName((String)part)));
            }
            QualifiedName qualifiedName = accumulator$iv;
            Intrinsics.checkNotNull((Object)qualifiedName);
            return qualifiedName;
        }

        @JvmStatic
        @NotNull
        public final QualifiedName byQualifiedName(@NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            return this.of(StringsKt.split$default((CharSequence)qualifiedName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null));
        }

        @NotNull
        public final QualifiedName asQualifiedName(@NotNull String $this$asQualifiedName) {
            Intrinsics.checkNotNullParameter((Object)$this$asQualifiedName, (String)"$this$asQualifiedName");
            return this.byQualifiedName($this$asQualifiedName);
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY_ARRAY$annotations() {
        }

        @NotNull
        public final QualifiedName[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

