/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@NotNull OCDeclarator declarator, OCSymbol symbol) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(0);
        }
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.initialize", this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, this.getProject())));
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.add.initializer", new Object[0]);
        if (string == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.mySymbol != null) {
            OCDeclaratorSymbol declaratorSymbol;
            OCResolveContext context = OCResolveContext.forPsi(declarator);
            OCType type = this.mySymbol.getResolvedType(context);
            if (this.mySymbol instanceof OCDeclaratorSymbol && (declaratorSymbol = (OCDeclaratorSymbol)this.mySymbol).hasInitializer()) {
                return false;
            }
            return !(type instanceof OCStructType) || type.isCppStructType(context) || ((OCStructType)type).isEnum();
        }
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(3);
        }
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        OCDeclarator declarator;
        if (project == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(4);
        }
        if ((declarator = (OCDeclarator)this.myElementPtr.getElement()) != null) {
            this.invoke(file, declarator, editor);
        }
    }

    protected void invoke(PsiFile file, @NotNull OCDeclarator declarator, Editor editor) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(5);
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        OCType type = this.mySymbol.getResolvedType(context);
        @NlsSafe String declarationText = "int " + declarator.getTextWithMacros() + "=" + type.getDefaultValue(context);
        OCDeclaration declaration = OCElementFactory.declarationFromText(declarationText, (PsiElement)file, true);
        OCExpression initializer = (declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration.getDeclarators().get(0))).getInitializer();
        if (initializer != null) {
            OCAddInitializerIntentionAction.invokeSmartCompletion(initializer, type);
        }
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression, @NotNull OCType type) {
        if (expression == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(6);
        }
        if (type == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(7);
        }
        OCFile file = expression.getContainingOCFile();
        final boolean deleteOnEsc = type.isPointerToObjectCompatible() && !OCCompilerFeaturesHelper.isArcDisabled(file);
        TextRange initializerRange = expression.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file.getProject().isDisposed() || !file.isValid()) {
                return;
            }
            CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
            base.invokeCompletion(file.getProject(), editor, 1, true);
            LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void lookupCanceled(@NotNull LookupEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (deleteOnEsc && expression.isValid()) {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
                                if (document != null) {
                                    PsiDocumentManager.getInstance((Project)expression.getProject()).commitDocument(document);
                                }
                                OCChangeUtil.delete(expression);
                            });
                        } else {
                            editor.getSelectionModel().removeSelection();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction$1", "lookupCanceled"));
                    }
                });
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeSmartCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

