/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperProtocolIntentionAction
extends OCSymbolQuickFix<OCClassSymbol> {
    private String myProtocol;
    private boolean myPrivateCategoryMode;

    public OCAddSuperProtocolIntentionAction(@NotNull OCClassSymbol anInterface, String protocol, boolean privateCategoryMode, @NotNull Project project) {
        if (anInterface == null) {
            OCAddSuperProtocolIntentionAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCAddSuperProtocolIntentionAction.$$$reportNull$$$0(1);
        }
        super(project, anInterface);
        this.myProtocol = protocol;
        this.myPrivateCategoryMode = privateCategoryMode;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        return "Adopt '" + this.myProtocol + "' by " + (this.myPrivateCategoryMode ? "private category '" + ((OCClassSymbol)this.mySymbol).getName() + "()'" : "class '" + ((OCClassSymbol)this.mySymbol).getName() + "'");
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myPrivateCategoryMode ? OCInspectionsBundle.message("intentions.add.super.protocol.by.class", new Object[0]) : OCInspectionsBundle.message("intentions.add.super.protocol.by.private.category", new Object[0]);
        if (string == null) {
            OCAddSuperProtocolIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myProtocol != null && !((OCClassSymbol)this.mySymbol).isPredeclaration();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCClassDeclaration declaration;
        if (project == null) {
            OCAddSuperProtocolIntentionAction.$$$reportNull$$$0(3);
        }
        if ((declaration = OCElementUtil.resolveClassDeclaration(this.mySymbol, project)) == null) {
            return;
        }
        if (this.myPrivateCategoryMode) {
            OCClassDeclaration privateCategory = OCCodeInsightUtil.getPrivateCategory(declaration);
            if (privateCategory == null) {
                privateCategory = OCElementFactory.interfaceByName(((OCClassSymbol)this.mySymbol).getName() + "()", declaration);
                privateCategory = OCChangeUtil.addBefore((PsiElement)declaration.getContainingFile(), privateCategory, declaration);
            }
            declaration = privateCategory;
        }
        this.addProtocol(declaration);
    }

    private void addProtocol(OCClassDeclaration declaration) {
        new OCElementsMover().addBaseProtocol(declaration, this.myProtocol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddSuperProtocolIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddSuperProtocolIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

