/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class OCPsiElementsQuickFix
extends OCQuickFix {
    protected List<SmartPsiElementPointer> myElementPointers;

    protected OCPsiElementsQuickFix(Collection<? extends PsiElement> elements) {
        if (elements != null) {
            this.myElementPointers = new ArrayList<SmartPsiElementPointer>(elements.size());
            for (PsiElement psiElement : elements) {
                if (psiElement == null) continue;
                this.myElementPointers.add(SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement));
            }
        }
    }

    protected OCPsiElementsQuickFix(PsiElement ... elements) {
        this.myElementPointers = new ArrayList<SmartPsiElementPointer>();
        for (PsiElement element : elements) {
            this.myElementPointers.add(SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element));
        }
    }

    @Override
    public boolean isAvailable() {
        boolean[] exists = new boolean[]{false};
        if (!this.processElements((Processor<PsiElement>)((Processor)element -> {
            exists[0] = true;
            return OCCodeInsightUtil.isValid(element);
        }))) {
            return false;
        }
        return exists[0];
    }

    protected boolean processElements(Processor<PsiElement> processor) {
        for (SmartPsiElementPointer pointer : this.myElementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null || processor.process((Object)element)) continue;
            return false;
        }
        return true;
    }

    public List<? extends PsiElement> getElements() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer pointer : this.myElementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            elements.add(element);
        }
        return elements;
    }
}

