/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCCppNamespaceImpl;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OCTopLevelTarget
extends OCTargetClass<PsiElement, OCSymbol> {
    private OCFile myImplementationFile;
    private final OCFile mySourceFile;
    private final String myNamespaceName;
    private final OCFile myTargetFile;
    private final PsiElement myTargetContext;
    private final boolean mySmartDefinitionsMode;
    private boolean myWrapNamespaceMode;

    public OCTopLevelTarget(OCFile sourceFile, OCFile file, OCNamespaceSymbol namespace, String namespaceName, PsiElement targetContext, Set<VirtualFile> files, Project project, boolean smartDefinitionsMode, boolean wrapNamespaceMode) {
        super(file.getName(), files, namespace, null, project);
        this.myTargetFile = file;
        this.myTargetContext = targetContext;
        this.mySmartDefinitionsMode = smartDefinitionsMode;
        this.mySourceFile = sourceFile;
        this.myNamespaceName = namespaceName;
        this.myWrapNamespaceMode = wrapNamespaceMode;
        if (this.myPsi == null && !wrapNamespaceMode) {
            this.myPsi = file;
            this.myStorage = new OCMemberInfoStorage(this.myPsi, this.mySmartDefinitionsMode, false, false);
            this.myStorage.getClassMemberInfos(this.myPsi);
        }
    }

    @Override
    public String getDisplayName() {
        return this.myPsi instanceof OCFile ? "file \"" + ((OCFile)this.myPsi).getName() + "\"" : super.getDisplayName();
    }

    public boolean isWrapNamespaceMode() {
        return this.myWrapNamespaceMode;
    }

    public PsiElement getTargetContext() {
        return this.myTargetContext;
    }

    public String getNamespaceName() {
        return this.myNamespaceName;
    }

    @Override
    public void locateTargetClass(boolean underWriteAction) {
        if (this.myWrapNamespaceMode) {
            if (underWriteAction) {
                PsiElement namespace = OCElementFactory.topLevelDeclarationFromText("namespace " + this.myNamespaceName + " {}", this.myTargetFile);
                Object parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this.myTargetContext, (Class[])new Class[]{OCCppNamespace.class, PsiFile.class});
                if (parent == null || !parent.getContainingFile().equals(this.myTargetFile)) {
                    parent = this.myTargetFile;
                }
                this.myPsi = OCChangeUtil.addBefore((PsiElement)parent, namespace, this.myTargetContext, OCChangeUtil.PostponedFormatAction.Format);
                this.mySymbol = ((OCCppNamespaceImpl)this.myPsi).getSymbol();
                PsiElement[] children = this.myPsi.getChildren();
                while (children.length == 1) {
                    this.myPsi = children[0];
                    children = this.myPsi.getChildren();
                }
                this.myWrapNamespaceMode = false;
            } else {
                return;
            }
        }
        this.myStorage = new OCMemberInfoStorage(this.myPsi, this.mySmartDefinitionsMode, false, false);
        this.myMembersMap.clear();
        for (OCMemberInfo info : this.myStorage.getClassMemberInfos(this.myPsi)) {
            PsiElement element = info.getSymbol().locateDefinition(this.myProject);
            if (element == null) continue;
            this.myMembersMap.put(info, element);
        }
        if (this.myPsi instanceof OCFile) {
            OCFile associatedFile;
            if (((OCFile)this.myPsi).isHeader() && !this.mySourceFile.equals(associatedFile = ((OCFile)this.myPsi).getAssociatedFile())) {
                this.myImplementationFile = associatedFile;
                if (this.myImplementationFile == null) {
                    ((OCFile)this.myPsi).getMembersContainer(false).processMembers(null, symbol -> {
                        if (!Comparing.equal((Object)symbol.getContainingFile(), (Object)((OCFile)this.myPsi).getVirtualFile())) {
                            return true;
                        }
                        if (symbol instanceof OCSymbolWithParent) {
                            if ((symbol = symbol.getAssociatedSymbol(this.myProject)) != null) {
                                this.myImplementationFile = symbol.getContainingOCFile(this.myProject);
                            }
                            if (this.myImplementationFile != null && this.myImplementationFile != this.myPsi) {
                                return false;
                            }
                        }
                        return true;
                    });
                }
            }
            if (this.myImplementationFile == null) {
                this.myImplementationFile = (OCFile)this.myPsi;
            }
        }
    }

    @Override
    @Nullable
    protected VirtualFile getTargetFile(PsiElement element, OCSymbol symbol) {
        if (((OCFile)element.getContainingFile()).isHeader()) {
            return this.myTargetFile.getVirtualFile();
        }
        if (this.myImplementationFile != null) {
            return this.myImplementationFile.getVirtualFile();
        }
        if (this.mySymbol != null) {
            return this.mySymbol.getContainingFile();
        }
        return null;
    }

    @Override
    @Nullable
    protected OCSymbolDeclarator addMember(@Nullable PsiElement element, OCSymbol symbol, @Nullable OCVisibility visibility) {
        if (element == null) {
            return null;
        }
        PsiElement newElement = OCChangeUtil.add((PsiElement)(!this.mySmartDefinitionsMode || ((OCFile)element.getContainingFile()).isHeader() ? this.myPsi : this.myImplementationFile), element, OCChangeUtil.PostponedFormatAction.Indent);
        if (newElement instanceof OCSymbolDeclarator) {
            return (OCSymbolDeclarator)newElement;
        }
        if (newElement instanceof OCDeclaration) {
            List<OCDeclarator> declarators = ((OCDeclaration)newElement).getDeclarators();
            if (declarators.isEmpty()) {
                OCTypeElement typeElement = ((OCDeclaration)newElement).getTypeElement();
                if (typeElement != null) {
                    for (PsiElement child : typeElement.getChildren()) {
                        if (!(child instanceof OCSymbolDeclarator)) continue;
                        return (OCSymbolDeclarator)child;
                    }
                }
            } else {
                return declarators.get(0);
            }
        }
        return null;
    }
}

