/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedFunctionSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.settings.OCRefactoringSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCRenameUtil {
    public static final Key<CachedValue<Ref<Boolean>>> RENAME_SAME_ENTITY_CACHE = Key.create((String)"RENAME_SAME_ENTITY_CACHE");

    @Nullable
    public static OCSymbol getSymbolToRename(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameUtil.$$$reportNull$$$0(0);
        }
        OCSymbol symbol = null;
        if (element instanceof OCSymbolDeclarator) {
            symbol = (OCSymbol)((OCSymbolDeclarator)element).getSymbol();
        } else {
            PsiReference maybeOperatorRef = element.getReference();
            if (maybeOperatorRef instanceof OCOperatorReference) {
                symbol = (OCSymbol)((OCOperatorReference)maybeOperatorRef).resolveToSymbol();
            }
        }
        return OCCompilerGeneratedFunctionSymbol.unwrap(symbol);
    }

    public static boolean shouldRenameSameClassOrFileEntity(@NotNull PsiElement element) {
        Ref<Boolean> cache;
        if (element == null) {
            OCRenameUtil.$$$reportNull$$$0(1);
        }
        return !(cache = OCRenameUtil.getRenameSameEntityCache(element)).isNull() && (Boolean)cache.get() != false;
    }

    public static boolean symbolHasSameNameWithFile(@NotNull String symbolName, @NotNull OCSymbolKind symbolKind, @NotNull PsiFile file) {
        if (symbolName == null) {
            OCRenameUtil.$$$reportNull$$$0(2);
        }
        if (symbolKind == null) {
            OCRenameUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCRenameUtil.$$$reportNull$$$0(4);
        }
        String name = symbolKind.isConstructorOrDestructor() ? StringUtil.trimStart((String)symbolName, (String)"~") : symbolName;
        return FileUtilRt.getNameWithoutExtension((String)file.getName()).equals(name);
    }

    public static void askToRenameSameEntityIfNeed(@NotNull PsiElement element) {
        OCSymbol declaratorSymbol;
        if (element == null) {
            OCRenameUtil.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiFile file = element.getContainingFile();
        Ref<Boolean> cache = OCRenameUtil.getRenameSameEntityCache((PsiElement)file);
        if (element instanceof OCFile) {
            OCFile headerFile;
            OCFile ocFile = (OCFile)element;
            OCFile oCFile = headerFile = ocFile.isHeader() ? ocFile : ocFile.getAssociatedFileWithSameName();
            if (headerFile != null && headerFile.getSameNamedClass() != null) {
                cache.set((Object)OCRenameUtil.askToRenameSameNamedClass());
            }
        } else if (element instanceof OCStructLike) {
            OCStructSymbol structSymbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            if (structSymbol != null && OCRenameUtil.symbolHasSameNameWithFile(structSymbol.getName(), structSymbol.getKind(), file)) {
                cache.set((Object)OCRenameUtil.askToRenameSameNamedFile(file.getProject()));
            }
        } else if (element instanceof OCDeclarator && (declaratorSymbol = ((OCDeclarator)element).getSymbol()) != null && declaratorSymbol.getKind().isConstructorOrDestructor() && OCRenameUtil.symbolHasSameNameWithFile(declaratorSymbol.getName(), declaratorSymbol.getKind(), file)) {
            cache.set((Object)OCRenameUtil.askToRenameSameNamedFile(file.getProject()));
        }
    }

    @TestOnly
    public static Ref<Boolean> getRenameSameEntityCacheForTests(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameUtil.$$$reportNull$$$0(6);
        }
        return OCRenameUtil.getRenameSameEntityCache(element);
    }

    private static Ref<Boolean> getRenameSameEntityCache(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameUtil.$$$reportNull$$$0(7);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(element.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{modificationTracker});
        return (Ref)manager.getCachedValue((UserDataHolder)element.getContainingFile(), RENAME_SAME_ENTITY_CACHE, provider2, false);
    }

    private static boolean askToRenameSameNamedFile(@NotNull Project project) {
        if (project == null) {
            OCRenameUtil.$$$reportNull$$$0(8);
        }
        String message = OCRefactoringSettings.getInstance().RENAME_ASSOCIATED_FILES ? OCBundle.message("rename.renameAssociatedFiles", new Object[0]) : OCBundle.message("rename.renameContainingFile", new Object[0]);
        return MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)message).show() == 0;
    }

    private static boolean askToRenameSameNamedClass() {
        return MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)OCBundle.message("rename.renameAssociatedClass", new Object[0])).show() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolToRename";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRenameSameClassOrFileEntity";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "symbolHasSameNameWithFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "askToRenameSameEntityIfNeed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenameSameEntityCacheForTests";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenameSameEntityCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "askToRenameSameNamedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

