/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbolBase;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExprSymbolClassifier {
    private final OCResolveContext myContext;

    public OCExprSymbolClassifier(OCResolveContext context) {
        this.myContext = context;
    }

    @NotNull
    private static OCExprValueCategory byBuiltInUnaryOperationSign(@NotNull OCElementType sign, boolean prefix) {
        if (sign == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(0);
        }
        if (sign == OCTokenTypes.MUL || prefix && (sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS)) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(1);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(2);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classify(OCExpressionSymbol symbol) {
        OCExprValueCategory oCExprValueCategory = this.classify(symbol, null);
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(3);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classify(OCExpressionSymbol symbol, @Nullable OCType exprType) {
        if (symbol instanceof OCBinaryExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyBinaryExpression((OCBinaryExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(4);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCCallExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyCallExpression((OCCallExpressionSymbol)symbol, exprType);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(5);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCCastExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyCastExpression((OCCastExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(6);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCCommaExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyCommaExpression((OCCommaExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(7);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCConditionalExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyConditionalExpression((OCConditionalExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(8);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCInitializerListExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyInitializerListExpressionSymbol((OCInitializerListExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(9);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCLambdaExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyLambdaExpression((OCLambdaExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(10);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCLiteralExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyLiteralExpression((OCLiteralExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(11);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCNewExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyCppNewExpression((OCNewExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(12);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCUnaryExpressionSymbolBase) {
            OCExprValueCategory oCExprValueCategory = this.classifyUnaryExpression((OCUnaryExpressionSymbolBase)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(13);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCQualifiedExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyQualifiedExpression((OCQualifiedExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(14);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCReferenceExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyReferenceExpression((OCReferenceExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(15);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCSizeofExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifySizeofExpression((OCSizeofExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(16);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCUnknownExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyUnknownExpression((OCUnknownExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(17);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCVariadicPackExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = this.classifyVariadicPackExpression((OCVariadicPackExpressionSymbol)symbol);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(18);
            }
            return oCExprValueCategory;
        }
        if (symbol instanceof OCArrayIndexExpressionSymbol) {
            return this.classifyArrayIndexExpression((OCArrayIndexExpressionSymbol)symbol);
        }
        if (symbol instanceof OCNoexceptExpressionSymbol) {
            return this.classifyNoexceptExpression((OCNoexceptExpressionSymbol)symbol);
        }
        OCLog.LOG.error("Unknown expression " + symbol);
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(19);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyUnknownExpression(@NotNull OCUnknownExpressionSymbol symbol) {
        if (symbol == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(20);
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(21);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyInitializerListExpressionSymbol(@NotNull OCInitializerListExpressionSymbol symbol) {
        if (symbol == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(22);
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(23);
        }
        return oCExprValueCategory;
    }

    public OCExprValueCategory classifyCommaExpression(OCCommaExpressionSymbol e) {
        return this.classify(e.getTailExpression()) == OCExprValueCategory.LValue ? OCExprValueCategory.LValue : OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyConditionalExpression(OCConditionalExpressionSymbol e) {
        OCType E2Type;
        OCType E1Type;
        OCExprValueCategory c2;
        OCExpressionSymbol E1 = e.getLeftOperandOrCondition();
        OCExpressionSymbol E2 = e.getRightOperand();
        if (E1 == null && E2 == null) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(24);
            }
            return oCExprValueCategory;
        }
        if (E1 == null) {
            OCExprValueCategory oCExprValueCategory = this.classify(E2);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(25);
            }
            return oCExprValueCategory;
        }
        if (E2 == null) {
            OCExprValueCategory oCExprValueCategory = this.classify(E1);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(26);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory c1 = this.classify(E1);
        if (c1 == (c2 = this.classify(E2)) && c1 != OCExprValueCategory.PRValue && (E1Type = E1.getResolvedType(this.myContext)).equals(E2Type = E2.getResolvedType(this.myContext), this.myContext)) {
            OCExprValueCategory oCExprValueCategory = c1;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(27);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(28);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyBinaryExpression(@NotNull OCBinaryExpressionSymbol e) {
        OCType customReturnType;
        if (e == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(29);
        }
        if ((customReturnType = e.getCustomReturnType(this.myContext)) != null) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.byReturnType(customReturnType);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(30);
            }
            return oCExprValueCategory;
        }
        OCElementType sign = e.getOperator();
        if (sign == OCTokenTypes.DOT_MUL && this.isPointerToDataMember(e.getRightOperand())) {
            OCExprValueCategory oCExprValueCategory = this.classify(e.getLeftOperand());
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(31);
            }
            return oCExprValueCategory;
        }
        if (sign == OCTokenTypes.DEREF_MUL && this.isPointerToDataMember(e.getRightOperand())) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(32);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(33);
        }
        return oCExprValueCategory;
    }

    private boolean isPointerToDataMember(@NotNull OCExpressionSymbol symbol) {
        OCType type;
        if (symbol == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(34);
        }
        if (!((type = symbol.getResolvedType(this.myContext)) instanceof OCPointerType)) {
            return true;
        }
        return !(((OCPointerType)type).getRefType() instanceof OCFunctionType);
    }

    @NotNull
    public OCExprValueCategory classifyCastExpression(OCCastExpressionSymbol e) {
        if (!this.myContext.isCpp() && e.getOperand() instanceof OCInitializerListExpressionSymbol) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(35);
            }
            return oCExprValueCategory;
        }
        OCType castType = e.getCastType().resolve(this.myContext);
        if (castType instanceof OCCppReferenceType) {
            OCCppReferenceType ref = (OCCppReferenceType)castType;
            if (ref.isRvalueRef()) {
                OCExprValueCategory oCExprValueCategory = OCExprValueCategory.XValue;
                if (oCExprValueCategory == null) {
                    OCExprSymbolClassifier.$$$reportNull$$$0(36);
                }
                return oCExprValueCategory;
            }
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(37);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(38);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifySizeofExpression(OCSizeofExpressionSymbol e) {
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(39);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyUnaryExpression(OCUnaryExpressionSymbolBase e) {
        OCType customReturnType = e.getCustomReturnType(this.myContext);
        if (customReturnType != null) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.byReturnType(customReturnType);
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(40);
            }
            return oCExprValueCategory;
        }
        return OCExprSymbolClassifier.byBuiltInUnaryOperationSign(e.getOperator(), e.getOperatorPlacement() == OCOperatorReference.OperatorPlacement.PREFIX);
    }

    @NotNull
    public OCExprValueCategory classifyCallExpression(OCCallExpressionSymbol e, @Nullable OCType exprType) {
        OCType type;
        OCType oCType = type = exprType != null ? exprType : e.getResolvedType(this.myContext);
        if (type.isUnknown()) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(41);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.byReturnType(type);
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(42);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyQualifiedExpression(OCQualifiedExpressionSymbol E1) {
        if (E1.isDeref()) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(43);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = this.classify(E1.getQualifier());
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(44);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyReferenceExpression(OCReferenceExpressionSymbol e) {
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(45);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyLiteralExpression(OCLiteralExpressionSymbol e) {
        if (e.getTokenType() == OCTokenTypes.STRING_LITERAL) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(46);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(47);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyLambdaExpression(OCLambdaExpressionSymbol lambdaExpression) {
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(48);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyCppNewExpression(OCNewExpressionSymbol e) {
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(49);
        }
        return oCExprValueCategory;
    }

    @NotNull
    public OCExprValueCategory classifyVariadicPackExpression(OCVariadicPackExpressionSymbol e) {
        OCExprValueCategory oCExprValueCategory = this.classify(e.getExpression());
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(50);
        }
        return oCExprValueCategory;
    }

    @NotNull
    private OCExprValueCategory classifyArrayIndexExpression(@NotNull OCArrayIndexExpressionSymbol symbol) {
        if (symbol == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(51);
        }
        if (symbol.getIndexSymbol() == null) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(52);
            }
            return oCExprValueCategory;
        }
        OCArrayIndexExpressionSymbol.ResolveResult result = symbol.getResolvedTypeWithKind(this.myContext);
        if (result.kind == OCArrayIndexExpressionSymbol.Kind.Builtin) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCExprSymbolClassifier.$$$reportNull$$$0(53);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.byReturnType(result.type);
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(54);
        }
        return oCExprValueCategory;
    }

    @NotNull
    private OCExprValueCategory classifyNoexceptExpression(@NotNull OCNoexceptExpressionSymbol symbol) {
        if (symbol == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(55);
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCExprSymbolClassifier.$$$reportNull$$$0(56);
        }
        return oCExprValueCategory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCExprSymbolClassifier";
                break;
            }
            case 20: 
            case 22: 
            case 34: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCExprSymbolClassifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "byBuiltInUnaryOperationSign";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyUnknownExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyInitializerListExpressionSymbol";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyConditionalExpression";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyBinaryExpression";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyCastExpression";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "classifySizeofExpression";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyUnaryExpression";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyCallExpression";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyQualifiedExpression";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyReferenceExpression";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyLiteralExpression";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyLambdaExpression";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyCppNewExpression";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyVariadicPackExpression";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyArrayIndexExpression";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "classifyNoexceptExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byBuiltInUnaryOperationSign";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "classifyUnknownExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "classifyInitializerListExpressionSymbol";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "classifyBinaryExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToDataMember";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "classifyArrayIndexExpression";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "classifyNoexceptExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

