/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.resolve.references.CompositeResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompositeResourceReference
implements OCResourceReference {
    private static final Function<OCResourceReference, PsiElement> ELEMENT = reference -> reference.getElement();
    private static final Function<OCResourceReference, Class> CLASS = reference -> reference.getClass();
    private final List<OCResourceReference> myReferences;

    public OCCompositeResourceReference(List<OCResourceReference> references) {
        CompositeResourceCompletionProvider.assertSameValue(references, CLASS);
        CompositeResourceCompletionProvider.assertSameValue(references, ELEMENT);
        this.myReferences = references;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(@NotNull @NlsSafe String openingQuote, @NotNull @NlsSafe String closingQuote) {
        if (openingQuote == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(0);
        }
        if (closingQuote == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(1);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        HashSet<String> alreadyProposedNames = new HashSet<String>();
        HashSet<PsiElement> alreadyProposedElements = new HashSet<PsiElement>();
        for (OCResourceReference reference : this.myReferences) {
            for (LookupElement element : reference.getLookupElements(openingQuote, closingQuote)) {
                PsiElement psiElement;
                if (!alreadyProposedNames.add(element.getLookupString()) || (psiElement = element.getPsiElement()) != null && !alreadyProposedElements.add(psiElement)) continue;
                result.add(element);
            }
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement resolve() {
        Pair<PsiElement, ? extends PsiReference> result = this.resolveInner();
        return (PsiElement)Pair.getFirst(result);
    }

    private Pair<PsiElement, ? extends PsiReference> resolveInner() {
        for (OCResourceReference reference : this.myReferences) {
            PsiElement element = reference.resolve();
            if (element == null) continue;
            return Pair.create((Object)element, (Object)reference);
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.getRepresentative().getElement();
        if (psiElement == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Pair<PsiElement, ? extends PsiReference> resolve;
        if (newElementName == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(4);
        }
        return (resolve = this.resolveInner()) == null ? null : ((PsiReference)resolve.second).handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(5);
        }
        return this.getRepresentative().bindToElement(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(6);
        }
        for (OCResourceReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        for (OCResourceReference reference : this.myReferences) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getRepresentative().getRangeInElement();
        if (textRange == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        String string = resolve == null ? this.getRepresentative().getCanonicalText() : ((PsiReference)resolve.second).getCanonicalText();
        if (string == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public PsiReference getRepresentative() {
        PsiReference psiReference = this.myReferences.get(0);
        if (psiReference == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(9);
        }
        return psiReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingQuote";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

