/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum OCSymbolKind {
    CATCH_EXCEPTION_VARIABLE,
    LOCAL_VARIABLE,
    PARAMETER,
    LABEL,
    STRUCT_FIELD,
    PROPERTY,
    INSTANCE_VARIABLE,
    METHOD,
    FUNCTION_PREDECLARATION,
    FUNCTION_DECLARATION,
    TYPEDEF,
    COMPATIBILITY_ALIAS,
    INTERFACE,
    PROTOCOL,
    IMPLEMENTATION,
    STRUCT,
    USING_SYMBOL_ALIAS,
    ENUM,
    UNION,
    NAMESPACE_ALIAS,
    NAMESPACE,
    NAMESPACE_USING_SYMBOL,
    SYMBOL_USING_SYMBOL,
    ENUM_CONST,
    GLOBAL_VARIABLE,
    GLOBAL_VARIABLE_PREDECLARATION,
    CPP_CONSTRUCTOR_PREDECLARATION,
    CPP_CONSTRUCTOR_DECLARATION,
    CPP_DEDUCTION_GUIDE,
    CPP_CTAD_DEDUCTION_CANDIDATE,
    CPP_CONCEPT,
    MACRO,
    MACRO_PARAMETER,
    UNDEF_MACRO,
    TEMPLATE_TYPE_PARAMETER,
    TEMPLATE_VALUE_PARAMETER,
    BUILTIN_SYMBOL,
    SYNTHESIZE,
    BLOCK,
    LAMBDA,
    IMPORT,
    LOCALIZED_STRING,
    EXPRESSION,
    ARGUMENT_LIST,
    GENERIC_PARAMETER,
    EXCEPTION_SPECIFIER,
    FOREIGN_ELEMENT,
    KEYWORD,
    FILE,
    FOLDER,
    UNKNOWN;


    @NotNull
    @Nls
    public String getName() {
        switch (this) {
            case TYPEDEF: {
                String string = OCBundle.message("symbol.kind.name.uppercase.type", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(0);
                }
                return string;
            }
            case ENUM_CONST: {
                String string = OCBundle.message("symbol.kind.name.uppercase.enum.constant", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(1);
                }
                return string;
            }
            case STRUCT_FIELD: {
                String string = OCBundle.message("symbol.kind.name.uppercase.field", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(2);
                }
                return string;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.function", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(3);
                }
                return string;
            }
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.constructor", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(4);
                }
                return string;
            }
            case PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(5);
                }
                return string;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.global.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(6);
                }
                return string;
            }
            case BUILTIN_SYMBOL: {
                String string = OCBundle.message("symbol.kind.name.uppercase.built.in.symbol", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(7);
                }
                return string;
            }
            case LOCAL_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.local.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(8);
                }
                return string;
            }
            case CATCH_EXCEPTION_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.exception.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(9);
                }
                return string;
            }
            case IMPLEMENTATION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.implementation", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(10);
                }
                return string;
            }
            case INSTANCE_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.instance.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(11);
                }
                return string;
            }
            case INTERFACE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.interface", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(12);
                }
                return string;
            }
            case LABEL: {
                String string = OCBundle.message("symbol.kind.name.uppercase.label", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(13);
                }
                return string;
            }
            case MACRO: 
            case UNDEF_MACRO: {
                String string = OCBundle.message("symbol.kind.name.uppercase.macro", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(14);
                }
                return string;
            }
            case MACRO_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.macro.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(15);
                }
                return string;
            }
            case IMPORT: {
                String string = OCBundle.message("symbol.kind.name.uppercase.import", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(16);
                }
                return string;
            }
            case COMPATIBILITY_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.uppercase.compatibility.alias", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(17);
                }
                return string;
            }
            case METHOD: {
                String string = OCBundle.message("symbol.kind.name.uppercase.method1", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(18);
                }
                return string;
            }
            case BLOCK: {
                String string = OCBundle.message("symbol.kind.name.uppercase.block", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(19);
                }
                return string;
            }
            case LAMBDA: {
                String string = OCBundle.message("symbol.kind.name.uppercase.lambda", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(20);
                }
                return string;
            }
            case PROPERTY: {
                String string = OCBundle.message("symbol.kind.name.uppercase.property", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(21);
                }
                return string;
            }
            case SYNTHESIZE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.synthesize.statement", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(22);
                }
                return string;
            }
            case PROTOCOL: {
                String string = OCBundle.message("symbol.kind.name.uppercase.protocol", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(23);
                }
                return string;
            }
            case STRUCT: {
                String string = OCBundle.message("symbol.kind.name.uppercase.struct", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(24);
                }
                return string;
            }
            case UNION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.union", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(25);
                }
                return string;
            }
            case ENUM: {
                String string = OCBundle.message("symbol.kind.name.uppercase.enum", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(26);
                }
                return string;
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.uppercase.namespace", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(27);
                }
                return string;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.type.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(28);
                }
                return string;
            }
            case TEMPLATE_VALUE_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.template.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(29);
                }
                return string;
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.uppercase.using", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(30);
                }
                return string;
            }
            case LOCALIZED_STRING: {
                String string = OCBundle.message("symbol.kind.name.uppercase.localized.string", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(31);
                }
                return string;
            }
            case EXPRESSION: {
                String string = OCBundle.message("symbol.kind.name.uppercase.expression", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(32);
                }
                return string;
            }
            case GENERIC_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.generic.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(33);
                }
                return string;
            }
            case CPP_CONCEPT: {
                String string = OCBundle.message("symbol.kind.name.uppercase.concept", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(34);
                }
                return string;
            }
            case KEYWORD: {
                String string = OCBundle.message("symbol.kind.name.uppercase.keyword", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(35);
                }
                return string;
            }
            case FILE: {
                String string = OCBundle.message("symbol.kind.name.uppercase.file", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(36);
                }
                return string;
            }
            case FOLDER: {
                String string = OCBundle.message("symbol.kind.name.uppercase.folder", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(37);
                }
                return string;
            }
        }
        String string = OCBundle.message("symbol.kind.name.uppercase.default", new Object[0]);
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getNameLowercase() {
        switch (this) {
            case TYPEDEF: {
                String string = OCBundle.message("symbol.kind.name.lowercase.type", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(39);
                }
                return string;
            }
            case ENUM_CONST: {
                String string = OCBundle.message("symbol.kind.name.lowercase.enum.constant", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(40);
                }
                return string;
            }
            case STRUCT_FIELD: {
                String string = OCBundle.message("symbol.kind.name.lowercase.field", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(41);
                }
                return string;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.function", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(42);
                }
                return string;
            }
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.constructor", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(43);
                }
                return string;
            }
            case PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(44);
                }
                return string;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.global.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(45);
                }
                return string;
            }
            case BUILTIN_SYMBOL: {
                String string = OCBundle.message("symbol.kind.name.lowercase.built.in.symbol", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(46);
                }
                return string;
            }
            case LOCAL_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.local.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(47);
                }
                return string;
            }
            case CATCH_EXCEPTION_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.exception.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(48);
                }
                return string;
            }
            case IMPLEMENTATION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.implementation", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(49);
                }
                return string;
            }
            case INSTANCE_VARIABLE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.instance.variable", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(50);
                }
                return string;
            }
            case INTERFACE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.interface", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(51);
                }
                return string;
            }
            case LABEL: {
                String string = OCBundle.message("symbol.kind.name.lowercase.label", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(52);
                }
                return string;
            }
            case MACRO: 
            case UNDEF_MACRO: {
                String string = OCBundle.message("symbol.kind.name.lowercase.macro", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(53);
                }
                return string;
            }
            case MACRO_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.macro.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(54);
                }
                return string;
            }
            case IMPORT: {
                String string = OCBundle.message("symbol.kind.name.lowercase.import", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(55);
                }
                return string;
            }
            case COMPATIBILITY_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.lowercase.compatibility.alias", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(56);
                }
                return string;
            }
            case METHOD: {
                String string = OCBundle.message("symbol.kind.name.lowercase.method1", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(57);
                }
                return string;
            }
            case BLOCK: {
                String string = OCBundle.message("symbol.kind.name.lowercase.block", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(58);
                }
                return string;
            }
            case LAMBDA: {
                String string = OCBundle.message("symbol.kind.name.lowercase.lambda", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(59);
                }
                return string;
            }
            case PROPERTY: {
                String string = OCBundle.message("symbol.kind.name.lowercase.property", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(60);
                }
                return string;
            }
            case SYNTHESIZE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.synthesize.statement", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(61);
                }
                return string;
            }
            case PROTOCOL: {
                String string = OCBundle.message("symbol.kind.name.lowercase.protocol", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(62);
                }
                return string;
            }
            case STRUCT: {
                String string = OCBundle.message("symbol.kind.name.lowercase.struct", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(63);
                }
                return string;
            }
            case UNION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.union", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(64);
                }
                return string;
            }
            case ENUM: {
                String string = OCBundle.message("symbol.kind.name.lowercase.enum", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(65);
                }
                return string;
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.lowercase.namespace", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(66);
                }
                return string;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.type.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(67);
                }
                return string;
            }
            case TEMPLATE_VALUE_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.template.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(68);
                }
                return string;
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                String string = OCBundle.message("symbol.kind.name.lowercase.using", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(69);
                }
                return string;
            }
            case LOCALIZED_STRING: {
                String string = OCBundle.message("symbol.kind.name.lowercase.localized.string", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(70);
                }
                return string;
            }
            case EXPRESSION: {
                String string = OCBundle.message("symbol.kind.name.lowercase.expression", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(71);
                }
                return string;
            }
            case GENERIC_PARAMETER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.generic.parameter", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(72);
                }
                return string;
            }
            case CPP_CONCEPT: {
                String string = OCBundle.message("symbol.kind.name.lowercase.concept", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(73);
                }
                return string;
            }
            case KEYWORD: {
                String string = OCBundle.message("symbol.kind.name.lowercase.keyword", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(74);
                }
                return string;
            }
            case FILE: {
                String string = OCBundle.message("symbol.kind.name.lowercase.file", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(75);
                }
                return string;
            }
            case FOLDER: {
                String string = OCBundle.message("symbol.kind.name.lowercase.folder", new Object[0]);
                if (string == null) {
                    OCSymbolKind.$$$reportNull$$$0(76);
                }
                return string;
            }
        }
        String string = OCBundle.message("symbol.kind.name.lowercase.default", new Object[0]);
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(77);
        }
        return string;
    }

    public Class<? extends PsiElement> getPsiElementClass() {
        switch (this) {
            case BUILTIN_SYMBOL: {
                return PsiElement.class;
            }
            case IMPLEMENTATION: {
                return OCImplementation.class;
            }
            case INTERFACE: 
            case PROTOCOL: {
                return OCClassDeclaration.class;
            }
            case LABEL: {
                return OCLabeledStatement.class;
            }
            case MACRO: {
                return OCDefineDirective.class;
            }
            case UNDEF_MACRO: {
                return OCUndefDirective.class;
            }
            case MACRO_PARAMETER: {
                return OCMacroParameter.class;
            }
            case IMPORT: {
                return OCIncludeDirective.class;
            }
            case COMPATIBILITY_ALIAS: {
                return OCCompatibilityAlias.class;
            }
            case METHOD: {
                return OCMethod.class;
            }
            case BLOCK: {
                return OCBlockExpression.class;
            }
            case SYNTHESIZE: {
                return OCSynthesizeProperty.class;
            }
            case STRUCT: {
                return OCStruct.class;
            }
            case UNION: {
                return OCUnion.class;
            }
            case ENUM: {
                return OCEnum.class;
            }
            case NAMESPACE: {
                return OCCppNamespace.class;
            }
            case NAMESPACE_ALIAS: {
                return OCCppNamespaceAlias.class;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCTypeParameterDeclaration.class;
            }
            case SYMBOL_USING_SYMBOL: 
            case NAMESPACE_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return OCCppUsingStatement.class;
            }
            case LOCALIZED_STRING: {
                return OCLocalizedString.class;
            }
            case EXPRESSION: {
                return OCExpression.class;
            }
            case GENERIC_PARAMETER: {
                return OCGenericParameter.class;
            }
            case CPP_CONCEPT: {
                return OCConceptDeclaration.class;
            }
        }
        return OCDeclarator.class;
    }

    public Icon getIcon() {
        switch (this) {
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case NAMESPACE_USING_SYMBOL: {
                return CidrLangIcons.CodeAssistantNamespace;
            }
            case TYPEDEF: 
            case TEMPLATE_TYPE_PARAMETER: 
            case SYMBOL_USING_SYMBOL: 
            case USING_SYMBOL_ALIAS: {
                return CidrLangIcons.CodeAssistantType;
            }
            case ENUM_CONST: {
                return CidrLangIcons.CodeAssistantEnumConst;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CidrLangIcons.CodeAssistantFunction;
            }
            case STRUCT_FIELD: 
            case INSTANCE_VARIABLE: {
                return CidrLangIcons.CodeAssistantField;
            }
            case IMPLEMENTATION: 
            case INTERFACE: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case MACRO: 
            case UNDEF_MACRO: 
            case MACRO_PARAMETER: 
            case IMPORT: {
                return CidrLangIcons.CodeAssistantMacro;
            }
            case COMPATIBILITY_ALIAS: {
                return CidrLangIcons.CodeAssistantClass;
            }
            case METHOD: {
                return CidrLangIcons.CodeAssistantMember;
            }
            case PROPERTY: {
                return CidrLangIcons.CodeAssistantProperty;
            }
            case PROTOCOL: {
                return CidrLangIcons.CodeAssistantProtocol;
            }
            case STRUCT: {
                return CidrLangIcons.CodeAssistantStruct;
            }
            case UNION: {
                return CidrLangIcons.CodeAssistantUnion;
            }
            case ENUM: {
                return CidrLangIcons.CodeAssistantEnum;
            }
            case PARAMETER: 
            case TEMPLATE_VALUE_PARAMETER: 
            case GENERIC_PARAMETER: {
                return CidrLangIcons.CodeAssistantParameter;
            }
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case LABEL: {
                return CidrLangIcons.CodeAssistantLocal;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: {
                return CidrLangIcons.CodeAssistantGlobal;
            }
            case BLOCK: 
            case LAMBDA: 
            case SYNTHESIZE: 
            case LOCALIZED_STRING: 
            case EXPRESSION: {
                return null;
            }
        }
        return null;
    }

    @NotNull
    @Nls
    public String getNameUppercase() {
        String string = this.getName();
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(78);
        }
        return string;
    }

    public boolean isClass() {
        switch (this) {
            case IMPLEMENTATION: 
            case INTERFACE: 
            case COMPATIBILITY_ALIAS: 
            case PROTOCOL: {
                return true;
            }
        }
        return false;
    }

    public boolean isClassOrTypedef() {
        return this.isClass() || this == TYPEDEF || this == USING_SYMBOL_ALIAS;
    }

    public boolean isType() {
        return this.isClassOrTypedef() || this.isStructLike() || this == TEMPLATE_TYPE_PARAMETER || this == COMPATIBILITY_ALIAS || this == GENERIC_PARAMETER;
    }

    public boolean isStructLike() {
        switch (this) {
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isStructOrUnion() {
        return this == STRUCT || this == UNION;
    }

    public boolean isFunction() {
        return this == FUNCTION_PREDECLARATION || this == FUNCTION_DECLARATION;
    }

    public boolean isFunctionOrConstructor() {
        return this.isFunction() || this.isConstructorOrDestructor();
    }

    public boolean isCallable() {
        return this.isFunction() || this == METHOD || this == BLOCK || this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == LAMBDA;
    }

    public boolean isPredeclaration() {
        return this == FUNCTION_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == STRUCT_FIELD;
    }

    public boolean isLocal() {
        return this == LOCAL_VARIABLE || this == CATCH_EXCEPTION_VARIABLE || this == LABEL || this == PARAMETER;
    }

    public boolean isConst() {
        return this == ENUM_CONST || this == TEMPLATE_VALUE_PARAMETER || this == GENERIC_PARAMETER || this.isFunction();
    }

    public OCSymbolKind toDeclarationKind() {
        switch (this) {
            case FUNCTION_PREDECLARATION: {
                return FUNCTION_DECLARATION;
            }
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return CPP_CONSTRUCTOR_DECLARATION;
            }
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return GLOBAL_VARIABLE;
            }
        }
        return this;
    }

    public boolean isExpression() {
        switch (this) {
            case ENUM_CONST: 
            case STRUCT_FIELD: 
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case BUILTIN_SYMBOL: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case LAMBDA: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isVariable() {
        switch (this) {
            case ENUM_CONST: 
            case PARAMETER: 
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: 
            case LOCAL_VARIABLE: 
            case CATCH_EXCEPTION_VARIABLE: 
            case INSTANCE_VARIABLE: 
            case PROPERTY: 
            case TEMPLATE_VALUE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalVariable() {
        return this == GLOBAL_VARIABLE || this == GLOBAL_VARIABLE_PREDECLARATION;
    }

    public boolean isConstructorOrDestructor() {
        return this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION;
    }

    public boolean isTemplateParameter() {
        return this == TEMPLATE_VALUE_PARAMETER || this == TEMPLATE_TYPE_PARAMETER || this == GENERIC_PARAMETER;
    }

    public boolean isTypedefOrAlias() {
        return this == TYPEDEF || this == COMPATIBILITY_ALIAS || this == USING_SYMBOL_ALIAS;
    }

    public boolean canBeNamespace() {
        switch (this) {
            case TYPEDEF: 
            case STRUCT: 
            case UNION: 
            case ENUM: 
            case NAMESPACE: 
            case NAMESPACE_ALIAS: 
            case TEMPLATE_TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public static OCSymbolKind parse(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("struct") || name.equals("class")) {
            return STRUCT;
        }
        if (name.equals("enum")) {
            return ENUM;
        }
        if (name.equals("union")) {
            return UNION;
        }
        if (name.equals("concept")) {
            return CPP_CONCEPT;
        }
        return null;
    }

    public boolean isSame(@NotNull OCSymbolKind kind) {
        if (kind == null) {
            OCSymbolKind.$$$reportNull$$$0(79);
        }
        return this == kind || this == FUNCTION_DECLARATION && kind == FUNCTION_PREDECLARATION || this == FUNCTION_PREDECLARATION && kind == FUNCTION_DECLARATION || this == CPP_CONSTRUCTOR_DECLARATION && kind == CPP_CONSTRUCTOR_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION && kind == CPP_CONSTRUCTOR_DECLARATION || this == GLOBAL_VARIABLE && kind == GLOBAL_VARIABLE_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION && kind == GLOBAL_VARIABLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 79: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 79: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolKind";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameLowercase";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameUppercase";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isSame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 79: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

