/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileSymbols
extends OCRecursiveVisitor {
    private MostlySingularMultiMap<String, OCSymbol> myLocalSymbolsMap = new MostlySingularMultiMap();
    private List<OCSymbol> myLocalNamespaceUsings = new ArrayList<OCSymbol>();
    private boolean myIsInsideLocalScope = false;
    private static final NotNullLazyKey<OCFileSymbols, AnnotationSession> CACHE = NotNullLazyKey.create((String)"LOCAL_SYMBOL_TABLE_DURING_ANNOTATION", dom -> {
        PsiFile file = dom.getFile();
        OCFileSymbols symbols = new OCFileSymbols();
        file.accept((PsiElementVisitor)symbols);
        for (String key : symbols.myLocalSymbolsMap.keySet()) {
            Iterable iterable = symbols.myLocalSymbolsMap.get((Object)key);
            if (!(iterable instanceof List) || ((List)iterable).size() <= 1) continue;
            ((List)iterable).sort(OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
        }
        symbols.myLocalNamespaceUsings.sort(OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
        return symbols;
    });

    private OCFileSymbols() {
    }

    @Override
    public void visitOCElement(OCElement scopeElement) {
        if (scopeElement instanceof OCCallable || scopeElement instanceof OCTemplateParameterList) {
            boolean old = this.myIsInsideLocalScope;
            this.myIsInsideLocalScope = true;
            super.visitOCElement(scopeElement);
            this.myIsInsideLocalScope = old;
        } else {
            super.visitOCElement(scopeElement);
        }
    }

    @Override
    public void visitLocalSymbolDeclarator(OCLocalSymbolDeclarator declarator) {
        if (!this.myIsInsideLocalScope) {
            super.visitLocalSymbolDeclarator(declarator);
        } else {
            Object symbol = declarator.getLocalSymbol();
            if (symbol != null && symbol.getScope() != null) {
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    this.myLocalNamespaceUsings.add((OCSymbol)symbol);
                } else {
                    this.myLocalSymbolsMap.add((Object)symbol.getName(), symbol);
                }
            }
        }
    }

    @Override
    public void visitConcept(OCConceptDeclaration concept) {
        if (!this.myIsInsideLocalScope) {
            super.visitConcept(concept);
        } else {
            this.visitLocalSymbolDeclarator(concept);
            this.visitElement(concept);
        }
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        if (!this.myIsInsideLocalScope) {
            super.visitStructLike(struct);
        } else {
            this.visitLocalSymbolDeclarator(struct);
            OCStructSymbol structSymbol = (OCStructSymbol)struct.getLocalSymbol();
            if (struct instanceof OCEnum) {
                ((OCEnum)struct).processEnumConsts((Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol != null && symbol.getScope() != null) {
                        if (structSymbol != null && structSymbol.getKind() == OCSymbolKind.ENUM) {
                            ((OCDeclaratorSymbolImpl)symbol).setType(structSymbol.getType());
                        } else {
                            ((OCDeclaratorSymbolImpl)symbol).setType(OCIntType.INT);
                        }
                        this.myLocalSymbolsMap.add((Object)symbol.getName(), symbol);
                    }
                    return true;
                }));
            } else {
                this.visitElement(struct);
            }
        }
    }

    @Override
    public void visitMacroCallArgument(OCMacroCallArgument argument) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canBeLocalSymbol(@NotNull OCFile file, String name) {
        if (file == null) {
            OCFileSymbols.$$$reportNull$$$0(0);
        }
        Object object = file.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                return localSymbols.myLocalSymbolsMap.containsKey((Object)name) || !localSymbols.myLocalNamespaceUsings.isEmpty();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Iterable<OCSymbol> getLocalSymbols(@NotNull OCFile file, String name) {
        if (file == null) {
            OCFileSymbols.$$$reportNull$$$0(1);
        }
        Object object = file.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                if (localSymbols.myLocalNamespaceUsings.size() == 0) {
                    return localSymbols.myLocalSymbolsMap.get((Object)name);
                }
                Iterable iterable = localSymbols.myLocalSymbolsMap.get((Object)name);
                if (iterable instanceof Set) {
                    ArrayList<OCSymbol> named = new ArrayList<OCSymbol>(1);
                    named.add((OCSymbol)iterable.iterator().next());
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, named, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                if (iterable instanceof List) {
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, (List)((List)iterable), OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                return localSymbols.myLocalNamespaceUsings;
            }
        }
        return null;
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        if (currentFile == null) {
            OCFileSymbols.$$$reportNull$$$0(2);
        }
        return OCFileSymbols.isSymbolImported(currentFile, symbol, null);
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol, @Nullable PsiElement before) {
        if (currentFile == null) {
            OCFileSymbols.$$$reportNull$$$0(3);
        }
        if (symbol == null || currentFile.getContext() != null) {
            return false;
        }
        if (Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return true;
        }
        VirtualFile file = OCFileSymbols.getFileToImport(currentFile, symbol);
        if (file != null && before != null) {
            OCIncludeDirective directive = currentFile.findIncludeDirective(file);
            return directive == null || directive.getRangeWithMacros().getStartOffset() <= OCElementUtil.getRangeWithMacros(before).getStartOffset();
        }
        return file != null;
    }

    @NotNull
    private static OCFileGlobalSymbols getSymbols(@NotNull OCFile currentFile) {
        if (currentFile == null) {
            OCFileSymbols.$$$reportNull$$$0(4);
        }
        OCFileGlobalSymbols oCFileGlobalSymbols = OCFileGlobalSymbolsCache.getInstance(currentFile.getProject()).forFile(currentFile);
        if (oCFileGlobalSymbols == null) {
            OCFileSymbols.$$$reportNull$$$0(5);
        }
        return oCFileGlobalSymbols;
    }

    @Nullable
    public static VirtualFile getFileToImport(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        if (currentFile == null) {
            OCFileSymbols.$$$reportNull$$$0(6);
        }
        if (symbol == null) {
            return null;
        }
        return OCFileSymbols.getSymbols(currentFile).getSymbolToImport().get(symbol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeLocalSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSymbols";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSymbolImported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSymbols";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileToImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

