/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.ImpatientDeferredException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProcessingDependencyGraph<Item> {
    private final Map<Thread, Item> myThreadToAwaitingItem = new HashMap<Thread, Item>();
    private final Map<Item, Context> myItemToProcessingContext = CollectionFactory.createSmallMemoryFootprintMap();

    ProcessingDependencyGraph() {
    }

    @NotNull
    synchronized State startProcessing(@NotNull Item item, @NotNull Thread currentThread, @Nullable Runnable reschedule) throws ImpatientDeferredException {
        Context currentProcessingContext;
        Thread currentProcessingThread;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(0);
        }
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(1);
        }
        Thread thread2 = currentProcessingThread = (currentProcessingContext = this.myItemToProcessingContext.get(item)) != null ? currentProcessingContext.getThread() : null;
        if (currentProcessingThread == currentThread) {
            State state = State.RECURSIVE;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(2);
            }
            return state;
        }
        if (currentProcessingThread == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            State state = State.ACQUIRED;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(3);
            }
            return state;
        }
        if (reschedule != null) {
            currentProcessingContext.add(reschedule);
            throw new ImpatientDeferredException();
        }
        if (this.checkForDeadlock(currentThread, currentProcessingThread)) {
            State state = State.DEADLOCK;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(4);
            }
            return state;
        }
        this.myThreadToAwaitingItem.put(currentThread, item);
        State state = State.WAIT;
        if (state == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(5);
        }
        return state;
    }

    synchronized boolean retryStartProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Thread currentProcessingThread;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(6);
        }
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(7);
        }
        if ((currentProcessingThread = this.getCurrentProcessingThread(item)) == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            this.myThreadToAwaitingItem.remove(currentThread);
            return true;
        }
        return false;
    }

    synchronized void stopWaiting(@NotNull Thread currentThread) {
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(8);
        }
        this.myThreadToAwaitingItem.remove(currentThread);
    }

    synchronized void finishProcessing(@NotNull Item item) {
        Context processingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(9);
        }
        if (!OCLog.LOG.assertTrue((processingContext = this.myItemToProcessingContext.remove(item)) != null, (Object)"Current processing context not found")) {
            return;
        }
        Iterator iterator = processingContext.iterator();
        while (iterator.hasNext()) {
            Runnable reschedule = (Runnable)iterator.next();
            reschedule.run();
        }
    }

    private boolean checkForDeadlock(@NotNull Thread context, @NotNull Thread thread2) {
        if (context == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(10);
        }
        if (thread2 == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(11);
        }
        Item lock;
        while ((lock = this.myThreadToAwaitingItem.get(thread2)) != null) {
            Thread next = this.getCurrentProcessingThread(lock);
            if (next == null || next == thread2) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread2 = next;
        }
        return false;
    }

    @Nullable
    private Thread getCurrentProcessingThread(@NotNull Item item) {
        Context currentProcessingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(12);
        }
        return (currentProcessingContext = this.myItemToProcessingContext.get(item)) != null ? currentProcessingContext.getThread() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProcessing";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "retryStartProcessing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stopWaiting";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishProcessing";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForDeadlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentProcessingThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Context
    extends SmartList<Runnable> {
        @NotNull
        private final Thread myThread;

        Context(@NotNull Thread thread2) {
            if (thread2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myThread = thread2;
        }

        @NotNull
        Thread getThread() {
            Thread thread2 = this.myThread;
            if (thread2 == null) {
                Context.$$$reportNull$$$0(1);
            }
            return thread2;
        }

        public boolean equals(@Nullable Object o) {
            throw new AssertionError();
        }

        public int hashCode() {
            throw new AssertionError();
        }

        public String toString() {
            return "ProcessingContext{thread=" + this.myThread + "} " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum State {
        DEADLOCK,
        RECURSIVE,
        ACQUIRED,
        WAIT;

    }
}

