/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArrayType
extends OCPointerType {
    @Nullable
    private OCExpressionSymbol myLength;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCArrayType() {
        this(null, null, false, false, null, OCTypeSubstitution.ID);
    }

    public OCArrayType(OCType ref, @Nullable OCExpressionSymbol length, boolean isConst, boolean isVolatile, @Nullable ARCAttribute attribute, @NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCArrayType.$$$reportNull$$$0(0);
        }
        super(ref, attribute, null, OCNullability.NONNULL, isConst, isVolatile);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myLength = length;
        this.mySubstitution = substitution;
    }

    public int getLength(@NotNull OCResolveContext context) {
        if (context == null) {
            OCArrayType.$$$reportNull$$$0(1);
        }
        if (this.myLength == null) {
            return -1;
        }
        Number result = OCExpressionEvaluator.evaluate(this.myLength, context);
        return result != null ? result.intValue() : -1;
    }

    public boolean hasLength() {
        return this.myLength != null;
    }

    @Nullable
    public OCExpressionSymbol getLengthSymbol() {
        return this.myLength;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCArrayType.$$$reportNull$$$0(2);
        }
        if (first == null) {
            OCArrayType.$$$reportNull$$$0(3);
        }
        if (second == null) {
            OCArrayType.$$$reportNull$$$0(4);
        }
        OCArrayType f = (OCArrayType)first;
        OCArrayType s = (OCArrayType)second;
        return c.equalObjects(f.myLength, s.myLength) && super.deepEqualStep(c, first, second);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myLength != null ? this.myLength.hashCode() : 0);
        return result;
    }

    public boolean isEmpty(HashSet<OCStructSymbol> processed, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCArrayType.$$$reportNull$$$0(5);
        }
        if (this.getLength(resolveContext) == 0) {
            return true;
        }
        OCType elementType = this.myRefType.resolve(resolveContext);
        if (elementType instanceof OCArrayType) {
            if (!((OCArrayType)elementType).isEmpty(processed, resolveContext)) {
                return false;
            }
        } else if (elementType instanceof OCStructType) {
            if (!((OCStructType)elementType).isEmpty(processed, resolveContext)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCArrayType.$$$reportNull$$$0(6);
        }
        return oCTypeSubstitution;
    }

    public static OCArrayType to(OCType type, int length, @Nullable ARCAttribute arcAttribute) {
        return new OCArrayType(type, OCArrayType.lengthFromInt(length), false, false, arcAttribute, OCTypeSubstitution.ID);
    }

    public static OCArrayType to(OCType ref, int length) {
        return OCArrayType.to(ref, length, null);
    }

    public static OCArrayType to(OCType type, OCExpressionSymbol length, @Nullable ARCAttribute arcAttribute) {
        return new OCArrayType(type, length, false, false, arcAttribute, OCTypeSubstitution.ID);
    }

    public static OCArrayType to(OCType ref, OCExpressionSymbol length) {
        return OCArrayType.to(ref, length, null);
    }

    public static OCArrayType fromPointer(@NotNull OCPointerType from) {
        if (from == null) {
            OCArrayType.$$$reportNull$$$0(7);
        }
        if (!from.isArrayLikeParameter()) {
            return null;
        }
        return new OCArrayType(from.getRefType(), from.getLengthInBrackets(), from.isConst(), from.isVolatile(), from.getARCAttribute(), OCTypeSubstitution.ID);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    @NotNull
    public OCType getArrayElementType() {
        OCType oCType = this.myRefType.getArrayElementType();
        if (oCType == null) {
            OCArrayType.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    public static OCExpressionSymbol lengthFromInt(int length) {
        if (length == -1) {
            return null;
        }
        return new OCLiteralExpressionSymbol(length, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCArrayType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCArrayType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromPointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

