/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeNameVisitorBase
implements OCTypeVisitor<String> {
    public static final int MAX_STRUCT_PARAMETERS_IN_PRESENTATION = 5;
    public static final int MAX_TEMPLATE_DEPTH_IN_PRESENTATION = 10;
    public static final int MAX_ARG_LENGTH_IN_PRESENTATION = 300;
    protected final int myTemplateDepth;

    protected OCTypeNameVisitorBase(int templateDepth) {
        this.myTemplateDepth = templateDepth;
    }

    @NotNull
    public abstract String getName(OCType var1);

    protected abstract String getNameForTypeArgument(OCTypeArgument var1);

    protected List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol symbol) {
        if (symbol == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(0);
        }
        return this.getTypeArguments(symbol, DefaultArgumentsRemovalStrategy.LAST_MATCH);
    }

    @NotNull
    protected abstract List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol var1, @NotNull DefaultArgumentsRemovalStrategy var2);

    @Nullable
    protected abstract String getCanonicalName(OCReferenceType var1);

    @Nullable
    protected abstract Project getProject();

    protected String getSubstitutedTypeName(String baseName, @NotNull OCTemplateSymbol symbol) {
        if (symbol == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(1);
        }
        return this.getSubstitutedTypeName(baseName, symbol, DefaultArgumentsRemovalStrategy.LAST_MATCH);
    }

    protected String getSubstitutedTypeName(String baseName, @NotNull OCTemplateSymbol symbol, @NotNull DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy) {
        if (symbol == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(2);
        }
        if (defaultArgumentsRemovalStrategy == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(3);
        }
        List<OCTypeArgument> arguments = this.getTypeArguments(symbol, defaultArgumentsRemovalStrategy);
        StringBuilder builder2 = new StringBuilder(baseName);
        if (arguments.size() > 0) {
            builder2.append('<');
            if (this.myTemplateDepth < 10) {
                for (int j = 0; j < arguments.size(); ++j) {
                    if (j > 5) {
                        builder2.append("...");
                        break;
                    }
                    if (j != 0) {
                        builder2.append(", ");
                    }
                    OCTypeArgument argument = arguments.get(j);
                    if (symbol.isSpecialization() && argument != null) {
                        builder2.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    if (argument instanceof OCType) {
                        builder2.append(this.getName((OCType)argument));
                        continue;
                    }
                    if (argument != null) {
                        builder2.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    builder2.append(symbol.getTemplateParameters().get(j).getName());
                }
            } else {
                builder2.append("...");
            }
            builder2.append(">");
        }
        return builder2.toString();
    }

    @NonNls
    private static String appendIsKindof(boolean isKindof, @NonNls String typeString) {
        if (!isKindof || typeString.startsWith("__kindof ")) {
            return typeString;
        }
        return "__kindof " + typeString;
    }

    protected String appendCVQualifiers(OCType type, @NonNls String typeString) {
        return CVQualifiers.appendCVQualifiers(typeString, type, this.getProject());
    }

    @NotNull
    public static String addTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project, @NonNls @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (typeString == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(4);
        }
        if (type == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(6);
        }
        if (qualifier.isEmpty()) {
            String string = typeString;
            if (string == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || type instanceof OCFunctionType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            Object object = typeString.endsWith(" " + qualifier) ? typeString : typeString + " " + qualifier;
            if (object == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(8);
            }
            return object;
        }
        Object object = typeString.startsWith(qualifier + " ") ? typeString : qualifier + " " + typeString;
        if (object == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    public static String removeTypeQualifier(@NonNls @NotNull String typeString, @NotNull OCType type, @Nullable Project project, @NonNls @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (typeString == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(10);
        }
        if (type == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(12);
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project != null ? (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            String string = typeString.endsWith(" " + qualifier) ? typeString.substring(0, typeString.length() - qualifier.length() - 1) : typeString;
            if (string == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = typeString.startsWith(qualifier + " ") ? typeString.substring(qualifier.length() + 1) : typeString;
        if (string == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected String getFunctionSignature(OCFunctionType type, String signatureWithoutParams) {
        StringBuilder builder2 = new StringBuilder(signatureWithoutParams);
        builder2.append('(');
        builder2.append(StringUtil.join(type.getParameterTypes(true), this::getName, (String)","));
        builder2.append(')');
        return this.appendCVQualifiers(type, builder2.toString());
    }

    @Override
    public String visitEllipsisReferenceType(OCEllipsisType type) {
        return "...";
    }

    @Override
    public String visitObjectType(OCObjectType type) {
        boolean isGeneric;
        List<OCProtocolSymbol> protocols = type.getAugmentedProtocols();
        OCInterfaceSymbol interfaceSymbol = type.getInterface();
        boolean bl = isGeneric = interfaceSymbol != null && !interfaceSymbol.getGenericParameters().isEmpty() && interfaceSymbol.getSubstitution() != OCTypeSubstitution.ID;
        if (protocols.isEmpty() && !isGeneric) {
            return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, type.getClassName()));
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append(isGeneric ? this.getSubstitutedTypeName(type.getClassName(), interfaceSymbol, DefaultArgumentsRemovalStrategy.ALL_MATCH) : type.getClassName());
        if (!protocols.isEmpty()) {
            builder2.append('<');
            builder2.append(StringUtil.join(protocols, OCSymbol::getName, (String)", "));
            builder2.append('>');
        }
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder2.toString()));
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return (String)this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return this.appendCVQualifiers(type, "auto");
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    @NonNls
    public String visitBracedInitListType(OCBracedInitListType type) {
        return "<braced-init-list>";
    }

    @Override
    public String visitReferenceType(OCReferenceType type) {
        String name = this.getCanonicalName(type);
        String[] protocolNames = type.getProtocolNames();
        if (protocolNames.length == 0) {
            return name != null ? OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, name)) : "<unnamed>";
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append(name).append('<').append(protocolNames[0]);
        for (int i2 = 1; i2 < protocolNames.length; ++i2) {
            builder2.append(", ").append(protocolNames[i2]);
        }
        builder2.append('>');
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder2.toString()));
    }

    @Override
    @NonNls
    public String visitStructuredBindingType(OCStructuredBindingType type) {
        return "<structured-binding>";
    }

    @Override
    @NonNls
    public String visitDeferredType(OCDeferredType type) {
        return "<deferred-type>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultArgumentsRemovalStrategy";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/names/OCTypeNameVisitorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/names/OCTypeNameVisitorBase";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addTypeQualifier";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTypeQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArguments";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTypeQualifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTypeQualifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DefaultArgumentsRemovalStrategy {
        NONE,
        LAST_MATCH,
        ALL_MATCH;

    }
}

