/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCUDLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCElementFactory {
    private static final Logger LOG = Logger.getInstance(OCElementFactory.class);

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context);
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(0);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declaration(@NlsSafe @Nullable String modifier, String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(modifier, name, type, null, null, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(1);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@NlsSafe @Nullable String modifier, @NlsSafe String name, OCType type, @Nullable OCExpression initializer, @Nullable OCCompoundInitializer initializerList, @Nullable OCArgumentList argumentList, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(2);
        }
        Object declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name, type, initializer != null ? "0" : null, context, null, false);
        if (initializer == null) {
            if (initializerList != null) {
                declText = (String)declText + "{}";
            } else if (argumentList != null) {
                declText = (String)declText + "(0)";
            }
        }
        OCDeclarationStatement statement = (OCDeclarationStatement)OCElementFactory.statementFromText((String)declText, context, true);
        OCDeclarator declarator = statement.getDeclaration().getDeclarators().get(0);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializer(), initializer);
        } else if (initializerList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializerList(), initializerList);
        } else if (argumentList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getArgumentList(), argumentList);
        }
        OCDeclarationStatement oCDeclarationStatement = statement;
        if (oCDeclarationStatement == null) {
            OCElementFactory.$$$reportNull$$$0(3);
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(4);
        }
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
    }

    @NotNull
    public static OCDeclaration declarationFromText(@NlsSafe @NotNull String text, PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(5);
        }
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(6);
        }
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, false);
    }

    @NotNull
    public static String declarationText(@NlsSafe String name, OCType type, String typeNameHint, @Nullable String initializerText, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(7);
        }
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, initializerText, context, typeNameHint, false);
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(@NlsSafe String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(name, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(8);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(@NlsSafe String text, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(9);
        }
        OCParameterDeclaration oCParameterDeclaration = ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(10);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(@NlsSafe String name, OCType type, @Nullable OCExpression defaultValue, PsiElement context) {
        OCParameterDeclaration paramDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(Collections.emptyList(), name, type, defaultValue != null ? "0" : null, context, null, false), context);
        if (defaultValue != null) {
            OCChangeUtil.replaceHandlingMacros(paramDeclaration.getDeclarator().getInitializer(), defaultValue);
        }
        OCParameterDeclaration oCParameterDeclaration = paramDeclaration;
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(11);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context) {
        return OCElementFactory.propertyDeclaration(name, type, context, null, false);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, readonly, null);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class);
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
    }

    @NotNull
    public static OCProperty propertyDeclaration(@NlsSafe String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @NlsSafe @Nullable String additionalAttributes) {
        ArrayList<@NlsSafe String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        @NlsSafe StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, true) + "; @end";
        OCProperty oCProperty = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(12);
        }
        return oCProperty;
    }

    @NotNull
    public static OCDeclaration enumConst(@NlsSafe String name, PsiElement context) {
        OCDeclaration oCDeclaration = ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context).getFirstChild()).getFields().get(0);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(13);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, @NotNull OCResolveContext context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(14);
        }
        String constant = OCIntType.getAppropriateBool(context.isObjc()).getValue(value, context);
        OCExpression oCExpression = (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(constant, context.getProject(), context.getElement(), false, false), OCExpression.class);
        if (oCExpression == null) {
            OCElementFactory.$$$reportNull$$$0(15);
        }
        return oCExpression;
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<@NlsSafe String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        OCSendMessageExpression oCSendMessageExpression = (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCSendMessageExpression == null) {
            OCElementFactory.$$$reportNull$$$0(16);
        }
        return oCSendMessageExpression;
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable @NlsSafe String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        OCCallExpression oCCallExpression = (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCCallExpression == null) {
            OCElementFactory.$$$reportNull$$$0(17);
        }
        return oCCallExpression;
    }

    @NotNull
    public static OCInterface interfaceByName(@NlsSafe String name, PsiElement context) {
        return (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context, true);
    }

    @NotNull
    public static OCMethod methodFromText(@NlsSafe String text, PsiElement context, boolean reformat) {
        OCMethod oCMethod = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
        if (oCMethod == null) {
            OCElementFactory.$$$reportNull$$$0(18);
        }
        return oCMethod;
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(@NlsSafe String name, @NlsSafe String defaultValue, PsiFile file) {
        return (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file);
    }

    @NotNull
    public static OCMethod methodFromSignature(@NlsSafe @NotNull String signature2, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings;
        if (signature2 == null) {
            OCElementFactory.$$$reportNull$$$0(19);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(20);
        }
        String semicolon = (settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), OCCodeStyleSettings.class)) != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        return OCElementFactory.methodFromText(signature2 + (String)(needBody ? semicolon + "{\n}" : ";"), context, reformat);
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        OCUnaryExpression oCUnaryExpression = expression;
        if (oCUnaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(21);
        }
        return oCUnaryExpression;
    }

    @NotNull
    public static PsiElement createUDLSuffux(@NlsSafe String name, PsiElement context) {
        OCUDLiteralExpressionImpl expression = (OCUDLiteralExpressionImpl)OCElementFactory.expressionFromText("\"\"" + name, context, false);
        PsiElement psiElement = expression.getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        OCBinaryExpression oCBinaryExpression = expression;
        if (oCBinaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(23);
        }
        return oCBinaryExpression;
    }

    @NotNull
    public static OCConditionalExpression conditionalExpression(@NotNull OCExpression condition, @NotNull OCExpression thenExpression, @NotNull OCExpression elseExpression) {
        if (condition == null) {
            OCElementFactory.$$$reportNull$$$0(24);
        }
        if (thenExpression == null) {
            OCElementFactory.$$$reportNull$$$0(25);
        }
        if (elseExpression == null) {
            OCElementFactory.$$$reportNull$$$0(26);
        }
        OCConditionalExpression conditionalExpression = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getCondition(), condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getPositiveExpression(false), thenExpression);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getNegativeExpression(), elseExpression);
        OCConditionalExpression oCConditionalExpression = conditionalExpression;
        if (oCConditionalExpression == null) {
            OCElementFactory.$$$reportNull$$$0(27);
        }
        return oCConditionalExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(@NlsSafe String operator, PsiElement context) {
        PsiElement psiElement = ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    public static ASTNode typeModifierFromText(@NlsSafe String modifier, PsiElement context) {
        ASTNode aSTNode = OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(29);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + scope + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            PsiElement psiElement = kid;
            if (psiElement == null) {
                OCElementFactory.$$$reportNull$$$0(30);
            }
            return psiElement;
        }
        if (null == null) {
            OCElementFactory.$$$reportNull$$$0(31);
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        OCInstanceVariablesList oCInstanceVariablesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
        if (oCInstanceVariablesList == null) {
            OCElementFactory.$$$reportNull$$$0(32);
        }
        return oCInstanceVariablesList;
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe String text, PsiElement context) {
        return OCElementFactory.constructorFromText(text, context, false);
    }

    @NotNull
    public static OCDeclaration constructorFromText(@NlsSafe String text, PsiElement context, boolean reformat) {
        String name = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name + " { " + text + ";}", context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        OCDeclaration oCDeclaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(33);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        OCConstructorInitializationList oCConstructorInitializationList = list;
        if (oCConstructorInitializationList == null) {
            OCElementFactory.$$$reportNull$$$0(34);
        }
        return oCConstructorInitializationList;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(@NlsSafe String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCConstructorFieldInitializer oCConstructorFieldInitializer = list.getInitializers().get(0);
        if (oCConstructorFieldInitializer == null) {
            OCElementFactory.$$$reportNull$$$0(35);
        }
        return oCConstructorFieldInitializer;
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @NlsSafe @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (String)(value != null ? "=" + value : "") + ") int x; @end";
        OCPropertyAttributesList oCPropertyAttributesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
        if (oCPropertyAttributesList == null) {
            OCElementFactory.$$$reportNull$$$0(36);
        }
        return oCPropertyAttributesList;
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(@NlsSafe String myKeyword, @NlsSafe String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizePropertiesList oCSynthesizePropertiesList = (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
        if (oCSynthesizePropertiesList == null) {
            OCElementFactory.$$$reportNull$$$0(37);
        }
        return oCSynthesizePropertiesList;
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(@NlsSafe String property, @NlsSafe @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (String)(ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizeProperty oCSynthesizeProperty = ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
        if (oCSynthesizeProperty == null) {
            OCElementFactory.$$$reportNull$$$0(38);
        }
        return oCSynthesizeProperty;
    }

    @NotNull
    private static String declaratorText(@NlsSafe String name, OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(39);
        }
        if ("<unnamed>".equals(name)) {
            name = "";
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type.getAliasName() == null) {
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                int length = arrayType.getLength(resolveContext);
                if (((String)name).startsWith("*")) {
                    name = "(" + (String)name + ")";
                }
                return OCElementFactory.declaratorText((String)name + " [" + (Serializable)(arrayType.hasLength() ? Integer.valueOf(length) : "") + "]", arrayType.getRefType(), context, eraseARCAttributes);
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + (String)name;
                }
                String string = (String)(!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText((String)name, pointerType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(40);
                }
                return string;
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(resolveContext));
                b.append(" (").append((String)name).append(")");
                b.append(OCTypeNameVisitor.getFunctionSignature(resolveContext, funType, "", false, null));
                String string = b.toString();
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(41);
                }
                return string;
            }
        }
        String string = type.getBestNameInContext(resolveContext) + " " + (String)name;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public static String declarationText(@NotNull List<@NlsSafe String> modifiers, @NlsSafe String name, OCType type, @NlsSafe @Nullable String initializerText, @NotNull PsiElement context, @NlsSafe @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (modifiers == null) {
            OCElementFactory.$$$reportNull$$$0(43);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(44);
        }
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name) || name.isEmpty();
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                b.append(resolveContext.isObjc() ? "id" : "int");
            } else {
                b.append(type.getBestNameInContext(resolveContext));
            }
            if (!isUnnamed) {
                b.append(' ').append(name);
            }
        }
        Object declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, resolveContext)) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name;
        }
        if (initializerText != null) {
            String string = (String)declarationText + "=" + initializerText;
            if (string == null) {
                OCElementFactory.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = declarationText;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(@NlsSafe @NotNull String name, @NotNull PsiElement context) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(47);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(48);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("int " + name, context.getProject(), context, false, false)), OCElement.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        PsiElement psiElement = declarators.get(0).getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(49);
        }
        return psiElement;
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NlsSafe @NotNull String name, @NotNull OCMacroForeignLeafElement sample) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(50);
        }
        if (sample == null) {
            OCElementFactory.$$$reportNull$$$0(51);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false)), OCDeclaration.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        OCMacroForeignLeafElement oCMacroForeignLeafElement = identifier;
        if (oCMacroForeignLeafElement == null) {
            OCElementFactory.$$$reportNull$$$0(52);
        }
        return oCMacroForeignLeafElement;
    }

    @Nullable
    public static OCCppNamespaceQualifier createNamespaceQualifier(OCQualifiedName name, PsiElement context) {
        String nameText = name.getFullName(OCResolveContext.forPsi(context));
        if (!nameText.isEmpty()) {
            OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + nameText + "::XXXX {}", context, true).getTypeElement().getFirstChild();
            return struct.getNamespaceQualifier();
        }
        return null;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        ASTNode aSTNode = struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(53);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(54);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(55);
        }
        return OCElementFactory.topLevelDeclarationFromText(text, context, false);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(56);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(57);
        }
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        PsiElement psiElement = child;
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(58);
        }
        return psiElement;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(59);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(60);
        }
        OCTypeElement oCTypeElement = OCElementFactory.typeElementFromTextOrNull(text, context, true);
        if (oCTypeElement == null) {
            OCElementFactory.$$$reportNull$$$0(61);
        }
        return oCTypeElement;
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(62);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(63);
        }
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NlsSafe @NotNull String name, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (name == null) {
            OCElementFactory.$$$reportNull$$$0(64);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(65);
        }
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(66);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(67);
        }
        return OCElementFactory.expressionFromText(text, context, false);
    }

    @Nullable
    public static OCExpression expressionFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(68);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(69);
        }
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(70);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(71);
        }
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NlsSafe @NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(72);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(73);
        }
        text = "void _______dummy(){" + (String)text + ";}";
        OCCodeFragment element = OCElementFactory.codeFragment((String)text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NonNls @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(74);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(75);
        }
        return OCElementFactory.codeFragment(text, project, context, OCTokenTypes.OC_FILE, physical, reformat);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(76);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(77);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(78);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(79);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(80);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(81);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(82);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(83);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(84);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(85);
        }
        return OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(86);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(87);
        }
        return OCElementFactory.codeFragment(text, project, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment qualifiedIdCodeFragment(@NlsSafe @NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(88);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(89);
        }
        return OCElementFactory.codeFragment(text, context.getProject(), context, OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT, true, false);
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(@NlsSafe String text, @NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(90);
        }
        return (OCCodeFragment)WriteCommandAction.writeCommandAction((Project)project).compute(() -> OCElementFactory.typeCodeFragment(text, project, context, true, true));
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NlsSafe @NotNull String text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(91);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(92);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(93);
        }
        return OCElementFactory.codeFragment(text, project, context, type, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context));
    }

    @NotNull
    public static OCLanguageKind getLanguageKindFromContext(@Nullable PsiElement context) {
        PsiFile file;
        if (context != null && (file = context.getContainingFile()) instanceof OCFile) {
            OCLanguageKind kind = ((OCFile)file).getKind();
            OCLanguageKind oCLanguageKind = CLanguageKind.find((boolean)kind.isObjC(), (boolean)kind.isCpp(), (boolean)kind.isCuda());
            if (oCLanguageKind == null) {
                OCElementFactory.$$$reportNull$$$0(94);
            }
            return oCLanguageKind;
        }
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage();
        if (cLanguageKind == null) {
            OCElementFactory.$$$reportNull$$$0(95);
        }
        return cLanguageKind;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull CharSequence text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(96);
        }
        if (project == null) {
            OCElementFactory.$$$reportNull$$$0(97);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(98);
        }
        if (kind == null) {
            OCElementFactory.$$$reportNull$$$0(99);
        }
        if (context == null && formatToCodestyle) {
            OCLog.LOG.warn("Formatting of code fragment without context is deprecated!");
        }
        OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project, kind, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed() || !physical) {
                PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fragment));
            } else {
                LOG.error("Write access is required");
            }
        }
        OCCodeFragmentImpl oCCodeFragmentImpl = fragment;
        if (oCCodeFragmentImpl == null) {
            OCElementFactory.$$$reportNull$$$0(100);
        }
        return oCCodeFragmentImpl;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(101);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(102);
        }
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(103);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(104);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1 CIDR_RULE_ZZZ2", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(105);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(106);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1\nCIDR_RULE_ZZZ2", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(107);
        }
        return psiElement;
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        if (oldElement == null) {
            OCElementFactory.$$$reportNull$$$0(108);
        }
        if (newElement == null) {
            OCElementFactory.$$$reportNull$$$0(109);
        }
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newElement.getNode()), (int)IndentHelper.getInstance().getIndent(context, oldElement.getNode()));
    }

    @NotNull
    public static OCBlockStatement surroundByBraces(@NotNull PsiElement element) {
        if (element == null) {
            OCElementFactory.$$$reportNull$$$0(110);
        }
        if (element instanceof OCBlockStatement) {
            OCBlockStatement oCBlockStatement = (OCBlockStatement)element;
            if (oCBlockStatement == null) {
                OCElementFactory.$$$reportNull$$$0(111);
            }
            return oCBlockStatement;
        }
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", element);
        OCChangeUtil.addAfter(blockStatement, element, blockStatement.getOpeningBrace());
        OCBlockStatement oCBlockStatement = blockStatement;
        if (oCBlockStatement == null) {
            OCElementFactory.$$$reportNull$$$0(112);
        }
        return oCBlockStatement;
    }

    @NotNull
    public static PsiElement createLeaf(@NotNull PsiManager manager, @NotNull OCElementType type) {
        if (manager == null) {
            OCElementFactory.$$$reportNull$$$0(113);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(114);
        }
        PsiElement psiElement = Factory.createSingleLeafElement((IElementType)type, (CharSequence)type.getName(), (int)0, (int)type.getName().length(), null, (PsiManager)manager).getPsi();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(115);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 39: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 39: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 39: 
            case 44: 
            case 48: 
            case 55: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 85: 
            case 89: 
            case 102: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 47: 
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 93: 
            case 98: 
            case 101: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "declaration";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 39: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationByNameAndType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationFromText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationByNameAndType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyDeclaration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "enumConst";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanConstant";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sendMessageExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "callExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "methodFromText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unaryExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createUDLSuffux";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryExpression";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "conditionalExpression";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryOperatorFromText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "typeModifierFromText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "ivarScopeSpecifier";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceVariableList";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFromText";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorInitializationList";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFieldInitializerFromText";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyAttributeList";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesizeList";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesize";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "declaratorText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationText";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createMacroForeignIdentifier";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createColon2x";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "topLevelDeclarationFromText";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "typeElementFromText";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKindFromContext";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "codeFragment";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceFromText";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "newlineFromText";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundByBraces";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "declarationFromText";
                break;
            }
            case 6: 
            case 7: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "declarationText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paramDeclarationFromText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "booleanConstant";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "methodFromSignature";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "conditionalExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "declaratorText";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createMacroForeignIdentifier";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "topLevelDeclarationFromText";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromText";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromTextOrNull";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "referenceElementFromText";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "expressionFromText";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "statementFromText";
                break;
            }
            case 74: 
            case 75: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "codeFragment";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragment";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragmentCpp";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "expressionOrStatementsCodeFragment";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "typeCodeFragment";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdCodeFragment";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCodeFragmentInWriteAction";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "spaceFromText";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "newlineFromText";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "initIndentFromContext";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "surroundByBraces";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 39: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

