/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ShowCompilerInfoForFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "appendAdditionalCompilerInfo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "context", "Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile$Context;", "getContext", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/psi/OCConfigurationOwner;", "update", "Context", "intellij.c"})
public class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.getProjectAndFile(e) != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void project;
        void file;
        void kind;
        Context context;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Context context2 = this.getContext(e);
        if (context2 == null) {
            return;
        }
        Context context3 = context = context2;
        Project project2 = context3.component1();
        VirtualFile virtualFile = context3.component2();
        OCLanguageKind oCLanguageKind = context3.component3();
        OCResolveConfiguration configuration = context3.component4();
        OCCompilerSettings oCCompilerSettings = configuration.getCompilerSettings((OCLanguageKind)kind, (VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerSettings, (String)"configuration.getCompilerSettings(kind, file)");
        OCCompilerSettings settings = oCCompilerSettings;
        StringBuilder builder2 = new StringBuilder();
        builder2.append("Compiler info for '" + file.getName() + "' in configuration '" + configuration.getDisplayName() + "' for language " + kind + '\n');
        builder2.append("\nCompiler kind: " + settings.getCompilerKind() + " path: " + settings.getCompilerExecutable() + '\n');
        this.appendAdditionalCompilerInfo(builder2, context);
        builder2.append("\nCompiler switches:\n");
        CidrCompilerSwitches switches = settings.getCompilerSwitches();
        if (switches == null) {
            builder2.append("\nnull\n");
        } else {
            List list = switches.getList(CidrCompilerSwitches.Format.RAW);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"switches.getList(CidrCompilerSwitches.Format.RAW)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder2.append("\t").append(it).append("\n");
            }
        }
        builder2.append("\nCompiler info:\n");
        builder2.append("\nDefines:\n");
        for (String preprocessorDefine : settings.getPreprocessorDefines()) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = builder2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(preprocessorDefine), (String)"append(value)");
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        builder2.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)settings.getCompilerFeatures().entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.2.INSTANCE, (int)30, null));
        StringBuilder stringBuilder = new StringBuilder().append("\n\nImplicit includes:\n");
        List list = settings.getImplicitIncludes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"settings.implicitIncludes");
        builder2.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.3.INSTANCE, (int)30, null)).toString());
        builder2.append("\n\nHeader Search paths:\n" + CollectionsKt.joinToString$default((Iterable)settings.getHeadersSearchRoots().getAllRoots(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.4.INSTANCE, (int)30, null));
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + file.getName() + "' in '" + configuration.getDisplayName() + '\'', (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder2);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)infoFile, false);
    }

    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder2, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    private final Triple<Project, VirtualFile, OCConfigurationOwner> getProjectAndFile(AnActionEvent e) {
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"AnAction.getEventProject(e) ?: return null");
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"e.getData(CommonDataKeys\u2026TUAL_FILE) ?: return null");
        VirtualFile file = virtualFile;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        if (!(object instanceof OCConfigurationOwner)) {
            object = null;
        }
        OCConfigurationOwner oCConfigurationOwner = (OCConfigurationOwner)object;
        if (oCConfigurationOwner == null) {
            return null;
        }
        OCConfigurationOwner psiFile = oCConfigurationOwner;
        return new Triple((Object)project2, (Object)file, (Object)psiFile);
    }

    /*
     * WARNING - void declaration
     */
    private final Context getContext(AnActionEvent e) {
        OCPsiFile oCPsiFile;
        void project;
        void file;
        Triple<Project, VirtualFile, OCConfigurationOwner> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, OCConfigurationOwner> triple2 = triple;
        Project project2 = (Project)triple2.component1();
        VirtualFile virtualFile = (VirtualFile)triple2.component2();
        OCConfigurationOwner psiFile = (OCConfigurationOwner)triple2.component3();
        OCResolveConfiguration oCResolveConfiguration = OCInclusionContextUtil.getActiveConfiguration((VirtualFile)file, (Project)project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveConfiguration, (String)"OCInclusionContextUtil.g\u2026, project) ?: return null");
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCConfigurationOwner oCConfigurationOwner = psiFile;
        if (!(oCConfigurationOwner instanceof OCPsiFile)) {
            oCConfigurationOwner = null;
        }
        if ((oCPsiFile = (OCPsiFile)oCConfigurationOwner) == null || (oCPsiFile = oCPsiFile.getOCFile()) == null || (oCPsiFile = oCPsiFile.getKind()) == null) {
            OCLanguageKind oCLanguageKind = psiFile.getRootKind(configuration);
            oCPsiFile = oCLanguageKind;
            Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind, (String)"psiFile.getRootKind(configuration)");
        }
        OCPsiFile kind = oCPsiFile;
        return new Context((Project)project, (VirtualFile)file, (OCLanguageKind)kind, configuration);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.c"})
    protected static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        public Context(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.project = project;
            this.file = file;
            this.kind = kind;
            this.configuration = configuration;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new Context(project, file, kind, configuration);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            Project project = this.project;
            VirtualFile virtualFile = this.file;
            OCLanguageKind oCLanguageKind = this.kind;
            OCResolveConfiguration oCResolveConfiguration = this.configuration;
            return (((project != null ? project.hashCode() : 0) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0)) * 31 + (oCLanguageKind != null ? oCLanguageKind.hashCode() : 0)) * 31 + (oCResolveConfiguration != null ? oCResolveConfiguration.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)context.project) || !Intrinsics.areEqual((Object)this.file, (Object)context.file) || !Intrinsics.areEqual((Object)this.kind, (Object)context.kind) || !Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

