/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class HtmlRequiredLangAttributeInspection
extends HtmlLocalInspectionTool {
    private static final String LANG = "lang";
    private static final String HTML = "html";
    private static final String XML_LANG = "xml:lang";
    private static final String XHTML_1 = "DTD XHTML 1.0";
    private static final String XHTML_11 = "DTD XHTML 1.1";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        XmlAttribute lang = tag.getAttribute(LANG);
        XmlAttribute xmlLang = tag.getAttribute(XML_LANG);
        String tagName = tag.getName();
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (!tagName.equalsIgnoreCase(HTML)) {
            return;
        }
        if (tag.getContainingFile().getFileType() == XHtmlFileType.INSTANCE) {
            XmlDocument doc = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)tag, XmlDocument.class, (boolean)true);
            if (doc == null || doc.getProlog() == null || doc.getProlog().getDoctype() == null || doc.getProlog().getDoctype().getPublicId() == null) {
                return;
            }
            if (doc.getProlog().getDoctype().getPublicId().contains(XHTML_1)) {
                if (xmlLang != null || lang != null) {
                    return;
                }
                if (isOnTheFly) {
                    fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, XML_LANG, new String[0]));
                }
            } else if (doc.getProlog().getDoctype().getPublicId().contains(XHTML_11)) {
                if (tag.getAttribute(XML_LANG) != null) {
                    return;
                }
                if (isOnTheFly) {
                    fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, XML_LANG, new String[0]));
                }
            }
        } else if (tag.getContainingFile().getFileType() == HtmlFileType.INSTANCE) {
            if (tag.getAttribute(LANG) != null) {
                return;
            }
            if (isOnTheFly) {
                fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, LANG, new String[0]));
            }
        } else {
            return;
        }
        InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.lang", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @NotNull
    public String getShortName() {
        return "HtmlRequiredLangAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredLangAttributeInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

